/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.function;

import com.ecc.shuffle.upgrade.function.ExtendedFunction;
import com.ecc.util.formula.FormulaException;
import com.ecc.util.formula.FormulaValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class Average
extends ExtendedFunction {
    public FormulaValue getValue(List argList) throws FormulaException {
        int size = argList.size();
        if (size < 1) {
            throw new FormulaException("Invalid paramaters for this Function!");
        }
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            FormulaValue dtValue = (FormulaValue)argList.get(i);
            if (dtValue.nDataType == 0) {
                int value = dtValue.nIntValue();
                sum += (double)value;
            } else if (dtValue.nDataType == 1) {
                float value = dtValue.dFloatValue();
                sum += (double)value;
            } else if (dtValue.nDataType == 8) {
                BigInteger value = dtValue.bigIntegerValue();
                sum += (double)value.floatValue();
            } else if (dtValue.nDataType == 7) {
                BigDecimal value = dtValue.decimalValue();
                sum += value.doubleValue();
            } else {
                System.out.println("\u53c2\u6570\u7c7b\u578b\u4e0d\u7b26\uff0c\u65e0\u6cd5\u8fdb\u884c\u5e73\u5747\u503c\u8ba1\u7b97");
                throw new FormulaException("some parameters can not be averaged");
            }
            ++i;
        }
        FormulaValue averageResult = new FormulaValue();
        averageResult.dFloatValue(sum / (double)size);
        return averageResult;
    }
}

