/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.function;

import com.ecc.shuffle.upgrade.function.ExtendedFunction;
import com.ecc.util.formula.function.Function;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FunctionManager {
    static Map funcs = new HashMap();
    static Map funcClassMap = new HashMap();
    static Map funcDsNameMap = new HashMap();

    public static void initialize(String functionFilePath) {
        FunctionManager temp = new FunctionManager();
        temp.loadDefineFunction(functionFilePath);
    }

    public static Function getFunction(String functionName) {
        return (Function)funcs.get(functionName);
    }

    public static String getFunctionClassName(String functionName) {
        return (String)funcClassMap.get(functionName);
    }

    public static String getDsName(String functionName) {
        return (String)funcDsNameMap.get(functionName);
    }

    public static void registFunction(String functionName, Function function) {
        funcs.put(functionName, function);
    }

    public void addFunction(Function function) {
        String functionName = function.getName();
        if (functionName.charAt(0) != '@') {
            functionName = String.valueOf('@') + functionName;
        }
        funcs.put(functionName, function);
    }

    public void loadDefineFunction(String functionFilePath) {
        System.out.println("===========\u52a0\u8f7d\u5168\u5c40\u51fd\u6570\u5b9a\u4e49===========");
        InputStream is = null;
        if (functionFilePath != null && functionFilePath.trim().length() > 0) {
            try {
                File funcFile = new File(functionFilePath);
                if (funcFile.exists() && funcFile.isFile()) {
                    is = new FileInputStream(funcFile);
                }
            }
            catch (Exception funcFile) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = new FileInputStream("function.xml");
            }
            catch (Exception e) {
                is = this.getClass().getResourceAsStream("/function.xml");
            }
        }
        if (is != null) {
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(is);
                Element root = doc.getDocumentElement();
                NodeList nodeList = root.getElementsByTagName("function");
                int i = 0;
                i = 0;
                while (i < nodeList.getLength()) {
                    try {
                        Element eFunc = (Element)nodeList.item(i);
                        String funcName = eFunc.getAttribute("name");
                        String funcClass = eFunc.getAttribute("implClass");
                        String dsName = eFunc.getAttribute("dsName");
                        ExtendedFunction func = (ExtendedFunction)((Object)Class.forName(funcClass).newInstance());
                        func.setName(funcName);
                        if (dsName != null && dsName.length() > 0) {
                            func.setDsName(dsName);
                        }
                        this.addFunction(func);
                        funcClassMap.put("@" + funcName, funcClass);
                        funcDsNameMap.put("@" + funcName, dsName);
                        System.out.println("===>Add Function: " + funcName + "[" + funcClass + "],dsName[" + dsName + "]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                System.out.println("===========\u5171\u52a0\u8f7d\u5168\u5c40\u51fd\u6570: " + i + "\u4e2a\u81ea\u5b9a\u4e49\u51fd\u6570===========");
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\u672a\u627e\u5230function.xml\u6587\u4ef6\uff0c\u8be5\u6587\u4ef6\u5fc5\u987b\u4f4d\u4e8ebin\u76ee\u5f55\uff08\u6216classes\u76ee\u5f55\uff09\u3001jar\u5305\u4e2d\uff01");
        }
    }
}

