/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.function;

import com.ecc.shuffle.SLog;
import com.ecc.shuffle.upgrade.ext.ShuffleStat1;
import com.ecc.shuffle.upgrade.function.ExtendedFunction;
import com.ecc.util.formula.FormulaException;
import com.ecc.util.formula.FormulaValue;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SumTransAmt
extends ExtendedFunction {
    private static Map hmCache = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormulaValue getValue(List argList) throws FormulaException {
        SLog.debug("invoke Function @SumTransAmt");
        if (argList.size() < 5) {
            throw new FormulaException("Invalid paramaters for the Function @SumTransAmt('statId','matchvalue','period',span,'transTime',transAmt)!");
        }
        float sumamt = 0.0f;
        FormulaValue fv1 = (FormulaValue)argList.get(0);
        FormulaValue fv2 = (FormulaValue)argList.get(1);
        FormulaValue fv3 = (FormulaValue)argList.get(2);
        FormulaValue fv4 = (FormulaValue)argList.get(3);
        FormulaValue fv5 = (FormulaValue)argList.get(4);
        if (fv1.nDataType != 2 || fv2.nDataType != 2 || fv3.nDataType != 2 || fv4.nDataType != 0 || fv5.nDataType != 2) throw new FormulaException("Invalid paramaters for the Function @SumTransAmt('statId','matchvalue','period',span,'transTime',transAmt)!");
        try {
            try {
                Connection conn = this.getConnection();
                String statId = fv1.sStringValue();
                String tableName = "sf_stat_cache_" + statId;
                tableName = tableName.toUpperCase();
                if (!hmCache.containsKey(statId)) {
                    DatabaseMetaData meta = conn.getMetaData();
                    ResultSet set = meta.getTables(null, null, tableName, null);
                    if (!set.next()) {
                        String sqlstr = "CREATE TABLE " + tableName + "(" + "MATCHVALUE VARCHAR2(200) not null," + "TRANSTIME INTEGER not null," + "AMT NUMBER(18,2)," + "primary key (MATCHVALUE, TRANSTIME)" + ")";
                        SLog.debug("\u6267\u884c\u7edf\u8ba1\u4e2d\u95f4\u8868\u5efa\u8868\u8bed\u53e5");
                        SLog.debug(sqlstr);
                        Statement smt = conn.createStatement();
                        smt.execute(sqlstr);
                        smt.close();
                    }
                    hmCache.put(statId, "1");
                }
                String matchValue = fv2.sStringValue();
                String period = fv3.sStringValue();
                int span = fv4.nIntValue();
                SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long transTime = formattxt.parse(fv5.sStringValue()).getTime();
                if (argList.size() == 6) {
                    FormulaValue fv6 = (FormulaValue)argList.get(5);
                    if (fv6.nDataType == 8 || fv6.nDataType == 7 || fv6.nDataType == 1 || fv6.nDataType == 0) {
                        float amt = fv6.dFloatValue();
                        SLog.debug("statId=" + statId + ";matchValue=" + matchValue + ";period=" + period + ";span=" + span + ";transTime=" + transTime + ";transAmt=" + amt);
                        sumamt = new ShuffleStat1(tableName).getSum(conn, matchValue, transTime, period, span, amt);
                    }
                } else if (argList.size() == 5) {
                    SLog.debug("statId=" + statId + ";matchValue=" + matchValue + ";period=" + period + ";span=" + span + ";transTime=" + transTime);
                    sumamt = new ShuffleStat1(tableName).getSum(conn, matchValue, transTime, period, span);
                }
            }
            catch (Exception e) {
                throw new FormulaException(e.getMessage(), e);
            }
        }
        finally {
            this.freeConnection();
        }
        FormulaValue stResult = new FormulaValue();
        stResult.nDataType = 1;
        stResult.dFloatValue(sumamt);
        return stResult;
    }
}

