/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffle.upgrade.rule;

import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.upgrade.FormulaProcesser;
import com.ecc.shuffle.upgrade.complier.ComplieException;
import com.ecc.shuffle.upgrade.complier.PseudoCodeComplier;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RuleFlow
extends Rule {
    private static final long serialVersionUID = 1L;
    public static final String newline = System.getProperty("line.separator");
    private RuleSet ruleSet = null;
    public Element flowElement = null;

    public RuleFlow(String name, RuleSet ruleSet) {
        super(name, ruleSet);
        this.ruleSet = ruleSet;
    }

    public RuleFlow(String name) {
        super(name);
    }

    public void setFlowElement(Element flowElement) {
        this.flowElement = flowElement;
    }

    public StringBuffer parseRuleFlow() throws ComplieException {
        StringBuffer javaBuffer = new StringBuffer();
        javaBuffer.append("public static boolean " + this.id + "(java.util.Map paramMap, java.util.Map resourceMap, java.util.Map valueMap) throws Exception{");
        javaBuffer.append(newline);
        if (this.runStatus == 2) {
            javaBuffer.append("if(true){");
            javaBuffer.append(newline);
            javaBuffer.append("System.out.println(\"\u89c4\u5219[" + this.id + "]\u5904\u4e8e\u505c\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u8c03\u7528!\");");
            javaBuffer.append(newline);
            javaBuffer.append("return false;");
            javaBuffer.append(newline);
            javaBuffer.append("}");
            javaBuffer.append(newline);
        }
        if (this.extClassName != null && this.extClassName.length() > 0) {
            String[] exts = this.extClassName.split(";");
            int k = 0;
            while (k < exts.length) {
                javaBuffer.append("if(com.ecc.shuffle.upgrade.ext.ShuffleExtFactory.getInstance().invokeExt(\"" + exts[k] + "\",paramMap, resourceMap, valueMap)==null)return false;");
                javaBuffer.append(newline);
                ++k;
            }
        }
        if (this.extScript != null && this.extScript.trim().length() > 0) {
            javaBuffer.append(new PseudoCodeComplier().parsePseudoCode(this.extScript));
            javaBuffer.append(newline);
        }
        StringBuffer methodBuffer = this.parseFlow1stStep();
        javaBuffer.append(methodBuffer);
        javaBuffer.append(newline);
        javaBuffer.append("return false;");
        javaBuffer.append(newline);
        javaBuffer.append("}");
        javaBuffer.append(newline);
        return javaBuffer;
    }

    private StringBuffer parseFlow1stStep() throws ComplieException {
        StringBuffer methodBuffer = new StringBuffer("");
        if (this.flowElement == null) {
            return methodBuffer;
        }
        Element startNode = null;
        HashMap<String, Element> fNodeMap = new HashMap<String, Element>();
        NodeList nodeList = this.flowElement.getElementsByTagName("node");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element fNode = (Element)nodeList.item(i);
            fNodeMap.put(fNode.getAttribute("id"), fNode);
            if ("true".equals(fNode.getAttribute("isStart"))) {
                if (startNode == null) {
                    startNode = fNode;
                } else {
                    throw new ComplieException("\u3010Complie Error\u3011:\u5f00\u59cb\u8282\u70b9\u91cd\u590d!");
                }
            }
            ++i;
        }
        methodBuffer = this.parseFlow2ndStep(fNodeMap, startNode);
        return methodBuffer;
    }

    private StringBuffer parseFlow2ndStep(Map fNodeMap, Element flowNode) throws ComplieException {
        StringBuffer methodBuffer = new StringBuffer("");
        NodeList nodeList = flowNode.getElementsByTagName("ref-rule");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element refRule = (Element)nodeList.item(i);
            String refName = refRule.getAttribute("refId");
            if (this.ruleSet.getRule(refName) == null) {
                throw new ComplieException("\u3010Complie Error\u3011:\u6d41\u7a0b\u4e2d\u5f15\u7528\u4e86\u672a\u5b9a\u4e49\u7684\u89c4\u5219[" + refName + "]!");
            }
            methodBuffer.append("resourceMap.put(\"_iruleId\",\"" + refName + "\");");
            methodBuffer.append(newline);
            methodBuffer.append(String.valueOf(refName) + "(paramMap, resourceMap, valueMap);");
            methodBuffer.append(newline);
            methodBuffer.append("resourceMap.remove(\"_iruleId\");");
            methodBuffer.append(newline);
            ++i;
        }
        nodeList = flowNode.getElementsByTagName("link");
        i = 0;
        while (i < nodeList.getLength()) {
            Element link = (Element)nodeList.item(i);
            String target = link.getAttribute("target");
            if (!fNodeMap.containsKey(target)) {
                throw new ComplieException("\u3010Complie Error\u3011:\u6d41\u7a0b\u8fde\u7ebf\u9519\u8bef\uff0c\u76ee\u6807\u8282\u70b9[" + target + "]\u4e0d\u5b58\u5728\uff01");
            }
            Element fNode = (Element)fNodeMap.get(target);
            String condition = link.getFirstChild().getNodeValue().trim();
            if (i > 0) {
                methodBuffer.append(" else ");
            }
            methodBuffer.append("if (");
            methodBuffer.append(this.translateCondition(condition));
            methodBuffer.append(") {");
            methodBuffer.append(newline);
            methodBuffer.append(this.parseFlow2ndStep(fNodeMap, fNode));
            methodBuffer.append(newline);
            methodBuffer.append("}");
            methodBuffer.append(newline);
            ++i;
        }
        return methodBuffer;
    }

    private String translateCondition(String condition) {
        if (condition == null || condition.trim().length() == 0) {
            return "true";
        }
        String s = String.valueOf(FormulaProcesser.class.getName()) + ".retBooleanValue(\"" + condition + "\", paramMap, resourceMap, valueMap)";
        return s;
    }

    public static void main(String[] args) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(new File("./rules/rules.xml"));
            Element root = doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("rule-flow");
            RuleFlow aRuleFlow = new RuleFlow("testFlow", null);
            aRuleFlow.flowElement = (Element)nl.item(0);
            StringBuffer buf = aRuleFlow.parseRuleFlow();
            System.out.println(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

