/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffleserver;

import com.ecc.shuffleserver.manager.AccessManager;
import com.ecc.shuffleserver.manager.UserManagerImpl;
import com.ecc.shufflestudio.permission.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ShuffleJNLPServlet
extends HttpServlet {
    private String userManagerClass;
    private UserManagerImpl userManager;
    private static final String CONTENT_TYPE = "application/x-java-jnlp-file;charset=UTF-8";

    public void init(ServletConfig config) throws ServletException {
        this.userManagerClass = config.getInitParameter("userManagerClass");
        System.out.println("userManagerClass=" + this.userManagerClass);
        if (this.userManagerClass != null) {
            try {
                this.userManager = (UserManagerImpl)Class.forName(this.userManagerClass).newInstance();
            }
            catch (Exception e) {
                System.err.println("\u521d\u59cb\u5316UserManagerImpl\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
            }
        }
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionId;
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        HttpSession session = request.getSession();
        String userid = (String)session.getAttribute("userid");
        if (userid == null || userid.equals("")) {
            userid = request.getParameter("userid");
        }
        if ((sessionId = (String)session.getAttribute("sessionId")) == null || sessionId.equals("")) {
            sessionId = session.getId();
        }
        System.out.println("sessionId===" + sessionId + ";userid===" + userid);
        if (userid == null || userid.equals("")) {
            userid = "%userid%";
        }
        if (sessionId == null || sessionId.equals("")) {
            sessionId = "%sessionid%";
        }
        try {
            if (this.userManager != null) {
                try {
                    UserInfo aUser = this.userManager.getUserInfo(userid);
                    AccessManager.getInstance().registerUser(aUser, sessionId);
                }
                catch (Exception e) {
                    System.err.println("ShuffleJNLPServlet\u81ea\u52a8\u767b\u9646\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    e.printStackTrace();
                }
            }
            String docpath = request.getSession().getServletContext().getRealPath("/shuffle/studio/shufflestudio.jnlp");
            FileInputStream in = new FileInputStream(new File(docpath));
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int intLength = 0;
            while ((intLength = in.read()) != -1) {
                bout.write(intLength);
            }
            byte[] bts = bout.toByteArray();
            String str = new String(bts, "UTF-8");
            str = str.replaceAll("%userid%", userid);
            str = str.replaceAll("%sessionid%", sessionId).trim();
            bout.close();
            in.close();
            out.println(str);
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
    }
}

