/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffleserver;

import com.ecc.shuffle.common.Utils;
import com.ecc.shuffle.db.DbControl;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.upgrade.RuleSetInstance;
import com.ecc.shuffleserver.factory.ServerFactory;
import com.ecc.shuffleserver.manager.AccessManager;
import com.ecc.shuffleserver.manager.ParameterManagerFactory;
import com.ecc.shuffleserver.manager.PermissionException;
import com.ecc.shuffleserver.manager.PublishManagerImpl;
import com.ecc.shuffleserver.manager.UserManagerImpl;
import com.ecc.shufflestudio.editor.rulestable.model.RulesTableWrapper;
import com.ecc.shufflestudio.permission.UserInfo;
import com.ecc.shufflestudio.ui.StudioApplication;
import com.ecc.shufflestudio.ui.view.ReturnObj;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;

public class ShuffleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String charset = "UTF-8";
    public static Properties props = new Properties();
    public static String shufflepath = null;
    private static String functionFilePath = "";
    private static String wrapperFolderPath = "";
    private static String JNDIName = "";
    private static String userManagerClass = "com.ecc.shuffleserver.manager.GeneralUserManager";
    private static String publishManagerClass = "com.ecc.shuffleserver.manager.GeneralPublishManager";
    private UserManagerImpl userManager = null;
    private PublishManagerImpl publishManager = null;
    private AccessManager accessManager = AccessManager.getInstance();

    public void init() throws ServletException {
        this.readShufflePropertes();
        shufflepath = props.getProperty("shufflepath");
        System.out.println("\u521d\u59cb\u5316\u53c2\u6570\uff1ashufflepath=" + shufflepath);
        String param = String.valueOf(shufflepath) + "\\function.xml";
        if (System.getProperty("file.separator") != null && System.getProperty("file.separator").equals("/")) {
            param = param.replaceAll("\\\\", "/");
        }
        if (param != null && param.trim().length() > 0) {
            if (param.startsWith("./")) {
                param = String.valueOf(this.getServletContext().getRealPath("/")) + param;
            }
            param.replace('\\', '/');
            functionFilePath = param;
        }
        System.out.println("\u521d\u59cb\u5316\u53c2\u6570\uff1afunctionFilePath=" + functionFilePath);
        param = String.valueOf(shufflepath) + "\\wrappers";
        if (System.getProperty("file.separator") != null && System.getProperty("file.separator").equals("/")) {
            param = param.replaceAll("\\\\", "/");
        }
        if (param != null && param.trim().length() > 0) {
            if (param.startsWith("./")) {
                param = String.valueOf(this.getServletContext().getRealPath("/")) + param;
            }
            param.replace('\\', '/');
            File folder = new File(param);
            if (folder.exists() && folder.isDirectory()) {
                wrapperFolderPath = param;
            }
        }
        System.out.println("\u521d\u59cb\u5316\u53c2\u6570\uff1awrapperFolderPath=" + wrapperFolderPath);
        param = this.getInitParameter("userManagerClass");
        if (param == null || param.trim().length() < 1) {
            param = props.getProperty("userManagerClass");
        }
        if (param != null && param.trim().length() > 0) {
            userManagerClass = param;
        }
        System.out.println("\u521d\u59cb\u5316\u53c2\u6570\uff1auserManagerClass=" + userManagerClass);
        param = this.getInitParameter("publishManagerClass");
        if (param == null || param.trim().length() < 1) {
            param = props.getProperty("publishManagerClass");
        }
        if (param != null && param.trim().length() > 0) {
            publishManagerClass = param;
        }
        System.out.println("\u521d\u59cb\u5316\u53c2\u6570\uff1apublishManagerClass=" + publishManagerClass);
        param = this.getInitParameter("loginTimeOut");
        if (param == null || param.trim().length() < 1) {
            param = props.getProperty("loginTimeOut");
        }
        if (param != null && param.trim().length() > 0) {
            this.accessManager.setLoginTimeOut(param);
        }
        this.accessManager.beginCheckingTimeOut();
        System.out.println("\u521d\u59cb\u5316accessManager\u6210\u529f\uff1aloginTimeOut=" + this.accessManager.getLoginTimeOut());
        param = this.getInitParameter("JNDIName");
        if (param == null || param.trim().length() < 1) {
            param = props.getProperty("JNDIName");
        }
        if (param != null && param.trim().length() > 0) {
            JNDIName = param;
            System.out.println("\u521d\u59cb\u5316\u53c2\u6570\uff1aJNDIName=" + JNDIName);
        }
        try {
            this.userManager = (UserManagerImpl)Class.forName(userManagerClass).newInstance();
            this.userManager.init();
            System.err.println("\u521d\u59cb\u5316userManager\u6210\u529f.");
        }
        catch (Exception e) {
            System.err.println("\u521d\u59cb\u5316userManager\u5931\u8d25!");
            e.printStackTrace();
        }
        try {
            this.publishManager = (PublishManagerImpl)Class.forName(publishManagerClass).newInstance();
            System.err.println("\u521d\u59cb\u5316publishManager\u6210\u529f.");
        }
        catch (Exception e) {
            System.err.println("\u521d\u59cb\u5316publishManager\u5931\u8d25!");
            e.printStackTrace();
        }
        super.init();
    }

    public static String getServletProperty(String key) {
        return props.getProperty(key);
    }

    private void readShufflePropertes() {
        InputStream is = null;
        try {
            is = new FileInputStream("shuffle.properties");
        }
        catch (Exception e) {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/shuffle.properties");
        }
        if (is != null) {
            try {
                props.load(is);
                if (props.containsKey("charset")) {
                    this.charset = props.getProperty("charset");
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getWrapperFolderPath() {
        return wrapperFolderPath;
    }

    public static String getJNDIName() {
        return JNDIName;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        queryStr = request.getQueryString();
        params = queryStr.split("&");
        if (params == null || params.length < 1) {
            System.out.println("\u7a7a\u6307\u4ee4");
            return;
        }
        aParam = params[0].split("=");
        method = null;
        if ("method".equals(aParam[0])) {
            method = aParam[1];
        }
        if (method == null) {
            System.out.println("\u65e0\u6cd5\u8bc6\u522b\u7684\u6307\u4ee4");
            return;
        }
        if (method.equals("shufflemanage")) {
            this.doShuffleManage(request, response);
            return;
        }
        response.setContentType("applcation/octet-stream");
        outStream = response.getOutputStream();
        objOutStream = new ObjectOutputStream((OutputStream)outStream);
        try {
            block111: {
                block110: {
                    block109: {
                        block108: {
                            block107: {
                                block106: {
                                    block105: {
                                        block102: {
                                            block103: {
                                                block101: {
                                                    block100: {
                                                        block99: {
                                                            block98: {
                                                                block97: {
                                                                    block96: {
                                                                        block95: {
                                                                            block94: {
                                                                                block93: {
                                                                                    block92: {
                                                                                        block91: {
                                                                                            block90: {
                                                                                                block89: {
                                                                                                    block88: {
                                                                                                        block87: {
                                                                                                            block86: {
                                                                                                                block85: {
                                                                                                                    factory = new ServerFactory();
                                                                                                                    map = (Map)this.getObj(request);
                                                                                                                    obj = new ReturnObj();
                                                                                                                    if (!method.equals("importParam")) break block85;
                                                                                                                    ruleSetName = (String)map.get("ruleSetName");
                                                                                                                    paramMap = ParameterManagerFactory.getInstance().getImportParameterClass().getRuleSetParam(ruleSetName);
                                                                                                                    obj = new ReturnObj(true, "\u83b7\u53d6\u53c2\u6570\u6210\u529f.", (Object)paramMap);
                                                                                                                    ** GOTO lbl283
                                                                                                                }
                                                                                                                if (!method.equals("getExtClass")) break block86;
                                                                                                                obj = factory.getExtClass();
                                                                                                                ** GOTO lbl283
                                                                                                            }
                                                                                                            if (!method.equals("getConstant")) break block87;
                                                                                                            obj = factory.getConstant();
                                                                                                            ** GOTO lbl283
                                                                                                        }
                                                                                                        if (!method.equals("setConstant")) break block88;
                                                                                                        obj = factory.setConstant(map);
                                                                                                        ** GOTO lbl283
                                                                                                    }
                                                                                                    if (!method.equals("getVariable")) break block89;
                                                                                                    obj = factory.getVariable();
                                                                                                    ** GOTO lbl283
                                                                                                }
                                                                                                if (!method.equals("setVariable")) break block90;
                                                                                                obj = factory.setVariable(map);
                                                                                                ** GOTO lbl283
                                                                                            }
                                                                                            if (!method.equals("getGuideLine")) break block91;
                                                                                            obj = factory.getGuideLine();
                                                                                            ** GOTO lbl283
                                                                                        }
                                                                                        if (!method.equals("getProperties")) break block92;
                                                                                        propKey = (String)map.get("propKey");
                                                                                        propValue = Utils.ISO2GB(ShuffleServlet.props.getProperty(propKey), this.charset);
                                                                                        if (propValue == null) {
                                                                                            obj.setFlag(false);
                                                                                        } else {
                                                                                            obj.setFlag(true);
                                                                                            obj.setObj((Object)propValue);
                                                                                        }
                                                                                        ** GOTO lbl283
                                                                                    }
                                                                                    if (!method.equals("getTransList")) break block93;
                                                                                    obj = factory.getTransList(map);
                                                                                    ** GOTO lbl283
                                                                                }
                                                                                if (!method.equals("newTrans")) break block94;
                                                                                obj = factory.newTrans(map);
                                                                                ** GOTO lbl283
                                                                            }
                                                                            if (!method.equals("removeTrans")) break block95;
                                                                            obj = factory.removeTrans(map);
                                                                            ** GOTO lbl283
                                                                        }
                                                                        if (!method.equals("updateTrans")) break block96;
                                                                        obj = factory.updateTrans(map);
                                                                        ** GOTO lbl283
                                                                    }
                                                                    if (!method.equals("saveTrans")) break block97;
                                                                    obj = factory.saveTrans(map);
                                                                    ** GOTO lbl283
                                                                }
                                                                if (!method.equals("saveTransByRule")) break block98;
                                                                rulesetid = (String)map.get("rulesetid");
                                                                ruleid = (String)map.get("ruleid");
                                                                transMap = (Map)map.get("transMap");
                                                                obj = factory.saveTransByRule(rulesetid, ruleid, transMap);
                                                                ** GOTO lbl283
                                                            }
                                                            if (!method.equals("getRules")) break block99;
                                                            rulesetMap = RuleBase.getInstance().ruleSets;
                                                            obj.setFlag(true);
                                                            obj.setInfo("\u83b7\u53d6\u89c4\u5219\u4fe1\u606f\u6210\u529f");
                                                            obj.setObj((Object)rulesetMap);
                                                            ** GOTO lbl283
                                                        }
                                                        if (!method.equals("getRuleSet")) break block100;
                                                        obj = factory.getRuleSet(map);
                                                        ** GOTO lbl283
                                                    }
                                                    if (!method.equals("getRule")) break block101;
                                                    obj = factory.getRule(map);
                                                    ** GOTO lbl283
                                                }
                                                if (!method.equals("login")) break block102;
                                                userName = (String)map.get("userName");
                                                password = (String)map.get("password");
                                                if (this.userManager != null) break block103;
                                                obj = new ReturnObj(false, "userManager\u672a\u542f\u52a8\uff01", null);
                                                ** GOTO lbl283
                                            }
                                            try {
                                                block104: {
                                                    userInfo = this.userManager.verifyUser(userName, password);
                                                    if (!this.accessManager.userHasLogin(userName)) break block104;
                                                    obj = new ReturnObj(false, "\u7528\u6237[" + userName + "]\u5df2\u767b\u5f55\uff01", null);
                                                    ** GOTO lbl283
                                                }
                                                this.accessManager.registerUser(userInfo);
                                                obj = new ReturnObj(true, String.valueOf(userName) + "\u767b\u5f55\u6210\u529f.", (Object)userInfo);
                                            }
                                            catch (PermissionException e) {
                                                obj = new ReturnObj(false, e.getMessage(), null);
                                            }
                                            ** GOTO lbl283
                                        }
                                        if (!method.equals("getLoginUser")) break block105;
                                        userName = (String)map.get("userName");
                                        sessionId = (String)map.get("sessionId");
                                        if (this.userManager == null) {
                                            obj = new ReturnObj(false, "userManager\u672a\u542f\u52a8\uff01", null);
                                        } else {
                                            try {
                                                userInfo = this.accessManager.getUser(userName, sessionId);
                                                obj = new ReturnObj(true, String.valueOf(userName) + "\u6210\u529f.", (Object)userInfo);
                                            }
                                            catch (Exception e) {
                                                obj = new ReturnObj(false, e.getMessage(), null);
                                            }
                                        }
                                        ** GOTO lbl283
                                    }
                                    if (!method.equals("logoff")) break block106;
                                    userName = (String)map.get("userName");
                                    sessionId = (String)map.get("sessionId");
                                    this.accessManager.unregisterUser(userName, sessionId);
                                    obj.setInfo("\u7528\u6237[" + userName + "]\u7b7e\u9000\u6210\u529f\uff01");
                                    ** GOTO lbl283
                                }
                                if (!method.equals("invokeshuffle")) break block107;
                                if (params.length > 2) {
                                    System.out.println("invokeshuffle\uff1a" + queryStr);
                                    aParam = params[1].split("=");
                                    ruleSetName = aParam[1];
                                    aParam = params[2].split("=");
                                    ruleName = aParam[1];
                                    try {
                                        engine = new RuleSetInstance(ruleSetName);
                                        outPutValue = engine.fireTargetRules(ruleName, map);
                                        obj.setInfo((String)outPutValue.get("retObj"));
                                        obj.setObj((Object)outPutValue);
                                    }
                                    catch (Exception e) {
                                        System.out.println("invokeshuffle\u5f02\u5e38\uff0c\u4fe1\u606f\u5982\u4e0b\uff1a");
                                        e.printStackTrace();
                                    }
                                } else {
                                    System.out.println("\u65e0\u6548\u7684\u8c03\u7528\u53c2\u6570for\uff1a" + queryStr);
                                }
                                ** GOTO lbl283
                            }
                            if (!method.equals("time")) break block108;
                            time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                            if (time != null && time.length() > 0) {
                                obj.setObj((Object)time);
                                obj.setFlag(true);
                            } else {
                                obj.setFlag(false);
                            }
                            ** GOTO lbl283
                        }
                        if (!method.equals("getAllRoles")) break block109;
                        obj = factory.getAllRoles();
                        ** GOTO lbl283
                    }
                    if (!method.equals("getAllGroups")) break block110;
                    obj = factory.getAllGroups();
                    ** GOTO lbl283
                }
                if (!method.equals("getAllUsers")) break block111;
                obj = factory.getAllUsers();
                ** GOTO lbl283
            }
            userName = (String)map.get("userName");
            sessionId = (String)map.get("sessionId");
            aUser = null;
            if (this.userManager.userExist(userName)) {
                if (!this.accessManager.checkSession(userName, sessionId)) {
                    obj = new ReturnObj(false, "\u7528\u6237[" + userName + "]\u64cd\u4f5c\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01", null);
                    objOutStream.writeObject(obj);
lbl194:
                    // 2 sources

                    return;
                }
            } else {
                obj = new ReturnObj(false, "\u7528\u6237[" + userName + "]\u4e0d\u5b58\u5728\uff01", null);
                objOutStream.writeObject(obj);
                ** continue;
            }
            aUser = this.userManager.getUserInfo(userName);
            if (method.equals("function")) {
                wrapper = factory.getFunctions(ShuffleServlet.functionFilePath);
                objOutStream.writeObject(wrapper);
                return;
            }
            try {
                if (method.equals("open")) {
                    obj = aUser.hasPermission("open") ? factory.open(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("list")) {
                    ruleSetList = factory.getAllRuleSet(map);
                    appList = factory.getAllAppClassify(map);
                    resultMap = new HashMap<String, ReturnObj>();
                    resultMap.put("ruleSets", ruleSetList);
                    resultMap.put("appList", appList);
                    obj.setFlag(true);
                    obj.setInfo("\u64cd\u4f5c\u6210\u529f\uff01");
                    obj.setObj(resultMap);
                } else if (method.equals("create")) {
                    obj = aUser.hasPermission("create") ? factory.insertRuleSet(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("ifRuleSetExist")) {
                    obj = factory.ifRuleSetExist(map);
                } else if (method.equals("save")) {
                    obj = aUser.hasPermission("edit") ? factory.saveRuleSet(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("delete")) {
                    obj = aUser.hasPermission("delete") ? factory.deleteRuleSet(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("deleteUnpublished")) {
                    obj = aUser.hasPermission("delete") ? factory.deleteRuleSetUnpublished(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("deleteversion")) {
                    obj = aUser.hasPermission("delete") ? factory.deleteRuleSetVersion(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("checkIn")) {
                    obj = aUser.hasPermission("edit") ? factory.checkIn(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("checkOut")) {
                    obj = aUser.hasPermission("edit") ? factory.checkOut(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("history")) {
                    if (aUser.hasPermission("history")) {
                        ruleSetId = (String)map.get("rsId");
                        obj = factory.queryVersions(ruleSetId);
                    } else {
                        obj = new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                    }
                } else if (method.equals("version")) {
                    if (aUser.hasPermission("history")) {
                        rsId = (String)map.get("rsId");
                        version = (String)map.get("version");
                        obj = factory.getVersionWra(String.valueOf(rsId) + "." + version);
                    } else {
                        obj = new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                    }
                } else if (method.equals("retrieve")) {
                    obj = aUser.hasPermission("retrieve") ? factory.retrieveVersion(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("publish")) {
                    obj = aUser.hasPermission("publish") ? factory.publish(map, this.publishManager) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("createApp")) {
                    obj = aUser.hasPermission("createApp") ? factory.createApp(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("deleteApp")) {
                    obj = factory.deleteApp(map);
                } else if (method.equals("move")) {
                    obj = aUser.hasPermission("move") ? factory.move(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("import")) {
                    obj = aUser.hasPermission("import") ? factory.importRS(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("rename")) {
                    obj = aUser.hasPermission("rename") ? factory.rename(map) : new ReturnObj(false, "\u7528\u6237[" + userName + "]\u6ca1\u6709\u64cd\u4f5c[" + method + "]\u6743\u9650\uff01", null);
                } else if (method.equals("recordStudioOperation")) {
                    obj = factory.recordStudioOperation(map);
                }
lbl283:
                // 58 sources

                objOutStream.writeObject(obj);
                objOutStream.flush();
                objOutStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (objOutStream != null) {
                    objOutStream.flush();
                    objOutStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getObj(HttpServletRequest request) throws IOException {
        ServletInputStream input = null;
        try {
            input = request.getInputStream();
        }
        catch (IOException e) {
            System.out.println("\u672a\u63a5\u6536\u5230\u5bf9\u8c61");
            e.printStackTrace();
        }
        ObjectInputStream ObjInput = new ObjectInputStream((InputStream)input);
        Object obj = null;
        try {
            try {
                boolean flag = true;
                while (flag) {
                    try {
                        obj = ObjInput.readObject();
                        flag = false;
                    }
                    catch (EOFException e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
            catch (ClassNotFoundException e1) {
                System.out.println("\u672a\u63a5\u6536\u5230\u5bf9\u8c61");
                e1.printStackTrace();
                try {
                    if (ObjInput != null) {
                        ObjInput.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (ObjInput != null) {
                    ObjInput.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public void doShuffleManage(HttpServletRequest request, HttpServletResponse response) {
        block14: {
            String actionType = request.getParameter("actionType");
            System.out.println("doShuffleManage\u89c4\u5219WEB\u5ba2\u6237\u7aef\u7ba1\u7406,actionType=" + actionType);
            if (actionType == null) {
                return;
            }
            try {
                if (actionType.equals("login")) {
                    String userid = request.getParameter("userid");
                    String password = request.getParameter("password");
                    try {
                        UserInfo userInfo = this.userManager.verifyUser(userid, password);
                        if (this.accessManager.userHasLogin(userid)) {
                            request.getRequestDispatcher("./shuffle/shufflemanage/loginerror.jsp?userid=" + userid).forward((ServletRequest)request, (ServletResponse)response);
                            break block14;
                        }
                        this.accessManager.registerUser(userInfo);
                        request.getSession().setAttribute("userid", (Object)userid);
                        request.getSession().setAttribute("sessionId", (Object)userInfo.getSessionId());
                        request.getRequestDispatcher("./shuffle/shufflemanage/indexFrame.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (PermissionException e) {
                        request.setAttribute("errormsg", (Object)e.getMessage());
                        request.getRequestDispatcher("./shuffle/shufflemanage/login.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    }
                    break block14;
                }
                if (actionType.equals("logoff")) {
                    String userName = (String)request.getSession().getAttribute("userid");
                    String sessionId = (String)request.getSession().getAttribute("sessionId");
                    this.accessManager.unregisterUser(userName, sessionId);
                    request.getRequestDispatcher("./shuffle/shufflemanage/login.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (actionType.equals("saveConstant")) {
                    String varid = request.getParameter("varid");
                    String vartype = request.getParameter("vartype");
                    String varvalue = new String(request.getParameter("varvalue").getBytes("iso-8859-1"), "GBK");
                    String vardesc = new String(request.getParameter("vardesc").getBytes("iso-8859-1"), "GBK");
                    DbControl db = DbControl.getInstance();
                    db.singleExecute("update sf_constant set constant_type='" + vartype + "',constant_value='" + varvalue + "',constant_desc='" + vardesc + "' where constant_id='" + varid + "'");
                    request.getRequestDispatcher("./shuffle/shufflemanage/constantList.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (actionType.equals("saveVar")) {
                    String varid = request.getParameter("varid");
                    String vartype = request.getParameter("vartype");
                    String varvalue = new String(request.getParameter("varvalue").getBytes("iso-8859-1"), "GBK");
                    String vardesc = new String(request.getParameter("vardesc").getBytes("iso-8859-1"), "GBK");
                    DbControl db = DbControl.getInstance();
                    db.singleExecute("update sf_var set var_type='" + vartype + "',var_value='" + varvalue + "',var_desc='" + vardesc + "' where var_id='" + varid + "'");
                    RuleBase.getInstance().initVariable();
                    request.getRequestDispatcher("./shuffle/shufflemanage/varList.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (actionType.equals("exportRuleTable2Excel")) {
                    this.exportRuleTable2Excel(request, response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void exportRuleTable2Excel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReturnObj obj;
        String ruleSetId = request.getParameter("ruleSetId");
        String ruleId = request.getParameter("ruleId");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + ruleSetId + "_" + ruleId + ".xls\"");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream out = response.getOutputStream();
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        sheet.setColumnWidth((short)0, (short)5000);
        sheet.setColumnWidth((short)1, (short)2500);
        sheet.setColumnWidth((short)2, (short)3000);
        sheet.setColumnWidth((short)3, (short)10000);
        sheet.setColumnWidth((short)4, (short)5000);
        workbook.setSheetName(0, "Shuffle\u89c4\u5219\u5f15\u64ce\u51b3\u7b56\u8868", (short)1);
        HSSFCellStyle style1 = workbook.createCellStyle();
        style1.setVerticalAlignment((short)1);
        style1.setAlignment((short)2);
        HSSFFont font1 = workbook.createFont();
        font1.setBoldweight((short)700);
        font1.setFontHeightInPoints((short)15);
        style1.setFont(font1);
        style1.setFillPattern((short)1);
        style1.setFillForegroundColor((short)17);
        style1.setBorderLeft((short)1);
        style1.setBorderRight((short)1);
        style1.setBorderTop((short)1);
        style1.setBorderBottom((short)1);
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setVerticalAlignment((short)1);
        style2.setAlignment((short)2);
        HSSFFont font2 = workbook.createFont();
        font2.setBoldweight((short)700);
        font2.setFontHeightInPoints((short)10);
        style2.setFont(font2);
        style2.setFillPattern((short)1);
        style2.setFillForegroundColor((short)57);
        style2.setBorderLeft((short)1);
        style2.setBorderRight((short)1);
        style2.setBorderTop((short)1);
        style2.setBorderBottom((short)1);
        HSSFCellStyle style3 = workbook.createCellStyle();
        style3.setVerticalAlignment((short)1);
        style3.setAlignment((short)2);
        HSSFFont font3 = workbook.createFont();
        font3.setBoldweight((short)700);
        font3.setFontHeightInPoints((short)10);
        style3.setFont(font3);
        style3.setFillPattern((short)1);
        style3.setFillForegroundColor((short)42);
        style3.setBorderLeft((short)1);
        style3.setBorderRight((short)1);
        style3.setBorderTop((short)1);
        style3.setBorderBottom((short)1);
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(22.0f);
        HSSFCell cell = row.createCell((short)0);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u3010Shuffle\u89c4\u5219\u5f15\u64ce\u51b3\u7b56\u8868\u3011");
        cell.setCellStyle(style1);
        row.createCell((short)1);
        row.createCell((short)2);
        row.createCell((short)3);
        row.createCell((short)4);
        Region region1 = new Region(0, 0, 0, 4);
        this.setRegionStyle(sheet, region1, style1);
        sheet.addMergedRegion(region1);
        row = sheet.createRow(1);
        row.setHeightInPoints(17.0f);
        cell = row.createCell((short)0);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u89c4\u5219\u96c6ID\uff1a" + ruleSetId + "   \u89c4\u5219ID\uff1a" + ruleId);
        cell.setCellStyle(style2);
        row.createCell((short)1);
        row.createCell((short)2);
        row.createCell((short)3);
        row.createCell((short)4);
        Region region2 = new Region(1, 0, 1, 4);
        this.setRegionStyle(sheet, region2, style2);
        sheet.addMergedRegion(region2);
        row = sheet.createRow(2);
        cell = row.createCell((short)0);
        cell.setCellStyle(style3);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u6307\u6807\u9879");
        cell = row.createCell((short)1);
        cell.setCellStyle(style3);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u6743\u91cd");
        cell = row.createCell((short)2);
        cell.setCellStyle(style3);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u7c7b\u578b");
        cell = row.createCell((short)3);
        cell.setCellStyle(style3);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u89c4\u5219");
        cell = row.createCell((short)4);
        cell.setCellStyle(style3);
        cell.setCellType(1);
        cell.setEncoding((short)1);
        cell.setCellValue("\u5f97\u5206");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setVerticalAlignment((short)1);
        style.setAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setBoldweight((short)400);
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)31);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
        style.setBorderBottom((short)1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ruleSetId", ruleSetId);
        map.put("ruleId", ruleId);
        String param = "?method=getRule";
        if (StudioApplication.servletUrl == null) {
            StudioApplication.servletUrl = String.valueOf(request.getScheme()) + "://" + request.getLocalAddr() + ":" + request.getServerPort() + request.getContextPath() + "/ShuffleServlet";
        }
        if ((obj = (ReturnObj)StudioApplication.invokeServlet((String)param, map)).isFlag()) {
            RulesTableWrapper rule = (RulesTableWrapper)obj.getObj();
            List luo = rule.getListUO();
            HashMap<String, String> hmRow = new HashMap<String, String>();
            HashMap<String, Integer> hmCount = new HashMap<String, Integer>();
            if (luo != null && luo.size() > 0) {
                Integer count;
                int i = 0;
                while (i < luo.size()) {
                    Map hm = (Map)luo.get(i);
                    String key = (String)hm.get("id");
                    if (!hmRow.containsKey(key)) {
                        hmRow.put(key, String.valueOf(i + 3));
                    }
                    if (hmCount.containsKey(key)) {
                        count = (Integer)hmCount.get(key);
                        count = count + 1;
                    } else {
                        count = new Integer(1);
                    }
                    hmCount.put(key, count);
                    row = sheet.createRow((short)i + 3);
                    if (count == 1) {
                        cell = row.createCell((short)0);
                        cell.setCellStyle(style);
                        cell.setCellType(1);
                        cell.setEncoding((short)1);
                        cell.setCellValue((String)hm.get("name"));
                        cell = row.createCell((short)1);
                        cell.setCellStyle(style);
                        cell.setCellType(1);
                        cell.setEncoding((short)1);
                        cell.setCellValue((String)hm.get("weight"));
                    } else {
                        row.createCell((short)0);
                        row.createCell((short)1);
                    }
                    cell = row.createCell((short)2);
                    cell.setCellStyle(style);
                    cell.setCellType(1);
                    cell.setEncoding((short)1);
                    cell.setCellValue((String)hm.get("type"));
                    cell = row.createCell((short)3);
                    cell.setCellStyle(style);
                    cell.setCellType(1);
                    cell.setEncoding((short)1);
                    cell.setCellValue((String)hm.get("formula"));
                    cell = row.createCell((short)4);
                    cell.setCellStyle(style);
                    cell.setCellType(1);
                    cell.setEncoding((short)1);
                    cell.setCellValue((String)hm.get("score"));
                    ++i;
                }
                for (String key : hmCount.keySet()) {
                    count = (Integer)hmCount.get(key);
                    if (count <= 1) continue;
                    int rownum = Integer.parseInt((String)hmRow.get(key));
                    Region region = new Region(rownum, 0, rownum + count - 1, 0);
                    this.setRegionStyle2(sheet, region, style);
                    sheet.addMergedRegion(region);
                    region = new Region(rownum, 1, rownum + count - 1, 1);
                    this.setRegionStyle2(sheet, region, style);
                    sheet.addMergedRegion(region);
                }
            }
        }
        workbook.write((OutputStream)out);
        out.flush();
    }

    private void setRegionStyle(HSSFSheet sheet, Region region, HSSFCellStyle cs) {
        int i = region.getRowFrom();
        while (i <= region.getRowTo()) {
            HSSFRow row = sheet.getRow(i);
            if (region.getColumnFrom() != region.getColumnTo()) {
                int j = region.getColumnFrom();
                while (j <= region.getColumnTo()) {
                    HSSFCell cell = row.getCell((short)j);
                    if (cell != null) {
                        cell.setCellStyle(cs);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void setRegionStyle2(HSSFSheet sheet, Region region, HSSFCellStyle cs) {
        int i = region.getRowFrom();
        while (i <= region.getRowTo()) {
            HSSFRow row = sheet.getRow(i);
            HSSFCell cell = row.getCell(region.getColumnFrom());
            if (cell != null) {
                cell.setCellStyle(cs);
            }
            ++i;
        }
    }
}

