/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffleserver.factory;

import com.ecc.shuffle.db.DbControl;
import com.ecc.shuffle.org.OrgFactory;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.upgrade.ext.UNID;
import com.ecc.shuffleserver.ShuffleServlet;
import com.ecc.shuffleserver.manager.PublishExtIF;
import com.ecc.shuffleserver.manager.PublishManagerImpl;
import com.ecc.shufflestudio.editor.ModelWrapper;
import com.ecc.shufflestudio.editor.RuleSetWrapper;
import com.ecc.shufflestudio.editor.function.FunctionsWrapper;
import com.ecc.shufflestudio.permission.UserInfo;
import com.ecc.shufflestudio.ui.view.AppClassify;
import com.ecc.shufflestudio.ui.view.ReturnObj;
import com.ecc.shufflestudio.ui.view.RuleSetInfo;
import com.ecc.shufflestudio.ui.view.VersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerFactory {
    DbControl db = DbControl.getInstance();

    public FunctionsWrapper getFunctions(String filePath) {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(new File(filePath));
            Element root = doc.getDocumentElement();
            return FunctionsWrapper.translate2Wrapper((Element)root);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ReturnObj login(Map map) {
        UserInfo userInfo = new UserInfo();
        String userName = (String)map.get("userName");
        String password = (String)map.get("password");
        userInfo.setUserName(userName);
        userInfo.setPassword(password);
        ReturnObj obj = this.setRObj(true, "\u767b\u9646\u6210\u529f", userInfo);
        return obj;
    }

    public ReturnObj checkOut(Map map) {
        ReturnObj obj = new ReturnObj();
        String name = (String)map.get("name");
        String userName = (String)map.get("userName");
        String sqlStr = "select * from sf_ruleSetInfo where name='" + name + "'";
        Map rsMap = null;
        try {
            rsMap = this.db.querySingle(sqlStr);
        }
        catch (SQLException e) {
            obj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return obj;
        }
        String checkOut = (String)rsMap.get("checkout");
        if (!"checkIn".equals(checkOut) && !checkOut.equals(null)) {
            obj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5df2\u88ab\u7528\u6237" + checkOut + "\u9501\u5b9a", null);
            return obj;
        }
        String version = null;
        try {
            version = this.getVersionNum(name);
        }
        catch (SQLException e1) {
            obj = this.setRObj(false, "\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25", null);
            e1.printStackTrace();
            return obj;
        }
        try {
            obj = this.getRuleSetWrapper(String.valueOf(name) + "." + version, ".version");
        }
        catch (Exception e) {
            obj = this.setRObj(false, "\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25", null);
            e.printStackTrace();
            return obj;
        }
        RuleSetWrapper rsWra = (RuleSetWrapper)obj.getObj();
        ReturnObj o = null;
        o = this.createRuleSetFile(rsWra, ".ruleset");
        if (!o.isFlag()) {
            return o;
        }
        obj.setFlag(true);
        String sql = "update sf_ruleSetInfo set checkOut='" + userName + "' where name='" + name + "'";
        try {
            this.db.singleExecute(sql);
        }
        catch (SQLException e) {
            obj = this.setRObj(false, "checkOut\u5931\u8d25", null);
            e.printStackTrace();
            return obj;
        }
        return obj;
    }

    public String getVersionNum(String name) throws SQLException {
        String sql = "select * from sf_ruleSetVersion where name='" + name + "' order by version desc";
        List list = this.db.queryAllInfos(sql);
        if (list != null && list.size() > 0) {
            String version = (String)((Map)list.get(0)).get("version");
            return version;
        }
        return "";
    }

    public ReturnObj open(Map map) {
        Map rsMap;
        ReturnObj rObj = new ReturnObj();
        String rsId = (String)map.get("rsId");
        String userName = (String)map.get("userName");
        Object ruleSetWra = null;
        String sql = "select * from sf_ruleSetInfo where name='" + rsId + "'";
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            rsMap = this.db.querySingle(sql);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        String checkOut = (String)rsMap.get("checkout");
        if (userName.equals(checkOut)) {
            try {
                rObj = this.getRuleSetWrapper(rsId, ".ruleset");
            }
            catch (Exception e) {
                e.printStackTrace();
                rObj = this.setRObj(false, "\u5f97\u5230.ruleset\u5bf9\u8c61\u51fa\u9519", null);
                return rObj;
            }
            if (rObj.isFlag()) {
                returnMap.put("editable", true);
                returnMap.put("rsWra", rObj.getObj());
                rObj.setObj(returnMap);
            }
        } else {
            String sqlStr = "select * from sf_ruleSetVersion where name='" + rsId + "'";
            try {
                List list = this.db.queryAllInfos(sqlStr);
                if (list.size() == 0) {
                    rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5f53\u524d\u65e0\u5386\u53f2\u7248\u672c", null);
                    return rObj;
                }
            }
            catch (SQLException e1) {
                rObj = this.setRObj(false, "\u67e5\u8be2\u5386\u53f2\u7248\u672c\u4fe1\u606f\u51fa\u9519", null);
                e1.printStackTrace();
                return rObj;
            }
            String version = null;
            try {
                version = this.getVersionNum(rsId);
            }
            catch (SQLException e1) {
                rObj = this.setRObj(false, "\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25", null);
                e1.printStackTrace();
                return rObj;
            }
            try {
                rObj = this.getRuleSetWrapper(String.valueOf(rsId) + "." + version, ".version");
            }
            catch (Exception e) {
                e.printStackTrace();
                return rObj;
            }
            if (rObj.isFlag()) {
                returnMap.put("editable", false);
                returnMap.put("rsWra", rObj.getObj());
                rObj.setObj(returnMap);
            }
        }
        rObj.setFlag(true);
        return rObj;
    }

    public ReturnObj getRuleSet(Map map) {
        ReturnObj rObj = new ReturnObj();
        rObj.setFlag(false);
        String ruleSetId = (String)map.get("ruleSetId");
        Object ruleSetWra = null;
        String version = null;
        try {
            version = this.getVersionNum(ruleSetId);
        }
        catch (SQLException e1) {
            rObj = this.setRObj(false, "\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25", null);
            e1.printStackTrace();
            return rObj;
        }
        try {
            rObj = this.getRuleSetWrapper(String.valueOf(ruleSetId) + "." + version, ".version");
        }
        catch (Exception e) {
            e.printStackTrace();
            return rObj;
        }
        return rObj;
    }

    public ReturnObj getRule(Map map) {
        ReturnObj rObj = new ReturnObj();
        rObj.setFlag(false);
        String ruleSetId = (String)map.get("ruleSetId");
        String ruleId = (String)map.get("ruleId");
        Object ruleSetWra = null;
        String version = null;
        try {
            version = this.getVersionNum(ruleSetId);
        }
        catch (SQLException e1) {
            rObj = this.setRObj(false, "\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25", null);
            e1.printStackTrace();
            return rObj;
        }
        try {
            rObj = this.getRuleSetWrapper(String.valueOf(ruleSetId) + "." + version, ".version");
        }
        catch (Exception e) {
            e.printStackTrace();
            return rObj;
        }
        if (rObj.isFlag()) {
            RuleSetWrapper rsWrapper = (RuleSetWrapper)rObj.getObj();
            ModelWrapper wm = rsWrapper.getRule(ruleId);
            rObj.setObj((Object)wm);
        }
        return rObj;
    }

    public ReturnObj getAllRuleSet(Map uMap) {
        ReturnObj rObj = new ReturnObj();
        String userName = (String)uMap.get("userName");
        String sql = "select * from sf_ruleSetInfo";
        sql = uMap.containsKey("sysid") ? String.valueOf(sql) + " where sysid='" + (String)uMap.get("sysid") + "'" : String.valueOf(sql) + " where sysid is null or sysid=''";
        List list = null;
        try {
            list = this.db.queryAllInfos(sql);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u6570\u636e\u5e93\u8868\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        ArrayList<RuleSetInfo> resultList = new ArrayList<RuleSetInfo>();
        int i = 0;
        while (i < list.size()) {
            Map map = (Map)list.get(i);
            String forder = (String)map.get("forder");
            String id = (String)map.get("name");
            String name = (String)map.get("cnname");
            String desc = (String)map.get("descinfo");
            String checkOut = (String)map.get("checkout");
            RuleSetInfo ruleSetInfo = new RuleSetInfo(id, name);
            ruleSetInfo.setForder(forder);
            ruleSetInfo.setInfo(desc);
            ruleSetInfo.setCheckOut(checkOut);
            ruleSetInfo.desc = (String)map.get("descinfo");
            ruleSetInfo.levels = (String)map.get("levels");
            ruleSetInfo.type = (String)map.get("type");
            ruleSetInfo.appsign = (String)map.get("appsign");
            ruleSetInfo.setPublishExtClass((String)map.get("publishext"));
            resultList.add(ruleSetInfo);
            ++i;
        }
        rObj = this.setRObj(true, "\u67e5\u8be2\u6210\u529f", resultList);
        return rObj;
    }

    public ReturnObj getAllAppClassify(Map uMap) {
        ReturnObj rObj = new ReturnObj();
        String sql = "select * from sf_appClassify";
        sql = uMap.containsKey("sysid") ? String.valueOf(sql) + " where sysid='" + (String)uMap.get("sysid") + "'" : String.valueOf(sql) + " where sysid is null or sysid=''";
        List list = null;
        try {
            list = this.db.queryAllInfos(sql);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u6570\u636e\u5e93\u8868\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        ArrayList<AppClassify> resultList = new ArrayList<AppClassify>();
        int i = 0;
        while (i < list.size()) {
            Map map = (Map)list.get(i);
            String forder = (String)map.get("forder");
            String cnname = (String)map.get("cnname");
            String descInfo = (String)map.get("descinfo");
            AppClassify app = new AppClassify(forder, cnname);
            app.setInfo(descInfo);
            resultList.add(app);
            ++i;
        }
        if (resultList.size() == 0) {
            rObj = this.setRObj(false, "\u672a\u67e5\u5230\u76f8\u5e94\u8bb0\u5f55", resultList);
            return rObj;
        }
        rObj = this.setRObj(true, "\u67e5\u8be2\u6210\u529f", resultList);
        return rObj;
    }

    public ReturnObj deleteApp(Map map) {
        ReturnObj rObj = new ReturnObj();
        String forder = (String)map.get("forder");
        String sql = "select * from sf_ruleSetInfo";
        List list = new ArrayList();
        try {
            String sqlStr;
            boolean flag;
            list = this.db.queryAllInfos(sql);
            if (list.size() != 0) {
                int i = 0;
                while (i < list.size()) {
                    Map rsMap = (Map)list.get(i);
                    String rsForder = (String)rsMap.get("forder");
                    if (rsForder.equals(forder)) {
                        rObj = this.setRObj(false, "\u8be5\u5e94\u7528\u5206\u7c7b\u4e0b\u5b58\u5728\u89c4\u5219\u96c6\uff0c\u65e0\u6cd5\u5220\u9664\uff01", null);
                        return rObj;
                    }
                    ++i;
                }
            }
            if (!(flag = this.db.singleExecute(sqlStr = "delete from sf_appClassify where forder='" + forder + "'"))) {
                rObj = this.setRObj(false, "\u5220\u9664\u5e94\u7528\u5206\u7c7b\u4fe1\u606f\u65f6\u51fa\u9519", null);
                return rObj;
            }
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        rObj.setFlag(true);
        return rObj;
    }

    public ReturnObj move(Map map) {
        ReturnObj rObj = new ReturnObj();
        String userName = (String)map.get("userName");
        String forder = (String)map.get("forder");
        String rsId = (String)map.get("rsId");
        String SQLString = "select * from sf_ruleSetInfo where name='" + rsId + "'";
        String checkOut = null;
        try {
            Map oldMap = this.db.querySingle(SQLString);
            checkOut = (String)oldMap.get("checkout");
            if (!(checkOut.equals(userName) || checkOut.equals("checkIn") || checkOut.equals(null))) {
                rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5df2\u88ab\u7528\u6237" + checkOut + "\u9501\u5b9a\uff0c\u60a8\u65e0\u6cd5\u79fb\u52a8", null);
                return rObj;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25", null);
            return rObj;
        }
        String sql = "update sf_ruleSetInfo set forder='" + forder + "' where name='" + rsId + "'";
        try {
            boolean flag = this.db.singleExecute(sql);
            if (!flag) {
                rObj = this.setRObj(false, "\u66f4\u6539\u89c4\u5219\u96c6\u76ee\u5f55\u4fe1\u606f\u51fa\u9519", null);
                return rObj;
            }
            rObj.setFlag(true);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u66f4\u6539\u89c4\u5219\u96c6\u76ee\u5f55\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        return rObj;
    }

    public ReturnObj queryVersions(String rsId) {
        ReturnObj obj = new ReturnObj();
        String sql = "select * from sf_ruleSetVersion where name='" + rsId + "' order by version";
        try {
            List list = this.db.queryAllInfos(sql);
            ArrayList<VersionInfo> resultList = new ArrayList<VersionInfo>();
            int i = 0;
            while (i < list.size()) {
                Map map = (Map)list.get(i);
                String name = (String)map.get("name");
                String version = (String)map.get("version");
                String versionDesc = (String)map.get("versiondesc");
                String pubInfo = (String)map.get("pubinfo");
                VersionInfo versionInfo = new VersionInfo();
                versionInfo.setName(name);
                versionInfo.setVersion(version);
                versionInfo.setVersionDesc(versionDesc);
                versionInfo.setPubInfo(pubInfo);
                resultList.add(versionInfo);
                ++i;
            }
            if (resultList.size() == 0) {
                obj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u672a\u521b\u5efa\u5386\u53f2\u7248\u672c", resultList);
                return obj;
            }
            obj = this.setRObj(true, "\u67e5\u8be2\u7248\u672c\u4fe1\u606f\u6210\u529f", resultList);
        }
        catch (SQLException e) {
            obj = this.setRObj(false, "\u67e5\u8be2\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
            e.printStackTrace();
            return obj;
        }
        return obj;
    }

    public ReturnObj getVersionWra(String name) throws IOException, ClassNotFoundException {
        ReturnObj obj = new ReturnObj();
        obj = this.getRuleSetWrapper(name, ".version");
        return obj;
    }

    public ReturnObj deleteRuleSet(Map map) {
        Map rsMap;
        ReturnObj rObj = new ReturnObj();
        String ruleSetId = (String)map.get("rsId");
        String delAll = (String)map.get("delAll");
        String userName = (String)map.get("userName");
        String sqlString = "select * from sf_ruleSetInfo where name='" + ruleSetId + "'";
        HashMap returnMap = new HashMap();
        try {
            rsMap = this.db.querySingle(sqlString);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        String checkOut = (String)rsMap.get("checkout");
        if (!(checkOut.equals(null) || "checkIn".equals(checkOut) || userName.equals(checkOut))) {
            rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u88ab\u7528\u6237" + checkOut + "\u9501\u5b9a\uff0c\u60a8\u65e0\u6cd5\u5220\u9664", null);
            return rObj;
        }
        boolean flag = false;
        String sqlStr = "delete from sf_ruleSetInfo where name='" + ruleSetId + "'";
        try {
            flag = this.db.singleExecute(sqlStr);
            rObj = this.setRObj(true, "\u5220\u9664\u57fa\u672c\u4fe1\u606f\u6210\u529f", null);
        }
        catch (Exception e) {
            rObj = this.setRObj(false, "\u5220\u9664\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", null);
            return rObj;
        }
        if (checkOut.equals(userName)) {
            rObj = this.deleteRuleSetFile(ruleSetId, ".ruleset");
        }
        if (delAll.equals("yes")) {
            List verList = (List)this.queryVersions(ruleSetId).getObj();
            if (verList.size() == 0) {
                return rObj;
            }
            String sql = "delete from sf_ruleSetVersion where name='" + ruleSetId + "'";
            try {
                this.db.singleExecute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                rObj = this.setRObj(false, "\u5220\u9664\u89c4\u5219\u96c6\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
                return rObj;
            }
            int i = 0;
            while (i < verList.size()) {
                VersionInfo verInfo = (VersionInfo)verList.get(i);
                String version = verInfo.getVersion();
                rObj = this.deleteRuleSetFile(String.valueOf(ruleSetId) + "." + version, ".version");
                ++i;
            }
        }
        return rObj;
    }

    public ReturnObj deleteRuleSetUnpublished(Map map) {
        ReturnObj rObj = new ReturnObj();
        String ruleSetId = (String)map.get("rsId");
        List verList = (List)this.queryVersions(ruleSetId).getObj();
        if (verList.size() == 0) {
            return rObj;
        }
        String sql = "delete from sf_ruleSetVersion where name='" + ruleSetId + "' and pubinfo='unpublished'";
        try {
            this.db.singleExecute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            rObj = this.setRObj(false, "\u5220\u9664\u89c4\u5219\u96c6\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
            return rObj;
        }
        int i = 0;
        while (i < verList.size()) {
            VersionInfo verInfo = (VersionInfo)verList.get(i);
            if (verInfo.getPubInfo() != null && verInfo.getPubInfo().equalsIgnoreCase("unpublished")) {
                String version = verInfo.getVersion();
                rObj = this.deleteRuleSetFile(String.valueOf(ruleSetId) + "." + version, ".version");
            }
            ++i;
        }
        return rObj;
    }

    public ReturnObj deleteRuleSetVersion(Map map) {
        ReturnObj rObj = new ReturnObj();
        String rsId = (String)map.get("rsId");
        String version = (String)map.get("version");
        String sql = "delete from sf_ruleSetVersion where name='" + rsId + "' and version='" + version + "'";
        try {
            this.db.singleExecute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            rObj = this.setRObj(false, "\u5220\u9664\u89c4\u5219\u96c6\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
            return rObj;
        }
        rObj = this.deleteRuleSetFile(String.valueOf(rsId) + "." + version, ".version");
        return rObj;
    }

    public ReturnObj retrieveVersion(Map map) {
        ReturnObj rObj = new ReturnObj();
        String userName = (String)map.get("userName");
        String name = (String)map.get("name");
        String version = (String)map.get("version");
        String sqlStr = "select * from sf_ruleSetInfo where name='" + name + "'";
        Map rsMap = null;
        try {
            String sql;
            boolean flag;
            rsMap = this.db.querySingle(sqlStr);
            String checkOut = (String)rsMap.get("checkout");
            if (!("checkIn".equals(checkOut) || userName.equals(checkOut) || checkOut.equals(null))) {
                rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5df2\u88ab\u7528\u6237" + checkOut + "\u9501\u5b9a\uff0c\u60a8\u65e0\u6cd5\u8fdb\u884c\u6062\u590d", null);
                return rObj;
            }
            try {
                rObj = this.getVersionWra(String.valueOf(name) + "." + version);
            }
            catch (Exception e1) {
                rObj = this.setRObj(false, "\u5f97\u5230\u6700\u65b0\u7248\u672c\u89c4\u5219\u96c6\u5931\u8d25", null);
                e1.printStackTrace();
            }
            RuleSetWrapper rsWra = (RuleSetWrapper)rObj.getObj();
            String path = ShuffleServlet.getWrapperFolderPath();
            File file = new File(String.valueOf(path) + "/" + name + ".ruleset");
            if (file.exists()) {
                file.delete();
            }
            if (!(rObj = this.createRuleSetFile(rsWra, ".ruleset")).isFlag()) {
                return rObj;
            }
            if ("checkIn".equals(checkOut) && !(flag = this.db.singleExecute(sql = "update sf_ruleSetInfo set checkOut='" + userName + "' where name='" + name + "'"))) {
                rObj = this.setRObj(false, "\u66f4\u6539\u89c4\u5219\u96c6checkOut\u72b6\u6001\u51fa\u9519", null);
            }
            rObj = this.setRObj(true, "\u6062\u590d\u6210\u529f", rsWra);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        return rObj;
    }

    public ReturnObj publish(Map map, PublishManagerImpl publishManager) {
        ReturnObj rObj = new ReturnObj();
        String userName = (String)map.get("userName");
        String id = (String)map.get("id");
        String version = (String)map.get("version");
        String SQL = "select * from sf_ruleSetInfo where name='" + id + "'";
        Map rsInfoMap = new HashMap();
        String forder = null;
        try {
            rsInfoMap = this.db.querySingle(SQL);
            forder = (String)rsInfoMap.get("forder");
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u5e94\u7528\u5206\u7c7b\u76ee\u5f55\u5931\u8d25", null);
            return rObj;
        }
        String sql = "update sf_ruleSetVersion set pubInfo='unpublished' where name='" + id + "'";
        try {
            boolean flag = this.db.singleExecute(sql);
            if (!flag) {
                rObj = this.setRObj(false, "\u66f4\u65b0\u7248\u672c\u4fe1\u606f\u65f6\u51fa\u9519", null);
                return rObj;
            }
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u66f4\u65b0\u7248\u672c\u4fe1\u606f\u65f6\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        String sqlStr = "update sf_ruleSetVersion set pubInfo='published' where name='" + id + "' and version='" + version + "'";
        try {
            boolean flag = this.db.singleExecute(sqlStr);
            if (!flag) {
                rObj = this.setRObj(false, "\u66f4\u65b0\u5931\u8d25", null);
                return rObj;
            }
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u66f4\u65b0\u7248\u672c\u4fe1\u606f\u65f6\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        try {
            ReturnObj rsReturnObj = this.getRuleSetWrapper(String.valueOf(id) + "." + version, ".version");
            RuleSetWrapper rsWra = (RuleSetWrapper)rsReturnObj.getObj();
            rsWra.version = version;
            Source source = rsWra.publishSource();
            publishManager.publish2TargetServer(source, forder, String.valueOf(id) + ".rule");
            String publishExtClass = rsWra.publishExtClass;
            if (publishExtClass != null && publishExtClass.trim().length() > 1) {
                PublishExtIF pe = (PublishExtIF)Class.forName(publishExtClass).newInstance();
                pe.doExecute(rsWra);
            }
        }
        catch (Exception e) {
            rObj = this.setRObj(false, "\u53d1\u5e03\u89c4\u5219\u96c6\u51fa\u73b0\u5f02\u5e38", null);
            e.printStackTrace();
            return rObj;
        }
        rObj.setFlag(true);
        return rObj;
    }

    public ReturnObj insertRuleSet(Map map) {
        Map m;
        ReturnObj rObj = new ReturnObj();
        String id = (String)map.get("id");
        String name = (String)map.get("name");
        String desc = (String)map.get("desc");
        String forder = (String)map.get("forder");
        String userName = (String)map.get("userName");
        String sqlStr = "select * from sf_ruleSetInfo where name='" + id + "'";
        try {
            m = this.db.querySingle(sqlStr);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25[SQLException]", null);
            return rObj;
        }
        if (m.size() == 0) {
            RuleSetWrapper wrapper = RuleSetWrapper.createRuleSet((String)id, (String)name);
            wrapper.desc = desc;
            wrapper.levels = (String)map.get("levels");
            wrapper.type = (String)map.get("type");
            wrapper.appsign = (String)map.get("appsign");
            wrapper.publishExtClass = (String)map.get("publishext");
            rObj = this.createRuleSetFile(wrapper, ".ruleset");
            if (!rObj.isFlag()) {
                return rObj;
            }
            String sql = map.containsKey("sysid") ? "insert into sf_ruleSetInfo(name,cnname,descInfo,forder,checkOut,levels,type,appsign,publishext,sysid) values('" + id + "','" + name + "','" + desc + "','" + forder + "','" + userName + "','" + (String)map.get("levels") + "','" + (String)map.get("type") + "','" + (String)map.get("appsign") + "','" + (String)map.get("publishext") + "','" + (String)map.get("sysid") + "')" : "insert into sf_ruleSetInfo(name,cnname,descInfo,forder,checkOut,levels,type,appsign,publishext) values('" + id + "','" + name + "','" + desc + "','" + forder + "','" + userName + "','" + (String)map.get("levels") + "','" + (String)map.get("type") + "','" + (String)map.get("appsign") + "','" + (String)map.get("publishext") + "')";
            try {
                this.db.singleExecute(sql);
            }
            catch (SQLException e) {
                rObj = this.setRObj(false, "\u63d2\u5165\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", null);
                return rObj;
            }
        } else {
            rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u89c4\u5219\u96c6\u540d\u79f0\uff01", null);
            return rObj;
        }
        rObj = this.setRObj(true, "\u521b\u5efa\u89c4\u5219\u96c6\u6210\u529f", null);
        return rObj;
    }

    public ReturnObj ifRuleSetExist(Map map) {
        Map m;
        ReturnObj rObj = new ReturnObj();
        String id = (String)map.get("id");
        String sqlStr = "select * from sf_ruleSetInfo where name='" + id + "'";
        try {
            m = this.db.querySingle(sqlStr);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25[SQLException]", null);
            return rObj;
        }
        rObj = m.size() == 0 ? this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u4e0d\u5b58\u5728", null) : this.setRObj(true, "\u8be5\u89c4\u5219\u96c6\u5df2\u5b58\u5728", null);
        return rObj;
    }

    public ReturnObj importRS(Map map) {
        Map m;
        ReturnObj rObj = new ReturnObj();
        String forder = (String)map.get("forder");
        String descInfo = (String)map.get("descInfo");
        RuleSetWrapper rsWra = (RuleSetWrapper)map.get("rsWra");
        String id = rsWra.getId();
        String name = rsWra.getName();
        String userName = (String)map.get("userName");
        String sqlStr = "select * from sf_ruleSetInfo where name='" + id + "'";
        try {
            m = this.db.querySingle(sqlStr);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25[SQLException]", null);
            return rObj;
        }
        if (m.size() == 0) {
            rObj = this.createRuleSetFile(rsWra, ".ruleset");
            if (!rObj.isFlag()) {
                return rObj;
            }
            String sql = "insert into sf_ruleSetInfo(name,cnname,descInfo,forder,checkOut,levels,type,appsign,publishext) values('" + id + "','" + name + "','" + descInfo + "','" + forder + "','" + userName + "','" + (String)map.get("levels") + "','" + (String)map.get("type") + "','" + (String)map.get("appsign") + "','" + (String)map.get("publishext") + "')";
            try {
                this.db.singleExecute(sql);
            }
            catch (SQLException e) {
                rObj = this.setRObj(false, "\u63d2\u5165\u89c4\u5219\u96c6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", null);
                return rObj;
            }
        } else {
            rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u89c4\u5219\u96c6\u540d\u79f0\uff01", null);
            return rObj;
        }
        rObj = this.setRObj(true, "\u521b\u5efa\u89c4\u5219\u96c6\u6210\u529f", null);
        return rObj;
    }

    public ReturnObj saveRuleSet(Map map) {
        ReturnObj rObj = new ReturnObj();
        RuleSetWrapper wrapper = (RuleSetWrapper)map.get("rsWra");
        rObj = this.createRuleSetFile(wrapper, ".ruleset");
        if (!rObj.isFlag()) {
            return rObj;
        }
        return rObj;
    }

    public ReturnObj checkIn(Map map) {
        ReturnObj rObj = new ReturnObj();
        String name = (String)map.get("name");
        String version = (String)map.get("version");
        String versionDesc = (String)map.get("versionDesc");
        String userName = (String)map.get("userName");
        try {
            String path = ShuffleServlet.getWrapperFolderPath();
            File file = new File(String.valueOf(path) + "/" + name + ".ruleset");
            if (!file.exists()) {
                rObj = this.setRObj(false, "\u89c4\u5219\u96c6.ruleset\u6587\u4ef6\u4e0d\u5b58\u5728", null);
                return rObj;
            }
            file.renameTo(new File(String.valueOf(path) + "/" + name + "." + version + ".version"));
        }
        catch (Exception e) {
            rObj = this.setRObj(false, "\u91cd\u547d\u540d\u51fa\u73b0\u5f02\u5e38", null);
            return rObj;
        }
        String sql = "insert into sf_ruleSetVersion(name,version,versionDesc,pubInfo) values('" + name + "','" + version + "','" + versionDesc + "','unpublished')";
        try {
            boolean flag = this.db.singleExecute(sql);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u63d2\u5165\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
            e.printStackTrace();
            return rObj;
        }
        String sqlStr = "update sf_ruleSetInfo set checkOut='checkIn' where name='" + name + "'";
        try {
            this.db.singleExecute(sqlStr);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u4fee\u6539checkOut\u72b6\u6001\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        rObj.setFlag(true);
        return rObj;
    }

    public ReturnObj createApp(Map map) {
        ReturnObj rObj = new ReturnObj();
        String forder = (String)map.get("forder");
        String cnname = (String)map.get("cnname");
        String descInfo = (String)map.get("descInfo");
        String sql = "select * from sf_appClassify where forder='" + forder + "'";
        try {
            Map m = this.db.querySingle(sql);
            if (m.size() != 0) {
                rObj = this.setRObj(false, "\u8be5\u5e94\u7528\u5206\u7c7b\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u540d\u79f0", null);
                return rObj;
            }
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u5e94\u7528\u5206\u7c7b\u4fe1\u606f\u51fa\u9519", null);
            e.printStackTrace();
            return rObj;
        }
        String sqlStr = map.containsKey("sysid") ? "insert into sf_appClassify(forder,cnname,descInfo,sysid) values('" + forder + "','" + cnname + "','" + descInfo + "','" + (String)map.get("sysid") + "')" : "insert into sf_appClassify(forder,cnname,descInfo) values('" + forder + "','" + cnname + "','" + descInfo + "')";
        try {
            this.db.singleExecute(sqlStr);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u65b0\u589e\u5e94\u7528\u5206\u7c7b\u4fe1\u606f", null);
            e.printStackTrace();
            return rObj;
        }
        rObj.setFlag(true);
        return rObj;
    }

    public ReturnObj rename(Map map) {
        Map m;
        ReturnObj rObj = new ReturnObj();
        String id = (String)map.get("id");
        String name = (String)map.get("name");
        String oldId = (String)map.get("oldId");
        String userName = (String)map.get("userName");
        String SQL = "select * from sf_ruleSetInfo where name='" + id + "'";
        try {
            m = this.db.querySingle(SQL);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25", null);
            return rObj;
        }
        if (m.size() != 0 && !id.equals(oldId)) {
            rObj = this.setRObj(false, "\u89c4\u5219\u96c6\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01", null);
            return rObj;
        }
        String SQLString = "select * from sf_ruleSetInfo where name='" + oldId + "'";
        String checkOut = null;
        try {
            Map oldMap = this.db.querySingle(SQLString);
            checkOut = (String)oldMap.get("checkout");
            if (!(checkOut.equals(userName) || checkOut.equals("checkIn") || checkOut.equals(null))) {
                rObj = this.setRObj(false, "\u8be5\u89c4\u5219\u96c6\u5df2\u88ab\u7528\u6237" + checkOut + "\u9501\u5b9a\uff0c\u60a8\u65e0\u6cd5\u8fdb\u884c\u91cd\u547d\u540d", null);
                return rObj;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25", null);
            return rObj;
        }
        String path = ShuffleServlet.getWrapperFolderPath();
        RuleSetWrapper rsWra = null;
        if (checkOut.equals(userName)) {
            File file = new File(String.valueOf(path) + "/" + oldId + ".ruleset");
            if (!file.exists()) {
                rObj = this.setRObj(false, ".ruleset\u6587\u4ef6\u4e0d\u5b58\u5728", null);
                return rObj;
            }
            try {
                rObj = this.getRuleSetWrapper(oldId, ".ruleset");
            }
            catch (Exception e1) {
                rObj = this.setRObj(false, "\u83b7\u5f97.ruleset\u5bf9\u8c61\u5931\u8d25", null);
                e1.printStackTrace();
                return rObj;
            }
            rsWra = (RuleSetWrapper)rObj.getObj();
            rsWra.setId(id);
            rsWra.setName(name);
            rsWra.setDesc((String)map.get("desc"));
            rsWra.levels = (String)map.get("levels");
            rsWra.type = (String)map.get("type");
            rsWra.appsign = (String)map.get("appsign");
            rsWra.publishExtClass = (String)map.get("publishext");
            file.delete();
            this.createRuleSetFile(rsWra, ".ruleset");
        }
        String sql = "update sf_ruleSetInfo set name='" + id + "',cnname='" + name + "',descInfo='" + rsWra.desc + "',levels='" + rsWra.levels + "',type='" + rsWra.type + "',appsign='" + rsWra.appsign + "',publishext='" + rsWra.publishExtClass + "' where name='" + oldId + "'";
        try {
            this.db.singleExecute(sql);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u66f4\u65b0\u89c4\u5219\u96c6\u4fe1\u606f\u8868\u5931\u8d25", null);
            e.printStackTrace();
            return rObj;
        }
        String sqlStr = "select * from sf_ruleSetVersion where name='" + oldId + "'";
        List list = new ArrayList();
        try {
            list = this.db.queryAllInfos(sqlStr);
        }
        catch (SQLException e) {
            rObj = this.setRObj(false, "\u67e5\u8be2\u89c4\u5219\u96c6\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
            e.printStackTrace();
            return rObj;
        }
        if (list.size() != 0) {
            File directory = new File(path);
            File[] verFile = directory.listFiles();
            int i = 0;
            while (i < verFile.length) {
                String fileName = verFile[i].getName();
                String subName = fileName.substring(0, fileName.indexOf("."));
                if (subName.equals(oldId)) {
                    try {
                        rObj = this.getRuleSetWrapper(fileName, "");
                    }
                    catch (Exception e1) {
                        rObj = this.setRObj(false, "\u83b7\u5f97.version\u5bf9\u8c61\u5931\u8d25", null);
                        e1.printStackTrace();
                        return rObj;
                    }
                    RuleSetWrapper verWra = (RuleSetWrapper)rObj.getObj();
                    verWra.setId(id);
                    verWra.setName(name);
                    verFile[i].delete();
                    this.createRuleSetFile(verWra, fileName.substring(fileName.indexOf(".")));
                }
                ++i;
            }
            String sqlString = "update sf_ruleSetVersion set name='" + id + "',pubInfo='unpublished' where name='" + oldId + "'";
            try {
                this.db.singleExecute(sqlString);
            }
            catch (SQLException e) {
                rObj = this.setRObj(false, "\u66f4\u65b0\u7248\u672c\u4fe1\u606f\u5931\u8d25", null);
                e.printStackTrace();
                return rObj;
            }
        }
        rObj = this.setRObj(true, "\u91cd\u547d\u540d\u6210\u529f", rsWra);
        return rObj;
    }

    public ReturnObj createRuleSetFile(RuleSetWrapper wrapper, String expandName) {
        ReturnObj rObj = new ReturnObj();
        String name = wrapper.getId();
        try {
            String path = ShuffleServlet.getWrapperFolderPath();
            File file = new File(String.valueOf(path) + "/" + name + expandName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    rObj = this.setRObj(false, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25", null);
                    e.printStackTrace();
                    return rObj;
                }
            }
            FileOutputStream stream = new FileOutputStream(file);
            try {
                ObjectOutputStream objOut = new ObjectOutputStream(stream);
                objOut.writeObject(wrapper);
                stream.flush();
                objOut.close();
                stream.close();
            }
            catch (Exception e) {
                rObj = this.setRObj(false, "IO\u5f02\u5e38", null);
                e.printStackTrace();
            }
            rObj = this.setRObj(true, "\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return rObj;
    }

    public ReturnObj getRuleSetWrapper(String ruleSetId, String expandName) throws IOException, ClassNotFoundException {
        ReturnObj obj = new ReturnObj();
        RuleSetWrapper ruleSetWra = null;
        String path = ShuffleServlet.getWrapperFolderPath();
        File file = new File(String.valueOf(path) + "/" + ruleSetId + expandName);
        if (file.exists()) {
            FileInputStream input = new FileInputStream(file);
            ObjectInputStream objInput = new ObjectInputStream(input);
            ruleSetWra = (RuleSetWrapper)objInput.readObject();
            objInput.close();
            input.close();
            obj = this.setRObj(true, "\u5f97\u5230\u89c4\u5219\u96c6\u5bf9\u8c61", ruleSetWra);
        } else {
            System.out.println("\u89c4\u5219\u96c6\u6587\u4ef6\u4e0d\u5b58\u5728");
            obj = this.setRObj(false, "\u89c4\u5219\u96c6\u6587\u4ef6\u4e0d\u5b58\u5728", null);
        }
        return obj;
    }

    public ReturnObj deleteRuleSetFile(String name, String expandName) {
        ReturnObj obj = new ReturnObj();
        String path = ShuffleServlet.getWrapperFolderPath();
        File file = new File(String.valueOf(path) + "/" + name + expandName);
        if (file.exists()) {
            file.delete();
            obj = this.setRObj(true, "\u5220\u9664\u6210\u529f", null);
        } else {
            obj = this.setRObj(false, "\u5220\u9664\u89c4\u5219\u96c6\u6587\u4ef6\u5931\u8d25", null);
        }
        return obj;
    }

    public ReturnObj setRObj(boolean flag, String info, Object o) {
        ReturnObj rObj = new ReturnObj();
        rObj.setFlag(flag);
        rObj.setInfo(info);
        rObj.setObj(o);
        return rObj;
    }

    public ReturnObj getConstant() {
        try {
            List list = this.db.queryAllInfos("select * from sf_constant order by constant_id");
            LinkedHashMap varMap = new LinkedHashMap();
            int i = 0;
            while (i < list.size()) {
                Map hm = (Map)list.get(i);
                String constant_id = (String)hm.get("constant_id");
                HashMap<String, String> hm2 = new HashMap<String, String>();
                hm2.put("varid", constant_id);
                hm2.put("varname", (String)hm.get("constant_name"));
                hm2.put("vartype", (String)hm.get("constant_type"));
                hm2.put("varvalue", hm.get("constant_value") == null ? "" : (String)hm.get("constant_value"));
                hm2.put("vardesc", hm.get("constant_desc") == null ? "" : (String)hm.get("constant_desc"));
                varMap.put(constant_id, hm2);
                ++i;
            }
            ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u89c4\u5219\u5e38\u91cf\u6210\u529f", varMap);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            ReturnObj obj = this.setRObj(false, "\u8bfb\u53d6\u89c4\u5219\u5e38\u91cf\u5931\u8d25", new HashMap());
            return obj;
        }
    }

    public ReturnObj setConstant(Map varMap) {
        block22: {
            if (varMap == null || varMap.isEmpty()) {
                return this.setRObj(false, "\u8bbe\u7f6e\u89c4\u5219\u5e38\u91cf\u5931\u8d25", null);
            }
            Connection conn = null;
            Statement ps = null;
            try {
                try {
                    conn = this.db.getConnection();
                    conn.setAutoCommit(false);
                    ps = conn.prepareStatement("delete from sf_constant");
                    ps.execute();
                    ps = conn.prepareStatement("insert into sf_constant(constant_id,constant_name,constant_type,constant_value,constant_desc) values(?,?,?,?,?)");
                    Iterator it = varMap.keySet().iterator();
                    while (it.hasNext()) {
                        Map hm = (Map)varMap.get(it.next());
                        ps.clearParameters();
                        ps.setString(1, (String)hm.get("varid"));
                        ps.setString(2, (String)hm.get("varname"));
                        ps.setString(3, (String)hm.get("vartype"));
                        ps.setString(4, (String)hm.get("varvalue"));
                        ps.setString(5, (String)hm.get("vardesc"));
                        ps.execute();
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    e.printStackTrace();
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (conn != null) {
                            this.db.releaseConnection(conn);
                        }
                        break block22;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn != null) {
                        this.db.releaseConnection(conn);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    this.db.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ReturnObj obj = this.setRObj(true, "\u8bbe\u7f6e\u89c4\u5219\u5e38\u91cf\u6210\u529f", null);
        return obj;
    }

    public ReturnObj getVariable() {
        try {
            List list = this.db.queryAllInfos("select * from sf_var order by var_id");
            LinkedHashMap varMap = new LinkedHashMap();
            int i = 0;
            while (i < list.size()) {
                Map hm = (Map)list.get(i);
                String var_id = (String)hm.get("var_id");
                HashMap<String, String> hm2 = new HashMap<String, String>();
                hm2.put("varid", var_id);
                hm2.put("varname", (String)hm.get("var_name"));
                hm2.put("vartype", (String)hm.get("var_type"));
                hm2.put("varvalue", hm.get("var_value") == null ? "" : (String)hm.get("var_value"));
                hm2.put("vardesc", hm.get("var_desc") == null ? "" : (String)hm.get("var_desc"));
                varMap.put(var_id, hm2);
                ++i;
            }
            ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u89c4\u5219\u5e38\u91cf\u6210\u529f", varMap);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            ReturnObj obj = this.setRObj(false, "\u8bfb\u53d6\u89c4\u5219\u5e38\u91cf\u5931\u8d25", new HashMap());
            return obj;
        }
    }

    public ReturnObj setVariable(Map varMap) {
        block22: {
            if (varMap == null || varMap.isEmpty()) {
                return this.setRObj(false, "\u8bbe\u7f6e\u5168\u5c40\u53d8\u91cf\u5931\u8d25", null);
            }
            Connection conn = null;
            Statement ps = null;
            try {
                try {
                    conn = this.db.getConnection();
                    conn.setAutoCommit(false);
                    ps = conn.prepareStatement("delete from sf_var");
                    ps.execute();
                    ps = conn.prepareStatement("insert into sf_var(var_id,var_name,var_type,var_value,var_desc) values(?,?,?,?,?)");
                    Iterator it = varMap.keySet().iterator();
                    while (it.hasNext()) {
                        Map hm = (Map)varMap.get(it.next());
                        ps.clearParameters();
                        ps.setString(1, (String)hm.get("varid"));
                        ps.setString(2, (String)hm.get("varname"));
                        ps.setString(3, (String)hm.get("vartype"));
                        ps.setString(4, (String)hm.get("varvalue"));
                        ps.setString(5, (String)hm.get("vardesc"));
                        ps.execute();
                    }
                    conn.commit();
                    RuleBase.getInstance().initVariable();
                }
                catch (Exception e) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    e.printStackTrace();
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (conn != null) {
                            this.db.releaseConnection(conn);
                        }
                        break block22;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn != null) {
                        this.db.releaseConnection(conn);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    this.db.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ReturnObj obj = this.setRObj(true, "\u8bbe\u7f6e\u5168\u5c40\u53d8\u91cf\u6210\u529f", null);
        return obj;
    }

    public ReturnObj getTransList(Map map) {
        String sysid = null;
        if (map.containsKey("sysid")) {
            sysid = (String)map.get("sysid");
        }
        LinkedHashMap transMap = new LinkedHashMap();
        try {
            String sql = "select * from sf_trans";
            if (sysid != null) {
                sql = String.valueOf(sql) + " where sysid='" + sysid + "'";
            }
            sql = String.valueOf(sql) + " order by trans_id";
            List list = this.db.queryAllInfos(sql);
            for (Map hm : list) {
                String trans_id = (String)hm.get("trans_id");
                HashMap<String, Object> hm2 = new HashMap<String, Object>();
                hm2.put("id", trans_id);
                hm2.put("name", (String)hm.get("trans_name"));
                hm2.put("desc", hm.get("trans_desc") == null ? "" : (String)hm.get("trans_desc"));
                hm2.put("permission", hm.get("trans_permission") == null ? "" : (String)hm.get("trans_permission"));
                hm2.put("ext", hm.get("trans_ext") == null ? "" : (String)hm.get("trans_ext"));
                HashMap hm3 = new HashMap();
                List al = this.db.queryAllInfos("select * from sf_transrule where trans_id='" + trans_id + "'");
                for (Map m : al) {
                    String rulesetid = (String)m.get("rulesetid");
                    String ruleid = (String)m.get("ruleid");
                    ArrayList<String> ruleList = new ArrayList<String>();
                    if (ruleid != null && ruleid.length() > 0) {
                        StringTokenizer st = new StringTokenizer(ruleid, ";");
                        while (st.hasMoreElements()) {
                            ruleList.add((String)st.nextElement());
                        }
                    }
                    hm3.put(rulesetid, ruleList);
                }
                hm2.put("ruleMap", hm3);
                transMap.put(trans_id, hm2);
            }
            ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u89c4\u5219\u4ea4\u6613\u8bbe\u7f6e\u6210\u529f", transMap);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            ReturnObj obj = this.setRObj(false, "\u8bfb\u53d6\u89c4\u5219\u4ea4\u6613\u8bbe\u7f6e\u5931\u8d25", new HashMap());
            return obj;
        }
    }

    public ReturnObj newTrans(Map transMap) {
        if (transMap == null || !transMap.containsKey("id")) {
            return this.setRObj(false, "\u65b0\u5efa\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
        String sysid = null;
        if (transMap.containsKey("sysid")) {
            sysid = (String)transMap.get("sysid");
        }
        try {
            String transid = (String)transMap.get("id");
            String sql = "insert into sf_trans(trans_id,trans_name,trans_permission,trans_ext,trans_desc,sysid) values('" + transid + "','" + (String)transMap.get("name") + "','" + (String)transMap.get("permission") + "','" + (String)transMap.get("ext") + "','" + (String)transMap.get("desc") + "',";
            sql = sysid == null ? String.valueOf(sql) + "''" : String.valueOf(sql) + "'" + sql + "'";
            sql = String.valueOf(sql) + ")";
            this.db.singleExecute(sql);
            return this.setRObj(true, "\u65b0\u5efa\u89c4\u5219\u4ea4\u6613\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.setRObj(false, "\u65b0\u5efa\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
    }

    public ReturnObj removeTrans(Map transMap) {
        if (transMap == null || !transMap.containsKey("id")) {
            return this.setRObj(false, "\u5220\u9664\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
        try {
            String transid = (String)transMap.get("id");
            this.db.singleExecute("delete from sf_trans where trans_id='" + transid + "'");
            this.db.singleExecute("delete from sf_transrule where trans_id='" + transid + "'");
            RuleBase.getInstance().initTrans();
            return this.setRObj(true, "\u5220\u9664\u89c4\u5219\u4ea4\u6613\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.setRObj(false, "\u5220\u9664\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
    }

    public ReturnObj updateTrans(Map transMap) {
        if (transMap == null || !transMap.containsKey("id")) {
            return this.setRObj(false, "\u4fee\u6539\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
        String sysid = null;
        if (transMap.containsKey("sysid")) {
            sysid = (String)transMap.get("sysid");
        }
        try {
            String transid = (String)transMap.get("id");
            String sql = "update sf_trans set trans_name='" + (String)transMap.get("name") + "'," + "trans_permission='" + (String)transMap.get("permission") + "'," + "trans_ext='" + (String)transMap.get("ext") + "'," + "trans_desc='" + (String)transMap.get("desc") + "'";
            if (sysid != null && sysid.length() > 0) {
                sql = String.valueOf(sql) + ",sysid='" + sysid + "'";
            }
            sql = String.valueOf(sql) + " where trans_id='" + transid + "'";
            this.db.singleExecute(sql);
            RuleBase.getInstance().initTrans();
            return this.setRObj(true, "\u4fee\u6539\u89c4\u5219\u4ea4\u6613\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.setRObj(false, "\u4fee\u6539\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
    }

    public ReturnObj saveTrans(Map transMap) {
        if (transMap == null || !transMap.containsKey("id")) {
            return this.setRObj(false, "\u4fdd\u5b58\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
        String sysid = null;
        if (transMap.containsKey("sysid")) {
            sysid = (String)transMap.get("sysid");
        }
        try {
            String transid = (String)transMap.get("id");
            this.db.singleExecute("delete from sf_transrule where trans_id='" + transid + "'");
            Map ruleMap = (Map)transMap.get("ruleMap");
            if (ruleMap != null && !ruleMap.isEmpty()) {
                for (String rulesetid : ruleMap.keySet()) {
                    List al = (List)ruleMap.get(rulesetid);
                    String ruleid = "";
                    if (al != null && al.size() > 0) {
                        int i = 0;
                        while (i < al.size()) {
                            ruleid = String.valueOf(ruleid) + ";" + al.get(i);
                            ++i;
                        }
                    }
                    if (ruleid.length() > 0) {
                        ruleid = ruleid.substring(1);
                    }
                    this.db.singleExecute("insert into sf_transrule(trans_id,rulesetid,ruleid) values('" + transid + "','" + rulesetid + "','" + ruleid + "')");
                }
            }
            RuleBase.getInstance().initTrans();
            return this.setRObj(true, "\u4fdd\u5b58\u89c4\u5219\u4ea4\u6613\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.setRObj(false, "\u4fdd\u5b58\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
    }

    public ReturnObj saveTransByRule(String rulesetid, String ruleid, Map transMap) {
        try {
            for (String transid : transMap.keySet()) {
                Map map = this.db.querySingle("select ruleid from sf_transrule where trans_id='" + transid + "' and rulesetid='" + rulesetid + "'");
                if (map.isEmpty()) {
                    this.db.singleExecute("insert into sf_transrule(trans_id,rulesetid,ruleid) values('" + transid + "','" + rulesetid + "','" + ruleid + "')");
                    continue;
                }
                String s_ruleid = (String)map.get("ruleid");
                s_ruleid = s_ruleid == null || s_ruleid.trim().length() == 0 ? ruleid : String.valueOf(s_ruleid) + ";" + ruleid;
                this.db.singleExecute("update sf_transrule set ruleid='" + s_ruleid + "' where trans_id='" + transid + "' and rulesetid='" + rulesetid + "'");
            }
            RuleBase.getInstance().initTrans();
            return this.setRObj(true, "\u4fdd\u5b58\u89c4\u5219\u4ea4\u6613\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.setRObj(false, "\u4fdd\u5b58\u89c4\u5219\u4ea4\u6613\u5931\u8d25", null);
        }
    }

    public ReturnObj getExtClass() {
        LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
        FileInputStream is = null;
        try {
            File varFile;
            String varFilePath = String.valueOf(ShuffleServlet.shufflepath) + "\\extclass.xml";
            if (System.getProperty("file.separator") != null && System.getProperty("file.separator").equals("/")) {
                varFilePath = varFilePath.replaceAll("\\\\", "/");
            }
            if ((varFile = new File(varFilePath)).exists() && varFile.isFile()) {
                is = new FileInputStream(varFile);
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(is);
                Element root = doc.getDocumentElement();
                NodeList nodeList = root.getElementsByTagName("ec");
                int i = 0;
                i = 0;
                while (i < nodeList.getLength()) {
                    Element element = (Element)nodeList.item(i);
                    hm.put(element.getAttribute("name"), element.getAttribute("implClass"));
                    ++i;
                }
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u6269\u5c55\u5b9e\u73b0\u7c7b\u6210\u529f", hm);
        return obj;
    }

    private void readVar(Map hm, String str) {
        if (str != null && str.length() > 0) {
            String s = str;
            int curIdx = 0;
            while (s.indexOf("$$") != -1) {
                s = s.substring(s.indexOf("$$") + 2, s.length());
                curIdx = 0;
                while (curIdx < s.length()) {
                    char chr = s.charAt(curIdx);
                    if (chr == ' ' || chr == '\r' || chr == '\n' || chr == '\t' || chr == '{' || chr == '}' || chr == '(' || chr == ')' || chr == ';' || chr == '#' || chr == ':' || chr == '+' || chr == '-' || chr == '*' || chr == '%' || chr == '/' || chr == '@' || chr == '=' || chr == ',' || chr == '!' || chr == '>' || chr == '<' || chr == '&' || chr == '|' || chr == '$') break;
                    ++curIdx;
                }
                hm.put(s.substring(0, curIdx), "");
            }
        }
    }

    public ReturnObj getGuideLine() {
        try {
            List list = this.db.queryAllInfos("select gl_id,gl_name from sf_guideline order by gl_id");
            LinkedHashMap varMap = new LinkedHashMap();
            int i = 0;
            while (i < list.size()) {
                Map hm = (Map)list.get(i);
                varMap.put(hm.get("gl_id"), hm.get("gl_name"));
                ++i;
            }
            ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u6307\u6807\u5b57\u5178\u53c2\u6570\u6210\u529f", varMap);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            ReturnObj obj = this.setRObj(false, "\u8bfb\u53d6\u89c4\u5219\u5e38\u91cf\u5931\u8d25", new HashMap());
            return obj;
        }
    }

    public ReturnObj recordStudioOperation(Map map) {
        ReturnObj obj = new ReturnObj();
        String userName = (String)map.get("userName");
        String TRANS_TYPE = (String)map.get("TRANS_TYPE");
        String OPERATION_TYPE = (String)map.get("OPERATION_TYPE");
        String OPERATION_CONTENT = (String)map.get("OPERATION_CONTENT");
        String sqlStr = "insert into sf_operation(OPERATION_ID,TRANS_TYPE,USER_ID,OPERATION_TIME,OPERATION_TYPE,OPERATION_CONTENT) values('" + UNID.getNextSNa() + "','" + TRANS_TYPE + "','" + userName + "','" + UNID.getNowDateTimeString() + "','" + OPERATION_TYPE + "','" + OPERATION_CONTENT + "')";
        try {
            boolean flag = this.db.singleExecute(sqlStr);
            if (!flag) {
                obj = this.setRObj(false, "ShuffleStudio\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", null);
                return obj;
            }
        }
        catch (SQLException e) {
            obj = this.setRObj(false, "ShuffleStudio\u64cd\u4f5c\u8bb0\u5f55\u65f6\u51fa\u9519", null);
            e.printStackTrace();
            return obj;
        }
        return obj;
    }

    public ReturnObj getAllRoles() {
        Map map;
        block14: {
            Connection con = null;
            map = new HashMap();
            try {
                try {
                    con = this.db.getConnection();
                    map = OrgFactory.getInstance().getOrgClass().getAllRoles(con);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (con != null) {
                            this.db.releaseConnection(con);
                        }
                        break block14;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        this.db.releaseConnection(con);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (con != null) {
                    this.db.releaseConnection(con);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u6240\u6709\u89d2\u8272\u4fe1\u606f", map);
        return obj;
    }

    public ReturnObj getAllGroups() {
        Map map;
        block14: {
            Connection con = null;
            map = new HashMap();
            try {
                try {
                    con = this.db.getConnection();
                    map = OrgFactory.getInstance().getOrgClass().getAllGroups(con);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (con != null) {
                            this.db.releaseConnection(con);
                        }
                        break block14;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        this.db.releaseConnection(con);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (con != null) {
                    this.db.releaseConnection(con);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u6240\u6709\u5c97\u4f4d\u4fe1\u606f", map);
        return obj;
    }

    public ReturnObj getAllUsers() {
        Map map;
        block14: {
            Connection con = null;
            map = new HashMap();
            try {
                try {
                    con = this.db.getConnection();
                    map = OrgFactory.getInstance().getOrgClass().getAllUsers(con);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (con != null) {
                            this.db.releaseConnection(con);
                        }
                        break block14;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        this.db.releaseConnection(con);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (con != null) {
                    this.db.releaseConnection(con);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ReturnObj obj = this.setRObj(true, "\u8bfb\u53d6\u6240\u6709\u7528\u6237\u4fe1\u606f", map);
        return obj;
    }
}

