/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffleserver.manager;

import com.ecc.shufflestudio.permission.UserInfo;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class AccessManager {
    private long loginTimeOut = 3600000L;
    private Hashtable userStatus = new Hashtable();
    private static AccessManager instance = new AccessManager();
    private static final char[] DICTIONARY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static Object syncObj = new Object();
    private static long counter = 0L;
    private String computerAddr = null;

    public static AccessManager getInstance() {
        return instance;
    }

    private AccessManager() {
    }

    public void setLoginTimeOut(String s) {
        try {
            this.loginTimeOut = Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public long getLoginTimeOut() {
        return this.loginTimeOut;
    }

    public boolean userHasLogin(String userName) {
        if (userName != null) {
            return this.userStatus.containsKey(userName);
        }
        return false;
    }

    public void registerUser(UserInfo aUser) {
        if (aUser == null) {
            return;
        }
        String userName = aUser.getUserName();
        if (this.userStatus.containsKey(userName)) {
            this.userStatus.remove(userName);
        }
        long currentTime = System.currentTimeMillis();
        String sessionId = this.generateSessionId();
        aUser.setSessionId(sessionId);
        aUser.setTimestamp(currentTime);
        this.userStatus.put(userName, aUser);
        System.out.println("User[" + userName + "] login:sessionId=" + sessionId);
    }

    public void registerUser(UserInfo aUser, String sessionId) {
        if (aUser == null) {
            return;
        }
        String userName = aUser.getUserName();
        if (this.userStatus.containsKey(userName)) {
            this.userStatus.remove(userName);
        }
        long currentTime = System.currentTimeMillis();
        aUser.setSessionId(sessionId);
        aUser.setTimestamp(currentTime);
        this.userStatus.put(userName, aUser);
        System.out.println("User[" + userName + "] login:sessionId=" + sessionId);
    }

    public void unregisterUser(String userName, String sessionId) {
        UserInfo aUser;
        if (userName == null || userName.trim().length() == 0) {
            return;
        }
        if (this.userStatus.containsKey(userName) && (aUser = (UserInfo)this.userStatus.get(userName)).getSessionId().equals(sessionId)) {
            this.userStatus.remove(userName);
            System.out.println("User[" + userName + "] logoff:sessionId=" + sessionId);
        }
    }

    public UserInfo getUser(String userName, String sessionId) {
        UserInfo aUser;
        if (userName == null || userName.trim().length() == 0) {
            return null;
        }
        if (this.userStatus.containsKey(userName) && (aUser = (UserInfo)this.userStatus.get(userName)).getSessionId().equals(sessionId)) {
            return aUser;
        }
        return null;
    }

    public UserInfo getUser(String userName) {
        if (userName == null || userName.trim().length() == 0) {
            return null;
        }
        if (this.userStatus.containsKey(userName)) {
            return (UserInfo)this.userStatus.get(userName);
        }
        return null;
    }

    public boolean checkSession(String userName, String sessionId) {
        UserInfo aUser;
        if (userName == null || userName.trim().length() == 0) {
            return false;
        }
        if (this.userStatus.containsKey(userName) && (aUser = (UserInfo)this.userStatus.get(userName)).getSessionId().equals(sessionId)) {
            aUser.setTimestamp(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public void beginCheckingTimeOut() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                Enumeration enumeration = AccessManager.this.userStatus.keys();
                while (enumeration.hasMoreElements()) {
                    String userName = (String)enumeration.nextElement();
                    UserInfo aUser = (UserInfo)AccessManager.this.userStatus.get(userName);
                    if (aUser == null || currentTime - aUser.getTimestamp() <= AccessManager.this.loginTimeOut) continue;
                    AccessManager.this.userStatus.remove(userName);
                    System.out.println("User[" + userName + "] timeout:sessionId=" + aUser.getSessionId());
                }
            }
        }, 15000L, 15000L);
    }

    private String generateSessionId() {
        String sessionKey = this.getSessionKey();
        byte[] abyte0 = sessionKey.getBytes();
        try {
            String encryptionAlgorithm = "SHA";
            MessageDigest messageDigest = MessageDigest.getInstance(encryptionAlgorithm);
            abyte0 = messageDigest.digest(abyte0);
            StringBuffer stringbuffer = new StringBuffer(40);
            int l = 0;
            while (l < abyte0.length) {
                int k = abyte0[l] + 128;
                int i = k / DICTIONARY.length;
                int j = k % DICTIONARY.length;
                stringbuffer.append(DICTIONARY[i]);
                stringbuffer.append(DICTIONARY[j]);
                ++l;
            }
            return stringbuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSessionKey() {
        char SEPARATOR = '#';
        StringBuffer buf = new StringBuffer();
        buf.append(this.getLocalHost());
        buf.append(SEPARATOR);
        buf.append(String.valueOf(1));
        buf.append(SEPARATOR);
        long l = 0L;
        Object object = syncObj;
        synchronized (object) {
            l = ++counter;
        }
        buf.append(Long.toHexString(l));
        buf.append(SEPARATOR);
        buf.append(Long.toHexString(System.currentTimeMillis()));
        buf.append(SEPARATOR);
        return buf.toString();
    }

    private String getLocalHost() {
        if (this.computerAddr == null) {
            try {
                this.computerAddr = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception _ex) {
                this.computerAddr = "UNKNOW_IP";
            }
        }
        return this.computerAddr;
    }

    public List getAllUserInfo() {
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        Enumeration enumer = this.userStatus.keys();
        while (enumer.hasMoreElements()) {
            UserInfo userInfo = (UserInfo)this.userStatus.get(enumer.nextElement());
            userInfos.add(userInfo);
        }
        return userInfos;
    }
}

