/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.shuffleserver.manager;

import com.ecc.shuffleserver.ShuffleServlet;
import com.ecc.shuffleserver.manager.PermissionException;
import com.ecc.shuffleserver.manager.UserManagerImpl;
import com.ecc.shufflestudio.permission.UserInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GeneralUserManager
implements UserManagerImpl {
    private String filePath = "";
    static Map userInfoMap = new HashMap();

    public void init() throws Exception {
        this.filePath = String.valueOf(ShuffleServlet.shufflepath) + "\\userDefine.xml";
        if (System.getProperty("file.separator") != null && System.getProperty("file.separator").equals("/")) {
            this.filePath = this.filePath.replaceAll("\\\\", "/");
        }
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(new File(this.filePath));
        Element root = doc.getDocumentElement();
        this.loadUserInfo(root);
    }

    private void loadUserInfo(Element root) {
        NodeList userList = root.getElementsByTagName("user");
        int i = 0;
        while (i < userList.getLength()) {
            Element userNode = (Element)userList.item(i);
            String username = userNode.getAttribute("username");
            String password = userNode.getAttribute("password");
            UserInfo userInfo = new UserInfo(username, password);
            userInfoMap.put(username, userInfo);
            NodeList permissions = userNode.getElementsByTagName("permission");
            int j = 0;
            while (j < permissions.getLength()) {
                Element permissionNode = (Element)permissions.item(j);
                String pType = permissionNode.getAttribute("type");
                userInfo.addPermission(pType);
                ++j;
            }
            ++i;
        }
    }

    public UserInfo verifyUser(String userName, String password) throws PermissionException {
        if (userName == null || userName.trim().length() == 0) {
            throw new PermissionException("userName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!userInfoMap.containsKey(userName)) {
            throw new PermissionException("userName\u4e0d\u5b58\u5728\uff01");
        }
        UserInfo aUser = (UserInfo)userInfoMap.get(userName);
        if (!aUser.getPassword().equals(password)) {
            throw new PermissionException("password\u8f93\u5165\u9519\u8bef\uff01");
        }
        return aUser;
    }

    public boolean verifyPermission(String userName, String permissionType) {
        try {
            UserInfo aUser = (UserInfo)userInfoMap.get(userName);
            if (aUser.hasPermission(permissionType)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean userExist(String userName) {
        if (userName != null && userName.trim().length() > 0) {
            return userInfoMap.containsKey(userName);
        }
        return false;
    }

    public UserInfo getUserInfo(String userName) {
        return (UserInfo)userInfoMap.get(userName);
    }
}

