/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.boot;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.container.Container;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboServiceMain {
    private static volatile boolean running = true;
    private static final Logger logger = LoggerFactory.getLogger(DubboServiceMain.class);
    private static final String APPLICATION_CONTEXT_PATH = "classpath*:spring/applicationContext.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("dubbo.spring.config", APPLICATION_CONTEXT_PATH);
        long startTime = System.currentTimeMillis();
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(Container.class);
        try {
            String config = ConfigUtils.getProperty((String)"dubbo.container", (String)loader.getDefaultExtensionName());
            String[] containerNames = Constants.COMMA_SPLIT_PATTERN.split(config);
            final ArrayList<Object> containers = new ArrayList<Object>();
            for (int i = 0; i < containerNames.length; ++i) {
                containers.add(loader.getExtension(containerNames[i]));
            }
            logger.debug("Dubbo  stopped!");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Iterator iterator = containers.iterator();
                    while (iterator.hasNext()) {
                        Container container = (Container)iterator.next();
                        try {
                            container.stop();
                            logger.debug("Dubbo " + container.getClass().getSimpleName() + " stopped!");
                        }
                        catch (Exception t) {
                            logger.error(t.getMessage(), (Throwable)t);
                        }
                        Class<DubboServiceMain> clazz = DubboServiceMain.class;
                        // MONITORENTER : com.irdstudio.efp.nls.service.boot.DubboServiceMain.class
                        running = false;
                        DubboServiceMain.class.notify();
                        // MONITOREXIT : clazz
                    }
                }
            });
            for (Container container : containers) {
                container.start();
                logger.info("Dubbo " + container.getClass().getSimpleName() + " started!");
            }
            long elasticsTime = System.currentTimeMillis() - startTime;
            String startedMsg = "efp-nls-service started, elapsedTime=" + (double)elasticsTime / 1000.0 + "s";
            logger.info(startedMsg);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        Class<DubboServiceMain> clazz = DubboServiceMain.class;
        synchronized (DubboServiceMain.class) {
            while (running) {
                try {
                    DubboServiceMain.class.wait();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }
}

