/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.efp.basic.framework.mq.client.producer.MQProducerMessageClient;
import com.irdstudio.efp.console.common.ConsoleEnums;
import com.irdstudio.efp.console.common.PrdStatEnums;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.PrdSoltRuleService;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.PrdSoltRuleVO;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.cus.service.facade.CusWhiteListTecService;
import com.irdstudio.efp.cus.service.vo.CusWhiteListTecVO;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.facade.MsLoanService;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.ed.LimitControlsService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import com.irdstudio.efp.rule.common.enumeration.Rule;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import com.irdstudio.efp.rule.service.vo.ReqAccessRuleVo;
import com.irdstudio.efp.rule.service.vo.ReqRuleVo;
import com.irdstudio.efp.rule.service.vo.RespRuleVO;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="accessRuleService")
public class AccessRuleServiceImpl
extends SoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AccessRuleServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="ruleCallService")
    private RuleCallService ruleService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="prdSoltRuleService")
    private PrdSoltRuleService prdSoltRuleService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    @Qualifier(value="cusWhiteListTecService")
    private CusWhiteListTecService cusWhiteListTecService;
    @Autowired
    @Qualifier(value="limitControlsService")
    private LimitControlsService limitControlsService;
    @Autowired
    @Qualifier(value="msLoanService")
    private MsLoanService msLoanService;
    @Autowired
    @Qualifier(value="producerService")
    private MQProducerMessageClient producerService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String slotCode = nlsProcessBizVo.getSoltCode();
        String certType = nlsApplyInfoVO.getCertType();
        String certCode = nlsApplyInfoVO.getCertCode();
        try {
            SCfgParamVO sCfgParamVO = new SCfgParamVO();
            sCfgParamVO.setParamKey(ConsoleEnums.ParamKey.MS_TRIAL_ORDER_SWITCH.getValue());
            sCfgParamVO.setParamValue("Y");
            sCfgParamVO = this.sCfgParamService.queryByCondition(sCfgParamVO);
            if (Objects.nonNull(sCfgParamVO)) {
                CusWhiteListTecVO cusWhiteListTecVO = new CusWhiteListTecVO();
                cusWhiteListTecVO.setCertType(certType);
                cusWhiteListTecVO.setCertNo(certCode);
                cusWhiteListTecVO = this.cusWhiteListTecService.queryByCertNoAndTyp(cusWhiteListTecVO);
                if (Objects.isNull(cusWhiteListTecVO)) {
                    nlsProcessBizVo.setRefuseMsg(RefuseType.NOTWHITE_LIST.getMsg());
                    throw new BizException("\u8bc1\u4ef6\u53f7\u7801\u4e3a\uff1a " + certCode + "\u7684\u5ba2\u6237\u4e0d\u5b58\u5728\u767d\u540d\u5355\u4e2d\uff0c\u8fdb\u4ef6\u7533\u8bf7\u5931\u8d25\uff01");
                }
            }
            log.info("\u5f00\u59cb\u8fdb\u884c\u51c6\u5165\u89c4\u5219\u4ea7\u54c1\u6821\u9a8c,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsApplyInfoVO);
            String prdId = Objects.requireNonNull(nlsApplyInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            PrdStatEnums prdStat = PrdStatEnums.parse((String)prdInfoVo.getPrdStatus());
            if (!Objects.equals(prdStat, PrdStatEnums.IN_USE)) {
                nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                throw new BizException("\u4ea7\u54c1\uff1a " + prdInfoVo.getPrdName() + " \u4e0d\u662f\u6709\u6548\u72b6\u6001");
            }
            boolean isDuring = this.limitControlsService.isDuring(nlsApplyInfoVO);
            NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
            nlsProcessRuleVO.setApplySeq(applySeq);
            nlsProcessRuleVO.setCreateTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setLastModifyTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setPrdCode(prdId);
            nlsProcessRuleVO.setPrdName(nlsApplyInfoVO.getPrdName());
            nlsProcessRuleVO.setCusName(nlsApplyInfoVO.getCusName());
            nlsProcessRuleVO.setCusId(nlsApplyInfoVO.getCusId());
            List prdSoltRules = this.prdSoltRuleService.queryByPrdIdAndSoltCode(prdId, slotCode);
            BigDecimal applyAmt = nlsApplyInfoVO.getApplyAmt();
            BigDecimal maxAmt = prdInfoVo.getLoanAppMaxAmt();
            BigDecimal minAmt = prdInfoVo.getLoanAppMinAmt();
            TermType appTermType = TermType.valueOf(nlsApplyInfoVO.getLoanTermType());
            TermType stdTermType = TermType.valueOf(prdInfoVo.getLmtTermUnit());
            int appLoanTerm = appTermType.toDay(Integer.valueOf(nlsApplyInfoVO.getLoanTerm()));
            int minTerm = stdTermType.toDay(Integer.parseInt(prdInfoVo.getMinLoanTerm()));
            int maxTerm = stdTermType.toDay(Integer.parseInt(prdInfoVo.getMaxLoanTerm()));
            AccLoanVO accLoanVO = new AccLoanVO();
            accLoanVO.setPrdId(prdId);
            accLoanVO.setCertType(nlsApplyInfoVO.getCertType());
            accLoanVO.setCertCode(nlsApplyInfoVO.getCertCode());
            List accLoanVOs = Optional.ofNullable(this.accLoanService.queryAccLoanListByCondition(accLoanVO)).orElseGet(Collections::emptyList);
            BigDecimal totalAmt = accLoanVOs.stream().filter(vo -> {
                String accStatus = vo.getAccountStatus();
                return accStatus != null;
            }).map(AccLoanVO::getLoanBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            NlsApplyInfoVO nlsApplyCode = new NlsApplyInfoVO();
            nlsApplyCode.setCertCode(nlsApplyInfoVO.getCertCode());
            Map<String, List<NlsApplyInfoVO>> groupMap = Optional.ofNullable(this.nlsApplyInfoService.queryCertCode(nlsApplyCode)).orElseGet(Collections::emptyList).stream().filter(i -> !applySeq.equals(i.getApplySeq())).filter(i -> i.getPrdId().equals(prdId)).collect(Collectors.groupingBy(NlsApplyInfoVO::getNlsApplyState));
            log.info("\u83b7\u53d6\u5ba1\u6279\u4e2d\u7684--\u7533\u8bf7\u91d1\u989d");
            totalAmt = Optional.ofNullable(groupMap.get(MsLoanConstant.NlsApplyStateEnum.APPR.VALUE)).orElseGet(ArrayList::new).stream().map(NlsApplyInfoVO::getApplyAmt).filter(Objects::nonNull).reduce(totalAmt, BigDecimal::add);
            log.info("\u83b7\u53d6\u5ba1\u6279\u901a\u8fc7,\u5f85\u653e\u6b3e--\u7533\u8bf7\u91d1\u989d");
            totalAmt = Optional.ofNullable(groupMap.get(MsLoanConstant.NlsApplyStateEnum.PASS.VALUE)).orElseGet(ArrayList::new).stream().filter(i -> i.getDnSts() != null && i.getDnSts().equals("3")).map(NlsApplyInfoVO::getApplyAmt).filter(Objects::nonNull).reduce(totalAmt, BigDecimal::add);
            totalAmt = applyAmt.add(totalAmt);
            log.info("\u51c6\u5165\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f00\u59cb\u6267\u884c\u51c6\u5165\u89c4\u5219");
            ReqRuleVo reqRuleVo = new ReqRuleVo();
            reqRuleVo.setAppNo(applySeq);
            reqRuleVo.setPrdName(nlsApplyInfoVO.getPrdName());
            ReqAccessRuleVo param = new ReqAccessRuleVo();
            param.setMaxLoanAmt(maxAmt);
            param.setMinLoanAmt(minAmt);
            param.setLoanAmt(applyAmt);
            param.setCusLoanBal(totalAmt);
            param.setMaxLoanBal(prdInfoVo.getLoanMaxAmtBalance());
            param.setMinTermDay(Integer.valueOf(minTerm));
            param.setMaxTermDay(Integer.valueOf(maxTerm));
            param.setDuring(isDuring);
            param.setAppTermDay(Integer.valueOf(appLoanTerm));
            reqRuleVo.setReqAccessRuleVo(param);
            List list = this.ruleService.executeBatchRule(Rule.RuleType.ACCESS, reqRuleVo);
            Map<String, List<RespRuleVO>> map = list.stream().collect(Collectors.groupingBy(RespRuleVO::getRuleId));
            String refuseMsg = "";
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < prdSoltRules.size(); ++j) {
                String order = ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleOrder();
                Method methodRuleName = NlsProcessRuleVO.class.getMethod("setRuleName" + order, String.class);
                Method methodRuleState = NlsProcessRuleVO.class.getMethod("setRuleState" + order, String.class);
                Method methodRuleTime = NlsProcessRuleVO.class.getMethod("setRuleTime" + order, String.class);
                methodRuleName.invoke((Object)nlsProcessRuleVO, ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                methodRuleTime.invoke((Object)nlsProcessRuleVO, DateUtility.getCurrAppDateTimeString());
                if (map.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()) != null) {
                    methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    sb.append(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleName()).append("\u89c4\u5219\u4e0d\u901a\u8fc7;");
                    refuseMsg = Rule.parseWithRuleId((String)((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()).getMsg();
                    continue;
                }
                methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
            }
            nlsProcessBizVo.setRefuseMsg(refuseMsg);
            this.nlsProcessRuleService.insertNlsProcessRule(nlsProcessRuleVO);
            if (!list.isEmpty()) {
                throw new BizException(sb.toString());
            }
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }

    static enum TermType {
        Y{

            @Override
            int toDay(int term) {
                return 365 * term;
            }
        }
        ,
        M{

            @Override
            int toDay(int term) {
                return 12 * term;
            }
        }
        ,
        D{

            @Override
            int toDay(int term) {
                return term;
            }
        };


        abstract int toDay(int var1);
    }
}

