/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.cus.service.facade.CusIndivExtService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivExtVO;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.nls.service.facade.CusCreateCommonService;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="cusCreateCommonService")
public class CusCreateCommonServiceImpl
implements CusCreateCommonService {
    private final Logger logger = LoggerFactory.getLogger(CusCreateCommonServiceImpl.class);
    public static final String PRD_TYPE_ANGELICA_01 = "01";
    public static final String PRD_TYPE_ANGELICA_02 = "02";
    public static final String CERT_CODE = "certCode";
    public static final String CERT_TYPE = "certType";
    public static final String APPRV_STS = "apprvSts";
    public static final String PRD_CODES = "prdCodes";
    public static final String ESTBLSHDT = "estblshDt";
    public static final String SSTBLSHBRCH = "sstblshBrch";
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusIndivExtService")
    private CusIndivExtService cusIndivExtService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    public static final String APPRV_STS_02 = "02";

    public Map<String, String> getEstblshDtAndSstblshBrch(Map<String, String> paramsMap) {
        String certType;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String estblshDt = "";
        String sstblshBrch = "";
        String certCode = paramsMap.get(CERT_CODE);
        CusIndivVO cusIndivVO = this.getCusIndivVO(certCode, certType = paramsMap.get(CERT_TYPE));
        if (Objects.isNull(cusIndivVO)) {
            estblshDt = paramsMap.get(ESTBLSHDT);
            sstblshBrch = paramsMap.get(SSTBLSHBRCH);
            this.logger.info(certCode + "\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
        } else {
            CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
            cusIndivExtVO.setCusId(cusIndivVO.getCusId());
            CusIndivExtVO cusIndivExtVO1 = this.cusIndivExtService.queryByPk(cusIndivExtVO);
            String cusType = cusIndivExtVO1.getCusType();
            if (PRD_TYPE_ANGELICA_01.equals(cusType)) {
                Map<String, Object> queryParamsMap = this.getQueryParamsMap(certCode, certType, PRD_TYPE_ANGELICA_01);
                NlsCreditInfoVO nlsCreditInfoVOSelect = this.nlsCreditInfoService.queryAllOrderByCreateTime(queryParamsMap);
                NlsApplyInfoVO nlsApplyInfoVO = this.nlsApplyInfoService.queryAllOrderByCreateTime(queryParamsMap);
                if (nlsCreditInfoVOSelect != null && nlsApplyInfoVO != null) {
                    this.logger.info(certCode + "\u67e5\u8be2\u5230\u6388\u4fe1\u4fe1\u606f:" + nlsCreditInfoVOSelect);
                    this.logger.info(certCode + "\u67e5\u8be2\u5230\u7528\u4fe1\u4fe1\u606f:" + nlsCreditInfoVOSelect);
                    int i = nlsCreditInfoVOSelect.getCreateTime().compareTo(nlsApplyInfoVO.getCreateTime());
                    if (i > 0) {
                        estblshDt = nlsApplyInfoVO.getCreateTime();
                        sstblshBrch = nlsApplyInfoVO.getNlsOperOrgid();
                    } else {
                        estblshDt = nlsCreditInfoVOSelect.getCreateTime();
                        sstblshBrch = nlsCreditInfoVOSelect.getNlsOperOrgid();
                    }
                } else {
                    if (nlsCreditInfoVOSelect == null && nlsApplyInfoVO == null) {
                        this.logger.error(certCode + "\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6388\u4fe1\u4e0e\u7528\u4fe1\u4fe1\u606f");
                    }
                    if (nlsCreditInfoVOSelect != null) {
                        this.logger.info(certCode + "\u67e5\u8be2\u5230\u6388\u4fe1\u4fe1\u606f:" + nlsCreditInfoVOSelect);
                        estblshDt = nlsCreditInfoVOSelect.getCreateTime();
                        sstblshBrch = nlsCreditInfoVOSelect.getNlsOperOrgid();
                    }
                    if (nlsApplyInfoVO != null) {
                        this.logger.info(certCode + "\u67e5\u8be2\u5230\u7528\u4fe1\u4fe1\u606f:" + nlsCreditInfoVOSelect);
                        estblshDt = nlsApplyInfoVO.getCreateTime();
                        sstblshBrch = nlsApplyInfoVO.getNlsOperOrgid();
                    }
                }
            } else if ("02".equals(cusType) || "0102".equals(cusType) || "0201".equals(cusType)) {
                Map<String, Object> queryParamsMap = this.getQueryParamsMap(certCode, certType, "02");
                NlsCreditInfoVO nlsCreditInfoVOSelect = this.nlsCreditInfoService.queryAllOrderByCreateTime(queryParamsMap);
                estblshDt = nlsCreditInfoVOSelect.getCreateTime();
                sstblshBrch = nlsCreditInfoVOSelect.getNlsOperOrgid();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)estblshDt)) {
            estblshDt = estblshDt.substring(0, 10);
            estblshDt = DateUtility.format10To8((String)estblshDt);
        }
        resultMap.put(ESTBLSHDT, estblshDt);
        resultMap.put(SSTBLSHBRCH, sstblshBrch);
        return resultMap;
    }

    public Map<String, String> getPrivateEstblshDtAndSstblshBrch(Map<String, String> paramsMap) {
        String certType;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String estblshDt = "";
        String sstblshBrch = "";
        String certCode = paramsMap.get(CERT_CODE);
        CusIndivVO queryCusIndiv = this.getCusIndivVO(certCode, certType = paramsMap.get(CERT_TYPE));
        if (Objects.isNull(queryCusIndiv)) {
            estblshDt = paramsMap.get(ESTBLSHDT);
            sstblshBrch = paramsMap.get(SSTBLSHBRCH);
            this.logger.info(certCode + "\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
        } else {
            Map<String, Object> queryParamsMap = this.getQueryParamsMap(certCode, certType, "02");
            NlsCreditInfoVO nlsCreditInfoVOSelect = this.nlsCreditInfoService.queryAllOrderByCreateTime(queryParamsMap);
            if (nlsCreditInfoVOSelect != null) {
                this.logger.info(certCode + "\u67e5\u8be2\u5230\u6388\u4fe1\u4fe1\u606f:" + nlsCreditInfoVOSelect);
                estblshDt = nlsCreditInfoVOSelect.getCreateTime();
                sstblshBrch = nlsCreditInfoVOSelect.getNlsOperOrgid();
            } else {
                this.logger.info(certCode + "\u67e5\u8be2\u5230\u6388\u4fe1\u4fe1\u606f:" + nlsCreditInfoVOSelect);
                estblshDt = paramsMap.get(ESTBLSHDT);
                sstblshBrch = paramsMap.get(SSTBLSHBRCH);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)estblshDt)) {
            estblshDt = estblshDt.substring(0, 10);
            estblshDt = DateUtility.format10To8((String)estblshDt);
        }
        resultMap.put(ESTBLSHDT, estblshDt);
        resultMap.put(SSTBLSHBRCH, sstblshBrch);
        return resultMap;
    }

    private Map<String, Object> getQueryParamsMap(String certCode, String certType, String prdType) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        List<String> prdCodeList = this.getPrdList(prdType);
        paramsMap.put(CERT_CODE, certCode);
        paramsMap.put(CERT_TYPE, certType);
        paramsMap.put(APPRV_STS, "02");
        paramsMap.put(PRD_CODES, prdCodeList);
        return paramsMap;
    }

    public List<String> getPrdList(String prdType) {
        List prdInfoVOS = this.prdInfoService.queryPrdInfoByPrdTypeAngelica(prdType);
        ArrayList<String> prdCodeList = new ArrayList<String>();
        prdInfoVOS.forEach(p -> prdCodeList.add(p.getPrdCode()));
        return prdCodeList;
    }

    public CusIndivVO getCusIndivVO(String certCode, String certType) {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCertType(certType);
        cusIndivVO.setCertCode(certCode);
        cusIndivVO = this.cusIndivService.getCusInvoByCertCode(cusIndivVO);
        return cusIndivVO;
    }
}

