/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.gdrcu.efp.cus.common.CusBankRelEnum;
import com.gdrcu.efp.cus.common.CusStatusEnum;
import com.gdrcu.efp.cus.common.CusTypeEnum;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.common.IrAdjModeEnum;
import com.irdstudio.efp.console.common.RateTypeEnum;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivExtService;
import com.irdstudio.efp.cus.service.facade.CusIndivRelService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivExtVO;
import com.irdstudio.efp.cus.service.vo.CusIndivRelVO;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.InstitutionEnums;
import com.irdstudio.efp.esb.common.constant.nls.NlsCrrEnum;
import com.irdstudio.efp.esb.service.bo.req.ecif.CusDetialInfoQueryReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.IdInfArry2Bean;
import com.irdstudio.efp.esb.service.bo.req.ecif.MaintainEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.PriMtEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.QryEcifThirdCusInfoReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.TelInfArry2Bean;
import com.irdstudio.efp.esb.service.bo.req.ecif.TrdPtyCustInfArryBean;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailIdInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailTelInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetialInfoQueryResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.MaintainEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PriMtEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.QryEcifThirdCusInfoResp;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.ecif.CusDetailInfoQueryService;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.esb.service.facade.hj.CustomerInfoCreateService;
import com.irdstudio.efp.nls.service.facade.CusCreateCommonService;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsApplyRelationService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.NlsApplyRelationVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="cusCreateService")
public class CusCreateServiceImpl
extends SoltServiceImpl {
    @Autowired
    @Qualifier(value="cusIndivExtService")
    private CusIndivExtService cusIndivExtService;
    @Autowired
    @Qualifier(value="qryEcifThirdCusInfoService")
    private EsbService<QryEcifThirdCusInfoReq, QryEcifThirdCusInfoResp> qryEcifThirdCusInfoService;
    @Autowired
    @Qualifier(value="maintainEcifThirdCusService")
    private EsbService<MaintainEcifThirdCusReq, MaintainEcifThirdCusResp> maintainEcifThirdCusService;
    private static final Logger log = LoggerFactory.getLogger(CusCreateServiceImpl.class);
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"CREL$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final PatternDescriptor CUS_PATTERN = DefaultPatternDescriptor.of((String)"$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final String HEAD = "head";
    private static final String BODY = "body";
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="nlsApplyRelationService")
    private NlsApplyRelationService nlsApplyRelationService;
    @Autowired
    @Qualifier(value="customerInfoCreateService")
    private CustomerInfoCreateService customerInfoCreateService;
    @Autowired
    private PatternedLimitableSeqService sequenceService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusIndivRelService")
    private CusIndivRelService cusIndivRelService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="priMainEcifThirdCusService")
    private EsbService<PriMtEcifThirdCusReq, PriMtEcifThirdCusResp> priMainEcifThirdCusService;
    @Autowired
    @Qualifier(value="cusDetailInfoQueryService")
    private CusDetailInfoQueryService cusDetailInfoQueryService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="cusCreateCommonService")
    private CusCreateCommonService cusCreateCommonService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String cusId = "";
        String userId = "";
        try {
            log.info("\u5f00\u59cb\u8fdb\u884c\u5ba2\u6237\u5efa\u6863\u63d2\u69fd,\u6d41\u6c34\u53f7:" + applySeq);
            Objects.requireNonNull(nlsApplyInfoVO);
            QryEcifThirdCusInfoReq query = QryEcifThirdCusInfoReq.builder().IdntfMd("1").IdentTp(nlsApplyInfoVO.getCertType()).IdentNo(nlsApplyInfoVO.getCertCode()).CustNm(nlsApplyInfoVO.getCusName()).StrtCnt("1").build();
            QryEcifThirdCusInfoResp queryResp = (QryEcifThirdCusInfoResp)this.qryEcifThirdCusInfoService.service((Object)query);
            boolean cusIndivExsit = true;
            MaintainEcifThirdCusResp maintainEcifThirdCusResp = new MaintainEcifThirdCusResp();
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("estblshDt", nlsApplyInfoVO.getCreateTime());
            paramsMap.put("sstblshBrch", nlsApplyInfoVO.getNlsOperOrgid());
            paramsMap.put("certCode", nlsApplyInfoVO.getCertCode());
            paramsMap.put("certType", nlsApplyInfoVO.getCertType());
            Map resultMap = this.cusCreateCommonService.getEstblshDtAndSstblshBrch(paramsMap);
            log.info(nlsApplyInfoVO.getApplySeq() + "\u67e5\u8be2\u5230\u7684\u5f00\u6237\u4fe1\u606f:{}", (Object)resultMap);
            String estblshDt = (String)resultMap.get("estblshDt");
            String sstblshBrch = (String)resultMap.get("sstblshBrch");
            try {
                String identMtrDt;
                String crrCd = null;
                try {
                    crrCd = StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getProfession()) ? NlsCrrEnum.UNKNOWN.getValue() : SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsApplyInfoVO.getProfession());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u672c\u5730\u7cfb\u7edf\u5b57\u5178\u9879\u8f6cECIF\u63a5\u53e3\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicExternal.properties)\uff01");
                }
                String crrCd1 = null;
                String crrCd2 = null;
                String crrCd3 = null;
                if (!crrCd.endsWith("00")) {
                    crrCd3 = crrCd;
                } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
                    crrCd2 = crrCd;
                } else if (crrCd.endsWith("0000")) {
                    crrCd1 = crrCd;
                }
                MaintainEcifThirdCusReq maintainEcifThirdCusReq = MaintainEcifThirdCusReq.builder().build();
                String identEfftvDt = nlsApplyInfoVO.getIndivIdExpDt().split("-")[0];
                String string = identMtrDt = nlsApplyInfoVO.getIndivIdExpDt().contains("\u957f\u671f") ? "20991231" : nlsApplyInfoVO.getIndivIdExpDt();
                if (identMtrDt.length() > 8) {
                    identMtrDt = identMtrDt.length() == 10 ? DateUtility.format10To8((String)identMtrDt) : identMtrDt.split("-")[1];
                }
                TrdPtyCustInfArryBean build = TrdPtyCustInfArryBean.builder().CustNm(nlsApplyInfoVO.getCusName()).IdentTp(nlsApplyInfoVO.getCertType()).IdentNo(nlsApplyInfoVO.getCertCode()).IdentEfftvDt(identEfftvDt).IdentMtrDt(identMtrDt).Gnd(nlsApplyInfoVO.getCusGender()).Natt(nlsApplyInfoVO.getEthnic()).MrtlSt(nlsApplyInfoVO.getMrgSitu()).Nation(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"Country", (String)nlsApplyInfoVO.getCusNational())).BrthDt(StringUtils.isBlank((CharSequence)nlsApplyInfoVO.getBrthDt()) ? "" : (nlsApplyInfoVO.getBrthDt().length() == 8 ? nlsApplyInfoVO.getBrthDt() : DateUtility.format10To8((String)nlsApplyInfoVO.getBrthDt()))).HghstEdu(nlsApplyInfoVO.getEdu()).CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).ProfTtl(SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Ttl", (String)nlsApplyInfoVO.getTtl())).CtcAddr(nlsApplyInfoVO.getIndivRsdAddr()).CtcTel(nlsApplyInfoVO.getMobile()).WrkCorp(nlsApplyInfoVO.getWrkCorpNm()).ChanNo("001").EstblshDt(estblshDt).EstblshBrch(sstblshBrch).build();
                maintainEcifThirdCusReq.setTrdPtyCustInfArry(Collections.singletonList(build));
                if (queryResp.getTotCnt() == 0) {
                    log.info("ECIF\u4e0d\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u524d\u5f80ECIF\u65b0\u589e");
                    Map respMap = this.maintainEcifThirdCusService.serviceMap((Object)maintainEcifThirdCusReq);
                    EsbRespSysHeadBean respSysHeadBean = (EsbRespSysHeadBean)respMap.get(HEAD);
                    if (StringUtils.equals((CharSequence)((EsbRespRetInfBean)respSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"3036000|210006")) {
                        queryResp = (QryEcifThirdCusInfoResp)this.qryEcifThirdCusInfoService.service((Object)query);
                        userId = ((QryEcifThirdCusInfoResp.TrdPtyCustInfArryBean)queryResp.getTrdPtyCustInfArry().get(0)).getTrdPtyCustNo();
                        ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(((QryEcifThirdCusInfoResp.TrdPtyCustInfArryBean)queryResp.getTrdPtyCustInfArry().get(0)).getTrdPtyCustNo());
                        this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
                    } else {
                        maintainEcifThirdCusResp = (MaintainEcifThirdCusResp)respMap.get(BODY);
                        userId = maintainEcifThirdCusResp.getTrdPtyCustNo();
                    }
                } else {
                    log.info("ECIF\u5df2\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u53bbECIF\u66f4\u65b0");
                    ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(((QryEcifThirdCusInfoResp.TrdPtyCustInfArryBean)queryResp.getTrdPtyCustInfArry().get(0)).getTrdPtyCustNo());
                    this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
                    userId = ((QryEcifThirdCusInfoResp.TrdPtyCustInfArryBean)queryResp.getTrdPtyCustInfArry().get(0)).getTrdPtyCustNo();
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528ECIF\u7b2c\u4e09\u65b9\u5bf9\u79c1\u5ba2\u6237\u4fe1\u606f\u7ef4\u62a4\u5f02\u5e38", (Throwable)e);
                nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
                throw new BizException("\u8c03\u7528ECIF\u7b2c\u4e09\u65b9\u5bf9\u79c1\u5ba2\u6237\u4fe1\u606f\u7ef4\u62a4\u5f02\u5e38", (Throwable)e);
            }
            CusIndivVO cusIndivQuery = new CusIndivVO();
            cusIndivQuery.setCertType(nlsApplyInfoVO.getCertType());
            cusIndivQuery.setCertCode(nlsApplyInfoVO.getCertCode());
            cusIndivQuery = this.cusIndivService.getCusInvoByCertCode(cusIndivQuery);
            if (Objects.isNull(cusIndivQuery)) {
                cusIndivExsit = false;
            } else {
                cusId = cusIndivQuery.getCusId();
            }
            String prdId = Objects.requireNonNull(nlsApplyInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            String dateString = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
            String dateTimeString = LocalDateTime.now().format(timeStrFormatter);
            String createUser = "admin";
            CusIndivVO cusIndivVO = new CusIndivVO();
            cusIndivVO.setCusName(nlsApplyInfoVO.getCusName());
            cusIndivVO.setIndivSex(nlsApplyInfoVO.getCusGender());
            cusIndivVO.setIndivIdExpDt(nlsApplyInfoVO.getIndivIdExpDt());
            cusIndivVO.setCertType(nlsApplyInfoVO.getCertType());
            cusIndivVO.setCertCode(nlsApplyInfoVO.getCertCode());
            cusIndivVO.setPhone(nlsApplyInfoVO.getMobile());
            cusIndivVO.setCusType(CusTypeEnum.NATURAL_MAN.getCode());
            cusIndivVO.setCusBankRel(CusBankRelEnum.NORMAL.getCode());
            cusIndivVO.setIndivHouhRegAdd(nlsApplyInfoVO.getCertAddr());
            cusIndivVO.setCusStatus(CusStatusEnum.OFFICIAL.getCode());
            cusIndivVO.setIndivCountry(nlsApplyInfoVO.getCusNational());
            cusIndivVO.setIndivNtn(nlsApplyInfoVO.getEthnic());
            cusIndivVO.setAgriFlg(nlsApplyInfoVO.getWhthrFrmr());
            cusIndivVO.setIndivEdt(nlsApplyInfoVO.getEdu());
            cusIndivVO.setIndivComName(nlsApplyInfoVO.getWrkCorpNm());
            cusIndivVO.setIndivComAddr(nlsApplyInfoVO.getWrkCorpAddr());
            cusIndivVO.setIndivSpsName(nlsApplyInfoVO.getSpsNm());
            cusIndivVO.setIndivCrtfctn(nlsApplyInfoVO.getTtl());
            cusIndivVO.setPostCode(nlsApplyInfoVO.getPstcd());
            cusIndivVO.setIndivAnnIncm(nlsApplyInfoVO.getIndvIncmAmt());
            cusIndivVO.setFamilyMincm(nlsApplyInfoVO.getFamIncmAmt());
            cusIndivVO.setIndivRsdAddr(nlsApplyInfoVO.getIndivRsdAddr());
            cusIndivVO.setIndivHouhRegAdd(nlsApplyInfoVO.getCertAddr());
            cusIndivVO.setFamilyAddr(nlsApplyInfoVO.getFamAddr());
            cusIndivVO.setFstAppChannel(prdInfoVo.getPrdType());
            cusIndivVO.setIndivMarSt(nlsApplyInfoVO.getMrgSitu());
            cusIndivVO.setIndivSpsMphn(nlsApplyInfoVO.getSpsMblTelNo());
            cusIndivVO.setIndivSpsPhone(nlsApplyInfoVO.getSpsCtcTelNo());
            cusIndivVO.setFphone(nlsApplyInfoVO.getFamTelNo());
            cusIndivVO.setPostAddr(nlsApplyInfoVO.getAplCmmAddr());
            cusIndivVO.setIndivOcc(nlsApplyInfoVO.getProfession());
            cusIndivVO.setIndivComTyp(nlsApplyInfoVO.getCorpChar());
            cusIndivVO.setIndivDtOfBirth(nlsApplyInfoVO.getBrthDt());
            cusIndivVO.setInputId("admin");
            cusIndivVO.setLastUpdateTime(dateTimeString);
            cusIndivVO.setLastUpdateUser("admin");
            if (cusIndivExsit) {
                if (StringUtils.isNotBlank((CharSequence)cusIndivQuery.getSelfCusId())) {
                    CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(cusIndivQuery.getCusName(), cusIndivQuery.getCertCode());
                    String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
                    String telCode = "";
                    List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
                    if (Objects.nonNull(telInfArry)) {
                        for (CusDetailTelInfArray item : telInfArry) {
                            if (!item.getAtchSys1().equals("2003000")) continue;
                            telCode = item.getTelId();
                        }
                    } else {
                        telCode = "";
                    }
                    this.priMtEcifThirdCusFn(nlsApplyInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
                }
                CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
                cusIndivExtVO.setCusId(cusId);
                CusIndivExtVO cusIndivExtVO1 = this.cusIndivExtService.queryByPk(cusIndivExtVO);
                if ("02".equals(cusIndivExtVO1.getCusType())) {
                    cusIndivExtVO1.setCusType("0201");
                    int num2 = this.cusIndivExtService.updateByPk(cusIndivExtVO1);
                    if (num2 == -1) {
                        throw new BizException("\u5ba2\u6237\u62d3\u5c55\u8868\u66f4\u65b0\u5f02\u5e38!");
                    }
                }
                cusIndivVO.setCusId(cusId);
                cusIndivVO.setInnerCusId(userId);
                int num1 = this.cusIndivService.updateByPk(cusIndivVO);
                if (num1 == -1) {
                    throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u66f4\u65b0\u5f02\u5e38!");
                }
            } else {
                cusIndivVO.setMainBrId(prdInfoVo.getDefaultManageOrg());
                cusIndivVO.setInnerCusId(userId);
                try {
                    cusId = this.sequenceService.getPatternedSequence("CUS_ID", CUS_PATTERN);
                }
                catch (Exception e) {
                    throw new BizException("\u5ba2\u6237id\u751f\u6210\u5931\u8d25");
                }
                cusIndivVO.setCusId(cusId);
                cusIndivVO.setComInitLoanDate(dateString);
                cusIndivVO.setInputDate(dateString);
                cusIndivVO.setCreateTime(dateTimeString);
                int num2 = this.cusIndivService.insertCusIndiv(cusIndivVO);
                CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
                cusIndivExtVO.setCusId(cusId);
                cusIndivExtVO.setOnlineVerfStatus("0");
                cusIndivExtVO.setCusType("01");
                cusIndivExtVO.setCreateUser("admin");
                cusIndivExtVO.setCreateTime(dateTimeString);
                cusIndivExtVO.setLastUpdateUser("admin");
                cusIndivExtVO.setLastUpdateTime(dateTimeString);
                int num3 = this.cusIndivExtService.insert(cusIndivExtVO);
                if (num2 == -1 || num3 == -1) {
                    throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u589e\u52a0\u5f02\u5e38!");
                }
            }
            CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
            ctrLoanContVO.setContNo(applySeq);
            ctrLoanContVO.setSerno(applySeq);
            ctrLoanContVO.setContType("02");
            ctrLoanContVO.setPrdCode(prdInfoVo.getPrdCode());
            ctrLoanContVO.setPrdId(prdInfoVo.getPrdId());
            ctrLoanContVO.setPrdName(prdInfoVo.getPrdName());
            ctrLoanContVO.setCusId(cusId);
            ctrLoanContVO.setCusName(nlsApplyInfoVO.getCusName());
            ctrLoanContVO.setCertCode(nlsApplyInfoVO.getCertCode());
            ctrLoanContVO.setCertType(nlsApplyInfoVO.getCertType());
            ctrLoanContVO.setTermTimeType(nlsApplyInfoVO.getLoanTermType());
            ctrLoanContVO.setLoanTerm(new BigDecimal(nlsApplyInfoVO.getLoanTerm()));
            ctrLoanContVO.setApprovalAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setContAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setAvailAmt(BigDecimal.ZERO);
            ctrLoanContVO.setTotalIssueAmt(nlsApplyInfoVO.getApplyAmt());
            ctrLoanContVO.setContState("101");
            ctrLoanContVO.setContStartDt(nlsApplyInfoVO.getApplyDate());
            ctrLoanContVO.setContEndDt(LocalDate.parse(nlsApplyInfoVO.getApplyDate()).plusMonths(Long.valueOf(nlsApplyInfoVO.getLoanTerm())).format(DateTimeFormatter.ISO_LOCAL_DATE));
            ctrLoanContVO.setIntRateType(RateTypeEnum.NORMAL.getCode());
            ctrLoanContVO.setIrAdjustMode(IrAdjModeEnum.FIXED.getCode());
            ctrLoanContVO.setUseDec(nlsApplyInfoVO.getLoanPurpose());
            ctrLoanContVO.setChannelCode(nlsApplyInfoVO.getChannelNo());
            ctrLoanContVO.setCreateUser("admin");
            ctrLoanContVO.setCreateTime(dateTimeString);
            ctrLoanContVO.setLastUpdateTime(dateTimeString);
            ctrLoanContVO.setLastUpdateUser("admin");
            ctrLoanContVO.setInputBrId(InstitutionEnums.InstitutionEnum.XFJRZX.getCode());
            this.ctrLoanContService.insertCtrLoanCont(ctrLoanContVO);
            if (!Objects.equals(nlsApplyInfoVO.getCusId(), cusId)) {
                nlsApplyInfoVO.setCusId(cusId);
                this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
            }
            if (!Objects.equals(nlsProcessBizVo.getCusId(), cusId)) {
                nlsProcessBizVo.setCusId(cusId);
            }
            NlsApplyRelationVO nlsApplyRelationVo = new NlsApplyRelationVO();
            nlsApplyRelationVo.setApplySeq(applySeq);
            List nlsApplyRelationVOs = Optional.ofNullable(this.nlsApplyRelationService.queryByApplySeq(nlsApplyRelationVo)).orElseGet(ArrayList::new);
            CusIndivRelVO cusIndivRelVO = new CusIndivRelVO();
            cusIndivRelVO.setCusId(ctrLoanContVO.getCusId());
            List cusIndivRelVOs = Optional.ofNullable(this.cusIndivRelService.queryByPkCusId(cusIndivRelVO)).orElseGet(ArrayList::new);
            CusIndivRelVO cusIndivRelVoNew = new CusIndivRelVO();
            for (NlsApplyRelationVO vo : nlsApplyRelationVOs) {
                String relSerno = "";
                cusIndivRelVoNew.setRelSerno(relSerno);
                cusIndivRelVoNew.setCusId(ctrLoanContVO.getCusId());
                cusIndivRelVoNew.setCertCode(vo.getCertCode());
                cusIndivRelVoNew.setCertType(vo.getCertType());
                cusIndivRelVoNew.setRelName(vo.getRelName());
                cusIndivRelVoNew.setRelation(vo.getRelRelation());
                cusIndivRelVoNew.setMobile(nlsApplyInfoVO.getMobile());
                cusIndivRelVoNew.setLastUpdateTime(dateTimeString);
                if (cusIndivRelVOs.size() > 0) {
                    for (CusIndivRelVO cus : cusIndivRelVOs) {
                        if (vo.getCusName().equals(cus.getRelName())) {
                            this.cusIndivRelService.updateByPk(cusIndivRelVoNew);
                            continue;
                        }
                        try {
                            relSerno = this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN);
                        }
                        catch (Exception e) {
                            throw new BizException("\u5173\u7cfb\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
                        }
                        cusIndivRelVoNew.setRelSerno(relSerno);
                        cusIndivRelVoNew.setCreateTime(dateTimeString);
                        this.cusIndivRelService.insertCusIndivRel(cusIndivRelVoNew);
                    }
                    continue;
                }
                try {
                    relSerno = this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN);
                }
                catch (Exception e) {
                    throw new BizException("\u5173\u7cfb\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
                }
                cusIndivRelVoNew.setRelSerno(relSerno);
                cusIndivRelVoNew.setCreateTime(dateTimeString);
                cusIndivRelVoNew.setLastUpdateTime(dateTimeString);
                this.cusIndivRelService.insertCusIndivRel(cusIndivRelVoNew);
            }
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
    }

    public String indivIdExpDt(String indivIdExpDt) {
        String[] indiv = indivIdExpDt.split("-");
        if ("\u957f\u671f".equals(indiv[1])) {
            return "20991231";
        }
        return indiv[1];
    }

    public CusDetialInfoQueryResp queryECIFInfo(String cusName, String idNo) throws Exception {
        CusDetialInfoQueryReq cusDetialInfoQueryReq = new CusDetialInfoQueryReq();
        cusDetialInfoQueryReq.setIdntfMd("1");
        cusDetialInfoQueryReq.setCustNm(cusName);
        cusDetialInfoQueryReq.setIdentNo(idNo);
        CusDetialInfoQueryResp resp = null;
        try {
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.cusDetailInfoQueryService, (Object)cusDetialInfoQueryReq, this.nlsQueueSoltComnService);
            resp = (CusDetialInfoQueryResp)esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            log.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        return resp;
    }

    public PriMtEcifThirdCusResp priMtEcifThirdCusFn(NlsApplyInfoVO nlsApplyInfoVO, String cusId, String idSeqCode, String telCode) throws ESBException {
        log.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u5f00\u59cb>>>>>>>>>>>>>>>>>");
        PriMtEcifThirdCusResp resp = new PriMtEcifThirdCusResp();
        try {
            TelInfArry2Bean telInfArry2Bean;
            String endDtCert;
            String string = endDtCert = nlsApplyInfoVO.getIndivIdExpDt().contains("\u957f\u671f") ? "20991231" : nlsApplyInfoVO.getIndivIdExpDt();
            if (endDtCert.length() > 8) {
                endDtCert = endDtCert.length() == 10 ? DateUtility.format10To8((String)endDtCert) : endDtCert.split("-")[1];
            }
            IdInfArry2Bean idInfArry2Bean = IdInfArry2Bean.builder().IdentInvalDt(endDtCert).IdentIssuCntry("156").IssuInst("\u4e2d\u56fd").IdentAddr(StringUtil.replaceNullByObj((Object)nlsApplyInfoVO.getCertAddr())).OprtFlg("2").IdentSeqNo(idSeqCode).build();
            ArrayList<IdInfArry2Bean> beans = new ArrayList<IdInfArry2Bean>();
            beans.add(idInfArry2Bean);
            ArrayList<TelInfArry2Bean> telBeans = new ArrayList<TelInfArry2Bean>();
            if (StringUtil.isNullorBank((String)telCode)) {
                telInfArry2Bean = TelInfArry2Bean.builder().OprtTp1("1").TelTp("05").CtcTelNo(nlsApplyInfoVO.getMobile()).build();
                telBeans.add(telInfArry2Bean);
            } else {
                telInfArry2Bean = TelInfArry2Bean.builder().OprtTp1("2").TelId(telCode).TelTp("05").CtcTelNo(nlsApplyInfoVO.getMobile()).AtchSys1("2003000").build();
                telBeans.add(telInfArry2Bean);
            }
            PriMtEcifThirdCusReq req = PriMtEcifThirdCusReq.builder().CustNo(cusId).CustNm(nlsApplyInfoVO.getCusName()).NationCd("156").MainMblNo(nlsApplyInfoVO.getMobile()).TelInfArry(telBeans).IdInfArry(beans).build();
            resp = (PriMtEcifThirdCusResp)this.priMainEcifThirdCusService.service((Object)req);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u5f02\u5e38>>>>>>>>>>>>>>>>>");
            throw new ESBException((Throwable)e);
        }
        log.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u7ed3\u675f>>>>>>>>>>>>>>>>>");
        return resp;
    }
}

