/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.cdp.pboc.service.facade.PbocCreditBasicService;
import com.irdstudio.cdp.pboc.service.facade.QueryReportService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.vo.PbocCreditBasicVO;
import com.irdstudio.cdp.pboc.service.vo.QueryReportVO;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.efp.esb.common.constant.ZXReturnType;
import com.irdstudio.efp.esb.service.bo.req.ZX10001QueryReports;
import com.irdstudio.efp.esb.service.facade.zx.ZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="generationCreditRulesService")
public class GenerationCreditQueryService {
    private static int FRIST_INDEX = 0;
    @Autowired
    @Qualifier(value="queryReportService")
    private QueryReportService queryReportService;
    @Autowired
    @Qualifier(value="zxHtmlInfoService")
    private ZXHtmlInfoService zxHtmlInfoService;
    @Autowired
    @Qualifier(value="zx10001JSONService")
    private ZXService<ZX10001QueryReports> zxJSONService;
    @Autowired
    @Qualifier(value="zx10001HTMLService")
    private ZXService<ZX10001QueryReports> zxHTMLService;
    @Autowired
    @Qualifier(value="pbocCreditBasicService")
    private PbocCreditBasicService pbocCreditBasicService;

    boolean creditRuleOfOneHasCreditReport(String reportId) {
        return Boolean.TRUE;
    }

    public String queryGenerationCredit(String cusName, String certCode, String queryType, String queryReason, String applyDate, String lmtApplySeq, String proCode, String zxOpId) throws Exception {
        return this.insertGenerationCreditReporst(cusName, certCode, queryType, queryReason, applyDate, lmtApplySeq, proCode, zxOpId);
    }

    public List<PbocCreditBasicVO> queryCreditBasicInfo(String reportId) throws Exception {
        PbocCreditBasicVO pbocCreditBasicVO = new PbocCreditBasicVO();
        pbocCreditBasicVO.setFId(reportId);
        return Optional.ofNullable(this.pbocCreditBasicService.selectByReportId(pbocCreditBasicVO)).orElseGet(ArrayList::new);
    }

    private String insertGenerationCreditReporst(String cusName, String certCode, String queryType, String queryReason, String applyDate, String lmtApplySeq, String proCode, String zxOpId) throws Exception {
        ZX10001QueryReports zxJsonQueryReports = this.buildGenerationCreditJSONQueryReports(cusName, certCode, queryType, queryReason, applyDate, lmtApplySeq, proCode);
        ZXVO zxvoJson = this.zxJSONService.service((Object)zxJsonQueryReports, zxOpId);
        ZX10001QueryReports zxHtmlQueryReports = this.buildGenerationCreditHTMLQueryReports(cusName, certCode, queryType, queryReason, applyDate, lmtApplySeq, proCode);
        ZXVO zxvoHtml = this.zxHTMLService.service((Object)zxHtmlQueryReports, zxOpId);
        String reportId = (String)zxvoJson.getResp();
        ZXHtmlInfoVO zxHtmlInfoVO = (ZXHtmlInfoVO)zxvoHtml.getResp();
        zxHtmlInfoVO.setReportId(reportId);
        this.zxHtmlInfoService.insert(zxHtmlInfoVO);
        return reportId;
    }

    private List<QueryReportVO> getCreditReports(String certCode) throws Exception {
        QueryReportVO queryReportVo = new QueryReportVO();
        queryReportVo.setCercode(certCode);
        return this.queryReportService.queryReportId(queryReportVo);
    }

    public static QueryReportVO isCreditReportExist(List<QueryReportVO> queryReportVOList) {
        return !queryReportVOList.isEmpty() ? queryReportVOList.get(FRIST_INDEX) : null;
    }

    public static boolean isCreditReportOver30days(QueryReportVO queryReportVO) throws Exception {
        String reportTime = queryReportVO.getReportTime();
        int isOver = TimeUtil.compareDates((String)TimeUtil.addDay((String)(reportTime = StringUtils.replace((String)reportTime, (String)".", (String)"-")), (int)30), (String)DateTool.getCurrentDateTime());
        return isOver < 0;
    }

    private ZX10001QueryReports buildGenerationCreditJSONQueryReports(String cusName, String certCode, String queryType, String queryReason, String applyDate, String lmtApplySeq, String proCode) {
        return new ZX10001QueryReports.Builder().withCustNm(cusName).withCertNo(certCode).withQryTp(queryType).withQryRsn(queryReason).withRtnType(ZXReturnType.JSON.VALUE).withAuthCd(lmtApplySeq).withBizType(proCode).withAuthTm(applyDate).build();
    }

    private ZX10001QueryReports buildGenerationCreditHTMLQueryReports(String cusName, String certCode, String queryType, String queryReason, String applyDate, String lmtApplySeq, String proCode) {
        return new ZX10001QueryReports.Builder().withCustNm(cusName).withCertNo(certCode).withQryTp(queryType).withQryRsn(queryReason).withRtnType(ZXReturnType.HTML.VALUE).withAuthCd(lmtApplySeq).withBizType(proCode).withAuthTm(applyDate).build();
    }
}

