/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.cus.service.vo.KafkaNoticeHeader;
import com.irdstudio.efp.flow.common.vo.PageApproveVO;
import com.irdstudio.efp.limit.service.facade.ManualReviewAppService;
import com.irdstudio.efp.limit.service.vo.ManualReviewAppVO;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.ManualReview2ApprService;
import com.irdstudio.efp.nls.service.facade.NlsStageInfoService;
import com.irdstudio.efp.nls.service.facade.psd.NlsCreditApprovalInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.vo.NlsCreditInfoNoticeVO;
import com.irdstudio.efp.nls.service.vo.NlsStageInfoVO;
import com.irdstudio.efp.nls.service.vo.psd.NlsCreditApprovalInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="manualReview2ApprService")
public class ManualReview2ApprServiceImpl
implements ManualReview2ApprService {
    private static Logger logger = LoggerFactory.getLogger(ManualReview2ApprServiceImpl.class);
    @Autowired
    @Qualifier(value="manualReviewAppService")
    private ManualReviewAppService manualReviewAppService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsStageInfoService")
    private NlsStageInfoService nlsStageInfoService;
    @Autowired
    @Qualifier(value="nlsCreditApprovalInfoService")
    private NlsCreditApprovalInfoService nlsCreditApprovalInfoService;
    @Value(value="${risk.kafkaToptic}")
    private String kafkaToptic;
    @Value(value="${risk.kafkaServers}")
    private String kafkaServers;
    @Autowired
    @Qualifier(value="applicationThreadPool")
    private ApplicationThreadPool2 threadPool;

    public void pass(String bizSerno, PageApproveVO pageApproveVo) {
        int outputVo;
        logger.info("\u4eba\u5de5\u590d\u6838\u4e8c\u7ea7\u5ba1\u6279\u901a\u8fc7\u6d41\u7a0b\u540e\u5904\u7406\u5f00\u59cb\uff0c\u6d41\u6c34\u53f7\u4e3a" + bizSerno);
        if (Objects.nonNull(bizSerno) && !"".equals(bizSerno) && (outputVo = this.updateApprove(bizSerno, pageApproveVo, "03")) > 0) {
            try {
                ManualReviewAppVO manualReviewAppVO = new ManualReviewAppVO();
                manualReviewAppVO.setBizSerno(bizSerno);
                ManualReviewAppVO query = this.manualReviewAppService.queryByPk(manualReviewAppVO);
                if (Objects.isNull(query)) {
                    logger.warn("\u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u4eba\u5de5\u590d\u6838\u7533\u8bf7\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
                    return;
                }
                NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
                nlsCreditInfoVO.setRefuseCause("");
                nlsCreditInfoVO.setLmtApplySeq(query.getLmtApplySeq());
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = new NlsCreditApprovalInfoVO();
                nlsCreditApprovalInfoVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
                nlsCreditApprovalInfoVO.setApprResult("Y");
                int outputVo1 = this.nlsCreditApprovalInfoService.updateByPrimaryKeySelective(nlsCreditApprovalInfoVO);
                if (outputVo != 1) {
                    logger.warn("\u66f4\u65b0\u6388\u4fe1\u5ba1\u6279\u8868\u5931\u8d25\uff01");
                    return;
                }
                nlsCreditInfoVO.setLmtApplySeq(query.getLmtApplySeq());
                NlsCreditInfoVO queryCredit = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
                if (Objects.isNull(queryCredit)) {
                    logger.warn("\u6839\u636e\u6388\u4fe1\u6d41\u6c34\u53f7\u67e5\u8be2\u6388\u4fe1\u7533\u8bf7\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
                    return;
                }
                logger.info("\u53d1\u9001MQ\u6d88\u606f");
                this.sendMessageIfApproveAccess(queryCredit);
                logger.info("\u53d1\u9001kafka\u6d88\u606f");
                this.sendToRisk(queryCredit);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff0c\u8bf7\u524d\u5f80\u65e5\u5fd7\u4e2d\u5fc3\u67e5\u8be2\u65e5\u5fd7");
                e.printStackTrace();
            }
        }
        logger.info("\u4eba\u5de5\u590d\u6838\u4e8c\u7ea7\u5ba1\u6279\u901a\u8fc7\u6d41\u7a0b\u540e\u5904\u7406\u7ed3\u675f\uff0c\u6d41\u6c34\u53f7\u4e3a" + bizSerno);
    }

    public void refuse(String bizSerno, PageApproveVO pageApproveVo) {
        logger.info("\u4eba\u5de5\u590d\u6838\u4e8c\u7ea7\u5ba1\u6279\u62d2\u7edd\u6d41\u7a0b\u540e\u5904\u7406\u5f00\u59cb\uff0c\u6d41\u6c34\u53f7\u4e3a" + bizSerno);
        if (Objects.nonNull(bizSerno) && !"".equals(bizSerno)) {
            int outputVo = this.updateApprove(bizSerno, pageApproveVo, "04");
            ManualReviewAppVO manualReviewAppVO = new ManualReviewAppVO();
            manualReviewAppVO.setBizSerno(bizSerno);
            ManualReviewAppVO query1 = this.manualReviewAppService.queryByPk(manualReviewAppVO);
            NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
            nlsCreditInfoVO.setLmtApplySeq(query1.getLmtApplySeq());
            nlsCreditInfoVO.setApprvSts("03");
            nlsCreditInfoVO.setRejectReason("\u4eba\u5de5\u590d\u6838\u5ba1\u6279\u4e0d\u901a\u8fc7");
            nlsCreditInfoVO.setRefuseCause("\u4eba\u5de5\u590d\u6838\u5ba1\u6279\u4e0d\u901a\u8fc7");
            int outputVo1 = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            if (outputVo1 != 1) {
                logger.error("\u66f4\u65b0\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u8868\u5931\u8d25\uff01");
            }
        }
        logger.info("\u4eba\u5de5\u590d\u6838\u4e8c\u7ea7\u5ba1\u6279\u62d2\u7edd\u6d41\u7a0b\u540e\u5904\u7406\u7ed3\u675f\uff0c\u6d41\u6c34\u53f7\u4e3a" + bizSerno);
    }

    public void repulse(String bizSerno, PageApproveVO pageApproveVo) {
        logger.info("\u4eba\u5de5\u590d\u6838\u4e8c\u7ea7\u5ba1\u6279\u6253\u56de\u6d41\u7a0b\u540e\u5904\u7406\u5f00\u59cb\uff0c\u6d41\u6c34\u53f7\u4e3a" + bizSerno);
        logger.info("\u4eba\u5de5\u590d\u6838\u4e8c\u7ea7\u5ba1\u6279\u6253\u56de\u6d41\u7a0b\u540e\u5904\u7406\u7ed3\u675f\uff0c\u6d41\u6c34\u53f7\u4e3a" + bizSerno);
    }

    private int updateApprove(String bizSerno, PageApproveVO pageApproveVo, String aprSts) {
        ManualReviewAppVO manualReviewApp = new ManualReviewAppVO();
        manualReviewApp.setBizSerno(bizSerno);
        manualReviewApp.setApproveSts(aprSts);
        manualReviewApp.setApproveOpi(pageApproveVo.getAprvComment());
        manualReviewApp.setApproveUser(pageApproveVo.getAprvUserId());
        manualReviewApp.setApproveTime(TimeUtil.getCurrentDateTime());
        int outputVo = this.manualReviewAppService.updateByPk(manualReviewApp);
        if (outputVo > 0) {
            logger.info("\u66f4\u65b0\u5ba1\u6279\u4fe1\u606f\u5230\u4eba\u5de5\u590d\u6838\u7533\u8bf7\u8868\u6210\u529f");
        } else {
            logger.info("\u66f4\u65b0\u5ba1\u6279\u4fe1\u606f\u5230\u4eba\u5de5\u590d\u6838\u7533\u8bf7\u8868\u5931\u8d25");
        }
        return outputVo;
    }

    private void sendMessageIfApproveAccess(NlsCreditInfoVO nlsCreditInfoVO) throws UnsupportedEncodingException {
        nlsCreditInfoVO.setSoltStage(PrdAdaptedSoltEnums.YedSoltStageEnum.CREDIT.getVALUE());
        String message = TopicEnums.QUEUE_TASK_CREDIT_TOPIC.getTopicId() + "_" + TagEnums.TAG_QUEUE_CREDIT_TASK.getTagId() + "_" + nlsCreditInfoVO.getLmtApplySeq() + "-3";
        this.producerService.sendMsg(new Message(TopicEnums.QUEUE_TASK_CREDIT_TOPIC.getTopicId(), TagEnums.TAG_QUEUE_CREDIT_TASK.getTagId(), nlsCreditInfoVO.getLmtApplySeq() + "-3", JSON.toJSONString((Object)nlsCreditInfoVO).getBytes("UTF-8")), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToRisk(NlsCreditInfoVO nlsCreditInfoVO) {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        logger.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            boolean flag = false;
            List infoVOS = this.nlsStageInfoService.queryList();
            for (NlsStageInfoVO vo : infoVOS) {
                if (!vo.getPrdId().equals("11110004") || !vo.getStatus().equals("on") || !vo.getStage().equals("credit")) continue;
                flag = true;
            }
            JSONObject jsonObject = new JSONObject();
            NlsCreditInfoNoticeVO array = new NlsCreditInfoNoticeVO();
            array.setTableName("NLS_CREDIT_INFO");
            String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyy-MM-dd HH:mm:ss");
            array.setApproveAmt(nlsCreditInfoVO.getApproveAmt());
            array.setApprvSts(nlsCreditInfoVO.getApprvSts());
            array.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            array.setRefuseCause(nlsCreditInfoVO.getRefuseCause());
            array.setDataTime(timeStamp);
            KafkaNoticeHeader header = new KafkaNoticeHeader();
            header.setMessageCode("YED_JISHI");
            header.setTimestamp(timeStamp);
            header.setTransactionId(ManualReview2ApprServiceImpl.getTransactionId());
            header.setSysName("netLoan");
            jsonObject.put("head", (Object)header);
            jsonObject.put("biz", (Object)array);
            if (!flag) {
                logger.info("\u5b9e\u65f6\u91c7\u96c6\u5f00\u5173\u672a\u6253\u5f00\uff01\uff01\uff01");
                return;
            }
            this.threadPool.add(() -> {
                KafkaUtil kafkaUtil = new KafkaUtil(this.kafkaServers, this.kafkaToptic);
                try {
                    kafkaUtil.sendMessage(JSONObject.toJSONString((Object)jsonObject));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            logger.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\uff1a" + applySeq + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            logger.info("\u4f18e\u8d37\u6388\u4fe1\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
        }
    }

    public static String getTransactionId() {
        String transactionId = "SEQ" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss", (Locale)Locale.CHINA) + RandomCodeUtils.generateLetter((int)6);
        return transactionId;
    }

    private int updateCredit(NlsCreditInfoVO nlsCreditInfoVO, String refuseReason) {
        nlsCreditInfoVO.setRefuseCause(refuseReason);
        return this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
    }
}

