/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.annotation.checkAnnotation.QueryParamsNullCheck;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.bean.SedSynCusManageVO;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.efp.loan.service.facade.AccoutErroTempService;
import com.irdstudio.efp.nls.service.dao.NlsApplyInfoDao;
import com.irdstudio.efp.nls.service.domain.NlsApplyInfo;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="nlsApplyInfoService")
public class NlsApplyInfoServiceImpl
implements NlsApplyInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(NlsApplyInfoServiceImpl.class);
    private static final String CHANGE_DATA_ERROR = "\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a";
    @Autowired
    private NlsApplyInfoDao nlsApplyInfoDao;
    @Autowired
    @Qualifier(value="accoutErroTempService")
    private AccoutErroTempService accoutErroTempService;

    public int insertNlsApplyInfo(NlsApplyInfoVO inNlsApplyInfoVo) throws Exception {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inNlsApplyInfoVo.toString());
        int num = 0;
        try {
            NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(inNlsApplyInfoVo, (Object)nlsApplyInfo);
            num = this.nlsApplyInfoDao.insertNlsApplyInfo(nlsApplyInfo);
        }
        catch (DuplicateKeyException dke) {
            throw new Exception("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c\u4e3b\u952e\u51b2\u7a81!");
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
            throw e;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    public int deleteByPk(NlsApplyInfoVO inNlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inNlsApplyInfoVo);
        int num = 0;
        try {
            NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(inNlsApplyInfoVo, (Object)nlsApplyInfo);
            num = this.nlsApplyInfoDao.deleteByPk(nlsApplyInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inNlsApplyInfoVo + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public int updateByPk(NlsApplyInfoVO inNlsApplyInfoVo) throws Exception {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inNlsApplyInfoVo.toString());
        int num = 0;
        try {
            NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(inNlsApplyInfoVo, (Object)nlsApplyInfo);
            num = this.nlsApplyInfoDao.updateByPk(nlsApplyInfo);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            num = -1;
            throw e;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + inNlsApplyInfoVo + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    public NlsApplyInfoVO queryByPk(NlsApplyInfoVO inNlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inNlsApplyInfoVo);
        inNlsApplyInfoVo.setLastModifyTime(TimeUtil.getCurrentDateTime());
        try {
            NlsApplyInfo queryNlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(inNlsApplyInfoVo, (Object)queryNlsApplyInfo);
            NlsApplyInfo queryRslNlsApplyInfo = this.nlsApplyInfoDao.queryByPk(queryNlsApplyInfo);
            if (Objects.nonNull((Object)queryRslNlsApplyInfo)) {
                NlsApplyInfoVO outNlsApplyInfoVo = new NlsApplyInfoVO();
                this.beanCopy((Object)queryRslNlsApplyInfo, outNlsApplyInfoVo);
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsApplyInfoVo.toString());
                return outNlsApplyInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @QueryParamsNullCheck(objName="inNlsApplyInfoVo", queryParamNames={"applySeq", "bdReqSn", "certType", "certCode", "nlsApplyState"})
    public NlsApplyInfoVO queryCopy(NlsApplyInfoVO inNlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inNlsApplyInfoVo);
        try {
            NlsApplyInfo queryNlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(inNlsApplyInfoVo, (Object)queryNlsApplyInfo);
            NlsApplyInfo queryRslNlsApplyInfo = this.nlsApplyInfoDao.queryCopy(queryNlsApplyInfo);
            if (Objects.nonNull((Object)queryRslNlsApplyInfo)) {
                NlsApplyInfoVO outNlsApplyInfoVo = new NlsApplyInfoVO();
                this.beanCopy((Object)queryRslNlsApplyInfo, outNlsApplyInfoVo);
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsApplyInfoVo.toString());
                return outNlsApplyInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public List<NlsApplyInfoVO> queryAllOwner(NlsApplyInfoVO nlsApplyInfoVo) throws Exception {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.queryAllOwnerByPage(nlsApplyInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsApplyInfos.size());
            this.pageSet(nlsApplyInfos, (BaseInfo)nlsApplyInfoVo);
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR, (Throwable)e);
            throw e;
        }
        return list;
    }

    public List<NlsApplyInfoVO> queryAllCurrOrg(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.queryAllCurrOrgByPage(nlsApplyInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsApplyInfos.size());
        List list = null;
        try {
            this.pageSet(nlsApplyInfos, (BaseInfo)nlsApplyInfoVo);
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR, (Throwable)e);
        }
        return list;
    }

    public List<NlsApplyInfoVO> queryAllCurrDownOrg(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<Object> nlsApplyInfos = new ArrayList();
        List<String> orgCodes = this.nlsApplyInfoDao.queryLoginUserOrgLocation(nlsApplyInfoVo);
        if (!CollectionUtils.isEmpty(orgCodes)) {
            String orgCodeInSql = String.join((CharSequence)"','", orgCodes);
            nlsApplyInfoVo.setOrgCodeInSql(orgCodeInSql);
            nlsApplyInfos = orgCodes.size() == 1 ? this.nlsApplyInfoDao.queryAllCurrDownOrgOneByPage(nlsApplyInfoVo) : this.nlsApplyInfoDao.queryAllCurrDownOrgByPage(nlsApplyInfoVo);
        }
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsApplyInfos.size());
        List list = null;
        try {
            this.pageSet(nlsApplyInfos, (BaseInfo)nlsApplyInfoVo);
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR, (Throwable)e);
        }
        return list;
    }

    public List<NlsApplyInfoVO> queryAllCurrOwnerPrd(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u4ea7\u54c1\u6743\u9650\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<Object> orgCodes = new ArrayList();
        List<Object> nlsApplyInfos = new ArrayList();
        if (!StringUtil.isEmpty((String)nlsApplyInfoVo.getPrdCodebyBaseInfo())) {
            orgCodes = Arrays.asList(nlsApplyInfoVo.getPrdCodebyBaseInfo().split(","));
        }
        if (orgCodes.size() > 0) {
            String prdCodes = String.join((CharSequence)"','", orgCodes);
            nlsApplyInfoVo.setPrdCodebyBaseInfo(prdCodes);
            nlsApplyInfos = orgCodes.size() == 1 ? this.nlsApplyInfoDao.queryAllCurrOwnerPrdOneByPage(nlsApplyInfoVo) : this.nlsApplyInfoDao.queryAllCurrOwnerPrdByPage(nlsApplyInfoVo);
        }
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u4ea7\u54c1\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsApplyInfos.size());
        List list = null;
        try {
            this.pageSet(nlsApplyInfos, (BaseInfo)nlsApplyInfoVo);
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR, (Throwable)e);
        }
        return list;
    }

    @QueryParamsNullCheck(objName="nlsApplyInfoVo", queryParamNames={"certCode", "prdCode"})
    public List<NlsApplyInfoVO> queryCertCode(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u67e5\u8be2\u5f53\u524d\u5ba2\u6237\u662f\u5426\u5b58\u5728:");
        List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.queryCertCode(nlsApplyInfoVo);
        logger.debug("\u67e5\u8be2\u5f53\u524d\u5ba2\u6237\u662f\u5426\u5b58\u5728:" + nlsApplyInfos.size());
        List list = null;
        try {
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR, (Throwable)e);
        }
        return list;
    }

    public List<NlsApplyInfoVO> queryListByConditions(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e\u5f00\u59cb......");
        NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
        List result = null;
        try {
            List<NlsApplyInfo> list = this.nlsApplyInfoDao.queryByConditionByPage(nlsApplyInfo);
            this.pageSet(list, nlsApplyInfo);
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e\u7ed3\u675f----------");
        return result;
    }

    public NlsApplyInfoVO qryOneByLmtApplSeq(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + nlsApplyInfoVo);
        try {
            NlsApplyInfo queryNlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(nlsApplyInfoVo, (Object)queryNlsApplyInfo);
            NlsApplyInfo queryRslNlsApplyInfo = this.nlsApplyInfoDao.qryOneByLmtApplSeq(queryNlsApplyInfo);
            if (Objects.nonNull((Object)queryRslNlsApplyInfo)) {
                NlsApplyInfoVO outNlsApplyInfoVo = new NlsApplyInfoVO();
                this.beanCopy((Object)queryRslNlsApplyInfo, outNlsApplyInfoVo);
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsApplyInfoVo.toString());
                return outNlsApplyInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @QueryParamsNullCheck(objName="nlsApplyInfoVo", queryParamNames={"lmtApplySeq", "nlsApplyState", "certType", "certCode", "prdId", "prdCode", "channelNo"})
    public List<NlsApplyInfoVO> qryListByConditionsTwo(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e\u5f00\u59cb......");
        NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
        List result = null;
        try {
            List<NlsApplyInfo> list = null;
            list = nlsApplyInfo.getStartNum() > -1 && nlsApplyInfo.getPageSize() > 0 ? this.nlsApplyInfoDao.queryByCondition2Page(nlsApplyInfo) : this.nlsApplyInfoDao.queryListByConditions(nlsApplyInfo);
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e\u7ed3\u675f----------");
        return result;
    }

    @QueryParamsNullCheck(objName="nlsApplyInfoVo", queryParamNames={"lmtApplySeq", "nlsApplyState", "certCode", "prdId", "prdCode", "channelNo"})
    public int queryTotalByCondition(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u6570\u636e\u603b\u6761\u6570\u5f00\u59cb......\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)nlsApplyInfoVo));
        int result = 0;
        try {
            NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
            result = this.nlsApplyInfoDao.queryTotalByCondition(nlsApplyInfo);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u6570\u636e\u603b\u6761\u6570\u7ed3\u675f----------");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countCustHasUsingLetter(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u5f00\u59cb\uff0c\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)nlsApplyInfoVo));
        int res = 0;
        try {
            NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
            res = this.nlsApplyInfoDao.countCustHasUsingLetter(nlsApplyInfo);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            logger.debug("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u7ed3\u675f\uff0c\u4e2a\u6570\u4e3a\uff1a" + res);
        }
        return res;
    }

    public List<NlsApplyInfoVO> queryListByBdIdPictureState() {
        logger.debug("\u67e5\u8be2\u3010\u653e\u6b3e\u7533\u8bf7\u4fe1\u606f\u6d41\u6c34\u3011\u4e2d\u672a\u83b7\u53d6\u767e\u5ea6\u7167\u7247\u7684\u7533\u8bf7\u4eba\u5217\u8868\u6570\u636e\u5f00\u59cb......");
        List result = null;
        try {
            List<NlsApplyInfo> list = this.nlsApplyInfoDao.queryListByBdIdPictureState();
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u3010\u653e\u6b3e\u7533\u8bf7\u4fe1\u606f\u6d41\u6c34\u3011\u4e2d\u672a\u83b7\u53d6\u767e\u5ea6\u7167\u7247\u7684\u7533\u8bf7\u4eba\u5217\u8868\u6570\u636e\u7ed3\u675f----------");
        return result;
    }

    public int insertOrUpdateNlsApplyInfo(List<NlsApplyInfoVO> list) {
        LocalDate today = LocalDate.now();
        String msg1 = "\u3010\u7f51\u8d37\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u660e\u7ec6\u8868\u3011\u6570\u636e\u540c\u6b65\u5f00\u59cb..." + today;
        logger.info(msg1, (Object)"message{}");
        ArrayList<NlsApplyInfo> nlsApplyInfolList = new ArrayList();
        int num = 0;
        try {
            nlsApplyInfolList = (List)this.beansCopy(list, NlsApplyInfo.class);
            num = this.nlsApplyInfoDao.insertOrUpdateNlsApplyInfo(nlsApplyInfolList);
            String num_msg = "\u3010\u7f51\u8d37\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u660e\u7ec6\u8868\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u5904\u7406\u7ed3\u679c:" + num;
            logger.info(num_msg, (Object)"message{}");
        }
        catch (Exception e) {
            String msg2 = "\u3010\u7f51\u8d37\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u660e\u7ec6\u8868\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u51fa\u73b0\u5f02\u5e38:" + e;
            logger.error(msg2, (Object)"message{}");
            num = -1;
        }
        return num;
    }

    public int batchUpdateOnly(List<NlsApplyInfoVO> list) throws Exception {
        int num = 0;
        for (NlsApplyInfoVO nlsApplyInfoVO : list) {
            num = this.updateByPk(nlsApplyInfoVO);
            if (num != -1) continue;
            logger.info("\u65b0\u589e\u501f\u636e\u4fe1\u606f\u6210\u529f\uff0c\u5f00\u59cb\u4fee\u6539\u7533\u8bf7\u8868\u7684\u72b6\u6001\u4e3a \u653e\u6b3e\u6210\u529f\uff0c\u5931\u8d25\uff01\u8fd4\u56de\u7ed3\u679crs\uff1a" + num);
            logger.error("\u66f4\u65b0\u8fd8\u6b3e\u72b6\u6001\u51fa\u9519!");
            String tableName = "NlsApplyInfo\u653e\u6b3e\u6d41\u6c34\u8868";
            String erroMsg = "";
            String tempTotal = "";
            String acountTotal = "";
            String type = "0";
            String updateDelInster = "\u66f4\u65b0";
            String no = nlsApplyInfoVO.getApplySeq();
            String eMsg = "\u66f4\u65b0\u8fd8\u6b3e\u72b6\u6001\u51fa\u9519!";
            this.accoutErroTempService.accountErroMsg(tableName, erroMsg, tempTotal, acountTotal, type, updateDelInster, no, eMsg);
        }
        return num;
    }

    public int batchUpdate(List<NlsApplyInfoVO> list) {
        LocalDate today = LocalDate.now();
        String msg1 = "\u3010\u7f51\u8d37\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u660e\u7ec6\u8868nls_apply_info\u3011\u6279\u91cf\u66f4\u65b0\u5f00\u59cb..." + today;
        logger.info(msg1, (Object)"message{}");
        ArrayList<NlsApplyInfo> nlsApplyInfolList = new ArrayList();
        int num = 0;
        try {
            nlsApplyInfolList = (List)this.beansCopy(list, NlsApplyInfo.class);
            num = this.nlsApplyInfoDao.batchUpdate(nlsApplyInfolList);
            String num_msg = "\u3010\u7f51\u8d37\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u660e\u7ec6\u8868nls_apply_info\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u5904\u7406\u7ed3\u679c:" + num;
            logger.info(num_msg, (Object)"message{}");
        }
        catch (Exception e) {
            String msg2 = "\u3010\u7f51\u8d37\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u660e\u7ec6\u8868nls_apply_info\u3011\u63d2\u5165\u6216\u66f4\u65b0\u6570\u636e\u51fa\u73b0\u5f02\u5e38:" + e;
            logger.error(msg2, (Object)"message{}");
            num = -1;
        }
        return num;
    }

    public NlsApplyInfoVO queryOnTheWay(NlsApplyInfoVO nlsApplyInfoVo) {
        return null;
    }

    public List<NlsApplyInfoVO> queryListByLmtApplySqe(NlsApplyInfoVO nlsApplyInfoVO) {
        logger.debug("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u67e5\u8be2\u5217\u8868\u6570\u636e\u5f00\u59cb......");
        NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVO, (Object)new NlsApplyInfo()));
        List result = null;
        try {
            List<NlsApplyInfo> list = this.nlsApplyInfoDao.queryListByLmtApplySqe(nlsApplyInfo);
            this.pageSet(list, nlsApplyInfo);
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e\u7ed3\u675f----------");
        return result;
    }

    @QueryParamsNullCheck(objName="nlsApplyInfoVO", queryParamNames={"lastModifyTime", "createTime"})
    public List<NlsApplyInfoVO> queryAllByCurrentDate(NlsApplyInfoVO nlsApplyInfoVO) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.queryAllByCurrentDate(nlsApplyInfoVO);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsApplyInfos.size());
        List list = null;
        try {
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR, (Throwable)e);
        }
        return list;
    }

    public boolean batchUpdateCusManage(List<SedSynCusManageVO> sedSynCusManageVOList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u5ba2\u6237\u7ecf\u7406\u5f00\u59cb");
        boolean result = false;
        try {
            ArrayList list = new ArrayList();
            int num = this.nlsApplyInfoDao.batchUpdateCusManage(sedSynCusManageVOList);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5ba2\u6237\u7ecf\u7406\u53d8\u66f4\u66f4\u65b0\u53f0\u8d26\u8868\u51fa\u9519!", (Throwable)e);
        }
        return result;
    }

    public NlsApplyInfoVO queryByGobalSerno(String gobalSerno) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + gobalSerno);
        try {
            NlsApplyInfo queryRslNlsApplyInfo = this.nlsApplyInfoDao.queryByGobalSerno(gobalSerno);
            if (Objects.nonNull((Object)queryRslNlsApplyInfo)) {
                NlsApplyInfoVO outNlsApplyInfoVo = new NlsApplyInfoVO();
                this.beanCopy((Object)queryRslNlsApplyInfo, outNlsApplyInfoVo);
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsApplyInfoVo.toString());
                return outNlsApplyInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public int countInfosByGlobalSerno(String globalSerno) {
        int result = 0;
        logger.debug("\u6839\u636e\u5168\u5c40\u6d41\u6c34\u53f7\u7edf\u8ba1\u4fe1\u606f\u5f00\u59cb----------\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\uff1a" + globalSerno);
        try {
            result = this.nlsApplyInfoDao.countInfosByGlobalSerno(globalSerno);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5168\u5c40\u6d41\u6c34\u53f7\u7edf\u8ba1\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38-----\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\uff1a" + globalSerno, (Throwable)e);
            result = -1;
        }
        return result;
    }

    public List<NlsApplyInfoVO> queryAllByLmtApplySeq(String lmtApplySeq) {
        logger.debug("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u67e5\u8be2\u5217\u8868\u6570\u636e\u5f00\u59cb......\u53c2\u6570\u4e3a\uff1a" + lmtApplySeq);
        List<NlsApplyInfoVO> result = new ArrayList();
        try {
            List<NlsApplyInfo> list = this.nlsApplyInfoDao.queryAllByLmtApplySeq(lmtApplySeq);
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5217\u8868\u6570\u636e\u7ed3\u675f----------\u67e5\u8be2\u7ed3\u679c\u603b\u6570\uff1a" + result.size());
        return result;
    }

    public BigDecimal queryDuringAmt(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u67e5\u8be2\u501f\u636e\u4f59\u989d\u5f00\u59cb:" + nlsApplyInfoVo.toString());
        try {
            NlsApplyInfoVO nlsApplyInfo = new NlsApplyInfoVO();
            this.beanCopy(nlsApplyInfoVo, nlsApplyInfo);
            BigDecimal applyAmt = this.nlsApplyInfoDao.queryDuringAmt(nlsApplyInfo);
            if (applyAmt == null) {
                applyAmt = BigDecimal.ZERO;
            }
            logger.debug(nlsApplyInfoVo.getCertCode() + "\u67e5\u8be2\u5728\u9014\u91d1\u989d\u7ed3\u675f\uff0c\u5728\u9014\u91d1\u989d\u4e3a:" + applyAmt.toString());
            return applyAmt;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u501f\u636e\u4f59\u989d\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    public List<NlsApplyInfoVO> querySampleAllByPk(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + nlsApplyInfoVo);
        NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
        List list = null;
        int i = 0;
        try {
            int rs = this.nlsApplyInfoDao.queryCountAllCus(nlsApplyInfoVo);
            int d = rs * nlsApplyInfoVo.getPercentage() / 100;
            int percentage = d < 1 ? 1 : d;
            int beginNum = (int)Math.random() * (rs - i + 1);
            int endNum = percentage;
            nlsApplyInfo.setBeginNum(beginNum);
            nlsApplyInfo.setEndNum(endNum);
            nlsApplyInfo.setPageSize(nlsApplyInfoVo.getSize());
            List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.querySampleAll(nlsApplyInfo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + nlsApplyInfos.size());
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        return list;
    }

    public List<NlsApplyInfoVO> getFourElementsIfNullList(String prdId) {
        List<NlsApplyInfo> needUploadList = this.nlsApplyInfoDao.getFourElementsIfNullList(prdId);
        try {
            return (List)this.beansCopy(needUploadList, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8f6c\u6362\u6570\u636e\u51fa\u9519");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countHsdCustHasUsingLetter(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u5f00\u59cb\uff0c\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)nlsApplyInfoVo));
        int res = 0;
        try {
            NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
            res = this.nlsApplyInfoDao.countHsdCustHasUsingLetter(nlsApplyInfo);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            logger.debug("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u7ed3\u675f\uff0c\u4e2a\u6570\u4e3a\uff1a" + res);
        }
        return res;
    }

    public List<NlsApplyInfoVO> querySuccessNlsApplyInfo() {
        logger.info("\u67e5\u8be2\u6210\u529f\u653e\u6b3e\u8bb0\u5f55");
        try {
            List<NlsApplyInfo> successNlsApplyInfo = this.nlsApplyInfoDao.querySuccessNlsApplyInfo();
            return (List)this.beansCopy(successNlsApplyInfo, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u6210\u529f\u653e\u6b3e\u8bb0\u5f55\u51fa\u9519");
            return null;
        }
    }

    public List<NlsApplyInfoVO> queryNlsApplyInfoByDnstsAndState(NlsApplyInfoVO nlsApplyInfoVO) {
        logger.info("\u67e5\u8be2\u653e\u6b3e\u72b6\u6001\u4e3a\u6210\u529f,\u7528\u4fe1\u5ba1\u6279\u72b6\u6001\u4e3a\u6210\u529f\u7684\u7528\u4fe1\u7533\u8bf7\u8bb0\u5f55\u8bb0\u5f55");
        try {
            NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVO, (Object)new NlsApplyInfo()));
            List<NlsApplyInfo> successNlsApplyInfo = this.nlsApplyInfoDao.queryNlsApplyInfoByDnstsAndState(nlsApplyInfo);
            return (List)this.beansCopy(successNlsApplyInfo, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u6210\u529f\u653e\u6b3e\u8bb0\u5f55\u51fa\u9519");
            return null;
        }
    }

    public List<NlsApplyInfoVO> queryByApplySeqs(List<String> list) throws Exception {
        return (List)this.beansCopy(this.nlsApplyInfoDao.queryByApplySeqs(list), NlsApplyInfoVO.class);
    }

    public List<NlsApplyInfoVO> queryAllByPrdCodes(List<String> prdCodes) {
        logger.debug("\u901a\u8fc7\u4ea7\u54c1\u96c6\u5408\u67e5\u8be2\u5217\u8868\u6570\u636e\u5f00\u59cb......");
        List result = null;
        try {
            List<NlsApplyInfo> list = this.nlsApplyInfoDao.queryAllByPrdCodes(prdCodes);
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
            logger.debug("\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u5f97\u5230\u7684\u7ed3\u679c\u96c6\u5927\u5c0f\u4e3a\uff1a" + result.size());
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u4ea7\u54c1\u96c6\u5408\u67e5\u8be2\u5217\u8868\u6570\u636e\u7ed3\u675f----------");
        return result;
    }

    public int queryCountByBdIdPictureState() {
        return this.nlsApplyInfoDao.queryCountByBdIdPictureState();
    }

    public List<NlsApplyInfoVO> queryApprovingByCert(String certType, String certCode) {
        logger.debug("\u901a\u8fc7\u8bc1\u4ef6\u53f7\u67e5\u8be2\u5217\u8868\u6570\u636e\u5f00\u59cb......" + certCode);
        List result = null;
        try {
            List<NlsApplyInfo> list = this.nlsApplyInfoDao.queryApprovingByCert(certType, certCode);
            result = (List)this.beansCopy(list, NlsApplyInfoVO.class);
            logger.debug("\u901a\u8fc7\u8bc1\u4ef6\u53f7\u67e5\u8be2\u5217\u8868\u6570\u636e\u5927\u5c0f\u4e3a\uff1a" + result.size());
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u8bc1\u4ef6\u53f7\u67e5\u8be2\u5217\u8868\u6570\u636e\u7ed3\u675f----------");
        return result;
    }

    public int queryByOrgCode(String orgCode) {
        NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
        nlsApplyInfo.setNlsOperOrgid(orgCode);
        int outputVo = this.nlsApplyInfoDao.queryByOrgCode(nlsApplyInfo);
        return outputVo;
    }

    public int updateStatusByApplySeq(String nlsApplyState, String applySeq) {
        return this.nlsApplyInfoDao.updateStatusByApplySeq(nlsApplyState, applySeq);
    }

    public int updateLoanSeqAndDistrNOByApplySeq(String loanSeq, String distrNo, String applySeq) {
        return this.nlsApplyInfoDao.updateLoanSeqAndDistrNOByApplySeq(loanSeq, distrNo, applySeq);
    }

    public List<NlsApplyInfoVO> queryNlsApplyInfoByDnstsAndState2() {
        logger.info("\u67e5\u8be2\u653e\u6b3e\u72b6\u6001\u4e3a\u6210\u529f,\u7528\u4fe1\u5ba1\u6279\u72b6\u6001\u4e3a\u6210\u529f\u7684\u7528\u4fe1\u7533\u8bf7\u8bb0\u5f55\u8bb0\u5f55");
        try {
            List<NlsApplyInfo> successNlsApplyInfo = this.nlsApplyInfoDao.queryNlsApplyInfoByDnstsAndState2();
            return (List)this.beansCopy(successNlsApplyInfo, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u6210\u529f\u653e\u6b3e\u8bb0\u5f55\u51fa\u9519");
            return null;
        }
    }

    public List<NlsApplyInfoVO> queryCusId(String cusId) {
        logger.info("\u6839\u636ecusId\u67e5\u8be2\u7528\u4fe1\u8868");
        try {
            List<NlsApplyInfo> nlsApplyInfons = this.nlsApplyInfoDao.queryCusId(cusId);
            return (List)this.beansCopy(nlsApplyInfons, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u6210\u529f\u653e\u6b3e\u8bb0\u5f55\u51fa\u9519");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countApplyInfoOnWay(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u6216\u8005\u7528\u4fe1\u6d41\u6c34\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u5f00\u59cb\uff0c\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)nlsApplyInfoVo));
        int res = 0;
        try {
            NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVo, (Object)new NlsApplyInfo()));
            res = this.nlsApplyInfoDao.countApplyInfoOnWay(nlsApplyInfo);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u6216\u8005\u7528\u4fe1\u6d41\u6c34\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            logger.debug("\u6839\u636e\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u6216\u8005\u7528\u4fe1\u6d41\u6c34\u7edf\u8ba1\u67d0\u4e2a\u5ba2\u6237\u5728\u9014\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e2a\u6570\u7ed3\u675f\uff0c\u4e2a\u6570\u4e3a\uff1a" + res);
        }
        return res;
    }

    public NlsApplyInfoVO queryLatestNlsApplyInfo(NlsApplyInfoVO nlsApplyInfoVO) {
        logger.info("\u67e5\u8be2\u6700\u8fd1\u4e00\u671f\u8d37\u6b3e\u6210\u529f\u7684\u8d37\u6b3e\u65e5\u671f");
        NlsApplyInfo nlsApplyInfo = (NlsApplyInfo)((Object)this.beanCopy(nlsApplyInfoVO, (Object)new NlsApplyInfo()));
        NlsApplyInfoVO result = new NlsApplyInfoVO();
        try {
            this.beanCopy((Object)this.nlsApplyInfoDao.queryLatestNlsApplyInfo(nlsApplyInfo), result);
        }
        catch (Exception e) {
            logger.error(CHANGE_DATA_ERROR + e.getMessage());
        }
        return result;
    }

    public int queryCountByCertCode(NlsApplyInfoVO nlsApplyInfoVO) {
        logger.info("\u6839\u636e\u8bc1\u4ef6\u53f7\u3001\u4ea7\u54c1id\u67e5\u8be2\u6570\u91cf\u5f00\u59cb");
        NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
        nlsApplyInfo.setCertCode(nlsApplyInfoVO.getCertCode());
        nlsApplyInfo.setPrdId(nlsApplyInfoVO.getPrdId());
        int out = this.nlsApplyInfoDao.queryCountByCertCode(nlsApplyInfo);
        logger.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\u4e3a\uff1a" + out);
        return out;
    }

    public int updateAcctNoByCertCode(NlsApplyInfoVO nlsApplyInfoVO) {
        logger.info("\u6839\u636e\u8bc1\u4ef6\u53f7\u3001\u4ea7\u54c1id\u66f4\u65b0\u8fd8\u6b3e\u8d26\u53f7\u5f00\u59cb");
        NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
        nlsApplyInfo.setCertCode(nlsApplyInfoVO.getCertCode());
        nlsApplyInfo.setPrdId(nlsApplyInfoVO.getPrdId());
        nlsApplyInfo.setRecvAcctNo(nlsApplyInfo.getRecvAcctNo());
        nlsApplyInfo.setRecvBankName(nlsApplyInfo.getRecvBankName());
        int out = this.nlsApplyInfoDao.updateAcctNoByCertCode(nlsApplyInfo);
        logger.info("\u66f4\u65b0\u6570\u636e\u6570\u91cf\u4e3a\uff1a" + out);
        return out;
    }

    public List<NlsApplyInfoVO> queryNlsApplyInfoByDnstsAndState4Yed() {
        logger.info("\u67e5\u8be2\u653e\u6b3e\u72b6\u6001\u4e3a\u6210\u529f,\u7528\u4fe1\u5ba1\u6279\u72b6\u6001\u4e3a\u6210\u529f\u7684\u7528\u4fe1\u7533\u8bf7\u8bb0\u5f55\u8bb0\u5f55");
        try {
            List<NlsApplyInfo> successNlsApplyInfo = this.nlsApplyInfoDao.queryNlsApplyInfoByDnstsAndState4Yed();
            return (List)this.beansCopy(successNlsApplyInfo, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u6210\u529f\u653e\u6b3e\u8bb0\u5f55\u51fa\u9519");
            return null;
        }
    }

    public List<NlsApplyInfoVO> queryByLmtSeqs(List<String> lmtSeqs) throws Exception {
        return (List)this.beansCopy(this.nlsApplyInfoDao.queryByLmtSeqs(lmtSeqs), NlsApplyInfoVO.class);
    }

    public int batchUpdateRecvAcc(List<NlsApplyInfoVO> nlsApplyInfoVOS) {
        int num;
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u5f00\u59cb");
        try {
            ArrayList<NlsApplyInfoVO> list = new ArrayList();
            list = (List)this.beansCopy(nlsApplyInfoVOS, NlsApplyInfoVO.class);
            num = this.nlsApplyInfoDao.batchUpdateRecvAcc(list);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u7ed3\u675f");
        return num;
    }

    public int batchUpdateRecvAccHed(List<NlsApplyInfoVO> nlsApplyInfoVOS) {
        int num;
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u5f00\u59cb");
        try {
            ArrayList<NlsApplyInfoVO> list = new ArrayList();
            list = (List)this.beansCopy(nlsApplyInfoVOS, NlsApplyInfoVO.class);
            num = this.nlsApplyInfoDao.batchUpdateRecvAccHed(list);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.info("\u6839\u636e\u8eab\u4efd\u8bc1\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u8fd8\u6b3e\u5361\u53f7\u7ed3\u675f");
        return num;
    }

    public List<NlsApplyInfoVO> queryAllByOrgCode(String orgCode) {
        List list = null;
        try {
            NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
            nlsApplyInfo.setNlsOperOrgid(orgCode);
            List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.queryAllByOrgCode(nlsApplyInfo);
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public NlsApplyInfoVO queryInfoByCertCodeAndApplyDate(NlsApplyInfoVO inNlsApplyInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inNlsApplyInfoVo);
        try {
            NlsApplyInfo queryNlsApplyInfo = new NlsApplyInfo();
            this.beanCopy(inNlsApplyInfoVo, (Object)queryNlsApplyInfo);
            NlsApplyInfo queryRslNlsApplyInfo = this.nlsApplyInfoDao.queryInfoByCertCodeAndApplyDate(queryNlsApplyInfo);
            if (Objects.nonNull((Object)queryRslNlsApplyInfo)) {
                NlsApplyInfoVO outNlsApplyInfoVo = new NlsApplyInfoVO();
                this.beanCopy((Object)queryRslNlsApplyInfo, outNlsApplyInfoVo);
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsApplyInfoVo.toString());
                return outNlsApplyInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    public BigDecimal queryDuringAmtYED(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u67e5\u8be2\u7533\u8bf7\u91d1\u989d\u5f00\u59cb:" + nlsApplyInfoVo.toString());
        try {
            NlsApplyInfoVO nlsApplyInfo = new NlsApplyInfoVO();
            this.beanCopy(nlsApplyInfoVo, nlsApplyInfo);
            BigDecimal applyAmt = this.nlsApplyInfoDao.queryDuringAmtYED(nlsApplyInfo);
            if (applyAmt == null) {
                applyAmt = BigDecimal.ZERO;
            }
            logger.debug(nlsApplyInfoVo.getCertCode() + "\u67e5\u8be2\u5728\u9014\u91d1\u989d\u7ed3\u675f\uff0c\u5728\u9014\u91d1\u989d\u4e3a:" + applyAmt.toString());
            return applyAmt;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5728\u9014\u91d1\u989d\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    public Integer queryDuringCountYED(NlsApplyInfoVO nlsApplyInfoVo) {
        logger.debug("\u67e5\u8be2\u7533\u8bf7\u7b14\u6570\u5f00\u59cb:" + nlsApplyInfoVo.toString());
        try {
            NlsApplyInfoVO nlsApplyInfo = new NlsApplyInfoVO();
            this.beanCopy(nlsApplyInfoVo, nlsApplyInfo);
            Integer applyCount = this.nlsApplyInfoDao.queryDuringCountYED(nlsApplyInfo);
            logger.debug(nlsApplyInfoVo.getCertCode() + "\u67e5\u8be2\u5728\u9014\u7533\u8bf7\u7b14\u6570\u7ed3\u675f\uff0c\u5728\u9014\u7533\u8bf7\u7b14\u6570\u4e3a:" + applyCount.toString());
            return applyCount;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5728\u9014\u7533\u8bf7\u7b14\u6570\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    public List<NlsApplyInfoVO> queryDuringByCondition(String certCode, String certType, String prdCode) throws Exception {
        List list = null;
        try {
            NlsApplyInfo nlsApplyInfo = new NlsApplyInfo();
            nlsApplyInfo.setCertCode(certCode);
            nlsApplyInfo.setCertType(certType);
            nlsApplyInfo.setPrdCode(prdCode);
            logger.debug("\u67e5\u8be2\u7533\u8bf7\u7b14\u6570\u5f00\u59cb:" + nlsApplyInfo.toString());
            List<NlsApplyInfo> nlsApplyInfos = this.nlsApplyInfoDao.queryDuringByCondition(nlsApplyInfo);
            list = (List)this.beansCopy(nlsApplyInfos, NlsApplyInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5728\u9014\u7533\u8bf7\u7b14\u6570\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            throw e;
        }
        return list;
    }

    public NlsApplyInfoVO queryAllOrderByCreateTime(Map<String, Object> paramsMap) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + paramsMap);
        try {
            NlsApplyInfo queryRslNlsApplyInfo = this.nlsApplyInfoDao.queryAllOrderByCreateTime(paramsMap);
            if (Objects.nonNull((Object)queryRslNlsApplyInfo)) {
                NlsApplyInfoVO outNlsApplyInfoVo = new NlsApplyInfoVO();
                this.beanCopy((Object)queryRslNlsApplyInfo, outNlsApplyInfoVo);
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outNlsApplyInfoVo.toString());
                return outNlsApplyInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }
}

