/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.redis.redisutil.RedisUtil;
import com.irdstudio.basic.framework.redis.redisutil.keys.Ocm_Console_Key;
import com.irdstudio.basic.framework.redis.redisutil.keys.Ocm_Cus_Key;
import com.irdstudio.basic.framework.redis.redisutil.keys.Ocm_Nls_Key;
import com.irdstudio.efp.console.common.psd.PsdEnumSet;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.PtProductUserVO;
import com.irdstudio.efp.cus.service.facade.CusWhiteListEService;
import com.irdstudio.efp.cus.service.facade.OrgWhiteListEService;
import com.irdstudio.efp.cus.service.vo.CusWhiteListEVO;
import com.irdstudio.efp.cus.service.vo.OrgWhiteListEVO;
import com.irdstudio.efp.esb.service.bo.req.sed.letter.ReqSedLetterBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.sed.letter.SedLetterInformService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.util.letter.Message;
import com.irdstudio.efp.nls.common.util.letter.MessageFactory;
import com.irdstudio.efp.nls.common.util.letter.message.PsdCreditFailureMessage;
import com.irdstudio.efp.nls.common.util.letter.message.PsdCreditSuccessMessage;
import com.irdstudio.efp.nls.common.util.letter.message.PsdLmtActivatedMessage;
import com.irdstudio.efp.nls.common.util.letter.message.PsdLmtActivatedMessage1;
import com.irdstudio.efp.nls.common.util.letter.message.PsdLmtActivatedMessage2;
import com.irdstudio.efp.nls.common.util.letter.message.PsdLmtActivatedMessage3;
import com.irdstudio.efp.nls.common.util.letter.message.PsdPreApproveEMessage;
import com.irdstudio.efp.nls.common.util.letter.message.PsdPreApproveNMessage;
import com.irdstudio.efp.nls.common.util.letter.message.PsdPreApproveYMessage;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.WsApplyNotifyService;
import com.irdstudio.efp.nls.service.facade.WsApproveackConfirmService;
import com.irdstudio.efp.nls.service.vo.WsApplyNotifyVO;
import com.irdstudio.efp.nls.service.vo.WsApproveackConfirmVO;
import com.irdstudio.efp.rule.service.facade.TaxWithholdRemitCorpService;
import com.irdstudio.efp.rule.service.vo.TaxWithholdRemitCorpVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="nlsPublicService")
public class NlsPublicServiceImpl
implements NlsPublicService {
    public static Logger logger = LoggerFactory.getLogger(NlsPublicServiceImpl.class);
    @Autowired
    @Qualifier(value="taxWithholdRemitCorpService")
    private TaxWithholdRemitCorpService taxWithholdRemitCorpService;
    @Autowired
    @Qualifier(value="orgWhiteListEService")
    private OrgWhiteListEService orgWhiteListEService;
    @Autowired
    @Qualifier(value="cusWhiteListEService")
    private CusWhiteListEService cusWhiteListEService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;
    @Autowired
    @Qualifier(value="wsApplyNotifyService")
    private WsApplyNotifyService wsApplyNotifyService;
    @Autowired
    @Qualifier(value="wsApproveackConfirmService")
    private WsApproveackConfirmService wsApproveackConfirmService;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    @Qualifier(value="sedLetterInformService")
    private SedLetterInformService sedLetterInformService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;

    public BigDecimal getintRateRatio(String certCode, String certType, String lmtApplySeq) {
        String cusWhite = this.redisUtil.get(Ocm_Cus_Key.CUS_WHITE_LIST_E_KEY.getPrefix() + lmtApplySeq);
        if (StringUtils.isNotEmpty((CharSequence)cusWhite)) {
            CusWhiteListEVO cusWhiteListEVOS = (CusWhiteListEVO)JSONObject.parseObject((String)cusWhite, CusWhiteListEVO.class);
            return cusWhiteListEVOS.getIntRateRatio();
        }
        String orgWhite = this.redisUtil.get(Ocm_Cus_Key.ORG_WHITE_LIST_E_KEY.getPrefix() + lmtApplySeq);
        if (StringUtils.isNotEmpty((CharSequence)orgWhite)) {
            OrgWhiteListEVO orgWhiteListEVO = (OrgWhiteListEVO)JSONObject.parseObject((String)orgWhite, OrgWhiteListEVO.class);
            return orgWhiteListEVO.getIntRateRatio();
        }
        CusWhiteListEVO cusWhiteListEVO = new CusWhiteListEVO();
        cusWhiteListEVO.setCertCode(certCode);
        cusWhiteListEVO.setCertCode(certType);
        Optional<CusWhiteListEVO> cusWhiteList = Optional.ofNullable(this.cusWhiteListEService.queryContractEle(cusWhiteListEVO));
        boolean isExist = cusWhiteList.isPresent();
        if (isExist) {
            return cusWhiteList.get().getIntRateRatio();
        }
        TaxWithholdRemitCorpVO taxWithholdRemitCorpVO = this.taxWithholdRemitCorpService.queryWthldngCorpNm(lmtApplySeq);
        if (taxWithholdRemitCorpVO != null) {
            TaxWithholdRemitCorpVO taxWithholdRemitCorp = Optional.ofNullable(this.taxWithholdRemitCorpService.queryWthldngCorpNm(taxWithholdRemitCorpVO)).orElseGet(TaxWithholdRemitCorpVO::new);
            OrgWhiteListEVO orgWhiteListEVO = new OrgWhiteListEVO();
            orgWhiteListEVO.setCompanyName(taxWithholdRemitCorp.getWthldngCorpNm());
            OrgWhiteListEVO orgWhiteList = Optional.ofNullable(this.orgWhiteListEService.queryByCompanyName(orgWhiteListEVO)).orElseGet(OrgWhiteListEVO::new);
            return orgWhiteList.getIntRateRatio();
        }
        logger.info("\u83b7\u53d6\u7684\u6d6e\u52a8\u5229\u7387\u4e3a\u7a7a!!!");
        return null;
    }

    public PrdInfoVO getProInfo(String proId) {
        String proStr = this.redisUtil.get(Ocm_Console_Key.PRD_INFO_KEY.getPrefix() + proId);
        if (StringUtils.isNotEmpty((CharSequence)proStr)) {
            return (PrdInfoVO)JSONObject.parseObject((String)proStr, PrdInfoVO.class);
        }
        PrdInfoVO prdInfoVO = new PrdInfoVO();
        prdInfoVO.setPrdCode(proId);
        prdInfoVO = this.prdInfoService.queryLastPrdInfo(prdInfoVO);
        if (Objects.isNull(prdInfoVO)) {
            return null;
        }
        this.redisUtil.setEx(Ocm_Console_Key.PRD_INFO_KEY.getPrefix() + proId, JSONObject.toJSONString((Object)prdInfoVO), Ocm_Console_Key.PRD_INFO_KEY.expireSeconds(), Ocm_Console_Key.PRD_INFO_KEY.getTimeUnit());
        return prdInfoVO;
    }

    public String getSysInfoOpenDay(String sysId) {
        String openday = this.pubSysInfoService.getOpenday(sysId);
        String isOpenday = Optional.ofNullable(openday).orElse("");
        if (StringUtils.isEmpty((CharSequence)isOpenday)) {
            logger.info("\u8425\u4e1a\u65e5\u671f\u83b7\u53d6\u4e3a\u7a7a \u8fd4\u56de\u7a7a\u5b57\u7b26\u7a9c");
        }
        return isOpenday;
    }

    public WsApplyNotifyVO getWsApplyNotify(String applyNo) {
        String wsApplyNotifyVOStr = this.redisUtil.get(Ocm_Nls_Key.WS_APPLY_NOTIFY_KEY.getPrefix() + applyNo);
        if (StringUtils.isNotEmpty((CharSequence)wsApplyNotifyVOStr)) {
            return (WsApplyNotifyVO)JSONObject.parseObject((String)wsApplyNotifyVOStr, WsApplyNotifyVO.class);
        }
        return Optional.ofNullable(this.wsApplyNotifyService.queryByApplyNo(applyNo)).orElseGet(WsApplyNotifyVO::new);
    }

    public WsApproveackConfirmVO getWsApproveackConfirm(String applyNo) {
        String wsApproveackConfirmStr = this.redisUtil.get(Ocm_Nls_Key.RISK_FINAL_APPLY_NOTIFY_INFO_KEY.getPrefix() + applyNo);
        if (StringUtils.isNotEmpty((CharSequence)wsApproveackConfirmStr)) {
            return (WsApproveackConfirmVO)JSONObject.parseObject((String)wsApproveackConfirmStr, WsApproveackConfirmVO.class);
        }
        return Optional.ofNullable(this.wsApproveackConfirmService.queryByApplyNo(applyNo)).orElseGet(WsApproveackConfirmVO::new);
    }

    public void sendSuccessMessage(String phone, String approveAmt) {
        try {
            ReqSedLetterBean letter = new ReqSedLetterBean();
            letter.setMblNo(phone);
            letter.setCntntInf(new MessageFactory((Message)new PsdCreditSuccessMessage(), new String[]{Optional.ofNullable(approveAmt).orElse("0").toString(), "96699"}).getMessageContent());
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.sedLetterInformService, (Object)letter, this.nlsQueueSoltComnService);
            esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendFailMesage(String phone) {
        try {
            ReqSedLetterBean letter = new ReqSedLetterBean();
            letter.setMblNo(phone);
            letter.setCntntInf(new MessageFactory((Message)new PsdCreditFailureMessage(), null).getMessageContent());
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.sedLetterInformService, (Object)letter, this.nlsQueueSoltComnService);
            esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendLmtActivatedMessage(String phone, String approveAmt) {
        try {
            ReqSedLetterBean letter = new ReqSedLetterBean();
            letter.setMblNo(phone);
            letter.setCntntInf(new MessageFactory((Message)new PsdLmtActivatedMessage(), new String[]{Optional.ofNullable(approveAmt).orElse("0").toString()}).getMessageContent());
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.sedLetterInformService, (Object)letter, this.nlsQueueSoltComnService);
            esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendMessageWithCusManagerInfo(String msgType, LmtPrdContVO lmtPrdContVO, PtProductUserVO ptProductUserVO, String phone) {
        logger.info("\u989d\u5ea6\u6fc0\u6d3b\u63a5\u53e3\u5206\u914d\u5de5\u53f7\u540e\u5f00\u59cb\u4e0b\u53d1\u77ed\u4fe1\uff1a\u77ed\u4fe1\u7c7b\u578b{}\uff0c\u624b\u673a\u53f7{}", (Object)msgType, (Object)phone);
        try {
            BigDecimal amount = lmtPrdContVO.getLmtAmt().setScale(4, 4);
            DecimalFormat df = new DecimalFormat("###,###.00");
            String approveAmt = df.format(amount);
            if (StringUtils.isEmpty((CharSequence)approveAmt)) {
                approveAmt = "0";
            }
            String ptName = "";
            String ptId = "";
            String ptPhone = "";
            if (!Objects.isNull(ptProductUserVO)) {
                ptName = StringUtils.isNotEmpty((CharSequence)ptProductUserVO.getUserName()) ? ptProductUserVO.getUserName() : "";
                ptId = StringUtils.isNotEmpty((CharSequence)ptProductUserVO.getLoginName()) ? ptProductUserVO.getLoginName() : "";
                ptPhone = StringUtils.isNotEmpty((CharSequence)ptProductUserVO.getPhone()) ? ptProductUserVO.getPhone() : "";
            }
            logger.info("\u989d\u5ea6\u6fc0\u6d3b\u63a5\u53e3\u5206\u914d\u5de5\u53f7\u540e\u5f00\u59cb\u4e0b\u53d1\u77ed\u4fe1\uff1a\u989d\u5ea6{}\uff0c\u5ba2\u6237\u7ecf\u7406{}\uff0c\u5ba2\u6237\u7ecf\u7406\u5de5\u53f7{}\uff0c\u5ba2\u6237\u7ecf\u7406\u7535\u8bdd{},\u76ee\u6807\u7535\u8bdd\u53f7{}", new Object[]{approveAmt, ptName, ptId, ptPhone, phone});
            ReqSedLetterBean letter = new ReqSedLetterBean();
            letter.setMblNo(phone);
            if ("1".equals(msgType)) {
                letter.setCntntInf(new MessageFactory((Message)new PsdLmtActivatedMessage1(), new String[]{approveAmt, ptName, ptId, ptPhone}).getMessageContent());
            } else if ("2".equals(msgType)) {
                letter.setCntntInf(new MessageFactory((Message)new PsdLmtActivatedMessage2(), new String[]{approveAmt, ptName, ptId, ptPhone}).getMessageContent());
            } else if ("3".equals(msgType)) {
                letter.setCntntInf(new MessageFactory((Message)new PsdLmtActivatedMessage3(), new String[]{approveAmt}).getMessageContent());
            }
            logger.info("\u989d\u5ea6\u6fc0\u6d3b\u63a5\u53e3\u5206\u914d\u5de5\u53f7\u540e\u5f00\u59cb\u4e0b\u53d1\u77ed\u4fe1\uff1a\u77ed\u4fe1\u5185\u5bb9{},\u76ee\u6807\u7535\u8bdd\u53f7{}", (Object)letter.getCntntInf(), (Object)phone);
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.sedLetterInformService, (Object)letter, this.nlsQueueSoltComnService);
            esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException | InterruptedException e) {
            e.printStackTrace();
            logger.error("\u5206\u914d\u5ba2\u6237\u7ecf\u7406\u540e\u4e0b\u53d1\u77ed\u4fe1\u5f02\u5e38", e);
        }
    }

    public void sendPsdPreApproveMessage(String phone, String approveFlag, String approveAmt) {
        try {
            logger.info("\u9884\u6388\u4fe1\u6536\u5230\u98ce\u63a7\u5ba1\u6279\u7ed3\u679c{},\u5f00\u59cb\u53d1\u77ed\u4fe1\u5230\u53f7\u7801{}", (Object)approveFlag, (Object)phone);
            if (StringUtils.isEmpty((CharSequence)phone)) {
                logger.error("\u9884\u6388\u4fe1\u5ba1\u6279\u540e\u4e0b\u53d1\u77ed\u4fe1\u5f02\u5e38\uff0c\u624b\u673a\u53f7\u7801\u4e3a\u7a7a");
                return;
            }
            ReqSedLetterBean letter = new ReqSedLetterBean();
            letter.setMblNo(phone);
            String messageContent = "";
            if (PsdEnumSet.AprvlRsltFlgEnum.PASS.getValue().equals(approveFlag)) {
                messageContent = new MessageFactory((Message)new PsdPreApproveYMessage(), new String[]{approveAmt}).getMessageContent();
            } else if (PsdEnumSet.AprvlRsltFlgEnum.REFUSE.getValue().equals(approveFlag)) {
                messageContent = new MessageFactory((Message)new PsdPreApproveNMessage(), new String[0]).getMessageContent();
            } else if (PsdEnumSet.AprvlRsltFlgEnum.EXCEPTION.getValue().equals(approveFlag)) {
                messageContent = new MessageFactory((Message)new PsdPreApproveEMessage(), new String[0]).getMessageContent();
            } else {
                logger.error("\u9884\u6388\u4fe1\u5ba1\u6279\u540e\u4e0b\u53d1\u77ed\u4fe1\u5f02\u5e38\uff0c\u5ba1\u6279\u7ed3\u679c\u4e0d\u5339\u914d\uff0c\u5f53\u524d\u5ba1\u6279\u7ed3\u679c{}", (Object)approveFlag);
                return;
            }
            logger.info("\u9884\u6388\u4fe1\u6536\u5230\u98ce\u63a7\u5ba1\u6279\u7ed3\u679c{},\u5f00\u59cb\u53d1\u77ed\u4fe1\u5230\u53f7\u7801{},\u77ed\u4fe1\u5185\u5bb9\u4e3a{}", new Object[]{approveFlag, phone, messageContent});
            letter.setCntntInf(messageContent);
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.sedLetterInformService, (Object)letter, this.nlsQueueSoltComnService);
            esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException | InterruptedException e) {
            e.printStackTrace();
            logger.info("\u9884\u6388\u4fe1\u6536\u5230\u98ce\u63a7\u5ba1\u6279\u7ed3\u679c{},\u5f00\u59cb\u53d1\u77ed\u4fe1\u5230\u53f7\u7801{},\u53d1\u751f\u5f02\u5e38\uff1a{}", new Object[]{approveFlag, phone, e.getMessage()});
            logger.error("\u9884\u6388\u4fe1\u5ba1\u6279\u540e\u4e0b\u53d1\u77ed\u4fe1\u5f02\u5e38", e);
        }
    }
}

