/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TraceUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.console.service.facade.PrdSoltRuleService;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.console.service.vo.PrdSoltRuleVO;
import com.irdstudio.efp.cus.service.facade.GreyBlackListService;
import com.irdstudio.efp.cus.service.vo.GreyBlackListVO;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import com.irdstudio.efp.rule.service.vo.RespRuleVO;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="nlsQueueSoltComnService")
public class NlsQueueSoltComnServiceImpl
implements NlsQueueSoltComnService {
    private static final Logger logger = LoggerFactory.getLogger(NlsQueueSoltComnServiceImpl.class);
    @Autowired
    @Qualifier(value="prdSoltRuleService")
    private PrdSoltRuleService prdSoltRuleService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="alarmJudgementService")
    private AlarmJudgementService alarmJudgementService;
    @Autowired
    @Qualifier(value="greyBlackListService")
    private GreyBlackListService greyBlackListService;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;

    public void ruleResultDeal(List<RespRuleVO> list, String serno, String prdId, String slotCode) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
        nlsProcessRuleVO.setApplySeq(serno);
        nlsProcessRuleVO = this.nlsProcessRuleService.queryByPk(nlsProcessRuleVO);
        if (Objects.isNull(nlsProcessRuleVO)) {
            logger.error("***************** \u6839\u636e\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + serno + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u7f51\u8d37\u89c4\u5219\u8fc7\u7a0b\u8868\u4fe1\u606f\u4e3a\u7a7a\uff0c\u518d\u6b21\u521d\u59cb\u5316 start***************************");
            flag = false;
            nlsProcessRuleVO = new NlsProcessRuleVO();
            nlsProcessRuleVO.setApplySeq(serno);
            nlsProcessRuleVO.setCusId(nlsProcessRuleVO.getCusId());
            nlsProcessRuleVO.setCusName(nlsProcessRuleVO.getCusName());
            nlsProcessRuleVO.setPrdCode(prdId);
            nlsProcessRuleVO.setPrdName(nlsProcessRuleVO.getPrdName());
            nlsProcessRuleVO.setCreateTime(DateUtility.getCurrDateTime());
            nlsProcessRuleVO.setLastModifyTime(DateUtility.getCurrDateTime());
        }
        List prdSoltRules = this.prdSoltRuleService.queryByPrdIdAndSoltCode(prdId, slotCode);
        Map<String, List<RespRuleVO>> map = list.stream().collect(Collectors.groupingBy(RespRuleVO::getRuleId));
        for (int j = 0; j < prdSoltRules.size(); ++j) {
            String order = ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleOrder();
            Method methodRuleName = NlsProcessRuleVO.class.getMethod("setRuleName" + order, String.class);
            Method methodRuleState = NlsProcessRuleVO.class.getMethod("setRuleState" + order, String.class);
            Method methodRuleTime = NlsProcessRuleVO.class.getMethod("setRuleTime" + order, String.class);
            methodRuleName.invoke((Object)nlsProcessRuleVO, ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
            methodRuleTime.invoke((Object)nlsProcessRuleVO, DateUtility.getCurrAppDateTimeString());
            if (map.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()) != null) {
                methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                sb.append(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleName()).append("\u89c4\u5219\u4e0d\u901a\u8fc7;");
                continue;
            }
            methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
        }
        if (flag) {
            this.nlsProcessRuleService.updateByPk(nlsProcessRuleVO);
        } else {
            this.nlsProcessRuleService.insertNlsProcessRule(nlsProcessRuleVO);
        }
        if (!list.isEmpty()) {
            throw new BizException(sb.toString());
        }
    }

    public void alarmNotice(String objectName, String alramLvl, String message) {
        TraceUtil.clear();
        try {
            ReqAlarmJudgementBean reqAlarmJudgementBean = new ReqAlarmJudgementBean();
            reqAlarmJudgementBean.setMonObjNm(objectName);
            reqAlarmJudgementBean.setMonObjSpfTpVal(objectName);
            reqAlarmJudgementBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmInf(message);
            reqAlarmJudgementBean.setAlrmTmstmp(DateUtility.getCurrAppDateTimeString());
            reqAlarmJudgementBean.setMonAlrmLvl(alramLvl);
            reqAlarmJudgementBean.setAlrmCd("OCM");
            reqAlarmJudgementBean.setAlrmIpAddr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmHstNm(InetAddress.getLocalHost().getHostName());
            RespAlarmJudgementBean respAlarmJudgementBean = this.alarmJudgementService.alarmJudgement(reqAlarmJudgementBean);
            logger.info("\u8c03\u7528\u544a\u8b66\u5224\u65ad\u8fd4\u56de\u7801\uff1a\u3010" + respAlarmJudgementBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + respAlarmJudgementBean.getRetMsg() + "\u3011");
            if (Objects.nonNull(respAlarmJudgementBean) && EsbBizEnums.AlarmJudgeRespCode.SUCCESS.getValue().equals(respAlarmJudgementBean.getRetCd())) {
                logger.info("\u8c03\u7528\u4e92\u91d1\u544a\u8b66\u63a5\u53e3\u301060120002_01\u3011\u6210\u529f\uff01\u8fd4\u56de\u4fe1\u606f\u7801\uff1a" + respAlarmJudgementBean.getRetCd());
            } else {
                logger.error("\u8c03\u7528\u4e92\u91d1\u544a\u8b66\u63a5\u53e3\u544a\u8b66\u301060120002_01\u3011\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\u7801\uff1a" + respAlarmJudgementBean.getRetCd());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528\u4e92\u91d1\u544a\u8b66\u63a5\u53e3\u301060120002_01\u3011\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
    }

    public boolean isGreyBlackList(String certType, String certCode) throws BizException {
        boolean isGreyBlackList = false;
        try {
            certType = SDicToExternal.getExternalSysDicVal((String)"OCM", (String)"CertType", (String)certType);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6821\u9a8c\u53cd\u6d17\u94b1\u540d\u5355\uff0c\u8fdb\u884c\u8bc1\u4ef6\u7c7b\u578b\u5b57\u5178\u9879\u8f6c\u6362\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
        GreyBlackListVO greyBlackListVO = new GreyBlackListVO();
        greyBlackListVO.setCardType(certType);
        greyBlackListVO.setCardNo(certCode);
        int numGbList = this.greyBlackListService.countGreyBlkLtByCust(greyBlackListVO);
        if (numGbList > 0) {
            isGreyBlackList = true;
        }
        return isGreyBlackList;
    }

    public String getPubSysOpenDay(String sysId) {
        String openday = this.pubSysInfoService.getOpenday(sysId);
        String isOpenday = Optional.ofNullable(openday).orElse("");
        if (StringUtil.isNullorBank((String)isOpenday)) {
            logger.error("\u901a\u8fc7\u7cfb\u7edfID\u3010" + sysId + "\u3011\uff0c\u67e5\u8be2\u5230\u7684\u8425\u4e1a\u65e5\u671f\u4e3a\u7a7a\uff01");
        }
        return isOpenday;
    }
}

