/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.Try;
import com.irdstudio.cdp.pboc.service.facade.CreditQueryDetailService;
import com.irdstudio.cdp.pboc.service.facade.QueryZxFailRecordService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.facade.ZXJsonInfoService;
import com.irdstudio.cdp.pboc.service.vo.CreditQueryDetailVO;
import com.irdstudio.cdp.pboc.service.vo.QueryZxFailRecordVO;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.cdp.pboc.service.vo.ZXJsonInfoVO;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.PrdSoltRuleService;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.edoc.service.bo.YedUploadRecordVO;
import com.irdstudio.efp.edoc.service.facade.yed.YedUploadService;
import com.irdstudio.efp.esb.service.bo.req.ZXCXA01QueryReports;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.esb.service.facade.zx.NewZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.yed.apply.bean.ZXQueryBean;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="YedZXRuleService")
public class YedZXRuleServiceImpl
extends CreditSoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(YedZXRuleServiceImpl.class);
    @Autowired
    @Qualifier(value="ruleCallService")
    private RuleCallService ruleService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="prdSoltRuleService")
    private PrdSoltRuleService prdSoltRuleService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="zxJsonInfoService")
    private ZXJsonInfoService zxJsonInfoService;
    @Autowired
    @Qualifier(value="zxCXA01Service")
    private NewZXService<ZXCXA01QueryReports> zxCXA01Service;
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    private ZXHtmlInfoService zxHtmlInfoService;
    @Autowired
    private YedUploadService yedUploadService;
    @Autowired
    private CreditQueryDetailService creditQueryDetailService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    private NlsCreditInfoService nlsCreditInfoService;
    @Value(value="${yed_zxreport_save_path}")
    private String filePath;
    private static AtomicInteger zxCount = new AtomicInteger(1);
    @Autowired
    private AlarmJudgementService alarmJudgementService;
    @Autowired
    @Qualifier(value="queryZxFailRecordService")
    private QueryZxFailRecordService queryZxFailRecordService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        try {
            String appNo = applySeq;
            log.info("\u5f00\u59cb\u8fdb\u884c\u5f81\u4fe1\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7:" + appNo);
            Objects.requireNonNull(nlsCreditInfoVO);
            if (!"02".equals(nlsCreditInfoVO.getApprvSts())) {
                throw new BizException("\u6388\u4fe1\u5ba1\u6279\u72b6\u6001\u4e0d\u4e3a\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u67e5\u5f81\u4fe1\u524d\u7f6e\u63a5\u53e3");
            }
            String cusName = nlsCreditInfoVO.getCusName();
            String certNo = nlsCreditInfoVO.getCertCode();
            String certType = nlsCreditInfoVO.getCertType();
            String authCd = appNo;
            String prdName = nlsCreditInfoVO.getPrdName();
            String prdCode = nlsCreditInfoVO.getPrdCode();
            String authDate = nlsCreditInfoVO.getCreateTime();
            String authTm = DateUtility.formatDateTime19To14((String)authDate);
            String date = DateTool.getCurrentDate();
            String StopDate = TimeUtil.addDay((String)date, (int)90);
            String prdId = Objects.requireNonNull(nlsCreditInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            List params = this.sCfgParamService.queryToZx();
            String RprtUsr = null;
            String RprtUsrBlngDept = null;
            String valiDay = null;
            for (SCfgParamVO param : params) {
                if (param.getParamKey().equals("ZX_RprtUsr")) {
                    RprtUsr = param.getParamValue();
                    continue;
                }
                if (param.getParamKey().equals("ZX_RprtUsrBlngDept")) {
                    RprtUsrBlngDept = param.getParamValue();
                    continue;
                }
                if (!param.getParamKey().equals("ZX_MS_VALID_DAY")) continue;
                valiDay = param.getParamValue();
            }
            String queryAppType = "05";
            String queryReason = "02";
            String queryType = "0";
            String authMd = "19";
            String crdtRprtQryMd = "1";
            ZXCXA01QueryReports ZXQueryReports = new ZXCXA01QueryReports.Builder().withQryAppTp("05").withRprtUsr(RprtUsr).withRprtUsrBlngDept(RprtUsrBlngDept).withCustNm(cusName).withIdentTp(certType).withIdentNo(certNo).withQryRsn("02").withQryTp("0").withAcqrngCustSrc("\u5e7f\u5dde\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8").withPdNm(prdName).withAuthMd("19").withCrdtRprtQryMd("1").withAuthTm(authTm).withAuthStrtDt(date).withAuthStopDt(StopDate).withCnlTp(nlsCreditInfoVO.getCnlTp()).build();
            String reportId = null;
            ZXJsonInfoVO queryReportVo = new ZXJsonInfoVO();
            queryReportVo.setCertCode(certNo);
            List zxInfo = this.zxJsonInfoService.queryReportId(queryReportVo);
            if (zxInfo.size() > 0) {
                String reportTime = ((ZXJsonInfoVO)zxInfo.get(0)).getReportTime();
                reportTime = StringUtils.replace((String)reportTime, (String)".", (String)"-");
                log.info("\u5f53\u524d\u7528\u6237\u5f81\u4fe1\u62a5\u544a\u65e5\u671f" + reportTime);
                int day = TimeUtil.compareDates((String)TimeUtil.addDay((String)reportTime, (int)Integer.parseInt(valiDay)), (String)DateTool.getCurrentDateTime());
                if (day < 0) {
                    try {
                        ZXVO zxvoJson = this.zxCXA01Service.Zxservice((Object)ZXQueryReports, params);
                        reportId = (String)zxvoJson.getResp();
                    }
                    catch (Exception e) {
                        throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                    }
                    log.info("\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5b8c\u6210,\u6d41\u6c34\u53f7:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
                } else {
                    reportId = ((ZXJsonInfoVO)zxInfo.get(0)).getReportId();
                    log.info("\u5f81\u4fe1\u62a5\u544a\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u67e5\u8be2\u5f81\u4fe1:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
                }
            } else {
                try {
                    ZXVO zxvoJson = this.zxCXA01Service.Zxservice((Object)ZXQueryReports, params);
                    reportId = (String)zxvoJson.getResp();
                }
                catch (Exception e) {
                    throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
                log.info("\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5b8c\u6210,\u6d41\u6c34\u53f7:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
            }
            List zxHtmlInfoVOS = this.zxHtmlInfoService.queryAllZXHtmlReports(Arrays.asList(reportId));
            if (null == zxHtmlInfoVOS || zxHtmlInfoVOS.isEmpty()) {
                throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38");
            }
            String fpath = this.filePath + reportId + ".html";
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(fpath), "UTF-8");
            osw.write(((ZXHtmlInfoVO)zxHtmlInfoVOS.get(0)).getContent());
            osw.flush();
            osw.close();
            YedUploadRecordVO yedUploadRecordVO = new YedUploadRecordVO();
            yedUploadRecordVO.setApplSeq(nlsCreditInfoVO.getLmtApplySeq());
            yedUploadRecordVO.setCreateTime(new Date());
            yedUploadRecordVO.setDealType("1");
            yedUploadRecordVO.setFileType("Y03");
            yedUploadRecordVO.setFileUrl(fpath);
            yedUploadRecordVO.setPrdId(nlsCreditInfoVO.getPrdId());
            yedUploadRecordVO.setUpErrMsg("");
            yedUploadRecordVO.setRecordId(UUID.randomUUID().toString().replace("-", ""));
            yedUploadRecordVO.setUpNum(Integer.valueOf(0));
            yedUploadRecordVO.setUpSta(Integer.valueOf(0));
            yedUploadRecordVO.setUpTime(new Date());
            this.yedUploadService.insert(yedUploadRecordVO);
            CreditQueryDetailVO creditQueryDetailVO = new CreditQueryDetailVO();
            creditQueryDetailVO.setSerno(UUID.randomUUID().toString().replace("-", ""));
            creditQueryDetailVO.setCusId(nlsCreditInfoVO.getCusId());
            creditQueryDetailVO.setCusName(cusName);
            creditQueryDetailVO.setCertType(certType);
            creditQueryDetailVO.setCertCode(certNo);
            creditQueryDetailVO.setTransactionCode(nlsCreditInfoVO.getLmtApplySeq());
            creditQueryDetailVO.setPrdCode(prdCode);
            creditQueryDetailVO.setPrdName(prdName);
            creditQueryDetailVO.setReportId(reportId);
            creditQueryDetailVO.setReportTime(TimeUtil.getCurrentDateTime());
            creditQueryDetailVO.setRequestTime(TimeUtil.getCurrentDateTime());
            creditQueryDetailVO.setZxOpId("admin");
            creditQueryDetailVO.setInputBrId(nlsCreditInfoVO.getMainBrId());
            creditQueryDetailVO.setFinaBrId(nlsCreditInfoVO.getChargeoffBrId());
            Optional.ofNullable(creditQueryDetailVO).ifPresent(Try.ofConsumer(arg_0 -> ((CreditQueryDetailService)this.creditQueryDetailService).insertCreditQueryDetailVO(arg_0)));
        }
        catch (BizException e) {
            e.printStackTrace();
            log.error(Arrays.toString(e.getStackTrace()));
            if (zxCount.intValue() > 3) {
                log.info("\u91cd\u8bd53\u6b21\u8c03\u7528\u5f81\u4fe1\u67e5\u8be2\u63a5\u53e3\u4ecd\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f81\u4fe1\u524d\u7f6e\uff01\uff01\uff01");
                zxCount.set(1);
                ReqAlarmJudgementBean reqAlarmJudgementBean = new ReqAlarmJudgementBean();
                reqAlarmJudgementBean.setAlrmInf("\u91cd\u8bd53\u6b21\u8c03\u7528\u5f81\u4fe1\u67e5\u8be2\u63a5\u53e3\u4ecd\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f81\u4fe1\u524d\u7f6e\uff01\uff01\uff01");
                try {
                    this.getrespAlarmJudgementBean(reqAlarmJudgementBean);
                    log.info("\u63d2\u5165\u67e5\u8be2\u5f81\u4fe1\u4fe1\u606f\u5931\u8d25\u7684\u8bb0\u5f55\u5230\u8865\u507f\u67e5\u8be2\u8868>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    this.insertFailRecord("N", "N", nlsCreditInfoVO);
                }
                catch (Exception alarme) {
                    alarme.printStackTrace();
                    log.debug("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + alarme.getMessage());
                }
                throw new Exception("\u3010\u8c03\u7528\u5f81\u4fe1\u67e5\u8be2\u63a5\u53e3\u3011\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u8c03\u7528\u5f81\u4fe1\u67e5\u8be2\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            }
            while (zxCount.intValue() <= 3) {
                Thread.sleep(30000L);
                log.error("\u6267\u884c\u8c03\u7528\u5f81\u4fe1\u67e5\u8be2\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                log.info("\u5f00\u59cb\u91cd\u8bd5\u7b2c" + zxCount.intValue() + "\u6b21\u8c03\u7528\u5f81\u4fe1\u67e5\u8be2\u63a5\u53e3\uff01\uff01\uff01");
                zxCount.incrementAndGet();
                this.doExecute(nlsProcessBizVo, nlsCreditInfoVO);
            }
        }
        catch (IOException e) {
            log.error(Arrays.toString(e.getStackTrace()));
            log.info("\u63d2\u5165\u5199\u5165\u5f81\u4fe1\u4fe1\u606f\u5230\u78c1\u76d8\u5931\u8d25\u7684\u8bb0\u5f55\u5230\u8865\u507f\u67e5\u8be2\u8868>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.insertFailRecord("Y", "N", nlsCreditInfoVO);
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
            throw new Exception("\u5176\u4ed6\u5f02\u5e38");
        }
    }

    public ZXVO getZxvoJson(ZXCXA01QueryReports queryReports, List<SCfgParamVO> params) throws ESBException, InterruptedException {
        ZXQueryBean zxQueryBean = new ZXQueryBean();
        zxQueryBean.setParams(params);
        zxQueryBean.setQueryReports(queryReports);
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper(this.zxCXA01Service, (Object)zxQueryBean, this.nlsQueueSoltComnService);
        ZXVO zxvoJson = (ZXVO)esbInvokeWrapper.invoke3Threes();
        Objects.requireNonNull(zxvoJson, "\u4f18e\u8d37\u8c03\u7528\u5f81\u4fe1\u524d\u7f6e\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a!!!");
        return zxvoJson;
    }

    public static void main(String[] args) throws IOException {
    }

    public RespAlarmJudgementBean getrespAlarmJudgementBean(ReqAlarmJudgementBean reqAlarmJudgementBean) throws Exception {
        RespAlarmJudgementBean respAlarmJudgementBean = null;
        try {
            reqAlarmJudgementBean.setMonObjNm("\u4f18e\u8d37");
            reqAlarmJudgementBean.setMonObjSpfTpVal("\u5916\u90e8\u63a5\u53e3");
            reqAlarmJudgementBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmTmstmp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            reqAlarmJudgementBean.setMonAlrmLvl("3");
            respAlarmJudgementBean = this.alarmJudgementService.alarmJudgement(reqAlarmJudgementBean);
            log.debug("\u8c03\u7528\u544a\u8b66\u5224\u65ad\u8fd4\u56de\u7801\uff1a\u3010" + respAlarmJudgementBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + respAlarmJudgementBean.getRetMsg() + "\u3011");
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
        return respAlarmJudgementBean;
    }

    private void insertFailRecord(String isQuerySuccess, String isUpdateSuccess, NlsCreditInfoVO nlsCreditInfoVO) {
        QueryZxFailRecordVO recordVO = new QueryZxFailRecordVO();
        recordVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        recordVO.setCusName(nlsCreditInfoVO.getCusName());
        recordVO.setCertType(nlsCreditInfoVO.getCertType());
        recordVO.setCertCode(nlsCreditInfoVO.getCertCode());
        recordVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        recordVO.setPrdName(nlsCreditInfoVO.getPrdName());
        recordVO.setAuthDate(nlsCreditInfoVO.getCreateTime());
        recordVO.setIsQuerySuccess(isQuerySuccess);
        recordVO.setIsUpdateSuccess(isUpdateSuccess);
        recordVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
        recordVO.setCreateTime(TimeUtil.getCurrentDateTime());
        recordVO.setLastUpdateUser("system");
        recordVO.setCreateUser("system");
        this.queryZxFailRecordService.insertQueryZxFailRecord(recordVO);
    }
}

