/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.cdp.pboc.service.facade.PbocBadDebtsService;
import com.irdstudio.cdp.pboc.service.facade.PbocCreditBasicService;
import com.irdstudio.cdp.pboc.service.facade.PbocCreditStatusService;
import com.irdstudio.cdp.pboc.service.facade.PbocCreditquerySummaryService;
import com.irdstudio.cdp.pboc.service.facade.PbocLoadBasicService;
import com.irdstudio.cdp.pboc.service.facade.PbocLoadStatusService;
import com.irdstudio.cdp.pboc.service.facade.PbocNearcreditStatusService;
import com.irdstudio.cdp.pboc.service.facade.QueryReportService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.vo.PbocBadDebtsVO;
import com.irdstudio.cdp.pboc.service.vo.PbocCreditBasicVO;
import com.irdstudio.cdp.pboc.service.vo.PbocCreditStatusVO;
import com.irdstudio.cdp.pboc.service.vo.PbocCreditquerySummaryVO;
import com.irdstudio.cdp.pboc.service.vo.PbocLoadBasicVO;
import com.irdstudio.cdp.pboc.service.vo.PbocLoadStatusVO;
import com.irdstudio.cdp.pboc.service.vo.PbocNearcreditStatusVO;
import com.irdstudio.cdp.pboc.service.vo.QueryReportVO;
import com.irdstudio.cdp.pboc.service.vo.ZXHtmlInfoVO;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.facade.PrdSoltRuleService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.console.service.vo.PrdSoltRuleVO;
import com.irdstudio.efp.esb.common.constant.ZXReturnType;
import com.irdstudio.efp.esb.service.bo.req.ZX10001QueryReports;
import com.irdstudio.efp.esb.service.facade.zx.ZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import com.irdstudio.efp.rule.common.enumeration.Rule;
import com.irdstudio.efp.rule.service.facade.RuleCallService;
import com.irdstudio.efp.rule.service.vo.ReqCreditRuleVo;
import com.irdstudio.efp.rule.service.vo.ReqRuleVo;
import com.irdstudio.efp.rule.service.vo.RespRuleVO;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="zxRuleService")
public class ZXRuleServiceImpl
extends SoltServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ZXRuleServiceImpl.class);
    private static final Function<List<PbocCreditStatusVO>, Integer> creditFunc = list -> list.stream().map(i -> Optional.ofNullable(i.getCreditStatus()).orElseGet(String::new)).filter(t -> t.equals("\u903e\u671f") || t.equals("\u5446\u8d26") || t.equals("\u51bb\u7ed3") || t.equals("\u6b62\u4ed8")).mapToInt(e -> 1).sum();
    private static final Function<List<PbocNearcreditStatusVO>, Integer> nearCreditFunc = list -> list.stream().map(i -> Optional.ofNullable(i.getNearcreditStatus()).orElseGet(String::new)).filter(t -> t.equals("\u903e\u671f") || t.equals("\u5446\u8d26") || t.equals("\u51bb\u7ed3") || t.equals("\u6b62\u4ed8")).mapToInt(e -> 1).sum();
    private static final IntPredicate ifOverdueStatus = c -> c >= 49 && c <= 55;
    private static final Predicate<String> ifFiveStyle = s -> s.equals("\u6b21\u7ea7") || s.equals("\u53ef\u7591") || s.equals("\u635f\u5931");
    private static final Function<String, String> last12MonthStatus = i -> i.length() >= 12 ? i.substring(i.length() - 12) : i;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="zx10001JSONService")
    private ZXService<ZX10001QueryReports> zxJSONService;
    @Autowired
    @Qualifier(value="zx10001HTMLService")
    private ZXService<ZX10001QueryReports> zxHTMLService;
    @Autowired
    @Qualifier(value="pbocLoadBasicService")
    private PbocLoadBasicService pbocLoadBasicService;
    @Autowired
    @Qualifier(value="pbocCreditBasicService")
    private PbocCreditBasicService pbocCreditBasicService;
    @Autowired
    @Qualifier(value="pbocBadDebtsService")
    private PbocBadDebtsService pbocBadDebtsService;
    @Autowired
    @Qualifier(value="pbocLoadStatusService")
    private PbocLoadStatusService pbocLoadStatusService;
    @Autowired
    @Qualifier(value="pbocNearcreditStatusService")
    private PbocNearcreditStatusService pbocNearcreditStatusService;
    @Autowired
    @Qualifier(value="pbocCreditquerySummaryService")
    private PbocCreditquerySummaryService PbocCreditquerySummaryService;
    @Autowired
    @Qualifier(value="ruleCallService")
    private RuleCallService ruleService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="prdSoltRuleService")
    private PrdSoltRuleService prdSoltRuleService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="zxHtmlInfoService")
    private ZXHtmlInfoService zxHtmlInfoService;
    @Autowired
    @Qualifier(value="pbocCreditStatusService")
    private PbocCreditStatusService pbocCreditStatusService;
    @Autowired
    @Qualifier(value="queryReportService")
    private QueryReportService queryReportService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;

    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String slotCode = nlsProcessBizVo.getSoltCode();
        try {
            String appNo = applySeq;
            log.info("\u5f00\u59cb\u8fdb\u884c\u5f81\u4fe1\u89c4\u5219\u53c2\u6570\u51c6\u5907,\u6d41\u6c34\u53f7:" + appNo);
            Objects.requireNonNull(nlsApplyInfoVO);
            String cusName = nlsApplyInfoVO.getCusName();
            String certNo = nlsApplyInfoVO.getCertCode();
            String authCd = appNo;
            String bussinessType = nlsApplyInfoVO.getPrdCode();
            String authDate = nlsApplyInfoVO.getApplyDate();
            NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
            nlsProcessRuleVO.setApplySeq(applySeq);
            nlsProcessRuleVO = this.nlsProcessRuleService.queryByPk(nlsProcessRuleVO);
            List prdSoltRules = this.prdSoltRuleService.queryByPrdIdAndSoltCode(nlsApplyInfoVO.getPrdCode(), slotCode);
            String prdId = Objects.requireNonNull(nlsApplyInfoVO.getPrdId());
            PrdInfoVO prdInfoVo = new PrdInfoVO();
            prdInfoVo.setPrdId(prdId);
            prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
            String queryType = "2";
            String queryReason = "02";
            ZX10001QueryReports zxJSONQueryReports = new ZX10001QueryReports.Builder().withCustNm(cusName).withCertNo(certNo).withQryTp("2").withQryRsn("02").withRtnType(ZXReturnType.JSON.VALUE).withAuthCd(authCd).withBizType(bussinessType).withAuthTm(authDate).build();
            ZX10001QueryReports zxHTMLQueryReports = new ZX10001QueryReports.Builder().withCustNm(cusName).withCertNo(certNo).withAuthCd(authCd).withBizType(bussinessType).withQryRsn("02").withQryTp("2").withAuthTm(authDate).withRtnType(ZXReturnType.HTML.VALUE).build();
            String reportId = null;
            QueryReportVO queryReportVo = new QueryReportVO();
            queryReportVo.setCercode(certNo);
            List queryReports = this.queryReportService.queryReportId(queryReportVo);
            if (queryReports.size() > 0) {
                String reportTime = ((QueryReportVO)queryReports.get(0)).getReportTime();
                reportTime = StringUtils.replace((String)reportTime, (String)".", (String)"-");
                log.info("\u5f53\u524d\u7528\u6237\u5f81\u4fe1\u62a5\u544a\u65e5\u671f" + reportTime);
                int day = TimeUtil.compareDates((String)TimeUtil.addDay((String)reportTime, (int)30), (String)DateTool.getCurrentDateTime());
                if (day < 0) {
                    try {
                        ZXVO zxvoJson = this.zxJSONService.service((Object)zxJSONQueryReports, prdInfoVo.getZxOpId());
                        ZXVO zxvoHtml = this.zxHTMLService.service((Object)zxHTMLQueryReports, prdInfoVo.getZxOpId());
                        reportId = (String)zxvoJson.getResp();
                        ZXHtmlInfoVO zxHtmlInfoVO = (ZXHtmlInfoVO)zxvoHtml.getResp();
                        zxHtmlInfoVO.setReportId(reportId);
                        this.zxHtmlInfoService.insert(zxHtmlInfoVO);
                    }
                    catch (Exception e2) {
                        throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e2);
                    }
                    log.info("\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5b8c\u6210,\u6d41\u6c34\u53f7:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
                } else {
                    reportId = ((QueryReportVO)queryReports.get(0)).getReportId();
                    log.info("\u5f81\u4fe1\u62a5\u544a\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u67e5\u8be2\u5f81\u4fe1:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
                }
            } else {
                try {
                    ZXVO zxvoJson = this.zxJSONService.service((Object)zxJSONQueryReports, prdInfoVo.getZxOpId());
                    ZXVO zxvoHtml = this.zxHTMLService.service((Object)zxHTMLQueryReports, prdInfoVo.getZxOpId());
                    reportId = (String)zxvoJson.getResp();
                    ZXHtmlInfoVO zxHtmlInfoVO = (ZXHtmlInfoVO)zxvoHtml.getResp();
                    zxHtmlInfoVO.setReportId(reportId);
                    this.zxHtmlInfoService.insert(zxHtmlInfoVO);
                }
                catch (Exception e3) {
                    throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38", (Throwable)e3);
                }
                log.info("\u5f81\u4fe1\u5355\u7b14\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5b8c\u6210,\u6d41\u6c34\u53f7:" + appNo + "\uff0c\u62a5\u544a\u7f16\u53f7\uff1a" + reportId);
            }
            String typeCredit = "CRDT";
            String typeNearCredit = "NECT";
            String zero = "0";
            int whiteCus = 0;
            if (reportId == null || "".equals(reportId)) {
                whiteCus = 1;
            }
            PbocLoadBasicVO pbocLoadBasicVO = new PbocLoadBasicVO();
            pbocLoadBasicVO.setFId(reportId);
            List reportLoadBasics = Optional.ofNullable(this.pbocLoadBasicService.selectByReportId(pbocLoadBasicVO)).orElseGet(ArrayList::new);
            PbocCreditBasicVO pbocCreditBasicVO = new PbocCreditBasicVO();
            pbocCreditBasicVO.setFId(reportId);
            List creditBasics = Optional.ofNullable(this.pbocCreditBasicService.selectByReportId(pbocCreditBasicVO)).orElseGet(ArrayList::new);
            int reportInfoTotalNum = reportLoadBasics.size() + creditBasics.size();
            List fids = reportLoadBasics.stream().map(PbocLoadBasicVO::getPId).collect(Collectors.toList());
            List loadStatusList = Optional.ofNullable(this.pbocLoadStatusService.queryByFId(fids)).orElseGet(ArrayList::new);
            int overdueNums = loadStatusList.stream().map(PbocLoadStatusVO::getLoadStatus).filter(Objects::nonNull).filter(t -> t.equals("\u903e\u671f")).mapToInt(e -> 1).sum();
            if (log.isDebugEnabled()) {
                log.debug("\u5f81\u4fe1\u89c4\u5219\u53c2\u6570\u51c6\u5907\uff0c\u8d37\u6b3e\u5f53\u524d\u72b6\u6001\u4e3a\u201c\u903e\u671f\u201d\u7684\u603b\u6570\u4e3a\uff1a " + overdueNums);
            }
            Map<String, List<PbocCreditBasicVO>> creditMap = creditBasics.stream().collect(Collectors.groupingBy(PbocCreditBasicVO::getCreditType));
            fids = Optional.ofNullable(creditMap.get("CRDT")).map(i -> i.stream().map(PbocCreditBasicVO::getPId).collect(Collectors.toList())).orElseGet(ArrayList::new);
            int ccAbnormalNum = Optional.ofNullable(this.pbocCreditStatusService.selectByFIdS(fids)).map(creditFunc).orElse(0);
            fids = Optional.ofNullable(creditMap.get("NECT")).map(i -> i.stream().map(PbocCreditBasicVO::getPId).collect(Collectors.toList())).orElseGet(ArrayList::new);
            List nearcreditStatusList = Optional.ofNullable(this.pbocNearcreditStatusService.queryByFID(fids)).orElseGet(ArrayList::new);
            int sccAbnormalNum = nearCreditFunc.apply(nearcreditStatusList);
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u72b6\u6001\u4e3a\u201c\u903e\u671f\u201d\u3001\u201c\u5446\u8d26\u201d\u3001\u201c\u51bb\u7ed3\u201d\u3001\u201c\u6b62\u4ed8\u201d\u7684\u8d37\u8bb0\u5361\u6570\u76ee\u4e3a\uff1a " + ccAbnormalNum);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u72b6\u6001\u4e3a\u201c\u903e\u671f\u201d\u3001\u201c\u5446\u8d26\u201d\u3001\u201c\u51bb\u7ed3\u201d\u3001\u201c\u6b62\u4ed8\u201d\u7684\u51c6\u8d37\u8bb0\u5361\u6570\u76ee\u4e3a\uff1a " + sccAbnormalNum);
            }
            int loanOverdue12MContNum = 0;
            for (PbocLoadBasicVO reportLoad : reportLoadBasics) {
                if (reportLoad.getMonth24status() == null) continue;
                for (char c : last12MonthStatus.apply(reportLoad.getMonth24status()).toCharArray()) {
                    if (!ifOverdueStatus.test(c)) continue;
                    loanOverdue12MContNum = Math.max(loanOverdue12MContNum, Integer.valueOf(String.valueOf(c)));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8d37\u6b3e\u6700\u8fd112\u4e2a\u6708\u8fde\u7eed\u903e\u671f\u8bb0\u5f55\uff1a " + loanOverdue12MContNum);
            }
            int loanOverdue12MTotalNum = reportLoadBasics.stream().map(PbocLoadBasicVO::getMonth24status).filter(Objects::nonNull).map(last12MonthStatus).mapToInt(i -> i.chars().filter(ifOverdueStatus).map(e -> 1).sum()).max().orElse(0);
            if (log.isDebugEnabled()) {
                log.debug("\u8d37\u6b3e\u6700\u8fd112\u4e2a\u6708\u5185\u6709\u7d2f\u8ba1\u903e\u671f\u8bb0\u5f55: " + loanOverdue12MTotalNum);
            }
            int ccOverdue12MContNum = 0;
            Object object = creditBasics.iterator();
            while (object.hasNext()) {
                PbocCreditBasicVO pBasicVO = (PbocCreditBasicVO)object.next();
                if (pBasicVO.getMonth24status() == null) continue;
                for (char c : last12MonthStatus.apply(pBasicVO.getMonth24status()).toCharArray()) {
                    if (!ifOverdueStatus.test(c)) continue;
                    ccOverdue12MContNum = Math.max(ccOverdue12MContNum, Integer.valueOf(String.valueOf(c)));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8d37\u8bb0\u5361\u3001\u51c6\u8d37\u8bb0\u5361\u6700\u8fd112\u4e2a\u6708\u5185\u8fde\u7eed\u903e\u671f\u8bb0\u5f55: " + ccOverdue12MContNum);
            }
            int ccOverdue12MTotalNum = creditBasics.stream().map(PbocCreditBasicVO::getMonth24status).filter(Objects::nonNull).map(last12MonthStatus).mapToInt(i -> i.chars().filter(ifOverdueStatus).map(e -> 1).sum()).max().orElse(0);
            if (log.isDebugEnabled()) {
                log.debug("\u8d37\u8bb0\u5361\u3001\u51c6\u8d37\u8bb0\u5361\u6700\u8fd112\u4e2a\u6708\u5185\u7d2f\u8ba1\u903e\u671f\u8bb0\u5f55\uff1a " + ccOverdue12MTotalNum);
            }
            PbocBadDebtsVO pbocBadDebtsVo = new PbocBadDebtsVO();
            pbocBadDebtsVo.setFId(reportId);
            PbocBadDebtsVO reportBadDebts = Optional.ofNullable(this.pbocBadDebtsService.selectByReportId(pbocBadDebtsVo)).orElseGet(PbocBadDebtsVO::new);
            int n = Stream.of(reportBadDebts.getAssetsNum(), reportBadDebts.getBadDebtsNum(), reportBadDebts.getSponsorialNum()).map(Optional::ofNullable).map(i -> i.map(Integer::valueOf).orElse(0)).reduce(Integer::sum).get();
            if (log.isDebugEnabled()) {
                log.debug("\u8d37\u6b3e\u51fa\u73b0\u201c\u5446\u8d26\u201d\u3001\u201c\u8d44\u4ea7\u5904\u7f6e\u201d\u3001\u201c\u4fdd\u8bc1\u4eba\u4ee3\u507f\u201d\u7b49\u7279\u6b8a\u60c5\u51b5\u7684\u8bb0\u5f55\u6570: " + n);
            }
            fids = reportLoadBasics.stream().map(PbocLoadBasicVO::getPId).collect(Collectors.toList());
            int loan5CcAbnormalNum = loadStatusList.stream().map(PbocLoadStatusVO::getFiveStyle).filter(ifFiveStyle).mapToInt(e -> 1).sum();
            if (log.isDebugEnabled()) {
                log.debug("\u8d37\u6b3e\u4e94\u7ea7\u5206\u7c7b\u4e3a\u201c\u6b21\u7ea7\u201d\u3001\u201c\u53ef\u7591\u201d\u3001\u201c\u635f\u5931\u201d\uff08\u6240\u6709\u8d37\u6b3e\uff09\u7684\u8bb0\u5f55\u6570: " + loan5CcAbnormalNum);
            }
            fids = Optional.ofNullable(creditMap.get("NECT")).orElseGet(ArrayList::new).stream().map(PbocCreditBasicVO::getPId).collect(Collectors.toList());
            int sccOverdue180DNum = nearcreditStatusList.stream().map(PbocNearcreditStatusVO::getOverdue180dAmount).filter(Objects::nonNull).map(i -> new BigDecimal((String)i)).filter(i -> i.compareTo(BigDecimal.ZERO) > 0).mapToInt(e -> 1).sum();
            if (log.isDebugEnabled()) {
                log.debug("\u51c6\u8d37\u8bb0\u5361\u6709\u900f\u652f180\u5929\u4ee5\u4e0a\u672a\u8fd8\u6b3e\u8bb0\u5f55: " + sccOverdue180DNum);
            }
            PbocCreditquerySummaryVO querySum = Optional.ofNullable(this.PbocCreditquerySummaryService.queryByFId(reportId)).orElseGet(PbocCreditquerySummaryVO::new);
            int creditQueryNum = Integer.valueOf(Optional.ofNullable(querySum.getLoadQueryTimes()).orElse("0")) + Integer.valueOf(Optional.ofNullable(querySum.getCreditQueryTimes()).orElse("0"));
            if (log.isDebugEnabled()) {
                log.debug("\u8fd11\u4e2a\u6708\u67e5\u8be2\u6b21\u6570: " + creditQueryNum);
            }
            ReqRuleVo reqRuleVo = new ReqRuleVo();
            reqRuleVo.setAppNo(appNo);
            reqRuleVo.setPrdCode(nlsApplyInfoVO.getPrdCode());
            ReqCreditRuleVo param = new ReqCreditRuleVo();
            param.setWhiteCus(Integer.valueOf(whiteCus));
            param.setReportInfoTotalNum(Integer.valueOf(reportInfoTotalNum));
            param.setCcAbnormalNum(Integer.valueOf(ccAbnormalNum));
            param.setCcOverdue12MContNum(Integer.valueOf(ccOverdue12MContNum));
            param.setCcOverdue12MTotalNum(Integer.valueOf(ccOverdue12MTotalNum));
            param.setCreditQueryNum(Integer.valueOf(creditQueryNum));
            param.setLoan5CcAbnormalNum(Integer.valueOf(loan5CcAbnormalNum));
            param.setLoanOverdue12MContNum(Integer.valueOf(loanOverdue12MContNum));
            param.setLoanOverdue12MTotalNum(Integer.valueOf(loanOverdue12MTotalNum));
            param.setLoanSpecNum(Integer.valueOf(n));
            param.setOverdueNum(Integer.valueOf(overdueNums));
            param.setSccAbnormalNum(Integer.valueOf(sccAbnormalNum));
            param.setSccOverdue180DNum(Integer.valueOf(sccOverdue180DNum));
            reqRuleVo.setReqCreditRuleVo(param);
            List list = this.ruleService.executeBatchRule(Rule.RuleType.ZX, reqRuleVo);
            Map<String, List<RespRuleVO>> map = list.stream().collect(Collectors.groupingBy(RespRuleVO::getRuleId));
            String refuseMsg = "";
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < prdSoltRules.size(); ++j) {
                String order = ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleOrder();
                Method methodRuleName = NlsProcessRuleVO.class.getMethod("setRuleName" + order, String.class);
                Method methodRuleState = NlsProcessRuleVO.class.getMethod("setRuleState" + order, String.class);
                Method methodRuleTime = NlsProcessRuleVO.class.getMethod("setRuleTime" + order, String.class);
                methodRuleName.invoke((Object)nlsProcessRuleVO, ((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode());
                methodRuleTime.invoke((Object)nlsProcessRuleVO, DateUtility.getCurrAppDateTimeString());
                if (map.get(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()) != null) {
                    methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    sb.append(((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleName()).append("\u89c4\u5219\u4e0d\u901a\u8fc7;");
                    refuseMsg = Rule.parseWithRuleId((String)((PrdSoltRuleVO)prdSoltRules.get(j)).getRuleCode()).getMsg();
                    continue;
                }
                methodRuleState.invoke((Object)nlsProcessRuleVO, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
            }
            nlsProcessBizVo.setRefuseMsg(refuseMsg);
            this.nlsProcessRuleService.updateByPk(nlsProcessRuleVO);
            if (!list.isEmpty()) {
                throw new BizException(sb.toString());
            }
        }
        catch (Exception e4) {
            e4.printStackTrace();
            log.error(Arrays.toString(e4.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e4);
        }
    }
}

