/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl;

import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.esb.service.bo.req.ecif.AddrInfArryBean;
import com.irdstudio.efp.esb.service.bo.req.ecif.IdInfArry2Bean;
import com.irdstudio.efp.esb.service.bo.req.ecif.IdInfArryBean;
import com.irdstudio.efp.esb.service.bo.req.ecif.PriMtEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.PrivateCreateThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.PrivateQryThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.RltdPrsnInfArryBean;
import com.irdstudio.efp.esb.service.bo.req.ecif.TelInfArry2Bean;
import com.irdstudio.efp.esb.service.bo.req.ecif.TelInfArryBean;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PriMtEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PrivateCreateThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PrivateQryThirdCusResp;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoExdVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ZydEcifThirdCusService {
    private static final Logger logger = LoggerFactory.getLogger(ZydEcifThirdCusService.class);
    @Autowired
    @Qualifier(value="privateQryThirdCusService")
    private EsbService<PrivateQryThirdCusReq, PrivateQryThirdCusResp> privateQryThirdCusService;
    @Autowired
    @Qualifier(value="priMainEcifThirdCusService")
    private EsbService<PriMtEcifThirdCusReq, PriMtEcifThirdCusResp> priMainEcifThirdCusService;
    @Autowired
    @Qualifier(value="privateCreateThirdCusService")
    private EsbService<PrivateCreateThirdCusReq, PrivateCreateThirdCusResp> privateCreateThirdCusService;

    public PrivateQryThirdCusResp privateQryThirdCusFn(NlsCreditInfoVO nlsCreditInfoVO) throws ESBException {
        logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u6e05\u5355\u67e5\u8be2\u63a5\u53e3\u301020130006_02\u3011\u5f00\u59cb>>>>>>>>>>>>>>>>>" + nlsCreditInfoVO.getCertCode());
        PrivateQryThirdCusResp resp = new PrivateQryThirdCusResp();
        try {
            PrivateQryThirdCusReq req = PrivateQryThirdCusReq.builder().IdntfMd("1").IdentNo(nlsCreditInfoVO.getCertCode()).IdentTp(nlsCreditInfoVO.getCertType()).CustNm(nlsCreditInfoVO.getCusName()).StrtCnt("1").build();
            resp = (PrivateQryThirdCusResp)this.privateQryThirdCusService.service((Object)req);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u6e05\u5355\u67e5\u8be2\u63a5\u53e3\u301020130006_02\u3011\u5f02\u5e38>>>>>>>>>>>>>>>>>");
            throw new ESBException((Throwable)e);
        }
        logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u6e05\u5355\u67e5\u8be2\u63a5\u53e3\u301020130006_02\u3011\u7ed3\u675f>>>>>>>>>>>>>>>>>");
        return resp;
    }

    public PriMtEcifThirdCusResp PriMtEcifThirdCusFn(NlsCreditInfoVO nlsCreditInfoVO, String cusId, String idSeqCode, String telCode) throws ESBException {
        logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u5f00\u59cb>>>>>>>>>>>>>>>>>");
        PriMtEcifThirdCusResp resp = new PriMtEcifThirdCusResp();
        try {
            TelInfArry2Bean telInfArry2Bean;
            String endDtCert;
            String string = endDtCert = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
            if (endDtCert.length() > 8) {
                endDtCert = endDtCert.length() == 10 ? DateUtility.format10To8((String)endDtCert) : endDtCert.split("-")[1];
            }
            IdInfArry2Bean idInfArry2Bean = IdInfArry2Bean.builder().IdentInvalDt(endDtCert).IdentIssuCntry("156").IssuInst("\u4e2d\u56fd").IdentAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getCertAddr())).OprtFlg("2").IdentSeqNo(idSeqCode).NetwrkngExmnRslt(nlsCreditInfoVO.getRetCode()).build();
            ArrayList<IdInfArry2Bean> beans = new ArrayList<IdInfArry2Bean>();
            beans.add(idInfArry2Bean);
            ArrayList<TelInfArry2Bean> telBeans = new ArrayList<TelInfArry2Bean>();
            if (StringUtil.isNullorBank((String)telCode)) {
                telInfArry2Bean = TelInfArry2Bean.builder().OprtTp1("1").TelTp("05").CtcTelNo(nlsCreditInfoVO.getIndivMobile()).build();
                telBeans.add(telInfArry2Bean);
            } else {
                telInfArry2Bean = TelInfArry2Bean.builder().OprtTp1("2").TelId(telCode).TelTp("05").CtcTelNo(nlsCreditInfoVO.getIndivMobile()).AtchSys1("2003000").build();
                telBeans.add(telInfArry2Bean);
            }
            String crrCd = nlsCreditInfoVO.getProfession().length() == 1 ? SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsCreditInfoVO.getProfession()) : nlsCreditInfoVO.getProfession();
            String crrCd1 = null;
            String crrCd2 = null;
            String crrCd3 = null;
            if (!crrCd.endsWith("00")) {
                crrCd3 = crrCd;
            } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
                crrCd2 = crrCd;
            } else if (crrCd.endsWith("0000")) {
                crrCd1 = crrCd;
            }
            PriMtEcifThirdCusReq req = PriMtEcifThirdCusReq.builder().CustNo(cusId).CustNm(nlsCreditInfoVO.getCusName()).NationCd("156").CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).MainMblNo(nlsCreditInfoVO.getIndivMobile()).TelInfArry(telBeans).IdInfArry(beans).build();
            resp = (PriMtEcifThirdCusResp)this.priMainEcifThirdCusService.service((Object)req);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u5f02\u5e38>>>>>>>>>>>>>>>>>");
            throw new ESBException((Throwable)e);
        }
        logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u7ef4\u62a4\u63a5\u53e3\u301020120001_31\u3011\u7ed3\u675f>>>>>>>>>>>>>>>>>");
        return resp;
    }

    public Map<String, Object> privateCreateFn(NlsCreditInfoVO nlsCreditInfoVO, NlsCreditInfoExdVO nlsCreditInfoExdVO, String sstblshBrch) throws ESBException {
        logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u6e05\u5355\u521b\u5efa\u63a5\u53e3\u63a5\u53e3\u301020120001_26\u3011\u5f00\u59cb>>>>>>>>>>>>>>>>>");
        HashMap<String, Object> respMap = new HashMap();
        try {
            String endDtCert;
            ArrayList<IdInfArryBean> idInfArryList = new ArrayList<IdInfArryBean>();
            ArrayList<TelInfArryBean> telInfArryList = new ArrayList<TelInfArryBean>();
            ArrayList<RltdPrsnInfArryBean> rltdPrsnInfArryList = new ArrayList<RltdPrsnInfArryBean>();
            String string = endDtCert = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
            if (endDtCert.length() > 8) {
                endDtCert = endDtCert.length() == 10 ? DateUtility.format10To8((String)endDtCert) : endDtCert.split("-")[1];
            }
            IdInfArryBean idInfArry2req = IdInfArryBean.builder().IdentTp(nlsCreditInfoVO.getCertType()).IdentNo(nlsCreditInfoVO.getCertCode()).IdentEfftvDt("").IdentInvalDt(endDtCert).IdentIssuCntry("156").IssuInst("\u4e2d\u56fd").IdentAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getCertAddr())).FrstChcFlg("1").IdentVrfcFlg("").NetwrkngExmnRslt(nlsCreditInfoVO.getRetCode()).RelateIdentTp("").RelateIdentNo("").build();
            idInfArryList.add(idInfArry2req);
            TelInfArryBean telInfArryBean = TelInfArryBean.builder().TelTp("05").CtcTelNo(nlsCreditInfoVO.getIndivMobile()).build();
            telInfArryList.add(telInfArryBean);
            ArrayList<AddrInfArryBean> addrInfArryBeans = new ArrayList<AddrInfArryBean>();
            AddrInfArryBean addrBeanPri = AddrInfArryBean.builder().AddrTp("100").DtlAddr(nlsCreditInfoVO.getIndivRsdAddr()).build();
            AddrInfArryBean addrBean = AddrInfArryBean.builder().AddrTp("114").DtlAddr(nlsCreditInfoVO.getIndivRsdAddr()).build();
            addrInfArryBeans.add(addrBeanPri);
            addrInfArryBeans.add(addrBean);
            RltdPrsnInfArryBean infArryBean = RltdPrsnInfArryBean.builder().RltdPrsnTp(SDicToExternal.getExternalSysDicVal((String)"RDP", (String)"ConstactsRelation", (String)nlsCreditInfoExdVO.getEmergencyContactRelate())).RltdPrsnNm(nlsCreditInfoExdVO.getEmergencyContactName()).MblNo1(nlsCreditInfoExdVO.getEmergencyContactPhone()).build();
            rltdPrsnInfArryList.add(infArryBean);
            String crrCd = nlsCreditInfoVO.getProfession().length() == 1 ? SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsCreditInfoVO.getProfession()) : nlsCreditInfoVO.getProfession();
            String crrCd1 = null;
            String crrCd2 = null;
            String crrCd3 = null;
            if (!crrCd.endsWith("00")) {
                crrCd3 = crrCd;
            } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
                crrCd2 = crrCd;
            } else if (crrCd.endsWith("0000")) {
                crrCd1 = crrCd;
            }
            PrivateCreateThirdCusReq req = PrivateCreateThirdCusReq.builder().CustNm(nlsCreditInfoVO.getCusName()).Gnd(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname()).BrthDt(DateUtility.format10To8((String)ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()))).NationCd("156").TelInfArry(telInfArryList).ProfTtl(SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Ttl", (String)nlsCreditInfoVO.getTtl())).CustPstlCd(nlsCreditInfoVO.getPostCode()).CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).IndvAnulIncm(Double.valueOf(new BigDecimal(nlsCreditInfoVO.getIndvMnthIncm()).multiply(new BigDecimal(12)).doubleValue())).MrtlSt(nlsCreditInfoVO.getMrgSitu()).HghstEdu(nlsCreditInfoVO.getEdu()).Dgr(nlsCreditInfoVO.getIndivDgr()).WrkCorp(nlsCreditInfoVO.getWrkCorpNm()).IdInfArry(idInfArryList).AddrInfArry(addrInfArryBeans).OpnAcctBrchNo(sstblshBrch).globalSerno(nlsCreditInfoVO.getGlobalSerno()).build();
            respMap = this.privateCreateThirdCusService.serviceMap((Object)req);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u6e05\u5355\u521b\u5efa\u63a5\u53e3\u63a5\u53e3\u301020120001_26\u3011\u5f02\u5e38>>>>>>>>>>>>>>>>>");
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        logger.info("\u8c03\u7528[ECIF]\u5bf9\u79c1\u5ba2\u6237\u6e05\u5355\u521b\u5efa\u63a5\u53e3\u63a5\u53e3\u301020120001_26\u3011\u7ed3\u675f>>>>>>>>>>>>>>>>>");
        return respMap;
    }
}

