/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.ctrloancont.ctr;

import com.irdstudio.basic.framework.core.constant.SDicCertTypeEnum;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.Amount2RMB;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.efp.console.service.facade.PrdInfoLprService;
import com.irdstudio.efp.console.service.vo.PrdInfoLprVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.nls.service.impl.ctrloancont.ctr.AbstractCtrLoanCtrBean;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="psdApplyCtrLoanCont")
public class PsdApplyCtrLoanCtr
extends AbstractCtrLoanCtrBean<NlsApplyInfoVO> {
    protected String repayMethod;
    protected String LPRRate;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="prdInfoLprService")
    private PrdInfoLprService prdInfoLprService;

    public PsdApplyCtrLoanCtr() {
        this.inputPath = "";
        this.outputPath = "";
    }

    @Override
    protected void setSpecifiedLoanContMedaData(NlsApplyInfoVO nlsApplyInfoVO) throws BizException {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setContNo(nlsApplyInfoVO.getLmtApplySeq());
        ctrLoanContVO = this.ctrLoanContService.queryByPk(ctrLoanContVO);
        if (Objects.nonNull(ctrLoanContVO)) {
            this.addContMetaData("cusName", ctrLoanContVO.getCusName());
            this.addContMetaData("certType", SDicCertTypeEnum.getDesc((String)ctrLoanContVO.getCertType()));
            this.addContMetaData("certCode", ctrLoanContVO.getCertCode());
            this.addContMetaData("cusAddr", ctrLoanContVO.getResdntAddr());
            this.addContMetaData("cusZipcode", ctrLoanContVO.getPstcd());
            this.addContMetaData("cusTax", ctrLoanContVO.getClnttFax());
            this.addContMetaData("cusPhone", ctrLoanContVO.getCtcTelNo());
            this.addContMetaData("cusEmail", ctrLoanContVO.getEmail());
        }
        String amount = nlsApplyInfoVO.getApplyAmt().setScale(2, 4).toString();
        this.addContMetaData("lmtAmtLower", amount);
        this.addContMetaData("lmtAmtUpper", Amount2RMB.convert((String)amount));
        this.addContMetaData("contNo", nlsApplyInfoVO.getApplySeq());
        this.addContMetaData("repayMethod", "101".equals(nlsApplyInfoVO.getRepayMethod()) ? "1" : "2");
        PrdInfoLprVO prdInfoLprVO = this.prdInfoLprService.queryByIntratecdAndTerm(new PrdInfoLprVO());
        if (prdInfoLprVO != null) {
            BigDecimal loanRate = nlsApplyInfoVO.getLoanRate().multiply(new BigDecimal("100")).setScale(2, 4);
            String lprRate = loanRate.subtract(prdInfoLprVO.getIntrate()).multiply(new BigDecimal("100")).abs().setScale(2, 4).toString();
            String quoteRates = prdInfoLprVO.getIntrate().setScale(2, 4).toString() + "%";
            this.addContMetaData("quoteRates", quoteRates);
            this.addContMetaData("LRPR", lprRate);
            String operator = loanRate.subtract(prdInfoLprVO.getIntrate()).multiply(new BigDecimal("100")).signum() == 1 ? "\u52a0" : "\u51cf";
            this.addContMetaData("operator", operator);
        }
        this.addContMetaData("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
        Date currDate = new Date(System.currentTimeMillis());
        String loanTermType = nlsApplyInfoVO.getLoanTermType();
        String loanTerm = nlsApplyInfoVO.getLoanTerm();
        this.addContMetaData("loanStartY", String.valueOf(DateTool.getYear((Date)currDate)));
        this.addContMetaData("loanStartM", String.valueOf(DateTool.getMonth((Date)currDate)));
        this.addContMetaData("loanStartD", String.valueOf(DateTool.getDay((Date)currDate)));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currDate);
        int term = Integer.parseInt(nlsApplyInfoVO.getLoanTerm());
        if ("Y".equals(nlsApplyInfoVO.getLoanTermType())) {
            calendar.add(1, term);
        } else if ("M".equals(nlsApplyInfoVO.getLoanTermType())) {
            calendar.add(2, term);
        } else if ("D".equals(nlsApplyInfoVO.getLoanTermType())) {
            calendar.add(6, term);
        }
        Date endDate = calendar.getTime();
        this.addContMetaData("loanEndY", String.valueOf(DateTool.getYear((Date)endDate)));
        this.addContMetaData("loanEndM", String.valueOf(DateTool.getMonth((Date)endDate)));
        this.addContMetaData("loanEndD", String.valueOf(DateTool.getDay((Date)endDate)));
    }
}

