/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.dxm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.HangException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.basic.framework.mq.client.producer.MQProducerMessageClient;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.common.constant.dxm.DxmEnum;
import com.irdstudio.efp.esb.common.util.SDicMappingClient;
import com.irdstudio.efp.esb.service.bo.req.dxm.ReqLoanAdjBizmessage;
import com.irdstudio.efp.esb.service.bo.req.dxm.ReqLoanAdjLmtNoticeBean;
import com.irdstudio.efp.esb.service.bo.resp.dxm.RespLoanAdjLmtNoticeBean;
import com.irdstudio.efp.esb.service.facade.dxm.LoanAdjLmtNoticeService;
import com.irdstudio.efp.limit.service.facade.LmtAdjustThirdService;
import com.irdstudio.efp.limit.service.vo.LmtAdjustThirdVO;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.common.constant.QueueTaskEnums;
import com.irdstudio.efp.nls.service.facade.dxm.LimitSoltService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.queue.NlsQueueTaskService;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class LimitSoltServiceImpl
implements LimitSoltService {
    private static Logger logger = LoggerFactory.getLogger(LimitSoltServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsQueueTaskService")
    private NlsQueueTaskService nlsQueueTaskService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="lmtAdjustThirdService")
    private LmtAdjustThirdService lmtAdjustThirdService;
    @Autowired
    @Qualifier(value="loanAdjLmtNoticeService")
    private LoanAdjLmtNoticeService loanAdjLmtNoticeService;
    @Autowired
    @Qualifier(value="producerService")
    private MQProducerMessageClient producerService;

    public void execute(NlsProcessBizVO nlsProcessBizVo, LmtAdjustThirdVO lmtAdjustThirdVo, int soltOrder) throws HangException, BizException, Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String soltCode = nlsProcessBizVo.getSoltCode();
        String soltName = nlsProcessBizVo.getSoltName();
        String soltService = nlsProcessBizVo.getSoltService();
        logger.info("*********************************************");
        logger.info("*            \u5f00\u59cb\u4e00\u4e2a\u65b0\u7684\u63d2\u69fd                 * ");
        logger.info("* \u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  *");
        logger.info("* \u63d2\u69fd\u4ee3\u7801 : \u3010" + soltCode + "\u3011  *");
        logger.info("* \u63d2\u69fd\u540d\u79f0 : \u3010" + soltName + "\u3011  *");
        logger.info("* \u63d2\u69fd\u670d\u52a1 : \u3010" + soltService + "\u3011  *");
        logger.info("*********************************************");
        try {
            Method methodSoltstate = nlsProcessBizVo.getClass().getMethod("setSoltState" + soltOrder, String.class);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u5f00\u59cb");
            methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.EXECUTING.getCode());
            this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u7ed3\u675f");
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u8c03\u7528\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u5f00\u59cb");
            this.doExecute(nlsProcessBizVo, lmtAdjustThirdVo);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u8c03\u7528\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u7ed3\u675f");
            boolean exceptionFlag = nlsProcessBizVo.isExceptionFlag();
            int hangTimes = nlsProcessBizVo.getHangTimes();
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u6839\u636e\u5f02\u5e38\u6807\u5fd7\u3010" + exceptionFlag + "\u3011\u5904\u7406\u540e\u7eed\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4fe1\u606f");
            if (exceptionFlag) {
                Exception exception = nlsProcessBizVo.getExceptionMsg();
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u6839\u636e\u5f02\u5e38\u3010" + exception + "\u3011\u5904\u7406\u540e\u7eed\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4fe1\u606f");
                if (exception instanceof BizException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c \u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\u548c\u66f4\u65b0 \u7b2c\u4e09\u65b9\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u8868\u4e2d\u8c03\u6574\u72b6\u6001\u4e3a\u62d2\u7edd");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    lmtAdjustThirdVo.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    lmtAdjustThirdVo.setAdjStatus(DxmEnum.LoanAdjustSts.REJECT.getVALUE());
                    this.noticeLoanAdjLmt(nlsProcessBizVo, lmtAdjustThirdVo);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u5f02\u5e38\u7ed3\u675f");
                } else {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5176\u5b83\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c \u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\u548c\u66f4\u65b0 \u7b2c\u4e09\u65b9\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u8868\u4e2d\u8c03\u6574\u72b6\u6001\u4e3a\u62d2\u7edd");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    lmtAdjustThirdVo.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    lmtAdjustThirdVo.setAdjStatus(DxmEnum.LoanAdjustSts.REJECT.getVALUE());
                    this.noticeLoanAdjLmt(nlsProcessBizVo, lmtAdjustThirdVo);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5176\u5b83\u5f02\u5e38\u7ed3\u675f");
                }
                lmtAdjustThirdVo.setRspCode(nlsProcessBizVo.getRefuseMsg());
                lmtAdjustThirdVo.setRspMsg(DxmEnum.DxmRefuseMsg.getValue((String)nlsProcessBizVo.getRefuseMsg()));
                lmtAdjustThirdVo.setRejectReason(exception.getMessage());
                nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                lmtAdjustThirdVo.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
                this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                this.lmtAdjustThirdService.updateByPk(lmtAdjustThirdVo);
                throw exception;
            }
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8be5\u63d2\u69fd\u7684\u65e0\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6210\u529f\uff0c\u6b64\u5904\u961f\u5217\u4efb\u52a1\u8868\u548c\u8fdb\u4ef6\u7533\u8bf7\u8868\u7684\u6570\u636e\u9700\u8981\u7b49\u63d2\u69fd\u5168\u90e8\u6267\u884c\u5b8c\u6210\u540e\u624d\u66f4\u65b0");
            methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
            nlsProcessBizVo.setHangTimes(QueueTaskEnums.QueueHangTimesEnum.INITIALIZE.getTimes());
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8be5\u63d2\u69fd\u7684\u65e0\u5f02\u5e38\u7ed3\u675f");
            nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
            this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
        }
        catch (HangException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5904\u7406\u6302\u8d77\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new HangException();
        }
        catch (BizException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u4e1a\u52a1\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new BizException();
        }
        catch (Exception e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5176\u4ed6\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new Exception();
        }
    }

    protected abstract void doExecute(NlsProcessBizVO var1, LmtAdjustThirdVO var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noticeLoanAdjLmt(NlsProcessBizVO nlsProcessBizVo, LmtAdjustThirdVO lmtAdjustThirdVo) throws Exception {
        try {
            logger.info("-------------------------- \u8c03\u7528\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff0c\u901a\u77e5\u8c03\u989d\u7533\u8bf7\u5931\u8d25\u5f00\u59cb..........................");
            ReqLoanAdjLmtNoticeBean reqLmtBean = new ReqLoanAdjLmtNoticeBean();
            reqLmtBean.setProdCd(SDicMappingClient.getExternalSysDicVal((String)"IOP", (String)"PrdCode", (String)lmtAdjustThirdVo.getPrdId()));
            reqLmtBean.setRetCd(DxmEnum.RetCd.SUCCESS.getValue());
            reqLmtBean.setTxnMd(DxmEnum.TxnModel.SYNC.getValue());
            reqLmtBean.setRepeatRqsBss(lmtAdjustThirdVo.getBdReqSn());
            reqLmtBean.setVerNo(lmtAdjustThirdVo.getVerNo());
            reqLmtBean.setRqsTmstmp(TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS"));
            reqLmtBean.setSessionId(lmtAdjustThirdVo.getAdjSeq());
            reqLmtBean.setAdvType(lmtAdjustThirdVo.getAdvType() + "Callback");
            ReqLoanAdjBizmessage reqBizmessage = new ReqLoanAdjBizmessage();
            String instRsnCd = nlsProcessBizVo.getRefuseMsg();
            if (StringUtil.isNullorBank((String)instRsnCd)) {
                instRsnCd = EsbBizEnums.RetCodeEnum.FAILURE.getVALUE();
            }
            reqBizmessage.setInstRsnCd(instRsnCd);
            reqBizmessage.setInstRsnCdRmk(nlsProcessBizVo.getExceptionMsg().getMessage());
            reqBizmessage.setInstPolcyCd(DxmEnum.OrgStrategyCode.REJECT_90000.getVALUE());
            reqBizmessage.setCfrmAdjtAmt(lmtAdjustThirdVo.getAdjResultLmt().toString());
            reqLmtBean.setBizmessage((Object)reqBizmessage);
            RespLoanAdjLmtNoticeBean respBean = this.loanAdjLmtNoticeService.loanAdjLmtNotice(reqLmtBean);
            logger.info("************* \u8c03\u7528\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)respBean));
        }
        catch (Exception e) {
            logger.error("*********** \u8c03\u7528\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u901a\u77e5\u8c03\u989d\u7533\u8bf7\u5931\u8d25\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        finally {
            logger.info("-------------------------- \u8c03\u7528\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff0c\u901a\u77e5\u8c03\u989d\u7533\u8bf7\u5931\u8d25\u7ed3\u675f--------------------------");
        }
    }
}

