/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.dxm;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.console.common.PrdStatEnums;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.common.constant.dxm.DxmEnum;
import com.irdstudio.efp.esb.common.util.SDicMappingClient;
import com.irdstudio.efp.esb.service.bo.req.dxm.ReqLoanAdjBizmessage;
import com.irdstudio.efp.esb.service.bo.req.dxm.ReqLoanAdjLmtNoticeBean;
import com.irdstudio.efp.esb.service.bo.resp.dxm.RespLoanAdjLmtNoticeBean;
import com.irdstudio.efp.esb.service.facade.dxm.LoanAdjLmtNoticeService;
import com.irdstudio.efp.limit.service.facade.LmtAdjustThirdService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtAdjustThirdVO;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.impl.dxm.LimitSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="lmtAdjAccessRuleService")
public class LmtAdjAccessRuleServiceImpl
extends LimitSoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(LmtAdjAccessRuleServiceImpl.class);
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="lmtAdjustThirdService")
    private LmtAdjustThirdService lmtAdjustThirdService;
    @Autowired
    @Qualifier(value="loanAdjLmtNoticeService")
    private LoanAdjLmtNoticeService loanAdjLmtNoticeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, LmtAdjustThirdVO lmtAdjustThirdVo) throws Exception {
        block10: {
            String adjSeq = lmtAdjustThirdVo.getAdjSeq();
            String adjAmtId = lmtAdjustThirdVo.getAdjAmtId();
            logger.info("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u5f00\u59cb\u8fdb\u884c\u89c4\u5219\u5224\u65ad----------\u4f1a\u8bddID\uff1a" + adjSeq + "------------\u8c03\u989d\u7533\u8bf7\u6d41\u6c34\u53f7\uff08\u552f\u4e00\u6807\u8bb0\u4e00\u6b21\u8c03\u989d\uff09:" + adjAmtId);
            try {
                Objects.requireNonNull(lmtAdjustThirdVo);
                BigDecimal adjResLmt = lmtAdjustThirdVo.getAdjResultLmt();
                String prdId = Objects.requireNonNull(lmtAdjustThirdVo.getPrdId());
                PrdInfoVO prdInfoVo = new PrdInfoVO();
                prdInfoVo.setPrdId(prdId);
                prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
                if (adjResLmt.compareTo(prdInfoVo.getCrdAprvMaxAmt()) == 1) {
                    nlsProcessBizVo.setRefuseMsg(DxmEnum.DxmRefuseMsg.EXCESS.getKey());
                    throw new BizException("\u8c03\u6574\u540e\u989d\u5ea6\uff1a\u3010" + adjResLmt + "\u3011\u5927\u4e8e\u4ea7\u54c1\u6700\u5927\u6388\u4fe1\u989d\u5ea6\uff1a\u3010" + prdInfoVo.getCrdAprvMaxAmt() + "\u3011\uff0c\u8c03\u989d\u7533\u8bf7\u5931\u8d25\uff01");
                }
                if (adjResLmt.compareTo(prdInfoVo.getCrdAprvMinAmt()) == -1) {
                    nlsProcessBizVo.setRefuseMsg(DxmEnum.DxmRefuseMsg.EXCESS.getKey());
                    throw new BizException("\u8c03\u6574\u540e\u989d\u5ea6\uff1a\u3010" + adjResLmt + "\u3011\u5c0f\u4e8e\u4ea7\u54c1\u6700\u5c0f\u6388\u4fe1\u989d\u5ea6\uff1a\u3010" + prdInfoVo.getCrdAprvMinAmt() + "\u3011\uff0c\u8c03\u989d\u7533\u8bf7\u5931\u8d25\uff01");
                }
                PrdStatEnums prdStat = PrdStatEnums.parse((String)prdInfoVo.getPrdStatus());
                if (!Objects.equals(prdStat, PrdStatEnums.IN_USE)) {
                    nlsProcessBizVo.setRefuseMsg(DxmEnum.DxmRefuseMsg.PRD_NOT_USE.getKey());
                    throw new BizException("\u4ea7\u54c1\uff1a " + prdInfoVo.getPrdName() + " \u4e0d\u662f\u6709\u6548\u72b6\u6001\uff01");
                }
                String channelNo = Objects.requireNonNull(lmtAdjustThirdVo.getChannelNo());
                String certCode = Objects.requireNonNull(lmtAdjustThirdVo.getCertCode());
                String curDate = TimeUtil.getCurDate();
                LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
                lmtPrdContVO.setChannelNo(channelNo);
                lmtPrdContVO.setPrdId(prdId);
                lmtPrdContVO.setCertCode(certCode);
                lmtPrdContVO.setCurDate(curDate);
                lmtPrdContVO.setLmtStatus("02");
                lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByCondition(lmtPrdContVO);
                if (Objects.nonNull(lmtPrdContVO)) {
                    if (null == lmtPrdContVO.getLmtAmt()) {
                        nlsProcessBizVo.setRefuseMsg(DxmEnum.DxmRefuseMsg.LMT_FAILURED.getKey());
                        throw new BizException("\u5ba2\u6237\u4e0d\u5b58\u5728\u6388\u4fe1\u989d\u5ea6\u3002\u5176\u8eab\u4efd\u8bc1\u53f7\u4e3a\uff1a" + certCode);
                    }
                    lmtAdjustThirdVo.setAdjStatus(DxmEnum.LoanAdjustSts.PASS.getVALUE());
                    this.lmtAdjustThirdService.updateByPk(lmtAdjustThirdVo);
                    lmtPrdContVO.setLmtAmt(adjResLmt);
                    lmtPrdContVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
                    this.lmtPrdContService.updateByPk(lmtPrdContVO);
                    this.lmtAdjCallBack(lmtAdjustThirdVo);
                    break block10;
                }
                nlsProcessBizVo.setRefuseMsg(DxmEnum.DxmRefuseMsg.LMT_FAILURED.getKey());
                throw new BizException("\u65e0\u6cd5\u6839\u636e\u3010\u6e20\u9053\u7f16\u53f7\u3011\uff1a" + channelNo + "\uff1b\u3010\u4ea7\u54c1\u7f16\u53f7\u3011\uff1a" + prdId + "\uff1b\u3010\u8eab\u4efd\u8bc1\u53f7\u3011\uff1a" + certCode + "\uff1b\u3010\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3011\uff1a" + curDate + "\uff0c\u67e5\u8be2\u5230\u5ba2\u6237\u6388\u4fe1\u989d\u5ea6\u4fe1\u606f\uff01");
            }
            catch (Exception e) {
                logger.error("--------\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage());
                nlsProcessBizVo.setExceptionFlag(true);
                nlsProcessBizVo.setExceptionMsg(e);
            }
            finally {
                logger.info("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u89c4\u5219\u5224\u65ad\u7ed3\u675f----------\u4f1a\u8bddID\uff1a" + adjSeq + "------------\u8c03\u989d\u7533\u8bf7\u6d41\u6c34\u53f7\uff08\u552f\u4e00\u6807\u8bb0\u4e00\u6b21\u8c03\u989d\uff09:" + adjAmtId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lmtAdjCallBack(LmtAdjustThirdVO lmtAdjustThirdVo) {
        String adjSeq = lmtAdjustThirdVo.getAdjSeq();
        String adjAmtId = lmtAdjustThirdVo.getAdjAmtId();
        logger.info("------------ \u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u5f00\u59cb\uff0c\u4f1a\u8bddID\u4e3a\uff1a" + adjSeq + "-----------\u8c03\u989d\u7533\u8bf7\u6d41\u6c34\u53f7\uff08\u552f\u4e00\u6807\u8bb0\u4e00\u6b21\u8c03\u989d\uff09\uff1a" + adjAmtId);
        try {
            ReqLoanAdjLmtNoticeBean reqBean = new ReqLoanAdjLmtNoticeBean();
            reqBean.setProdCd(SDicMappingClient.getExternalSysDicVal((String)"IOP", (String)"PrdCode", (String)lmtAdjustThirdVo.getPrdId()));
            reqBean.setRetCd(DxmEnum.RetCd.SUCCESS.getValue());
            reqBean.setTxnMd(DxmEnum.TxnModel.SYNC.getValue());
            reqBean.setRepeatRqsBss(lmtAdjustThirdVo.getBdReqSn());
            reqBean.setVerNo(lmtAdjustThirdVo.getVerNo());
            reqBean.setRqsTmstmp(TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS"));
            reqBean.setSessionId(adjSeq);
            reqBean.setAdvType(lmtAdjustThirdVo.getAdvType() + "Callback");
            ReqLoanAdjBizmessage reqBizmessage = new ReqLoanAdjBizmessage();
            reqBizmessage.setInstRsnCd(EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE());
            reqBizmessage.setInstRsnCdRmk("\u8c03\u989d\u7533\u8bf7\u901a\u8fc7\uff01");
            reqBizmessage.setInstPolcyCd(DxmEnum.OrgStrategyCode.PASS_10000.getVALUE());
            reqBizmessage.setCfrmAdjtAmt(lmtAdjustThirdVo.getAdjResultLmt().toString());
            reqBean.setBizmessage((Object)reqBizmessage);
            RespLoanAdjLmtNoticeBean respBean = this.loanAdjLmtNoticeService.loanAdjLmtNotice(reqBean);
            logger.info("************* \u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)respBean));
            if (!EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE().equals(respBean.getRetCd()) || !DxmEnum.RetCd.REQ_REPEAT.getValue().equals(respBean.getRetCd())) {
                logger.error("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u8fd4\u56de\u4fe1\u606f\u51fa\u9519!");
            } else {
                logger.error("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u8fd4\u56de\u4fe1\u606f\u6210\u529f!");
            }
        }
        catch (Exception e) {
            logger.error("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            logger.info("------------ \u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u7ed3\u675f\uff0c\u4f1a\u8bddID\u4e3a\uff1a" + adjSeq + "-----------\u8c03\u989d\u7533\u8bf7\u6d41\u6c34\u53f7\uff08\u552f\u4e00\u6807\u8bb0\u4e00\u6b21\u8c03\u989d\uff09\uff1a" + adjAmtId);
        }
    }
}

