/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.dxm;

import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.common.constant.dxm.DxmEnum;
import com.irdstudio.efp.esb.common.util.SDicMappingClient;
import com.irdstudio.efp.esb.service.bo.req.dxm.ReqLoanAdjBizmessage;
import com.irdstudio.efp.esb.service.bo.req.dxm.ReqLoanAdjLmtNoticeBean;
import com.irdstudio.efp.esb.service.bo.resp.dxm.RespLoanAdjLmtNoticeBean;
import com.irdstudio.efp.esb.service.facade.dxm.LoanAdjLmtNoticeService;
import com.irdstudio.efp.limit.service.vo.LmtAdjustThirdVO;
import com.irdstudio.efp.nls.service.impl.dxm.LimitSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="lmtAdjCallBackService")
public class LmtAdjCallBackServiceImpl
extends LimitSoltServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(LmtAdjCallBackServiceImpl.class);
    @Autowired
    @Qualifier(value="loanAdjLmtNoticeService")
    private LoanAdjLmtNoticeService loanAdjLmtNoticeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, LmtAdjustThirdVO lmtAdjustThirdVo) throws Exception {
        String adjSeq = lmtAdjustThirdVo.getAdjSeq();
        String adjAmtId = lmtAdjustThirdVo.getAdjAmtId();
        logger.info("------------ \u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u5f00\u59cb\uff0c\u4f1a\u8bddID\u4e3a\uff1a" + adjSeq + "-----------\u8c03\u989d\u7533\u8bf7\u6d41\u6c34\u53f7\uff08\u552f\u4e00\u6807\u8bb0\u4e00\u6b21\u8c03\u989d\uff09\uff1a" + adjAmtId);
        try {
            ReqLoanAdjLmtNoticeBean reqBean = new ReqLoanAdjLmtNoticeBean();
            reqBean.setProdCd(SDicMappingClient.getExternalSysDicVal((String)"IOP", (String)"PrdCode", (String)lmtAdjustThirdVo.getPrdId()));
            reqBean.setRetCd(DxmEnum.RetCd.SUCCESS.getValue());
            reqBean.setTxnMd(DxmEnum.TxnModel.SYNC.getValue());
            reqBean.setRepeatRqsBss(lmtAdjustThirdVo.getBdReqSn());
            reqBean.setVerNo(lmtAdjustThirdVo.getVerNo());
            reqBean.setRqsTmstmp(TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS"));
            reqBean.setSessionId(adjSeq);
            reqBean.setAdvType(lmtAdjustThirdVo.getAdvType() + "Callback");
            ReqLoanAdjBizmessage reqBizmessage = new ReqLoanAdjBizmessage();
            reqBizmessage.setInstRsnCd(EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE());
            reqBizmessage.setInstRsnCdRmk("\u8c03\u989d\u7533\u8bf7\u901a\u8fc7\uff01");
            reqBizmessage.setInstPolcyCd(DxmEnum.OrgStrategyCode.PASS_10000.getVALUE());
            reqBizmessage.setCfrmAdjtAmt(lmtAdjustThirdVo.getAdjResultLmt().toString());
            reqBean.setBizmessage((Object)reqBizmessage);
            RespLoanAdjLmtNoticeBean respBean = this.loanAdjLmtNoticeService.loanAdjLmtNotice(reqBean);
            Objects.requireNonNull(respBean);
            if (!EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE().equals(respBean.getRetCd())) {
                logger.error("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u8fd4\u56de\u4fe1\u606f\u51fa\u9519!");
            }
        }
        catch (Exception e) {
            logger.error("\u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            logger.info("------------ \u989d\u5ea6\u8c03\u6574\u7533\u8bf7\u7ed3\u679c\u56de\u8c03\u5f00\u59cb\uff0c\u4f1a\u8bddID\u4e3a\uff1a" + adjSeq + "-----------\u8c03\u989d\u7533\u8bf7\u6d41\u6c34\u53f7\uff08\u552f\u4e00\u6807\u8bb0\u4e00\u6b21\u8c03\u989d\uff09\uff1a" + adjAmtId);
        }
    }
}

