/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.hed;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.Try;
import com.irdstudio.cdp.pboc.service.facade.CreditQueryDetailService;
import com.irdstudio.cdp.pboc.service.facade.ZXHtmlInfoService;
import com.irdstudio.cdp.pboc.service.vo.CreditQueryDetailVO;
import com.irdstudio.efp.console.common.PrdBizEnums;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.esb.service.bo.req.ZXCXE01QueryReports;
import com.irdstudio.efp.esb.service.facade.zx.NewZXService;
import com.irdstudio.efp.esb.service.vo.zx.ZXVO;
import com.irdstudio.efp.nls.service.facade.hed.HedZxLocalQueryService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoExdService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoExdVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="hedZxLocalQueryService")
public class HedZxLocalQueryServiceImpl
implements HedZxLocalQueryService {
    private final Logger logger = LoggerFactory.getLogger(HedZxLocalQueryServiceImpl.class);
    public static final String loggerID = "\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_";
    @Autowired
    @Qualifier(value="nlsCreditInfoExdService")
    private NlsCreditInfoExdService nlsCreditInfoExdService;
    @Autowired
    @Qualifier(value="zxCXE01Service")
    private NewZXService<ZXCXE01QueryReports> zxCXE01Service;
    @Autowired
    @Qualifier(value="sCfgParamService")
    private SCfgParamService sCfgParamService;
    @Autowired
    @Qualifier(value="creditQueryDetailService")
    private CreditQueryDetailService creditQueryDetailService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    private ZXHtmlInfoService zxHtmlInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doQuery() {
        this.logger.info("\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_\u5f00\u59cb");
        try {
            NlsCreditInfoExdVO vo = new NlsCreditInfoExdVO();
            vo.setProCode(PrdBizEnums.PrdCodeEnum.PRD_CODE_HED.getValue());
            List list = new ArrayList();
            list = this.nlsCreditInfoExdService.queryByCondition(vo);
            if (null != list && list.size() > 0) {
                this.logger.info("\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_\u7b26\u5408\u6761\u4ef6\u7684\u6761\u6570\u4e3a" + list.size());
                List params = this.sCfgParamService.queryToZx();
                String RprtUsr = null;
                String RprtUsrBlngDept = null;
                String valiDay = null;
                for (SCfgParamVO param : params) {
                    if (param.getParamKey().equals("ZX_RprtUsr")) {
                        RprtUsr = param.getParamValue();
                        continue;
                    }
                    if (param.getParamKey().equals("ZX_RprtUsrBlngDept")) {
                        RprtUsrBlngDept = param.getParamValue();
                        continue;
                    }
                    if (!param.getParamKey().equals("ZX_MS_VALID_DAY")) continue;
                    valiDay = param.getParamValue();
                }
                for (NlsCreditInfoExdVO exdVO : list) {
                    String creditAppSeq = exdVO.getLmtApplySeq();
                    String zxReportId = exdVO.getZxReportId();
                    String loggerIDByZxId = "\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_\u6388\u4fe1\u7533\u6d41\u6c34\u53f7_" + creditAppSeq + "\u5f81\u4fe1\u7f16\u53f7_" + zxReportId;
                    this.logger.info(loggerIDByZxId + "\u5904\u7406\u5f00\u59cb");
                    try {
                        boolean num = false;
                        CreditQueryDetailVO queryVO = new CreditQueryDetailVO();
                        queryVO.setTransactionCode(creditAppSeq);
                        queryVO.setReportId(zxReportId);
                        CreditQueryDetailVO queryDetailVO = this.creditQueryDetailService.queryByReportId(queryVO);
                        if (null != queryDetailVO) {
                            int num1 = this.nlsCreditInfoExdService.updateByReportId(creditAppSeq, zxReportId, "Y");
                            if (num1 > 0) {
                                this.logger.info(loggerIDByZxId + "\u66f4\u65b0\u5f81\u4fe1\u67e5\u8be2\u72b6\u6001\u6210\u529f");
                            } else {
                                this.logger.info(loggerIDByZxId + "\u66f4\u65b0\u5f81\u4fe1\u67e5\u8be2\u72b6\u6001\u5931\u8d25");
                            }
                        } else {
                            this.logger.info(loggerIDByZxId + "\u8c03\u7528\u4e8c\u4ee3\u4e2a\u4eba\u5f81\u4fe1\u62a5\u544a\u672c\u5730\u67e5\u9605\u63a5\u53e3");
                            ZXCXE01QueryReports queryReports = new ZXCXE01QueryReports.Builder().withRqstTrnvrId("").withCrRfrncRprtNo(zxReportId).withBeQryPrsnNm("").withBeQryPrsnIdentTp("").withBeQryPrsnIdentNo("").withQryRsn("").withQryTp("").withQryFmt("").withRprtRsltSeg("").withRprtQryDt("").withCnlTp("843").build();
                            ZXVO zxvoJson = this.zxCXE01Service.Zxservice((Object)queryReports, params);
                            List zxHtmlInfoVOS = this.zxHtmlInfoService.queryAllZXHtmlReports(Arrays.asList(zxReportId));
                            if (null == zxHtmlInfoVOS || zxHtmlInfoVOS.isEmpty()) {
                                throw new BizException("\u8c03\u7528\u5f81\u4fe1\u7cfb\u7edf\u5f02\u5e38");
                            }
                            NlsCreditInfoVO pkParam = new NlsCreditInfoVO();
                            pkParam.setLmtApplySeq(creditAppSeq);
                            NlsCreditInfoVO nlsCreditInfo = this.nlsCreditInfoService.queryByPk(pkParam);
                            if (null == nlsCreditInfo) {
                                throw new Exception("\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e0d\u5b58\u5728");
                            }
                            CreditQueryDetailVO creditQueryDetailVO = new CreditQueryDetailVO();
                            creditQueryDetailVO.setSerno(UUID.randomUUID().toString().replace("-", ""));
                            creditQueryDetailVO.setCusId("");
                            creditQueryDetailVO.setCusName(nlsCreditInfo.getCusName());
                            creditQueryDetailVO.setCertType(nlsCreditInfo.getCertType());
                            creditQueryDetailVO.setCertCode(nlsCreditInfo.getCertCode());
                            creditQueryDetailVO.setTransactionCode(creditAppSeq);
                            creditQueryDetailVO.setPrdCode(nlsCreditInfo.getPrdCode());
                            creditQueryDetailVO.setPrdName(nlsCreditInfo.getPrdName());
                            creditQueryDetailVO.setReportId(zxReportId);
                            creditQueryDetailVO.setReportTime(TimeUtil.getCurrentDateTime());
                            creditQueryDetailVO.setRequestTime(TimeUtil.getCurrentDateTime());
                            creditQueryDetailVO.setZxOpId("admin");
                            creditQueryDetailVO.setInputBrId("");
                            creditQueryDetailVO.setFinaBrId("");
                            Optional.ofNullable(creditQueryDetailVO).ifPresent(Try.ofConsumer(arg_0 -> ((CreditQueryDetailService)this.creditQueryDetailService).insertCreditQueryDetailVO(arg_0)));
                        }
                        this.logger.info(loggerIDByZxId + "\u5904\u7406\u7ed3\u675f");
                    }
                    catch (Exception e) {
                        this.logger.error(loggerIDByZxId + e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                this.logger.info("\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_\u7b26\u5408\u6761\u4ef6\u7684\u6761\u6570\u4e3a0");
            }
            this.logger.info("\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(loggerID + e.getMessage(), (Throwable)e);
        }
        finally {
            this.logger.info("\u5904\u7406\u60e0e\u8d37\u5f81\u4fe1\u67e5\u8be2\u5e76\u843d\u8868_\u7ed3\u675f");
        }
        return false;
    }
}

