/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.hed.apply;

import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespServiceBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.service.facade.hed.apply.HedLoanReleaseService;
import com.irdstudio.efp.esb.service.facade.hed.req.HedLoanReleaseReqBean;
import com.irdstudio.efp.nls.service.facade.hed.HedApplyInfoService;
import com.irdstudio.efp.nls.service.vo.hed.HedApplyInfoVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="hedApplyInfoService")
public class HedApplyInfoServiceImpl
implements HedApplyInfoService {
    private Logger logger = LoggerFactory.getLogger(HedApplyInfoServiceImpl.class);
    @Autowired
    @Qualifier(value="hedLoanReleaseService")
    private HedLoanReleaseService hedLoanReleaseService;

    public Map<String, String> applyProcess(HedApplyInfoVO bean, String glblSrlNo) {
        try {
            this.logger.info("\u60e0e\u8d37\u7528\u4fe1\u7533\u8bf7\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\uff1a", (Object)glblSrlNo);
            HedLoanReleaseReqBean releaseReqBean = new HedLoanReleaseReqBean();
            releaseReqBean.setCustNo(bean.getCustNo());
            releaseReqBean.setPdTp(bean.getPdTp());
            releaseReqBean.setCcy(bean.getCcy());
            releaseReqBean.setLoanAmt(new BigDecimal(bean.getLoanAmt()));
            releaseReqBean.setTxnBrch(bean.getBrch());
            releaseReqBean.setAcctNm(bean.getAcctNm());
            releaseReqBean.setSetlmnAcctNo(bean.getSetlmnAcctNo());
            releaseReqBean.setOwnBnkOthrBnkFlg(StringUtils.isNotBlank((CharSequence)bean.getOwnBnkOthrBnkFlg()) ? bean.getOwnBnkOthrBnkFlg() : "1");
            releaseReqBean.setAcctClsf(StringUtils.isNotBlank((CharSequence)bean.getAcctClsf()) ? bean.getAcctClsf() : "02");
            EsbRespServiceBean esbRespServiceBean = this.hedLoanReleaseService.applyHjProcess(releaseReqBean, glblSrlNo);
            HashMap<String, String> map = new HashMap<String, String>();
            EsbRespSysHeadBean sysHead = esbRespServiceBean.getSysHead();
            String retCode = "";
            String retMsg = "";
            if (Objects.nonNull(sysHead)) {
                EsbRespRetInfBean esbRespRetInfBean = sysHead.getRetInfArry().stream().findFirst().orElseGet(EsbRespRetInfBean::new);
                retCode = Optional.ofNullable(esbRespRetInfBean.getRetCd()).orElse("");
                map.put("retCode", retCode);
                retMsg = Optional.ofNullable(esbRespRetInfBean.getRetMsg()).orElse("");
                map.put("retMsg", retMsg);
            }
            return map;
        }
        catch (Exception e) {
            this.logger.error("\u60e0e\u8d37\u652f\u7528\u7533\u8bf7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
            return new HashMap<String, String>();
        }
    }
}

