/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.hed.credit;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.HangException;
import com.irdstudio.basic.framework.core.threadpool.AbstractThreadTask;
import com.irdstudio.basic.framework.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.efp.console.common.PrdBizEnums;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.edoc.service.bo.OfficialInfoVO;
import com.irdstudio.efp.edoc.service.facade.OfficialInfoService;
import com.irdstudio.efp.esb.common.constant.InstitutionEnums;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.sx.HedCreditRiskApproveReq;
import com.irdstudio.efp.esb.service.bo.resp.sx.HedCreditRiskApproveResp;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(value="prototype")
@Service(value="hedCreditBizProcess")
public class HedCreditBizProcessImpl
extends AbstractThreadTask
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(HedCreditBizProcessImpl.class);
    private NlsCreditInfoVO nlsCreditInfoVO;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="officialInfoService")
    private OfficialInfoService officialInfoService;
    @Autowired
    @Qualifier(value="hedCreditRiskInvokService")
    private EsbService<HedCreditRiskApproveReq, HedCreditRiskApproveResp> hedCreditRiskInvokService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusReferrerInfoService")
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;

    public NlsCreditInfoVO getNlsCreditInfoVO() {
        return this.nlsCreditInfoVO;
    }

    public void setNlsCreditInfoVO(NlsCreditInfoVO nlsCreditInfoVO) {
        this.nlsCreditInfoVO = nlsCreditInfoVO;
    }

    public ExecuteRtnInfo call() throws Exception {
        this.doTask();
        return new ExecuteRtnInfo(null, null, null, null, true);
    }

    public void doTask() throws HangException, BizException, Exception {
        try {
            BigDecimal yedLmtAmt;
            String cusFlag;
            block17: {
                logger.info("*********************************************");
                logger.info("*            \u5f00\u59cb\u4e00\u7b14\u65b0\u7684\u6267\u884c\u961f\u5217                 * ");
                logger.info("*********************************************");
                logger.info("* \u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + this.nlsCreditInfoVO.getLmtApplySeq() + "\u3011*");
                logger.info("* \u5ba2\u6237\u7f16\u53f7 : \u3010" + this.nlsCreditInfoVO.getCusId() + "\u3011*");
                logger.info("* \u5ba2\u6237\u540d\u79f0 : \u3010" + this.nlsCreditInfoVO.getCusName() + "\u3011*");
                logger.info("* \u4ea7\u54c1ID:  \u3010" + this.nlsCreditInfoVO.getPrdId() + "\u3011*");
                logger.info("* \u4ea7\u54c1\u4ee3\u7801: \u3010" + this.nlsCreditInfoVO.getPrdCode() + "\u3011*");
                logger.info("* \u4ea7\u54c1\u540d\u79f0 : \u3010" + this.nlsCreditInfoVO.getPrdName() + "\u3011*");
                logger.info("* \u521b\u5efa\u65f6\u95f4 : \u3010" + this.nlsCreditInfoVO.getCreateTime() + "\u3011*");
                logger.info("*********************************************");
                String lmtApplySeq = this.nlsCreditInfoVO.getLmtApplySeq();
                cusFlag = "N";
                OfficialInfoVO queryVo = new OfficialInfoVO();
                queryVo.setIdentificationNo(this.nlsCreditInfoVO.getCertCode());
                OfficialInfoVO officialInfoVO = this.officialInfoService.queryByCertCode(queryVo);
                if (null != officialInfoVO) {
                    cusFlag = "Y";
                }
                BigDecimal lmtAmtA = BigDecimal.ZERO;
                BigDecimal lmtAmtB = BigDecimal.ZERO;
                BigDecimal lmtAmtC = BigDecimal.ZERO;
                BigDecimal lmtAmtD = BigDecimal.ZERO;
                NlsCreditInfoVO creditCondition = new NlsCreditInfoVO();
                creditCondition.setCertCode(this.nlsCreditInfoVO.getCertCode());
                creditCondition.setCertType(this.nlsCreditInfoVO.getCertType());
                creditCondition.setPrdCode(PrdBizEnums.PrdCodeEnum.PRD_CODE_YED.getValue());
                List nlsCreditInfoVOS = this.nlsCreditInfoService.queryAllByCondition(creditCondition);
                yedLmtAmt = BigDecimal.ZERO;
                try {
                    if (nlsCreditInfoVOS == null || nlsCreditInfoVOS.size() <= 0) break block17;
                    if (nlsCreditInfoVOS.size() == 1) {
                        for (NlsCreditInfoVO vo : nlsCreditInfoVOS) {
                            if (vo.getApprvSts().equals(MsLoanConstant.NlsApplyStateEnum.APPR.getVALUE())) {
                                lmtAmtA = vo.getApplyAmt();
                                continue;
                            }
                            if (!vo.getApprvSts().equals(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE())) continue;
                            LmtPrdContVO lmtPrdCont = this.getLmtPrdCont(vo.getLmtApplySeq());
                            if (lmtPrdCont != null && lmtPrdCont.getLmtStatus().equals("02")) {
                                lmtAmtB = lmtPrdCont.getLmtAmt();
                                lmtAmtB = this.getBigDecimal(lmtAmtB, vo);
                                continue;
                            }
                            if (lmtPrdCont == null || !lmtPrdCont.getLmtStatus().equals("03")) continue;
                            lmtAmtC = this.getBigDecimal(lmtAmtC, vo);
                        }
                    } else {
                        for (NlsCreditInfoVO vo : nlsCreditInfoVOS) {
                            if (vo.getApprvSts().equals(MsLoanConstant.NlsApplyStateEnum.APPR.getVALUE())) {
                                lmtAmtD = lmtAmtD.add(vo.getApplyAmt());
                                continue;
                            }
                            if (!vo.getApprvSts().equals(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE())) continue;
                            LmtPrdContVO lmtPrdCont = this.getLmtPrdCont(vo.getLmtApplySeq());
                            if (lmtPrdCont != null && lmtPrdCont.getLmtStatus().equals("02")) {
                                lmtAmtD = lmtAmtD.add(lmtPrdCont.getLmtAmt());
                                lmtAmtD = this.getBigDecimal(lmtAmtD, vo);
                                continue;
                            }
                            if (lmtPrdCont == null || !lmtPrdCont.getLmtStatus().equals("03")) continue;
                            lmtAmtD = this.getBigDecimal(lmtAmtD, vo);
                        }
                    }
                    if (lmtAmtA.compareTo(BigDecimal.ZERO) > 0 && lmtAmtA.compareTo(lmtAmtB) > 0 && lmtAmtA.compareTo(lmtAmtC) > 0 && lmtAmtA.compareTo(lmtAmtD) > 0) {
                        yedLmtAmt = lmtAmtA;
                    }
                    if (lmtAmtB.compareTo(BigDecimal.ZERO) > 0 && lmtAmtB.compareTo(lmtAmtA) > 0 && lmtAmtB.compareTo(lmtAmtC) > 0 && lmtAmtB.compareTo(lmtAmtD) > 0) {
                        yedLmtAmt = lmtAmtB;
                    }
                    if (lmtAmtC.compareTo(BigDecimal.ZERO) > 0 && lmtAmtC.compareTo(lmtAmtA) > 0 && lmtAmtC.compareTo(lmtAmtB) > 0 && lmtAmtC.compareTo(lmtAmtD) > 0) {
                        yedLmtAmt = lmtAmtC;
                    }
                    if (lmtAmtD.compareTo(BigDecimal.ZERO) > 0 && lmtAmtD.compareTo(lmtAmtA) > 0 && lmtAmtD.compareTo(lmtAmtC) > 0 && lmtAmtD.compareTo(lmtAmtB) > 0) {
                        yedLmtAmt = lmtAmtD;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
                }
            }
            this.callFkSp(this.nlsCreditInfoVO, cusFlag, yedLmtAmt);
        }
        catch (Exception e) {
            String lmtApplySeq = this.nlsCreditInfoVO.getLmtApplySeq();
            NlsCreditInfoVO nlsCredit = new NlsCreditInfoVO();
            nlsCredit.setLmtApplySeq(lmtApplySeq);
            nlsCredit.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.VALUE);
            nlsCredit.setRefuseCause("\u62d2\u7edd\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
            this.nlsCreditInfoService.updateByPk(nlsCredit);
            e.printStackTrace();
            logger.error("\u60e0e\u8d37\u6388\u4fe1\u7533\u8bf7\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)e.getMessage(), (Object)this.nlsCreditInfoVO.getLmtApplySeq());
        }
    }

    private LmtPrdContVO getLmtPrdCont(String lmtApplySeq) {
        return this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
    }

    private BigDecimal getBigDecimal(BigDecimal lmtAmtD, NlsCreditInfoVO vo) {
        NlsApplyInfoVO nlsApplyInfo = new NlsApplyInfoVO();
        nlsApplyInfo.setLmtApplySeq(vo.getLmtApplySeq());
        List nlsApplyInfoVOS = this.nlsApplyInfoService.queryListByLmtApplySqe(nlsApplyInfo);
        if (nlsApplyInfoVOS != null && nlsApplyInfoVOS.size() > 0) {
            for (NlsApplyInfoVO info : nlsApplyInfoVOS) {
                AccLoanVO accLoanVo = new AccLoanVO();
                accLoanVo.setApplySeq(info.getApplySeq());
                AccLoanVO accLoanVO = this.accLoanService.queryByApplySeq(accLoanVo);
                if (accLoanVO.getAccountStatus().equals("4")) continue;
                lmtAmtD = lmtAmtD.add(accLoanVO.getLoanBalance());
            }
        }
        return lmtAmtD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callFkSp(NlsCreditInfoVO nlsCreditInfoVO, String cusRed, BigDecimal lmtAmt) {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        logger.info("\u60e0e\u8d37\u6388\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8c03\u7528\u5f00\u59cb\u6267\u884c,\u6d41\u6c34\u53f7:" + applySeq);
        try {
            CusReferrerInfoVO cusReferrerInfo = new CusReferrerInfoVO();
            cusReferrerInfo.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            CusReferrerInfoVO cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusReferrerInfo);
            String certType = nlsCreditInfoVO.getCertType();
            String certCode = nlsCreditInfoVO.getCertCode();
            HedCreditRiskApproveReq credit = HedCreditRiskApproveReq.builder().Age(BigDecimal.valueOf(ValidationUtils.getAgeFromIdNumber((String)nlsCreditInfoVO.getCertCode()))).AppNo(nlsCreditInfoVO.getLmtApplySeq()).Crr(nlsCreditInfoVO.getProfession()).CrspAddr(nlsCreditInfoVO.getIndivRsdAddr()).DeptNo(InstitutionEnums.InstitutionEnum.ZHPHJRB.getCode()).Gnd(nlsCreditInfoVO.getGender()).IdenEfftDt(nlsCreditInfoVO.getCertEndDt()).IdentNo(certCode).IdentTp(certType).MblNo(nlsCreditInfoVO.getIndivMobile()).MrtlSt(nlsCreditInfoVO.getMrgSitu()).Name(nlsCreditInfoVO.getCusName()).Nation(nlsCreditInfoVO.getNational()).RsdcProvn(nlsCreditInfoVO.getIndivRsdAddr().substring(0, 7)).TlrNo(cusReferrerInfoVO.getMarkManager()).WhthrFlg(cusRed).NetwrkLoanOcptnLmt(lmtAmt).Nation(nlsCreditInfoVO.getNational()).PdNo(PrdBizEnums.PrdCodeEnum.PRD_CODE_HED.value).glblSrlNo(nlsCreditInfoVO.getGlobalSerno()).InstId(InstitutionEnums.InstitutionEnum.ZHPHJRB.getCode()).CnlTp("15").PlafmID(nlsCreditInfoVO.getPlatfmid()).PlafmUsrID(nlsCreditInfoVO.getPlatfmusrid()).build();
            try {
                this.hedCreditRiskInvokService.service((Object)credit);
                nlsCreditInfoVO.setSoltName("\u60e0e\u8d37\u6388\u4fe1\u9636\u6bb5\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3--\u5904\u7406\u4e2d");
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6388\u4fe1\u7533\u8bf7-\u98ce\u63a7\u5ba1\u6279\u5f02\u5e38\uff1a" + e.getMessage());
                nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.VALUE);
                nlsCreditInfoVO.setRefuseCause("\u6388\u4fe1\u7533\u8bf7-\u98ce\u63a7\u5ba1\u6279\u5f02\u5e38\uff1a" + e.getMessage().substring(0, 256));
                this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            logger.info("\u60e0e\u8d37\u6388\u4fe1\u98ce\u63a7\u5ba1\u6279\u63a5\u53e3\u8c03\u7528\u7ed3\u675f\uff0c\u6d41\u6c34\u53f7\uff1a" + nlsCreditInfoVO.getLmtApplySeq());
        }
    }
}

