/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.hed.credit;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.nls.common.util.NlsStringUtil;
import com.irdstudio.efp.nls.service.facade.bean.HedCreditRiskApproveNoticeReqBean;
import com.irdstudio.efp.nls.service.facade.hed.HedCreditRiskApproveService;
import com.irdstudio.efp.nls.service.facade.psd.NlsCreditApprovalInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.vo.psd.NlsCreditApprovalInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="hedCreditRiskApproveService")
public class HedCreditRiskApproveServiceImpl
implements HedCreditRiskApproveService {
    private static Logger logger = LoggerFactory.getLogger(HedCreditRiskApproveServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsCreditApprovalInfoService")
    private NlsCreditApprovalInfoService nlsCreditApprovalInfoService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;

    public boolean bizProcess(HedCreditRiskApproveNoticeReqBean hedCreditRisk, String cnlTp) throws Exception {
        try {
            logger.info("\u60e0e\u8d37\u98ce\u63a7\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u7c7b,\u5168\u5c40\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)hedCreditRisk.getCrAppSrlNo());
            NlsCreditInfoVO selectCreditInfo = this.nlsCreditInfoService.queryByLmtApplySeq(hedCreditRisk.getCrAppSrlNo());
            if (selectCreditInfo == null) {
                logger.error("\u60e0e\u8d37\u6388\u4fe1\u901a\u77e5 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + hedCreditRisk.getCrAppSrlNo() + "\u3011 \u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f!");
                throw new ESBException(EsbRetCodeStandard.YWLJCLYC.getValue(), hedCreditRisk.getCrAppSrlNo() + " \u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f!");
            }
            if (MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE().equals(selectCreditInfo.getApprvSts()) || MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE().equals(selectCreditInfo.getApprvSts()) || MsLoanConstant.NlsApplyStateEnum.CANCEL.getVALUE().equals(selectCreditInfo.getApprvSts()) || MsLoanConstant.NlsApplyStateEnum.REVOKED.getVALUE().equals(selectCreditInfo.getApprvSts())) {
                logger.error("\u60e0e\u8d37\u6388\u4fe1\u901a\u77e5 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + hedCreditRisk.getCrAppSrlNo() + "\u3011 \u8be5\u6388\u4fe1\u7533\u8bf7\u5df2\u6536\u5230\u5ba1\u6279\u901a\u77e5\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u9001!");
                throw new ESBException(EsbRetCodeStandard.YWLJCLYC.getValue(), hedCreditRisk.getCrAppSrlNo() + " \u8be5\u6388\u4fe1\u7533\u8bf7\u5df2\u6536\u5230\u5ba1\u6279\u901a\u77e5\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u9001!");
            }
            selectCreditInfo.setLastUpdateTime(DateUtility.getCurrAppDateTimeString());
            selectCreditInfo.setApprvDate(DateUtility.getCurrDate());
            selectCreditInfo.setWrkCorpNm(hedCreditRisk.getWrkCorpNm());
            selectCreditInfo.setSoltName("\u60e0e\u8d37\u6388\u4fe1\u7533\u8bf7\u7ed3\u679c\u901a\u77e5--\u56de\u8c03\u6210\u529f");
            if (!this.isApproveAccess(hedCreditRisk)) {
                selectCreditInfo.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
                if (this.isApproveFailure(hedCreditRisk)) {
                    selectCreditInfo.setRefuseCause(NlsStringUtil.toShorterString((String)(hedCreditRisk.getRfsCd() + "|" + hedCreditRisk.getRfsRsn()), (int)500));
                } else if (this.isApproveException(hedCreditRisk)) {
                    selectCreditInfo.setRefuseCause(NlsStringUtil.toShorterString((String)("\u98ce\u63a7\u7cfb\u7edf\u6388\u4fe1\u5ba1\u6279\u5f02\u5e38:" + hedCreditRisk.getRfsCd() + "|" + hedCreditRisk.getRfsRsn()), (int)500));
                }
                this.insertCreditApproveInfo(hedCreditRisk, selectCreditInfo);
                this.updateCreditInfo(selectCreditInfo);
            } else {
                selectCreditInfo.setApproveAmt(new BigDecimal(hedCreditRisk.getCrRcmndnAmt()));
                selectCreditInfo.setApplyAmt(new BigDecimal(hedCreditRisk.getCrRcmndnAmt()));
                selectCreditInfo.setApproveRateY(new BigDecimal(hedCreditRisk.getAnulIntRt()));
                selectCreditInfo.setCustTp(hedCreditRisk.getCustTp());
                selectCreditInfo.setIndvMnthIncm("".equals(hedCreditRisk.getIndvMnthIncm()) || hedCreditRisk.getIndvMnthIncm() == null ? 0.0 : Double.parseDouble(hedCreditRisk.getIndvMnthIncm()));
                selectCreditInfo.setAssureMeansMain("00");
                selectCreditInfo.setTermType("M");
                this.insertCreditApproveInfo(hedCreditRisk, selectCreditInfo);
                this.sendMessageIfApproveAccess(selectCreditInfo);
            }
            return true;
        }
        catch (ESBException e) {
            logger.error("\u60e0e\u8d37\u6388\u4fe1\u7533\u8bf7\u5f02\u5e38,\u6d41\u6c34\u53f7\uff1a" + hedCreditRisk.getCrAppSrlNo() + "\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            NlsCreditInfoVO selectCreditInfo = this.nlsCreditInfoService.queryByLmtApplySeq(hedCreditRisk.getCrAppSrlNo());
            selectCreditInfo.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
            selectCreditInfo.setRefuseCause(e.getMessage().length() > 50 ? e.getMessage().substring(0, 49) : e.getMessage());
            this.updateCreditInfo(selectCreditInfo);
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u60e0e\u8d37\u98ce\u63a7\u5ba1\u6279\u901a\u77e5\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + NlsStringUtil.toShorterString((String)e.getMessage(), (int)50));
        }
        catch (BizException e) {
            logger.error("\u60e0e\u8d37\u6388\u4fe1\u7533\u8bf7\u5f02\u5e38,\u6d41\u6c34\u53f7\uff1a" + hedCreditRisk.getCrAppSrlNo() + "\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            NlsCreditInfoVO selectCreditInfo = this.nlsCreditInfoService.queryByLmtApplySeq(hedCreditRisk.getCrAppSrlNo());
            selectCreditInfo.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
            selectCreditInfo.setRefuseCause(e.getMessage().length() > 50 ? e.getMessage().substring(0, 49) : e.getMessage());
            this.updateCreditInfo(selectCreditInfo);
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u60e0e\u8d37\u98ce\u63a7\u5ba1\u6279\u901a\u77e5\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + NlsStringUtil.toShorterString((String)e.getMessage(), (int)50));
        }
        catch (Exception e) {
            NlsCreditInfoVO selectCreditInfo = this.nlsCreditInfoService.queryByLmtApplySeq(hedCreditRisk.getCrAppSrlNo());
            selectCreditInfo.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.getVALUE());
            selectCreditInfo.setRefuseCause(e.getMessage().length() > 50 ? e.getMessage().substring(0, 49) : e.getMessage());
            this.updateCreditInfo(selectCreditInfo);
            e.printStackTrace();
            logger.error("\u60e0e\u8d37\u6388\u4fe1\u98ce\u63a7\u56de\u8c03\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            logger.error("\u60e0e\u8d37\u6388\u4fe1\u7533\u8bf7\u5f02\u5e38,\u6d41\u6c34\u53f7\uff1a" + hedCreditRisk.getCrAppSrlNo() + "\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u60e0e\u8d37\u98ce\u63a7\u5ba1\u6279\u901a\u77e5\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + NlsStringUtil.toShorterString((String)e.getMessage(), (int)50));
        }
    }

    private boolean isApproveAccess(HedCreditRiskApproveNoticeReqBean hedCreditRiskApproveNoticeReqBean) {
        return "Y".equals(hedCreditRiskApproveNoticeReqBean.getAprvlRsltFlg().trim());
    }

    private boolean isApproveException(HedCreditRiskApproveNoticeReqBean hedCreditRiskApproveNoticeReqBean) {
        return "E".equals(hedCreditRiskApproveNoticeReqBean.getAprvlRsltFlg().trim());
    }

    private boolean isApproveFailure(HedCreditRiskApproveNoticeReqBean hedCreditRiskApproveNoticeReqBean) {
        return "N".equals(hedCreditRiskApproveNoticeReqBean.getAprvlRsltFlg().trim());
    }

    private void insertCreditApproveInfo(HedCreditRiskApproveNoticeReqBean hedCreditRiskApproveNoticeReqBean, NlsCreditInfoVO selectCreditInfo) throws BizException {
        int result;
        NlsCreditApprovalInfoVO nlsCreditInfoApprovalVO = new NlsCreditApprovalInfoVO();
        nlsCreditInfoApprovalVO.setLmtApplySeq(selectCreditInfo.getLmtApplySeq());
        nlsCreditInfoApprovalVO.setGlobalSerno(selectCreditInfo.getGlobalSerno());
        nlsCreditInfoApprovalVO.setApprResult(hedCreditRiskApproveNoticeReqBean.getAprvlRsltFlg());
        nlsCreditInfoApprovalVO.setApproveTime(new Date());
        nlsCreditInfoApprovalVO.setApplyRateY(new BigDecimal(hedCreditRiskApproveNoticeReqBean.getAnulIntRt()));
        nlsCreditInfoApprovalVO.setApproveTermType(hedCreditRiskApproveNoticeReqBean.getLoanTrmType());
        nlsCreditInfoApprovalVO.setCreateTime(new Date());
        nlsCreditInfoApprovalVO.setCreateUser("admin");
        nlsCreditInfoApprovalVO.setLastUpdateUser("admin");
        nlsCreditInfoApprovalVO.setLastUpdateTime(new Date());
        nlsCreditInfoApprovalVO.setMaxAmt(new BigDecimal(hedCreditRiskApproveNoticeReqBean.getMaxAmt()));
        if (!this.isApproveAccess(hedCreditRiskApproveNoticeReqBean)) {
            nlsCreditInfoApprovalVO.setRefuseCode(hedCreditRiskApproveNoticeReqBean.getRfsCd());
            nlsCreditInfoApprovalVO.setRefuseMsg(hedCreditRiskApproveNoticeReqBean.getRfsRsn());
        }
        if ((result = this.nlsCreditApprovalInfoService.insert(nlsCreditInfoApprovalVO)) != 1) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u60e0e\u8d37\u66f4\u65b0\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void updateCreditInfo(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result != 1) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u60e0e\u8d37\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void sendMessageIfApproveAccess(NlsCreditInfoVO nlsCreditInfoVO) throws UnsupportedEncodingException {
        String messageKey = TopicEnums.HED_CREDIT_CUSINDIV_TOPIC.getTopicId() + "_" + TagEnums.HED_CREDIT_CUSINDIV_TASK.getTagId() + "_" + nlsCreditInfoVO.getLmtApplySeq();
        this.producerService.sendMsg(new Message(TopicEnums.HED_CREDIT_CUSINDIV_TOPIC.getTopicId(), TagEnums.HED_CREDIT_CUSINDIV_TASK.getTagId(), nlsCreditInfoVO.getLmtApplySeq() + "-1", JSON.toJSONString((Object)nlsCreditInfoVO).getBytes("UTF-8")), messageKey);
    }
}

