/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.hed.credit;

import com.gdrcu.efp.cus.common.CusBankRelEnum;
import com.gdrcu.efp.cus.common.CusStatusEnum;
import com.gdrcu.efp.cus.common.CusTypeEnum;
import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.exception.HangException;
import com.irdstudio.basic.framework.core.threadpool.AbstractThreadTask;
import com.irdstudio.basic.framework.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.facade.PrdInfoService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.cus.service.facade.CusIndivExtService;
import com.irdstudio.efp.cus.service.facade.CusIndivRelService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.facade.CusReferrerInfoService;
import com.irdstudio.efp.cus.service.vo.CusIndivExtVO;
import com.irdstudio.efp.cus.service.vo.CusIndivRelVO;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.cus.service.vo.CusReferrerInfoVO;
import com.irdstudio.efp.edoc.service.bo.OfficialInfoVO;
import com.irdstudio.efp.edoc.service.facade.OfficialInfoService;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.ecif.CusDetialInfoQueryReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.MaintainEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.TrdPtyCustInfArryBean;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailIdInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailTelInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetialInfoQueryResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.MaintainEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PriMtEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PrivateCreateThirdCusResp;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.ecif.CusDetailInfoQueryService;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.limit.service.facade.ManualReviewAppService;
import com.irdstudio.efp.limit.service.vo.ManualReviewAppVO;
import com.irdstudio.efp.nls.common.util.NlsStringUtil;
import com.irdstudio.efp.nls.service.facade.CusCreateCommonService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoExdService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.ZydEcifThirdCusService;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoExdVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(value="prototype")
@Service(value="hedCusIndivBizProcess")
public class HedCusIndivProcessImpl
extends AbstractThreadTask
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(HedCusIndivProcessImpl.class);
    private NlsCreditInfoVO nlsCreditInfoVO;
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"CREL$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final PatternDescriptor CUS_PATTERN = DefaultPatternDescriptor.of((String)"$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    private static final String HEAD = "head";
    private static final String BODY = "body";
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsCreditInfoExdService")
    private NlsCreditInfoExdService nlsCreditInfoExdService;
    @Autowired
    private ZydEcifThirdCusService zydEcifThirdCusService;
    @Autowired
    @Qualifier(value="officialInfoService")
    private OfficialInfoService officialInfoService;
    @Autowired
    @Qualifier(value="prdInfoService")
    private PrdInfoService prdInfoService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusReferrerInfoService")
    private CusReferrerInfoService cusReferrerInfoService;
    @Autowired
    @Qualifier(value="manualReviewAppService")
    private ManualReviewAppService manualReviewAppService;
    @Autowired
    @Qualifier(value="cusIndivRelService")
    private CusIndivRelService cusIndivRelService;
    @Autowired
    private PatternedLimitableSeqService sequenceService;
    @Autowired
    @Qualifier(value="cusIndivExtService")
    private CusIndivExtService cusIndivExtService;
    @Autowired
    @Qualifier(value="cusDetailInfoQueryService")
    private CusDetailInfoQueryService cusDetailInfoQueryService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="maintainEcifThirdCusService")
    private EsbService<MaintainEcifThirdCusReq, MaintainEcifThirdCusResp> maintainEcifThirdCusService;
    @Autowired
    @Qualifier(value="cusCreateCommonService")
    private CusCreateCommonService cusCreateCommonService;

    public NlsCreditInfoVO getNlsCreditInfoVO() {
        return this.nlsCreditInfoVO;
    }

    public void setNlsCreditInfoVO(NlsCreditInfoVO nlsCreditInfoVO) {
        this.nlsCreditInfoVO = nlsCreditInfoVO;
    }

    public ExecuteRtnInfo call() throws Exception {
        this.doTask();
        return new ExecuteRtnInfo(null, null, null, null, true);
    }

    public void doTask() throws HangException, BizException, Exception {
        try {
            logger.info("*********************************************");
            logger.info("*            \u5f00\u59cb\u4e00\u7b14\u65b0\u7684\u6267\u884c\u961f\u5217                 * ");
            logger.info("*********************************************");
            logger.info("* \u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + this.nlsCreditInfoVO.getLmtApplySeq() + "\u3011*");
            logger.info("* \u5ba2\u6237\u7f16\u53f7 : \u3010" + this.nlsCreditInfoVO.getCusId() + "\u3011*");
            logger.info("* \u5ba2\u6237\u540d\u79f0 : \u3010" + this.nlsCreditInfoVO.getCusName() + "\u3011*");
            logger.info("* \u4ea7\u54c1ID:  \u3010" + this.nlsCreditInfoVO.getPrdId() + "\u3011*");
            logger.info("* \u4ea7\u54c1\u4ee3\u7801: \u3010" + this.nlsCreditInfoVO.getPrdCode() + "\u3011*");
            logger.info("* \u4ea7\u54c1\u540d\u79f0 : \u3010" + this.nlsCreditInfoVO.getPrdName() + "\u3011*");
            logger.info("* \u521b\u5efa\u65f6\u95f4 : \u3010" + this.nlsCreditInfoVO.getCreateTime() + "\u3011*");
            logger.info("*********************************************");
            String globalSerno = this.nlsCreditInfoVO.getGlobalSerno();
            this.createCusIndivInfo(this.nlsCreditInfoVO);
            this.nlsCreditInfoVO.setApprvSts(MsLoanConstant.NlsApplyStateEnum.PASS.getVALUE());
            this.updateCreditInfo(this.nlsCreditInfoVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            String lmtApplySeq = this.nlsCreditInfoVO.getLmtApplySeq();
            NlsCreditInfoVO nlsCredit = new NlsCreditInfoVO();
            nlsCredit.setLmtApplySeq(lmtApplySeq);
            nlsCredit.setApprvSts(MsLoanConstant.NlsApplyStateEnum.REJECT.VALUE);
            nlsCredit.setRefuseCause("\u62d2\u7edd\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
            this.nlsCreditInfoService.updateByPk(nlsCredit);
            logger.error("\u60e0e\u8d37\u6388\u4fe1\u7533\u8bf7\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)e.getMessage(), (Object)this.nlsCreditInfoVO.getLmtApplySeq());
        }
    }

    private void createCusIndivInfo(NlsCreditInfoVO selectCreditInfo) throws Exception {
        ManualReviewAppVO manualReviewAppVO;
        String cusId = "";
        PriMtEcifThirdCusResp priMtEcifThirdCusResp = new PriMtEcifThirdCusResp();
        NlsCreditInfoExdVO pojo = new NlsCreditInfoExdVO();
        pojo.setLmtApplySeq(selectCreditInfo.getLmtApplySeq());
        NlsCreditInfoExdVO nlsCreditInfoExdVO = this.nlsCreditInfoExdService.queryByPk(pojo);
        selectCreditInfo.setRetCode(nlsCreditInfoExdVO.getRetCode());
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("estblshDt", this.nlsCreditInfoVO.getCreateTime());
        paramsMap.put("sstblshBrch", this.nlsCreditInfoVO.getNlsOperOrgid());
        paramsMap.put("certCode", this.nlsCreditInfoVO.getCertCode());
        paramsMap.put("certType", this.nlsCreditInfoVO.getCertType());
        Map resultMap = this.cusCreateCommonService.getPrivateEstblshDtAndSstblshBrch(paramsMap);
        logger.info(this.nlsCreditInfoVO.getLmtApplySeq() + "\u67e5\u8be2\u5230\u7684\u5f00\u6237\u4fe1\u606f:{}", (Object)resultMap);
        String estblshDt = (String)resultMap.get("estblshDt");
        String sstblshBrch = (String)resultMap.get("sstblshBrch");
        CusReferrerInfoVO cusReferrerInfo = this.getCusReferrerInfo(selectCreditInfo);
        CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(selectCreditInfo.getCusName(), selectCreditInfo.getCertCode());
        String usrID = "";
        boolean cusIndivExsit = true;
        if (Objects.isNull(cusDetialInfoQueryResp) || StringUtil.isNullorBank((String)cusDetialInfoQueryResp.getCustNo())) {
            logger.info("\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + selectCreditInfo.getLmtApplySeq() + "\u67e5\u8be2ecif\u4e0d\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237\uff0c\u524d\u5f80ecif\u5ba2\u6237\u5efa\u6863");
            Map<String, Object> map = this.zydEcifThirdCusService.privateCreateFn(selectCreditInfo, nlsCreditInfoExdVO, "");
            usrID = this.checkCreateThirdCusResp(map, selectCreditInfo);
        } else {
            logger.info("\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + selectCreditInfo.getLmtApplySeq() + "ecif\u5df2\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237\uff0c\u524d\u5f80ecif\u5ba2\u6237\u4fe1\u606f\u7ef4\u62a4");
            String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
            String telCode = "";
            List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
            if (Objects.nonNull(telInfArry)) {
                for (CusDetailTelInfArray item : telInfArry) {
                    if (!item.getAtchSys1().equals("2003000")) continue;
                    telCode = item.getTelId();
                }
            } else {
                telCode = "";
            }
            priMtEcifThirdCusResp = this.zydEcifThirdCusService.PriMtEcifThirdCusFn(selectCreditInfo, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
            usrID = priMtEcifThirdCusResp.getCustNo();
        }
        CusIndivVO queryCusIndiv = new CusIndivVO();
        queryCusIndiv.setCertType(selectCreditInfo.getCertType());
        queryCusIndiv.setCertCode(selectCreditInfo.getCertCode());
        queryCusIndiv = this.cusIndivService.getCusInvoByCertCode(queryCusIndiv);
        if (Objects.isNull(queryCusIndiv)) {
            cusIndivExsit = false;
        }
        String prdId = Objects.requireNonNull(selectCreditInfo.getPrdId());
        PrdInfoVO prdInfoVo = new PrdInfoVO();
        prdInfoVo.setPrdId(prdId);
        prdInfoVo = this.prdInfoService.queryByPk(prdInfoVo);
        String dateString = LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE);
        String dateTimeString = LocalDateTime.now().format(timeStrFormatter);
        String createUser = "admin";
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusName(selectCreditInfo.getCusName());
        cusIndivVO.setIndivSex(selectCreditInfo.getGender());
        cusIndivVO.setCertType(selectCreditInfo.getCertType());
        cusIndivVO.setCertCode(selectCreditInfo.getCertCode());
        cusIndivVO.setPhone(selectCreditInfo.getIndivMobile());
        cusIndivVO.setCusType(CusTypeEnum.NATURAL_MAN.getCode());
        cusIndivVO.setCusBankRel(CusBankRelEnum.NORMAL.getCode());
        cusIndivVO.setIndivHouhRegAdd(selectCreditInfo.getCertAddr());
        cusIndivVO.setCusStatus(CusStatusEnum.OFFICIAL.getCode());
        cusIndivVO.setIndivNtn(selectCreditInfo.getEthnic());
        cusIndivVO.setIndivCountry(selectCreditInfo.getNational());
        if (Objects.nonNull(selectCreditInfo.getIndvMnthIncm())) {
            cusIndivVO.setIndivAnnIncm(new BigDecimal(selectCreditInfo.getIndvMnthIncm()).setScale(2, 4));
            cusIndivVO.setFamilyMincm(new BigDecimal(selectCreditInfo.getIndvMnthIncm()).setScale(2, 4));
        }
        BigDecimal annualIncome = new BigDecimal(0);
        annualIncome = StringUtil.isNullorBank((String)selectCreditInfo.getCustTp()) ? ((manualReviewAppVO = this.manualReviewAppService.queryByLmtSeq(selectCreditInfo.getLmtApplySeq())).getCustTp().equals("Y") ? manualReviewAppVO.getIndvMnthIncm().multiply(new BigDecimal(12)) : selectCreditInfo.getApproveAmt().multiply(new BigDecimal(12)).divide(new BigDecimal(14), 2, 4)) : (selectCreditInfo.getCustTp().equals("Y") ? new BigDecimal(selectCreditInfo.getIndvMnthIncm() * 12.0) : selectCreditInfo.getApproveAmt().multiply(new BigDecimal(12)).divide(new BigDecimal(14), 2, 4));
        cusIndivVO.setPerAnnualIncome(annualIncome);
        cusIndivVO.setFamAnnualIncome(annualIncome);
        cusIndivVO.setIndivEdt(selectCreditInfo.getEdu());
        cusIndivVO.setIndivDgr(nlsCreditInfoExdVO.getIndivDgr());
        cusIndivVO.setIndivRsdSt(nlsCreditInfoExdVO.getIndivRsdSt());
        cusIndivVO.setIndivComName(selectCreditInfo.getWrkCorpNm());
        cusIndivVO.setIndivComAddr(selectCreditInfo.getWrkCorpAddr());
        cusIndivVO.setIndivSpsName(selectCreditInfo.getSpsNm());
        cusIndivVO.setIndivCrtfctn(selectCreditInfo.getTtl());
        cusIndivVO.setIndivOcc(selectCreditInfo.getProfession());
        cusIndivVO.setIndivComJobTtl(selectCreditInfo.getIndivComJobTtl());
        cusIndivVO.setIndivHouhRegAdd(selectCreditInfo.getCertAddr());
        cusIndivVO.setIndivRsdAddr(selectCreditInfo.getIndivRsdAddr());
        cusIndivVO.setFamilyAddr(selectCreditInfo.getIndivRsdAddr());
        cusIndivVO.setPostAddr(selectCreditInfo.getIndivRsdAddr());
        cusIndivVO.setIndivIdExpDt(selectCreditInfo.getCertEndDt().replaceAll("-", ""));
        cusIndivVO.setIndivMarSt(selectCreditInfo.getMrgSitu());
        cusIndivVO.setIndivDtOfBirth(ValidationUtils.getBirthdayFromIdNumber((String)selectCreditInfo.getCertCode()));
        cusIndivVO.setIndivZipCode(selectCreditInfo.getPostCode());
        cusIndivVO.setPostCode(selectCreditInfo.getPostCode());
        cusIndivVO.setIndivComFld(selectCreditInfo.getIndivComFld());
        cusIndivVO.setInputId("admin");
        if (Objects.nonNull(cusReferrerInfo)) {
            cusIndivVO.setCusManager(cusReferrerInfo.getReferrerId());
            cusIndivVO.setMainBrId(cusReferrerInfo.getMainBrId());
            cusIndivVO.setPerformanceOwner(cusReferrerInfo.getReferrerId());
            cusIndivVO.setPerformanceOrg(cusReferrerInfo.getMainBrId());
            selectCreditInfo.setNlsOperUserid(cusReferrerInfo.getReferrerId());
            selectCreditInfo.setNlsOperOrgid(cusReferrerInfo.getMainBrId());
            selectCreditInfo.setNlsOperOrgid(cusReferrerInfo.getMainBrId());
        }
        cusIndivVO.setLastUpdateTime(dateTimeString);
        cusIndivVO.setLastUpdateUser("admin");
        cusIndivVO.setIndivCountry(selectCreditInfo.getNational());
        CusIndivRelVO cusIndivRelVO = new CusIndivRelVO();
        cusIndivRelVO.setRelName(nlsCreditInfoExdVO.getEmergencyContactName());
        cusIndivRelVO.setRelation(nlsCreditInfoExdVO.getEmergencyContactRelate());
        cusIndivRelVO.setMobile(nlsCreditInfoExdVO.getEmergencyContactPhone());
        cusIndivRelVO.setLastUpdateTime(dateTimeString);
        CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
        if (cusIndivExsit) {
            if (StringUtils.isNotBlank((CharSequence)queryCusIndiv.getInnerCusId())) {
                this.sendCusIndivToEcif(selectCreditInfo, queryCusIndiv, estblshDt, sstblshBrch);
            }
            if (StringUtils.isNotBlank((CharSequence)usrID)) {
                cusIndivVO.setSelfCusId(usrID);
            }
            cusId = queryCusIndiv.getCusId();
            cusIndivVO.setCusId(cusId);
            cusIndivRelVO.setCusId(cusId);
            int num1 = this.cusIndivService.updateByPk(cusIndivVO);
            selectCreditInfo.setCusId(cusId);
            this.nlsCreditInfoService.updateByPk(selectCreditInfo);
            List cusIndivRelVOs = Optional.ofNullable(this.cusIndivRelService.queryByPkCusId(cusIndivRelVO)).orElseGet(ArrayList::new);
            String relSerno = "";
            if (cusIndivRelVOs.size() > 0) {
                boolean cusRelExits = Boolean.TRUE;
                for (CusIndivRelVO cus : cusIndivRelVOs) {
                    if (!cus.getRelName().equals(nlsCreditInfoExdVO.getEmergencyContactName())) continue;
                    cusIndivRelVO.setRelSerno(cus.getRelSerno());
                    this.cusIndivRelService.updateByPk(cusIndivRelVO);
                    cusRelExits = Boolean.FALSE;
                    break;
                }
                if (cusRelExits) {
                    try {
                        relSerno = this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN);
                    }
                    catch (Exception e) {
                        throw new BizException("\u5173\u7cfb\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
                    }
                    cusIndivRelVO.setRelSerno(relSerno);
                    cusIndivRelVO.setCreateTime(dateTimeString);
                    this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
                }
            } else {
                try {
                    relSerno = this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN);
                }
                catch (Exception e) {
                    throw new BizException("\u5173\u7cfb\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25");
                }
                cusIndivRelVO.setRelSerno(relSerno);
                cusIndivRelVO.setCreateTime(dateTimeString);
                cusIndivRelVO.setLastUpdateTime(dateTimeString);
                this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
            }
            cusIndivExtVO.setCusId(cusId);
            CusIndivExtVO cusIndivExtVO1 = this.cusIndivExtService.queryByPk(cusIndivExtVO);
            cusIndivExtVO1.setIndivComJobTtlLvl(StringUtil.replaceNullByObj((Object)nlsCreditInfoExdVO.getPosLvl()));
            cusIndivExtVO1.setSvcWrkMos(StringUtil.replaceNullByObj((Object)nlsCreditInfoExdVO.getSvcWrkMos()));
            cusIndivExtVO1.setIndivOccSt(StringUtil.replaceNullByObj((Object)nlsCreditInfoExdVO.getWorkSt()));
            if ("01".equals(cusIndivExtVO1.getCusType())) {
                cusIndivExtVO1.setCusType("0102");
            }
            cusIndivExtVO1.setOnlineVerfStatus(nlsCreditInfoExdVO.getOnlineVerfStatus());
            cusIndivExtVO1.setRetCode(nlsCreditInfoExdVO.getRetCode());
            cusIndivExtVO1.setLastUpdateUser("admin");
            cusIndivExtVO1.setLastUpdateTime(dateTimeString);
            String redCus = "N";
            OfficialInfoVO queryVo = new OfficialInfoVO();
            queryVo.setIdentificationNo(selectCreditInfo.getCertCode());
            OfficialInfoVO officialInfoVO = this.officialInfoService.queryByCertCode(queryVo);
            if (null != officialInfoVO) {
                redCus = "Y";
            }
            cusIndivExtVO1.setRedCus(redCus);
            int num2 = this.cusIndivExtService.updateByPk(cusIndivExtVO1);
            if (num2 == -1) {
                throw new BizException("\u5ba2\u6237\u62d3\u5c55\u8868\u66f4\u65b0\u5f02\u5e38!!");
            }
            if (num1 == -1) {
                throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u66f4\u65b0\u5f02\u5e38!");
            }
        } else {
            cusId = this.sequenceService.getPatternedSequence("CUS_ID", CUS_PATTERN);
            cusIndivVO.setMainBrId(StringUtil.isNullorBank((String)cusReferrerInfo.getMainBrId()) ? prdInfoVo.getDefaultManageOrg() : cusReferrerInfo.getMainBrId());
            cusIndivVO.setCusId(cusId);
            cusIndivVO.setSelfCusId(usrID);
            cusIndivVO.setComInitLoanDate(dateString);
            cusIndivVO.setInputDate(dateString);
            cusIndivVO.setCreateTime(dateTimeString);
            cusIndivVO.setFstAppChannel(selectCreditInfo.getChannelNo());
            int num2 = this.cusIndivService.insertCusIndiv(cusIndivVO);
            selectCreditInfo.setCusId(cusId);
            cusIndivExtVO.setCusId(cusId);
            cusIndivExtVO.setCusType("02");
            cusIndivExtVO.setOnlineVerfStatus(nlsCreditInfoExdVO.getOnlineVerfStatus());
            cusIndivExtVO.setRetCode(nlsCreditInfoExdVO.getRetCode());
            cusIndivExtVO.setIndivComJobTtlLvl(nlsCreditInfoExdVO.getPosLvl());
            cusIndivExtVO.setSvcWrkMos(nlsCreditInfoExdVO.getSvcWrkMos());
            cusIndivExtVO.setIndivOccSt(nlsCreditInfoExdVO.getWorkSt());
            cusIndivExtVO.setCreateUser("admin");
            cusIndivExtVO.setCreateTime(dateTimeString);
            cusIndivExtVO.setLastUpdateUser("admin");
            cusIndivExtVO.setLastUpdateTime(dateTimeString);
            String redCus = "N";
            OfficialInfoVO queryVo = new OfficialInfoVO();
            queryVo.setIdentificationNo(selectCreditInfo.getCertCode());
            OfficialInfoVO officialInfoVO = this.officialInfoService.queryByCertCode(queryVo);
            if (null != officialInfoVO) {
                redCus = "Y";
            }
            cusIndivExtVO.setRedCus(redCus);
            int num4 = this.cusIndivExtService.insert(cusIndivExtVO);
            this.nlsCreditInfoService.updateByPk(selectCreditInfo);
            cusIndivRelVO.setCusId(cusId);
            cusIndivRelVO.setRelSerno(this.sequenceService.getPatternedSequence("CUS_REL_SERNO", PATTERN));
            cusIndivRelVO.setCreateTime(dateTimeString);
            int num3 = this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
            if (num2 == -1 || num3 == -1 || num4 == -1) {
                throw new BizException("\u5ba2\u6237\u6570\u636e\u8868\u589e\u52a0\u5f02\u5e38!");
            }
        }
    }

    private void updateCreditInfo(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result != 1) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u60e0e\u8d37\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private CusReferrerInfoVO getCusReferrerInfo(NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        CusReferrerInfoVO cusVo = new CusReferrerInfoVO();
        cusVo.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        CusReferrerInfoVO cusReferrerInfoVO = this.cusReferrerInfoService.queryChargeoffBrIdByPk(cusVo);
        return cusReferrerInfoVO;
    }

    public CusDetialInfoQueryResp queryECIFInfo(String cusName, String idNo) throws Exception {
        CusDetialInfoQueryReq cusDetialInfoQueryReq = new CusDetialInfoQueryReq();
        cusDetialInfoQueryReq.setIdntfMd("1");
        cusDetialInfoQueryReq.setCustNm(cusName);
        cusDetialInfoQueryReq.setIdentNo(idNo);
        CusDetialInfoQueryResp resp = null;
        try {
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.cusDetailInfoQueryService, (Object)cusDetialInfoQueryReq, this.nlsQueueSoltComnService);
            resp = (CusDetialInfoQueryResp)esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            logger.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        return resp;
    }

    public String checkCreateThirdCusResp(Map<String, Object> map, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        EsbRespSysHeadBean respSysHeadBean = (EsbRespSysHeadBean)map.get(HEAD);
        PrivateCreateThirdCusResp privateCreateThirdCusResp = (PrivateCreateThirdCusResp)map.get(BODY);
        String usrID = privateCreateThirdCusResp.getCustNo();
        if (StringUtils.equals((CharSequence)((EsbRespRetInfBean)respSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"3036000|210006")) {
            logger.info("\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + nlsCreditInfoVO.getLmtApplySeq() + "\u77ed\u65f6\u95f4\u5e76\u53d1\u5bfc\u81f4ecif\u5df2\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237,\u524d\u5f80ecif\u66f4\u65b0\uff01");
            CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(nlsCreditInfoVO.getCusName(), nlsCreditInfoVO.getCertCode());
            String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
            String telCode = "";
            List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
            if (Objects.nonNull(telInfArry)) {
                for (CusDetailTelInfArray item : telInfArry) {
                    if (!item.getAtchSys1().equals("2003000")) continue;
                    telCode = item.getTelId();
                }
            } else {
                telCode = "";
            }
            this.zydEcifThirdCusService.PriMtEcifThirdCusFn(nlsCreditInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
        }
        return usrID;
    }

    private void sendCusIndivToEcif(NlsCreditInfoVO nlsCreditInfoVO, CusIndivVO cusIndivVO, String estblshDt, String sstblshBrch) throws Exception {
        String identEfftvDt;
        MaintainEcifThirdCusReq maintainEcifThirdCusReq = MaintainEcifThirdCusReq.builder().build();
        String string = identEfftvDt = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
        if (identEfftvDt.length() > 8) {
            identEfftvDt = identEfftvDt.length() == 10 ? DateUtility.format10To8((String)identEfftvDt) : identEfftvDt.split("-")[1];
        }
        String crrCd = nlsCreditInfoVO.getProfession().length() == 1 ? SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsCreditInfoVO.getProfession()) : nlsCreditInfoVO.getProfession();
        String crrCd1 = null;
        String crrCd2 = null;
        String crrCd3 = null;
        if (!crrCd.endsWith("00")) {
            crrCd3 = crrCd;
        } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
            crrCd2 = crrCd;
        } else if (crrCd.endsWith("0000")) {
            crrCd1 = crrCd;
        }
        TrdPtyCustInfArryBean build = TrdPtyCustInfArryBean.builder().CustNm(nlsCreditInfoVO.getCusName()).IdentTp(nlsCreditInfoVO.getCertType()).IdentNo(nlsCreditInfoVO.getCertCode()).IdentMtrDt(identEfftvDt).Gnd(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname()).Nation(StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getNational()) ? "156" : nlsCreditInfoVO.getNational()).BrthDt(DateUtility.format10To8((String)ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()))).HghstEdu(nlsCreditInfoVO.getEdu()).CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).ProfTtl(nlsCreditInfoVO.getTtl()).CtcAddr(NlsStringUtil.toShorterString((String)nlsCreditInfoVO.getIndivRsdAddr(), (int)300)).CtcTel(nlsCreditInfoVO.getIndivMobile()).WrkCorp(nlsCreditInfoVO.getWrkCorpNm()).ChanNo("010").EstblshDt(estblshDt).EstblshBrch(sstblshBrch).build();
        maintainEcifThirdCusReq.setTrdPtyCustInfArry(Collections.singletonList(build));
        ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(cusIndivVO.getInnerCusId());
        this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
    }
}

