/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.loan_repay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.constant.sed.DealState;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.impl.loan_repay.CompensationTask;
import com.irdstudio.efp.nls.service.impl.psd.apply.PsdLoanReleaseServiceImpl;
import com.irdstudio.efp.nls.service.impl.psd.apply.PsdSyncLoanInfoServiceImpl;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="loanReleaseCompensationTask")
public class LoanReleaseCompensationTask
extends CompensationTask<NlsApplyInfoVO> {
    private static Logger logger = LoggerFactory.getLogger(LoanReleaseCompensationTask.class);
    @Value(value="${loanReleaseCompensationTask.maxexcutenum:218}")
    private int maxExcuteNum;
    @Autowired
    @Qualifier(value="psdLoanReleaseService")
    private PsdLoanReleaseServiceImpl psdLoanReleaseService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="psdSyncLoanInfoService")
    private PsdSyncLoanInfoServiceImpl syncLoanInfoHsdService;

    @Override
    protected void updateStatus(NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        if (nlsApplyInfoVO.getExecuteTime() + 1 >= this.maxExcuteNum) {
            NlsApplyInfoVO updateNlsApplyInfo = this.updateNlsApplyInfoFailureStatus(nlsApplyInfoVO, "", "");
            this.nlsApplyInfoService.updateByPk(updateNlsApplyInfo);
            LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            this.psdLoanReleaseService.recoverAmt(nlsApplyInfoVO, lmtPrdContVO);
            return;
        }
        RespLoanRepayResultQryBean respLoanRepayResultQryBean = this.psdLoanReleaseService.getRespLoanRepayResultQryBean(nlsApplyInfoVO);
        RespLoanRepayResultQryBean.TxnRsltInfBean txnRsltInfBean = Optional.ofNullable(respLoanRepayResultQryBean.parseTxnRsltInf()).orElseGet(RespLoanRepayResultQryBean.TxnRsltInfBean::new);
        String txnStCd = respLoanRepayResultQryBean.getTxnStCd();
        String qrySt = respLoanRepayResultQryBean.getQrySt();
        NlsApplyInfoVO updateNlsApplyInfo = null;
        if (DealState.SUCCESS.getValue().equals(txnStCd)) {
            this.psdLoanReleaseService.updateLmtTerm(nlsApplyInfoVO);
            updateNlsApplyInfo = this.updateNlsApplyInfoSuccessStatus(nlsApplyInfoVO, txnRsltInfBean.getBaseAcctNo(), txnRsltInfBean.getAcctSeqNo());
            try {
                this.syncLoanInfoHsdService.doExecute(null, nlsApplyInfoVO);
            }
            catch (Exception e) {
                logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u6210\u529f,\u6267\u884c\u540c\u6b65\u5931\u8d25 \u7b49\u5f85\u8865\u507f\u4efb\u52a1\u8865\u507f");
                nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u540c\u6b65\u4efb\u52a1");
                nlsApplyInfoVO.setNlsApplyState("01");
            }
        } else if (DealState.FAIL.getValue().equals(txnStCd) || SedNlsEnum.QuerySts.WITHOUT.getValue().equals(qrySt) && StringUtils.isEmpty((CharSequence)txnStCd)) {
            updateNlsApplyInfo = this.updateNlsApplyInfoFailureStatus(nlsApplyInfoVO, txnRsltInfBean.getBaseAcctNo(), txnRsltInfBean.getAcctSeqNo());
            LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            this.psdLoanReleaseService.recoverAmt(nlsApplyInfoVO, lmtPrdContVO);
        } else if (DealState.DEALING.getValue().equals(txnStCd) || DealState.SUSPEND.getValue().equals(txnStCd) || DealState.UNKNOW.getValue().equals(txnStCd)) {
            logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011 \u653e\u6b3e\u8865\u507f\u4efb\u52a1\u6b63\u5728\u6267\u884c \u5f53\u524d\u6267\u884c\u7684\u6b21\u6570\u4e3a\u3010" + nlsApplyInfoVO.getExecuteTime() + "\u3011");
            logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011 \u7528\u4fe1\u7533\u8bf7\u4e3a" + JSONObject.toJSONString((Object)nlsApplyInfoVO));
            throw new ESBException("\u653e\u6b3e\u8865\u507f\u4efb\u52a1\u6267\u884c");
        }
        this.nlsApplyInfoService.updateByPk(updateNlsApplyInfo);
    }

    @Override
    protected void sendMessage(NlsApplyInfoVO nlsApplyInfoVO) {
        try {
            int executeTime = nlsApplyInfoVO.getExecuteTime();
            nlsApplyInfoVO.setExecuteTime(++executeTime);
            this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
            logger.info("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011 \u653e\u6b3e\u8865\u507f\u4efb\u52a1\u6b63\u5728\u6267\u884c \u5f53\u524d\u6267\u884c\u7684\u6b21\u6570\u4e3a\u3010" + nlsApplyInfoVO.getExecuteTime() + "\u3011 \u5ef6\u8fdf\u6267\u884c\u7ea7\u522b\u3010" + this.delayLevel(nlsApplyInfoVO.getExecuteTime()) + "\u3011");
            Message message = new Message(TopicEnums.LOANRELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId(), TagEnums.LOANRELEASEORREPAY_QUEUE_TASK.getTagId(), nlsApplyInfoVO.getApplySeq().concat(".").concat("NlsApplyInfoVO-" + nlsApplyInfoVO.getExecuteTime()), JSON.toJSONString((Object)nlsApplyInfoVO).getBytes("UTF-8"));
            message.setDelayTimeLevel(this.delayTimes(nlsApplyInfoVO.getExecuteTime()));
            String messageKey = TopicEnums.LOANRELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId() + "_" + TagEnums.LOANRELEASEORREPAY_QUEUE_TASK.getTagId() + "_" + nlsApplyInfoVO.getApplySeq().concat(".").concat("NlsApplyInfoVO-" + nlsApplyInfoVO.getExecuteTime());
            this.producerService.sendMsg(message, messageKey);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1\u65f6\uff0c\u53d1\u9001mq\u51fa\u73b0\u5f02\u5e38!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1\u65f6\uff0c\u66f4\u65b0\u8865\u507f\u4efb\u52a1\u6267\u884c\u6b21\u6570\u5931\u8d25!!!");
        }
    }

    @Override
    protected NlsApplyInfoVO convertToJavaBean(String body) {
        return (NlsApplyInfoVO)JSONObject.parseObject((String)body, NlsApplyInfoVO.class);
    }

    private NlsApplyInfoVO updateNlsApplyInfoFailureStatus(NlsApplyInfoVO nlsApplyInfoVO, String loanNo, String distrNo) {
        nlsApplyInfoVO.setNlsApplyState("03");
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u5931\u8d25");
        nlsApplyInfoVO.setDnSts("0");
        nlsApplyInfoVO.setLoanNo(loanNo);
        nlsApplyInfoVO.setDistrNo(distrNo);
        return nlsApplyInfoVO;
    }

    private NlsApplyInfoVO updateNlsApplyInfoSuccessStatus(NlsApplyInfoVO nlsApplyInfoVO, String loanNo, String distrNo) {
        nlsApplyInfoVO.setRefuseCause("");
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u6210\u529f");
        nlsApplyInfoVO.setDnSts("6");
        nlsApplyInfoVO.setLoanNo(loanNo);
        nlsApplyInfoVO.setDistrNo(distrNo);
        nlsApplyInfoVO.setRefuseCause("");
        nlsApplyInfoVO.setExecuteTime(0);
        return nlsApplyInfoVO;
    }
}

