/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.ms;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.GsonUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.esb.common.constant.MsLoanConstant;
import com.irdstudio.efp.esb.service.bo.req.MsLoanReq;
import com.irdstudio.efp.esb.service.bo.resp.MsLoanResp;
import com.irdstudio.efp.esb.service.facade.MsLoanService;
import com.irdstudio.efp.esb.service.vo.BigShowVO;
import com.irdstudio.efp.nls.common.util.KafkaUtil;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="msLoanApprNoticeService")
public class MsLoanApprNoticeServiceImpl
extends SoltServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(MsLoanApprNoticeServiceImpl.class);
    @Autowired
    @Qualifier(value="msLoanService")
    private MsLoanService msLoanService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Value(value="${bigshow.servers}")
    private String servers;
    @Value(value="${bigshow.kafkaToptic}")
    private String kafkaToptic;

    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        block11: {
            final String applySeq = nlsProcessBizVo.getApplySeq();
            try {
                logger.info("\u9a6c\u4e0a\u8d37\u6b3e\u5ba1\u6838\u901a\u77e5\u63a5\u53e3\uff08\u5e7f\u5dde\u94f6\u884c->\u9a6c\u4e0a\uff09\uff0c\u6d41\u6c34\u53f7:" + applySeq);
                Objects.requireNonNull(nlsApplyInfoVO);
                String nlsApplyState = Objects.requireNonNull(nlsApplyInfoVO.getNlsApplyState());
                try {
                    MsLoanReq msLoanReq = new MsLoanReq();
                    msLoanReq.setTxnFlowNo(applySeq);
                    boolean isSend = false;
                    nlsApplyInfoVO.setRefuseCause("");
                    nlsApplyInfoVO.setDnSts("3");
                    logger.info("\u9a6c\u4e0a\u8d37\u6b3e\u5ba1\u6838\u901a\u77e5\u66f4\u65b0\u653e\u6b3e\u72b6\u6001\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)nlsApplyInfoVO));
                    int num = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
                    logger.info("\u9a6c\u4e0a\u8d37\u6b3e\u5ba1\u6838\u901a\u77e5\u66f4\u65b0\u653e\u6b3e\u72b6\u6001\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)num));
                    msLoanReq.setAudRslt(MsLoanConstant.AudRsltEnum.PASS.VALUE);
                    if (num > 0) {
                        isSend = true;
                    }
                    if (!isSend) break block11;
                    MsLoanResp msLoanResp = this.msLoanService.msLoan(msLoanReq);
                    try {
                        Objects.requireNonNull(msLoanResp);
                        if (!MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(msLoanResp.getRetStCd())) {
                            logger.error("\u8c03\u7528\u9a6c\u4e0a\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f" + msLoanResp.getRtnMsg());
                        }
                        try {
                            if (MsLoanConstant.RetCodeEnum.SUCCESS.VALUE.equals(msLoanResp.getRetStCd())) {
                                logger.info("\u9a6c\u4e0a\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f00\u59cb");
                                BigShowVO array = new BigShowVO();
                                array.setSysName("\u7f51\u8d37");
                                array.setCreditNo(applySeq);
                                array.setCreditAmount(nlsApplyInfoVO.getApplyAmt());
                                array.setProductName(nlsApplyInfoVO.getPrdName());
                                array.setName(nlsApplyInfoVO.getCusName());
                                array.setCertNo(nlsApplyInfoVO.getCertCode());
                                array.setPhoneNum(nlsApplyInfoVO.getMobile());
                                String timeStamp = TimeUtil.getTimeStampByPattern((String)"yyyyMMdd HH:mm:ss");
                                array.setDateTime(timeStamp);
                                ArrayList<BigShowVO> jsonObjects = new ArrayList<BigShowVO>();
                                jsonObjects.add(array);
                                final HashMap<String, ArrayList<BigShowVO>> map = new HashMap<String, ArrayList<BigShowVO>>();
                                map.put("array", jsonObjects);
                                ThreadFactory threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("ms-bigShow-singleThreadPool").build();
                                ThreadPoolExecutor singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingDeque<Runnable>(1024), threadFactoryBuilder, new ThreadPoolExecutor.AbortPolicy());
                                singleThreadPool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        KafkaUtil kafka = new KafkaUtil(MsLoanApprNoticeServiceImpl.this.servers, MsLoanApprNoticeServiceImpl.this.kafkaToptic);
                                        try {
                                            kafka.sendMessage(GsonUtils.toJson((Object)map));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            logger.error("\u9a6c\u4e0a\u8fdb\u4ef6\u7533\u8bf7\u4ea4\u6613\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5931\u8d25\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + "\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                                        }
                                    }
                                });
                                singleThreadPool.shutdown();
                                logger.info("\u9a6c\u4e0a\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u7ed3\u675f\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq);
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u9a6c\u4e0a\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u53d1\u9001kafka\u6d88\u606f\u7ed9\u5927\u6570\u636e\u5f02\u5e38\uff0c\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + "\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        nlsProcessBizVo.setExceptionFlag(true);
                        nlsProcessBizVo.setExceptionMsg(e);
                        logger.error("\u8c03\u7528\u9a6c\u4e0a\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                        throw new BizException("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    nlsProcessBizVo.setExceptionFlag(true);
                    nlsProcessBizVo.setExceptionMsg(e);
                    logger.error("\u8c03\u7528\u9a6c\u4e0a\u5ba1\u6279\u7ed3\u679c\u6d88\u8d39\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                    throw new BizException("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("\u9a6c\u4e0a\u8d37\u6b3e\u5ba1\u6838\u901a\u77e5\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                nlsProcessBizVo.setExceptionFlag(true);
                nlsProcessBizVo.setExceptionMsg(e);
            }
        }
    }
}

