/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.ms;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.QueuePauseException;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.efp.console.service.facade.CustomerLimitInfoService;
import com.irdstudio.efp.console.service.vo.CustomerLimitInfoVO;
import com.irdstudio.efp.esb.service.bo.req.MsYxApproveReqBean;
import com.irdstudio.efp.esb.service.bo.resp.MsYxApproveRespBean;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.ed.LimitControlsService;
import com.irdstudio.efp.nls.service.facade.ms.MsZxInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.MsZxInfoVO;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.PlcFldInfArryFromNls;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="msLoanApprService")
public class MsLoanApprServiceImpl
extends SoltServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(MsLoanApprServiceImpl.class);
    public final String customerLimitInfoSts = "01";
    public final String cusType = "02";
    @Autowired
    @Qualifier(value="msZxService")
    private MsZxInfoService msZxInfoService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="limitControlsService")
    private LimitControlsService limitControlsService;
    @Autowired
    @Qualifier(value="customerLimitInfoService")
    private CustomerLimitInfoService customerLimitInfoService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="msYxApprService")
    private EsbService<MsYxApproveReqBean, MsYxApproveRespBean> msApproveService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsApplyInfoVO.getApplySeq();
        logger.info("======>\u9a6c\u4e0a\u91d1\u878d\u8054\u5408\u8d37\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        try {
            try {
                BigDecimal sumAmt = BigDecimal.ZERO;
                BigDecimal amtLimit = BigDecimal.ZERO;
                MsZxInfoVO inMsZxInfoVo = new MsZxInfoVO();
                inMsZxInfoVo.setApplySeq(applySeq);
                MsZxInfoVO msZxInfo = this.msZxInfoService.queryByPk(inMsZxInfoVo);
                Objects.requireNonNull(msZxInfo, "\u9a6c\u4e0a\u91d1\u878d\u8054\u5408\u8d37\u7528\u4fe1\u5ba1\u6279\u83b7\u53d6\u9a6c\u4e0a\u5f81\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                sumAmt = this.limitControlsService.getPreOccAmt(nlsApplyInfoVO.getCertCode(), nlsApplyInfoVO.getCertType());
                CustomerLimitInfoVO customerLimitInfoVO = new CustomerLimitInfoVO();
                customerLimitInfoVO.setSts("01");
                customerLimitInfoVO.setCusType("02");
                customerLimitInfoVO = this.customerLimitInfoService.queryByStsAndCusTyp(customerLimitInfoVO);
                Objects.requireNonNull(customerLimitInfoVO, "\u9a6c\u4e0a\u91d1\u878d\u8054\u5408\u8d37\u7528\u4fe1\u5ba1\u6279\u83b7\u53d6\u5ba2\u6237\u9650\u989d\u4e3a\u7a7a");
                if (customerLimitInfoVO.getQuotaLimiAmt() != null && TimeUtil.compareDates((String)TimeUtil.getCurDate(), (String)customerLimitInfoVO.getStrDt()) > -1 && TimeUtil.compareDates((String)TimeUtil.getCurDate(), (String)customerLimitInfoVO.getEndDt()) < 1) {
                    amtLimit = customerLimitInfoVO.getQuotaLimiAmt();
                }
                int age = ValidationUtils.getAgeFromIdNumber((String)nlsApplyInfoVO.getCertCode(), (int)22, (int)55);
                boolean isFemale = ValidationUtils.isFemale((String)nlsApplyInfoVO.getCertCode());
                if (isFemale) {
                    age = ValidationUtils.getAgeFromIdNumber((String)nlsApplyInfoVO.getCertCode(), (int)22, (int)50);
                }
                this.invokeApproveInterface(nlsApplyInfoVO, msZxInfo, applySeq, sumAmt, amtLimit, age);
                throw new QueuePauseException("");
            }
            catch (Exception e) {
                logger.error("======>\u7f51\u8d37\u3010\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u3011\u6267\u884c\u5931\u8d25\u539f\u56e0\u4e3a<======" + e.getMessage());
                if (!(e instanceof QueuePauseException)) {
                    logger.error("======>\u7f51\u8d37\u3010\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u3011\u63d2\u69fd\u6267\u884c\u5931\u8d25\uff01\uff01\uff01<======");
                }
                nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
                nlsProcessBizVo.setRefuseMsg(e.getMessage());
                nlsProcessBizVo.setExceptionMsg(e);
                logger.info("======>\u9a6c\u4e0a\u91d1\u878d\u8054\u5408\u8d37\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
            }
        }
        catch (Throwable throwable) {
            logger.info("======>\u9a6c\u4e0a\u91d1\u878d\u8054\u5408\u8d37\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
            throw throwable;
        }
    }

    private void invokeApproveInterface(NlsApplyInfoVO nlsApplyInfoVO, MsZxInfoVO msZxInfo, String applySeq, BigDecimal sumAmt, BigDecimal amtLimit, int age) throws Exception {
        MsYxApproveReqBean msZxApproveReqBeanArr = new MsYxApproveReqBean();
        MsYxApproveReqBean.QryRptsInfArry msZxApproveReqBean = new MsYxApproveReqBean.QryRptsInfArry();
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getIndivIdExpDt())) {
            msZxApproveReqBean.setIdentVldty(nlsApplyInfoVO.getIndivIdExpDt());
        } else {
            msZxApproveReqBean.setIdentVldty(this.indivIdExpDt(nlsApplyInfoVO.getIndivIdExpDt()));
        }
        msZxApproveReqBean.setAppNo(applySeq);
        msZxApproveReqBean.setName(nlsApplyInfoVO.getCusName());
        msZxApproveReqBean.setGnd(nlsApplyInfoVO.getCusGender());
        msZxApproveReqBean.setAge(Integer.toString(age));
        msZxApproveReqBean.setIdentTp(nlsApplyInfoVO.getCertType());
        msZxApproveReqBean.setIdentNo(nlsApplyInfoVO.getCertCode());
        msZxApproveReqBean.setCrr(nlsApplyInfoVO.getProfession());
        msZxApproveReqBean.setCrspAddr(nlsApplyInfoVO.getCertAddr());
        msZxApproveReqBean.setNation(nlsApplyInfoVO.getCusNational());
        msZxApproveReqBean.setCustLmt(amtLimit.toString());
        msZxApproveReqBean.setNetwrkLoanOcptnLmt(sumAmt.toString());
        msZxApproveReqBean.setTlrNo("gzyh123");
        msZxApproveReqBean.setDeptNo("01328");
        msZxApproveReqBean.setMblNo(nlsApplyInfoVO.getMobile());
        msZxApproveReqBean.setCrCardOdueJdg(msZxInfo.getGzyhLCOverdue());
        msZxApproveReqBean.setCrCardStJdg(msZxInfo.getGzyhIsCFrozen());
        msZxApproveReqBean.setCrCardRctly12MosInsdAcmlnOdueTms(msZxInfo.getGzyhCTotalPdNum12m());
        msZxApproveReqBean.setCrCardCtnsOdueJdg(msZxInfo.getGzyhCMaxContinuePdNum12m());
        msZxApproveReqBean.setGnrCmpnstJdg(msZxInfo.getGzyhNumGuacmp());
        msZxApproveReqBean.setBdDbtJdg(msZxInfo.getGzyhNumTbd());
        msZxApproveReqBean.setAstDispJdg(msZxInfo.getGzyhNumAssdsp());
        msZxApproveReqBean.setLoanOdueJdg(msZxInfo.getGzyhLLOverdue());
        msZxApproveReqBean.setLoanStJdg(msZxInfo.getGzyhIsLOvdue());
        msZxApproveReqBean.setCllctnAcctSt(msZxInfo.getGzyhIsLCollecting());
        msZxApproveReqBean.setLoanClsfSt(msZxInfo.getGzyhIfFiveClassUnnormal());
        msZxApproveReqBean.setLoanRcntOdueTms(msZxInfo.getGzyhLTotalPdNum12m());
        msZxApproveReqBean.setLoanCtnsOdueJdg(msZxInfo.getGzyhLMaxContinuePdNum12m());
        msZxApproveReqBean.setCustInfJdg(msZxInfo.getGzyhIfHaveBasicInfo());
        msZxApproveReqBean.setNrOneMosQryTms(msZxInfo.getGzyh1MCardEnquiriesLC());
        msZxApproveReqBean.setNnLoanRcrdJdg(msZxInfo.getGzyhIsCreditWhite());
        msZxApproveReqBean.setQscrdtOdueJdg(msZxInfo.getGzyhLSOverdue());
        msZxApproveReqBean.setQscrdtSt(msZxInfo.getGzyhIsSFrozen());
        msZxApproveReqBean.setQscrdtOdNonRpymtRcrdJdg(msZxInfo.getGzyhIsSOvdueMThan180D());
        msZxApproveReqBean.setQscrdtOdSt(msZxInfo.getGzyhSTotalPdNum12m());
        msZxApproveReqBean.setQscrdtCtnsOdueJdg(msZxInfo.getGzyhSMaxContinuePdNum12m());
        msZxApproveReqBean.setSnglBnkHghstCrLmt(msZxInfo.getGzyhAmtcHclacc());
        msZxApproveReqBean.setTotCrLmt(msZxInfo.getGzyhAmtcClop());
        msZxApproveReqBean.setAlrdyCrLmt(msZxInfo.getGzyhAmtcUtlcop());
        msZxApproveReqBean.setOdueSnglMonHghstOdueTotAmt(msZxInfo.getGzyhAmtcHtpdever());
        msZxApproveReqBean.setLoanCrLoanBrchCnt(msZxInfo.getGzyhNumlLpos());
        msZxApproveReqBean.setRctlyAcmlnOdueCnt(msZxInfo.getGzyhTotalLoanOverdueNum());
        msZxApproveReqBean.setPBCIdy(msZxInfo.getGzyhInd());
        msZxApproveReqBean.setEnfrcExecJdg(msZxInfo.getGzyhIsEnforement());
        msZxApproveReqBean.setCrCardRctlyAcmlnOdueTrmCnt(msZxInfo.getGzyhTotaCrelOverdueNum());
        msZxApproveReqBean.setSmlLndBrchCrBrchCnt(msZxInfo.getGzyhSmallCNum());
        msZxApproveReqBean.setSmlLndBrchHvLndBrchCnt(msZxInfo.getGzyhSmallLoanNum());
        msZxApproveReqBean.setSmlLndBrchHvLndDbllCnt(msZxInfo.getGzyhSmallLoanLoanNum());
        msZxApproveReqBean.setCnsmnFinBrchCrBrchCnt(msZxInfo.getGzyhFinancialCreditInsNum());
        msZxApproveReqBean.setCnsmnFinBrchHvLndBrchCnt(msZxInfo.getGzyhFinancialLoanInsNum());
        msZxApproveReqBean.setCnsmnFinBrchHvLndDbllCnt(msZxInfo.getGzyhFinancialLoanLoanInsNum());
        msZxApproveReqBean.setCrnOdueTrmCnt(msZxInfo.getGzyhLCOverdueNum());
        msZxApproveReqBean.setCrnOdueAmt(msZxInfo.getGzyhLCCpdSum());
        msZxApproveReqBean.setCrnLmtUseFrqcy(msZxInfo.getGzyhCurrentQuotaUsage());
        msZxApproveReqBean.setBalNoForNonBalCrCardShetCnt(msZxInfo.getGzyhLCNo0CardNum());
        msZxApproveReqBean.setUncldHsngMrtgeLoanCnt(msZxInfo.getGzyhUnOverMortgageLoanNum());
        msZxApproveReqBean.setUncldCrpnLoanCnt(msZxInfo.getGzyhUnOverBusinessLoanNum());
        msZxApproveReqBean.setUncldLoanCnt(msZxInfo.getGzyhUnOverOtherLoanNum());
        msZxApproveReqBean.setWhthrExstExtGrnt(msZxInfo.getGzyhIsNumExtwrt());
        msZxApproveReqBean.setUncldLoanCntSmzg(msZxInfo.getGzyhNumlOs());
        msZxApproveReqBean.setWhthrAbnStCrCard(msZxInfo.getGzyhLCAbnormalCard());
        msZxApproveReqBean.setWhthrAbnStQscrdt(msZxInfo.getGzyhLSAbnormalCard());
        msZxApproveReqBean.setWhthrExstAbnLoan(msZxInfo.getGzyhLLAbnormalLoan());
        msZxApproveReqBean.setMrtlSitu(msZxInfo.getGzyhStuMrg());
        msZxApproveReqBean.setHghstEdu(msZxInfo.getGzyhDiploma());
        msZxApproveReqBean.setHghstDgr(msZxInfo.getGzyhDegree());
        msZxApproveReqBean.setLoanCrBal(msZxInfo.getGzyhAmtlOsbal());
        msZxApproveReqBean.setUncldLoanCrRpymnt(msZxInfo.getGzyhAmtlApos6m());
        msZxApproveReqBean.setUncldCrCardCrBrchCnt(msZxInfo.getGzyhNumcLpop());
        msZxApproveReqBean.setNonCnslAcctCrCardCrAvUseLmt(msZxInfo.getGzyhAmtcAutlcop6m());
        msZxApproveReqBean.setGrntCnt(msZxInfo.getGzyhNumExtwrt());
        msZxApproveReqBean.setGrntPnpBal(msZxInfo.getGzyhAtmExtwrt());
        msZxApproveReqBean.setHsngLoanCnt(msZxInfo.getGzyhAtmExtwrt());
        msZxApproveReqBean.setIndvCmrclHsngLoanCnt(msZxInfo.getGzyhPersonalCommercialLoans());
        msZxApproveReqBean.setCrCardLngstAcctAge(msZxInfo.getGzyhLCLongestAge());
        msZxApproveReqBean.setLoanPnpBal(msZxInfo.getGzyhAmtlBalSum());
        msZxApproveReqBean.setLoanUncldCnt(msZxInfo.getGzyhUnfinishLoans());
        msZxApproveReqBean.setCrpnLoanBal(msZxInfo.getGzyhOperLoanBalance());
        msZxApproveReqBean.setFrmrLoanBal(msZxInfo.getGzyhFarmerLoanBalance());
        msZxApproveReqBean.setIndvCnsmnLoanBal(msZxInfo.getGzyhPersonalLoanBalance());
        msZxApproveReqBean.setCnsmnFinCoLoanBal(msZxInfo.getGzyhCFianceCompanyLoanBalance());
        msZxApproveReqBean.setSmlLndCoLoanBal(msZxInfo.getGzyhSmallLoanCompanyBanlance());
        msZxApproveReqBean.setRctly1MosInsdCrCardQryBrchCnt(msZxInfo.getGzyh1MCardEnquiries());
        msZxApproveReqBean.setRctly3MosInsdCrCardQryBrchCnt(msZxInfo.getGzyh3MCardEnquiries());
        msZxApproveReqBean.setRctly6MosInsdCrCardQryBrchCnt(msZxInfo.getGzyh6MCardEnquiries());
        msZxApproveReqBean.setRctly12MosInsdCrCardQryBrchCnt(msZxInfo.getGzyh12MCardEnquiries());
        msZxApproveReqBean.setRctly24MosInsdCrCardQryBrchCnt(msZxInfo.getGzyh24MCardEnquiries());
        msZxApproveReqBean.setRctly1MosInsdLoanQryBrchCnt(msZxInfo.getGzyh1MLoanEnquiries());
        msZxApproveReqBean.setRctly3MosInsdLoanQryBrchCnt(msZxInfo.getGzyh3MLoanEnquiries());
        msZxApproveReqBean.setRctly6MosInsdLoanQryBrchCnt(msZxInfo.getGzyh6MLoanEnquiries());
        msZxApproveReqBean.setRctly12MosInsdLoanQryBrchCnt(msZxInfo.getGzyh12MLoanEnquiries());
        msZxApproveReqBean.setRctly24MosInsdLoanQryBrchCnt(msZxInfo.getGzyh24MLoanEnquiries());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM1Tms(msZxInfo.getGzyh12MOverdueM1());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM2Tms(msZxInfo.getGzyh12MOverdueM2());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM3Tms(msZxInfo.getGzyh12MOverdueM3());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM4Tms(msZxInfo.getGzyh12MOverdueM4());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM1UpTms(msZxInfo.getGzyh12MOverdueBigThanM1());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM2UpTms(msZxInfo.getGzyh12MOverdueBigThanM2());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM3UpTms(msZxInfo.getGzyh12MOverdueBigThanM3());
        msZxApproveReqBean.setCrCardRctly12MosOdueAndDfltM4UpTms(msZxInfo.getGzyh12MOverdueBigThanM4());
        msZxApproveReqBean.setCrCardRctly12MosMxOdueSumDfltTrmCnt(msZxInfo.getGzyh12MMaxOverdueNum());
        msZxApproveReqBean.setCrCardRctly24MosMxOdueSumDfltTrmCnt(msZxInfo.getGzyh24MMaxOverdueNum());
        msZxApproveReqBean.setCrnLoanOdueAndDfltTotAmt(msZxInfo.getGzyhCurrentAmtlCpdSum());
        msZxApproveReqBean.setCrnLoanOdueAndDfltTrmCnt(msZxInfo.getGzyhCurrentAmtlCpdMax());
        msZxApproveReqBean.setLoanRctly12MosOdueAndDfltM1UpTms(msZxInfo.getGzyh12MlldOverdueBigThanM1());
        msZxApproveReqBean.setLoanRctly24MosOdueAndDfltM1UpTms(msZxInfo.getGzyh24MlldOverdueBigThanM1());
        msZxApproveReqBean.setLoanRctly12MosOdueAndDfltM2UpTms(msZxInfo.getGzyh12MlldOverdueBigThanM2());
        msZxApproveReqBean.setLoanRctly24MosOdueAndDfltM2UpTms(msZxInfo.getGzyh24MlldOverdueBigThanM2());
        msZxApproveReqBean.setLoanRctly12MosOdueAndDfltM3UpTms(msZxInfo.getGzyh12MlldOverdueBigThanM3());
        msZxApproveReqBean.setLoanRctly24MosOdueAndDfltM3UpTms(msZxInfo.getGzyh24MlldOverdueBigThanM3());
        msZxApproveReqBean.setLoanRctly12MosOdueAndDfltM4UpTms(msZxInfo.getGzyh12MlldOverdueBigThanM4());
        msZxApproveReqBean.setLoanRctly24MosOdueAndDfltM4UpTms(msZxInfo.getGzyh24MlldOverdueBigThanM4());
        msZxApproveReqBean.setLoanRctly12MosMxOdueAndDfltTms(msZxInfo.getGzyh12MlldOverdueMax());
        msZxApproveReqBean.setLoanRctly24MosMxOdueAndDfltTms(msZxInfo.getGzyh24MlldOverdueMax());
        msZxApproveReqBean.setRprtTm(msZxInfo.getTIME_REP());
        msZxApproveReqBean.setCardSnglHghstLmtUseRt(msZxInfo.getGzyhCMaxUsedRate());
        msZxApproveReqBean.setNr3MosAprvlQry(msZxInfo.getGzyh3MCardEnquiriesLC());
        msZxApproveReqBean.setUncldLoanBrchCnt(msZxInfo.getGzyhUnclosedLoanInsNum());
        msZxApproveReqBean.setUncldLoanContrTotAmt(msZxInfo.getGzyhUnclosedLoanContrAmt());
        msZxApproveReqBean.setRsrvFld1("");
        msZxApproveReqBean.setRsrvFld2("");
        msZxApproveReqBean.setRsrvFld3("");
        msZxApproveReqBean.setRsrvFld4("");
        msZxApproveReqBean.setRsrvFld5("");
        msZxApproveReqBean.setRsrvFld6("");
        msZxApproveReqBean.setRsrvFld7("");
        msZxApproveReqBean.setRsrvFld8("");
        msZxApproveReqBean.setRsrvFld9("");
        msZxApproveReqBean.setRsrvFld10("");
        msZxApproveReqBean.setPlcFldTp(nlsApplyInfoVO.getPlcFldTp());
        ArrayList<MsYxApproveReqBean.PlcFldInfArry> PlcFldInfArrys = new ArrayList<MsYxApproveReqBean.PlcFldInfArry>();
        List plcFldInfArrys = nlsApplyInfoVO.getPlcFldInfArryFromNls();
        if (Objects.nonNull(plcFldInfArrys) && !plcFldInfArrys.isEmpty() && plcFldInfArrys.size() > 0) {
            for (PlcFldInfArryFromNls plcFldInfArryBean : plcFldInfArrys) {
                MsYxApproveReqBean.PlcFldInfArry plcFldInfArry = new MsYxApproveReqBean.PlcFldInfArry();
                plcFldInfArry.setDstcTpEncd(plcFldInfArryBean.getDstcTpEncd());
                plcFldInfArry.setDstcTpDesc(plcFldInfArryBean.getDstcTpDesc());
                plcFldInfArry.setProvnCd(plcFldInfArryBean.getProvnCd());
                plcFldInfArry.setProvn(plcFldInfArryBean.getProvn());
                plcFldInfArry.setCityCd(plcFldInfArryBean.getCityCd());
                plcFldInfArry.setCity(plcFldInfArryBean.getCity());
                PlcFldInfArrys.add(plcFldInfArry);
            }
        }
        logger.debug("===PlcFldInfArrys\u4e3a\uff1a" + JSONObject.toJSONString(PlcFldInfArrys) + "====");
        msZxApproveReqBean.setPlcFldInfArry(PlcFldInfArrys);
        ArrayList<MsYxApproveReqBean.QryRptsInfArry> qryRptsInfArries = new ArrayList<MsYxApproveReqBean.QryRptsInfArry>();
        qryRptsInfArries.add(msZxApproveReqBean);
        msZxApproveReqBeanArr.setQryRptsInfArrys(qryRptsInfArries);
        MsYxApproveRespBean service = (MsYxApproveRespBean)this.msApproveService.service((Object)msZxApproveReqBeanArr);
    }

    public String indivIdExpDt(String indivIdExpDt) {
        String[] indiv = indivIdExpDt.split("-");
        if ("\u957f\u671f".equals(indiv[1])) {
            return "\u957f\u671f";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sf.format(sdf.parse(indiv[1]));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }
}

