/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.vo.RetMsgVO;
import com.irdstudio.basic.framework.redis.lock.RedisLock;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.service.facade.QuotaLimitPrdService;
import com.irdstudio.efp.console.service.vo.QuotaLimitPrdVO;
import com.irdstudio.efp.nls.service.facade.psd.QuotaCheckService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service(value="quotaCheckService")
public class QuotaCheckServiceImpl
implements QuotaCheckService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(QuotaCheckServiceImpl.class);
    @Autowired
    private QuotaLimitPrdService quotaLimitPrdService;
    @Autowired
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    private JedisCluster jedisCluster;

    @RedisLock(key="preNlsCreditInfoService_preOccupied")
    public RetMsgVO preOccupied(String sxApplySeq, BigDecimal preApproveLimit) throws Exception {
        this.setHash();
        RetMsgVO check = this.check("XD050300601", preApproveLimit);
        if (!check.isRetFlag()) {
            return check;
        }
        this.jedisCluster.hset(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY, sxApplySeq, LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "_" + preApproveLimit.toString());
        return new RetMsgVO(true, "");
    }

    private void setHash() {
        if (!this.jedisCluster.exists(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY).booleanValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("init", TimeUtil.getCurrentDate() + "_0");
            this.jedisCluster.hmset(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY, map);
        }
    }

    public RetMsgVO check(String prdId) throws Exception {
        List quotaLimitPrdVOS = this.quotaLimitPrdService.queryPrdActiveQuota(prdId, TimeUtil.getCurrentDate());
        if (quotaLimitPrdVOS == null || quotaLimitPrdVOS.isEmpty()) {
            return new RetMsgVO(true, "");
        }
        for (QuotaLimitPrdVO quotaLimitPrdVO : quotaLimitPrdVOS) {
            BigDecimal preTotal;
            BigDecimal arroveLimitTotal = this.nlsCreditInfoService.queryArroveLimitTotal(quotaLimitPrdVO.getPrdId());
            if (!(arroveLimitTotal.add(preTotal = this.getPreOccupieAmt(quotaLimitPrdVO)).doubleValue() >= quotaLimitPrdVO.getQuotaLimitAmt().doubleValue())) continue;
            return new RetMsgVO(false, "\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\u989d\u5ea6");
        }
        return new RetMsgVO(true, "");
    }

    public RetMsgVO check(String prdId, BigDecimal approveLimit) throws Exception {
        List quotaLimitPrdVOS = this.quotaLimitPrdService.queryPrdActiveQuota(prdId, TimeUtil.getCurrentDate());
        if (quotaLimitPrdVOS == null || quotaLimitPrdVOS.isEmpty()) {
            return new RetMsgVO(true, "");
        }
        for (QuotaLimitPrdVO quotaLimitPrdVO : quotaLimitPrdVOS) {
            BigDecimal preTotal;
            BigDecimal arroveLimitTotal = this.nlsCreditInfoService.queryArroveLimitTotal(quotaLimitPrdVO.getPrdId());
            if (!(arroveLimitTotal.add(preTotal = this.getPreOccupieAmt(quotaLimitPrdVO)).add(approveLimit).doubleValue() > quotaLimitPrdVO.getQuotaLimitAmt().doubleValue())) continue;
            return new RetMsgVO(false, "\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\u989d\u5ea6");
        }
        return new RetMsgVO(true, "");
    }

    public void clearPreOccupied(String sxApplySeq) {
        if (StringUtils.isEmpty((CharSequence)sxApplySeq)) {
            return;
        }
        if (this.jedisCluster.exists(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY).booleanValue() && this.jedisCluster.hexists(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY, sxApplySeq).booleanValue()) {
            this.jedisCluster.hdel(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY, new String[]{sxApplySeq});
        }
    }

    public void updatePreOccupied(String sxApplySeq, BigDecimal amt) {
        if (Objects.isNull(amt)) {
            return;
        }
        if (this.jedisCluster.exists(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY).booleanValue() && this.jedisCluster.hexists(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY, sxApplySeq).booleanValue()) {
            this.jedisCluster.hset(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY, sxApplySeq, TimeUtil.getCurrentDate() + "_" + amt.toString());
        }
    }

    private BigDecimal getPreOccupieAmt(QuotaLimitPrdVO quotaLimitPrdVO) {
        BigDecimal preTotal = BigDecimal.ZERO;
        if (this.jedisCluster.exists(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY).booleanValue()) {
            List hvals = this.jedisCluster.hvals(PsdConstantSet.PRE_OCCUPIED_REDIS_HASH_KEY);
            for (String hval : hvals) {
                String[] s = hval.split("_");
                LocalDate parse = LocalDate.parse(s[0], DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                preTotal = preTotal.add(new BigDecimal(s[1]));
            }
        }
        return preTotal;
    }
}

