/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.apply;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.exception.QueuePauseException;
import com.irdstudio.efp.esb.service.bo.req.psd.PsdApplyApprReqBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.psd.PsdApplyApprService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.PsdSendTaxRecordService;
import com.irdstudio.efp.nls.service.facade.UpdateLmtPrdContService;
import com.irdstudio.efp.nls.service.facade.psd.PreNlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.psd.PreNlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdApplyAccessService")
public class PsdApplyAccessServiceImpl
extends SoltServiceImpl
implements FrameworkService {
    private final Logger logger = LoggerFactory.getLogger(PsdApplyAccessServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="psdApplyApprService")
    private PsdApplyApprService psdApplyApprService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="preNlsCreditInfoService")
    private PreNlsCreditInfoService preNlsCreditInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="updateLmtPrdContService")
    private UpdateLmtPrdContService updateLmtPrdContService;
    @Autowired
    private PsdSendTaxRecordService psdSendTaxRecordService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsApplyInfoVO.getApplySeq();
        this.logger.info("======>\u666e\u7a0e\u8d37\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        try {
            try {
                NlsApplyInfoVO queryNlsApplyInfoVO = new NlsApplyInfoVO();
                queryNlsApplyInfoVO.setApplySeq(applySeq);
                queryNlsApplyInfoVO = Optional.ofNullable(this.nlsApplyInfoService.queryByPk(queryNlsApplyInfoVO)).orElseThrow(() -> new BizException("\u666e\u7a0e\u8d37\u901a\u8fc7 " + applySeq + "\u6d41\u6c34\u53f7\u67e5\u8be2\u4e0d\u5230\u7528\u4fe1\u4fe1\u606f!!!"));
                NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
                Objects.requireNonNull(nlsCreditInfoVO, "\u666e\u7a0e\u8d37\u6388\u4fe1\u5ba1\u6279\u670d\u52a1\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
                preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
                preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
                Objects.requireNonNull(preNlsCreditInfoVO, "\u666e\u7a0e\u8d37\u6388\u4fe1\u5ba1\u6279\u670d\u52a1\u83b7\u53d6\u5230\u7684\u9884\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                Objects.requireNonNull(nlsCreditInfoVO.getApproveRateY(), "\u83b7\u53d6\u5230\u7684\u5ba1\u6279\u5e74\u5229\u7387\u4e3a\u7a7a");
                this.invokeApplyInterface(nlsApplyInfoVO, applySeq, nlsCreditInfoVO, preNlsCreditInfoVO);
                throw new QueuePauseException("");
            }
            catch (Exception e) {
                this.logger.error("======>\u666e\u7a0e\u8d37\u3010\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u3011\u6267\u884c\u5931\u8d25\u539f\u56e0\u4e3a<======", (Object)e.getMessage());
                if (!(e instanceof QueuePauseException)) {
                    this.updateLmtPrdContService.recoverLmtPro(nlsApplyInfoVO.getLmtApplySeq(), nlsApplyInfoVO.getApplySeq());
                }
                nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
                nlsProcessBizVo.setRefuseMsg(e.getMessage());
                nlsProcessBizVo.setExceptionMsg(e);
                this.logger.info("======>\u666e\u7a0e\u8d37\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7<======" + applySeq);
            }
        }
        catch (Throwable throwable) {
            this.logger.info("======>\u666e\u7a0e\u8d37\u7528\u4fe1\u5ba1\u6279\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7<======" + applySeq);
            throw throwable;
        }
    }

    private void invokeApplyInterface(NlsApplyInfoVO nlsApplyInfoVO, String applySeq, NlsCreditInfoVO nlsCreditInfoVO, PreNlsCreditInfoVO preNlsCreditInfoVO) throws ESBException, InterruptedException {
        PsdApplyApprReqBean psdApplyApprReqArray = new PsdApplyApprReqBean();
        PsdApplyApprReqBean.QryRptsInfArry psdApplyApprReqBean = new PsdApplyApprReqBean.QryRptsInfArry();
        psdApplyApprReqBean.setAppNo(applySeq);
        psdApplyApprReqBean.setLPRprsIdentNo(nlsApplyInfoVO.getCertCode());
        psdApplyApprReqBean.setLPMblNo(nlsApplyInfoVO.getMobile());
        psdApplyApprReqBean.setLPNm(nlsApplyInfoVO.getCusName());
        psdApplyApprReqBean.setLPIdentTp(nlsApplyInfoVO.getCertType());
        psdApplyApprReqBean.setUsrID("2003000");
        psdApplyApprReqBean.setDeptNo(nlsApplyInfoVO.getNlsOperOrgid());
        psdApplyApprReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
        psdApplyApprReqBean.setEntpLo(preNlsCreditInfoVO.getRegistration());
        psdApplyApprReqBean.setEntpNm(preNlsCreditInfoVO.getEnterpriseName());
        psdApplyApprReqBean.setEntpUSCC(preNlsCreditInfoVO.getSocialCreditCode());
        psdApplyApprReqBean.setUsrID("2003000");
        psdApplyApprReqBean.setDeptNo(nlsCreditInfoVO.getNlsOperOrgid());
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setCertType(preNlsCreditInfoVO.getCertType());
        lmtPrdContVO.setCertCode(preNlsCreditInfoVO.getCertNo());
        lmtPrdContVO.setLmtStatus("02");
        lmtPrdContVO.setAssureMeansMain("00");
        List lmtPrdContVOS = this.lmtPrdContService.aplcOCMExstdCrLmt(lmtPrdContVO);
        BigDecimal approveAmtTotal = lmtPrdContVOS.stream().map(LmtPrdContVO::getLmtAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        psdApplyApprReqBean.setOCMPLSExstdCrLmt(Double.valueOf(approveAmtTotal.doubleValue()));
        psdApplyApprReqBean.setAnulzLoanIntRt(Double.valueOf(nlsCreditInfoVO.getApproveRateY().doubleValue()));
        psdApplyApprReqBean.setBsnSrlNo(this.psdSendTaxRecordService.querySzsjYwlshByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq()));
        psdApplyApprReqBean.setDistrSrlNo(this.psdSendTaxRecordService.querySzsjFklshByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq()));
        ArrayList<PsdApplyApprReqBean.QryRptsInfArry> qryRptsInfArries = new ArrayList<PsdApplyApprReqBean.QryRptsInfArry>();
        qryRptsInfArries.add(psdApplyApprReqBean);
        psdApplyApprReqArray.setQryRptsInfArrys(qryRptsInfArries);
        psdApplyApprReqArray.setGlobaNo(nlsApplyInfoVO.getGlobalSerno());
        psdApplyApprReqArray.setCntlp(nlsApplyInfoVO.getCnlTp());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.psdApplyApprService, (Object)psdApplyApprReqArray, this.nlsQueueSoltComnService);
        esbInvokeWrapper.invoke3Threes();
    }
}

