/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.apply;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.esb.service.bo.req.psd.PsdLoanReleaseReqBean;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.psd.PsdLoanReleaseRespBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.psd.PsdLoanReleaseService;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayResultQryService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.exception.LoanReleaseException;
import com.irdstudio.efp.nls.common.exception.LoanRepaySyncException;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.UpdateLmtPrdContService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.psd.apply.PsdSyncLoanInfoServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdLoanReleaseService")
public class PsdLoanReleaseServiceImpl
extends SoltServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(PsdLoanReleaseServiceImpl.class);
    private static final String ONE_YEAR = "Y1";
    private static final String NO_DATA = "0";
    @Autowired
    @Qualifier(value="loanRepayResultQryService")
    private LoanRepayResultQryService loanRepayResultQryService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="psdHjLoanReleaseService")
    private PsdLoanReleaseService psdHjLoanReleaseService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="updateLmtPrdContService")
    private UpdateLmtPrdContService updateLmtPrdContService;
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    @Qualifier(value="psdSyncLoanInfoService")
    private PsdSyncLoanInfoServiceImpl psdSyncLoanInfoService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        block11: {
            String applySeq = nlsApplyInfoVO.getApplySeq();
            this.logger.info("======>\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u670d\u52a1\u3011\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
            CtrLoanContVO ctrLoanContVO = this.getCtrLoanContVO(nlsApplyInfoVO);
            Optional.ofNullable(ctrLoanContVO).orElseThrow(() -> new BizException("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u8d37\u6b3e\u5408\u540c\u4e3a\u7a7a!!!"));
            LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            Optional.ofNullable(lmtPrdContVO).orElseThrow(() -> new BizException("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u989d\u5ea6\u4e3a\u7a7a!!!"));
            NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            Optional.ofNullable(nlsCreditInfoVO).orElseThrow(() -> new BizException("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a!!!"));
            PrdInfoVO proInfo = this.nlsPublicService.getProInfo(nlsApplyInfoVO.getPrdId());
            Optional.ofNullable(proInfo).orElseThrow(() -> new BizException("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u4ea7\u54c1\u4e3a\u7a7a!!!"));
            CusIndivVO cusIndivVO = new CusIndivVO();
            cusIndivVO.setCusId(nlsApplyInfoVO.getCusId());
            cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
            Optional.ofNullable(cusIndivVO).orElseThrow(() -> new BizException("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a!!!"));
            try {
                PsdLoanReleaseRespBean respLoanReleaseBean = null;
                RespLoanRepayResultQryBean respLoanRepayResultQryBean = this.getRespLoanRepayResultQryBean(nlsApplyInfoVO);
                String qrySt = respLoanRepayResultQryBean.getQrySt();
                if (!SedNlsEnum.QuerySts.WITHOUT.getValue().equals(qrySt)) break block11;
                respLoanReleaseBean = this.callLoanRelease(nlsApplyInfoVO, ctrLoanContVO, proInfo, lmtPrdContVO, cusIndivVO, nlsCreditInfoVO);
                this.updateLoanReleaseStatus(nlsApplyInfoVO, respLoanReleaseBean.getLoanNo(), respLoanReleaseBean.getDistrNo());
                this.updateLmtTerm(nlsApplyInfoVO);
                try {
                    this.psdSyncLoanInfoService.doExecute(nlsProcessBizVo, nlsApplyInfoVO);
                }
                catch (Exception e) {
                    this.logger.error("\u653e\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + nlsApplyInfoVO.getApplySeq() + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getGlobalSerno() + "\u3011\uff0c\u6210\u529f\u8fd8\u6b3e\u540e\u6267\u884c\u540c\u6b65\u4efb\u52a1\u5931\u8d25\uff01");
                    throw new LoanRepaySyncException("\u653e\u6b3e\u540e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                }
            }
            catch (LoanReleaseException e) {
                this.logger.error(Arrays.toString(e.getStackTrace()));
                this.setException(nlsProcessBizVo, (Exception)((Object)e));
                this.logger.error("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u6d41\u7a0b\u672a\u6267\u884c\u6210\u529f\u3011 \u8f6c\u4e3a\u66f4\u65b0\u8865\u507f\u4efb\u52a1\u5904\u7406!!!" + (Object)((Object)e));
            }
            catch (LoanRepaySyncException e) {
                this.logger.error(Arrays.toString(e.getStackTrace()));
                this.setException(nlsProcessBizVo, (Exception)((Object)e));
                this.logger.error("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u6d41\u7a0b\u672a\u6267\u884c\u6210\u529f\u3011 \u8f6c\u4e3a\u540c\u6b65\u4efb\u52a1\u5904\u7406!!!" + (Object)((Object)e));
            }
            catch (Exception e) {
                this.logger.error(Arrays.toString(e.getStackTrace()));
                nlsApplyInfoVO.setDnSts(NO_DATA);
                this.setException(nlsProcessBizVo, e);
                this.logger.error("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u9047\u5230\u672a\u77e5\u5f02\u5e38!!!" + e);
            }
            finally {
                this.logger.info("======>\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u670d\u52a1\u3011\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
            }
        }
    }

    private void setException(NlsProcessBizVO nlsProcessBizVo, Exception e) {
        nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
        nlsProcessBizVo.setRefuseMsg(e.getMessage());
        nlsProcessBizVo.setExceptionMsg(e);
        this.setNlsProcessException(nlsProcessBizVo, e);
    }

    public RespLoanRepayResultQryBean getRespLoanRepayResultQryBean(NlsApplyInfoVO nlsApplyInfoVO) throws ESBException, InterruptedException {
        ReqLoanRepayResultQryBean reqLoanRepayResultQryBean = new ReqLoanRepayResultQryBean();
        reqLoanRepayResultQryBean.setTxnGlblSrlNo(nlsApplyInfoVO.getGlobalSerno());
        reqLoanRepayResultQryBean.setCnlTp(nlsApplyInfoVO.getCnlTp());
        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.loanRepayResultQryService, (Object)reqLoanRepayResultQryBean, this.nlsQueueSoltComnService);
        RespLoanRepayResultQryBean respLoanRepayResultQryBean = (RespLoanRepayResultQryBean)esbInvokeWrapper.invoke3Threes();
        Objects.requireNonNull(respLoanRepayResultQryBean, "\u666e\u7a0e\u8d37\u8c03\u7528\u4e92\u8054\u7f51\u91d1\u878d\u5e73\u53f0\u653e\u6b3e\u67e5\u8be2\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a!!!");
        return respLoanRepayResultQryBean;
    }

    private CtrLoanContVO getCtrLoanContVO(NlsApplyInfoVO nlsApplyInfoVO) {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(nlsApplyInfoVO.getApplySeq());
        ctrLoanContVO.setContType("02");
        ctrLoanContVO = this.ctrLoanContService.qryBySernoAndContTyp(ctrLoanContVO);
        return ctrLoanContVO;
    }

    private void setNlsProcessException(NlsProcessBizVO nlsProcessBizVo, Exception e) {
        nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
        nlsProcessBizVo.setRefuseMsg(e.getMessage());
    }

    public void recoverAmt(NlsApplyInfoVO nlsApplyInfoVO, LmtPrdContVO lmtPrdContVO) throws LoanReleaseException {
        this.updateLmtPrdContService.recoverLmtPro(nlsApplyInfoVO.getLmtApplySeq(), nlsApplyInfoVO.getApplySeq());
    }

    private void updateLmtAmt(NlsApplyInfoVO nlsApplyInfoVO, LmtPrdContVO lmtPrdContVO) throws OcmSystemException {
        List applySeqs = this.updateLmtPrdContService.getApplySeqList(nlsApplyInfoVO.getLmtApplySeq());
        BigDecimal occAmt = this.updateLmtPrdContService.getOccAmt(applySeqs);
        BigDecimal preOccAmt = this.updateLmtPrdContService.getPreOccAmt(nlsApplyInfoVO.getLmtApplySeq());
        lmtPrdContVO.setOccAmt(occAmt.add(preOccAmt));
        lmtPrdContVO.setPreOccAmt(BigDecimal.ZERO);
        lmtPrdContVO.setAvailAmt(lmtPrdContVO.getLmtAmt().subtract(occAmt.add(preOccAmt)));
        int result = 0;
        try {
            result = this.lmtPrdContService.updateByPk(lmtPrdContVO);
        }
        catch (Exception e) {
            throw new OcmSystemException("\u3010\u666e\u7a0e\u8d37\u3011\u653e\u6b3e\u63d2\u69fd \u989d\u5ea6\u5360\u7528\u5931\u8d25!!!");
        }
        if (result != 1) {
            throw new OcmSystemException("\u3010\u666e\u7a0e\u8d37\u3011\u653e\u6b3e\u63d2\u69fd \u989d\u5ea6\u5360\u7528\u5931\u8d25!!!");
        }
    }

    private void updateLoanReleaseStatus(NlsApplyInfoVO nlsApplyInfoVO, String loanNo, String distrNo) throws LoanReleaseException {
        String msg = "\u66f4\u65b0\u7528\u4fe1\u7533\u8bf7\u8868 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u66f4\u65b0 \u653e\u6b3e\u72b6\u6001 \u8d37\u6b3e\u53f7 \u53d1\u653e\u53f7,\u653e\u6b3e\u72b6\u6001,\u653e\u6b3e\u91d1\u989d\u5931\u8d25!!!";
        nlsApplyInfoVO.setDnSts("6");
        String amoutOfLoan = nlsApplyInfoVO.getApplyAmt().setScale(2, 4).toString();
        nlsApplyInfoVO.setAmountOfLoan(amoutOfLoan);
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u6210\u529f");
        nlsApplyInfoVO.setLoanNo(loanNo);
        nlsApplyInfoVO.setDistrNo(distrNo);
        nlsApplyInfoVO.setExecuteTime(0);
        nlsApplyInfoVO.setRefuseCause("");
        int result = 0;
        try {
            result = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(msg);
            }
            this.logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1", (Throwable)e);
            throw new LoanReleaseException("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1");
        }
        if (result != 1) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(msg);
            }
            this.logger.error("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1");
            throw new LoanReleaseException("\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u653e\u6b3e\u5931\u8d25 \u6267\u884c\u653e\u6b3e\u8865\u507f\u4efb\u52a1");
        }
    }

    private void updateNlsApplyInfo(NlsApplyInfoVO nlsApplyInfoVO) throws LoanReleaseException {
        nlsApplyInfoVO.setDnSts(NO_DATA);
        nlsApplyInfoVO.setNlsApplyState(NlsApplyInfoEnums.NlsApplyState.REJECT.getValue());
        nlsApplyInfoVO.setFlowStatus("\u653e\u6b3e\u5931\u8d25");
        int result = 0;
        try {
            result = this.nlsApplyInfoService.updateByPk(nlsApplyInfoVO);
        }
        catch (Exception e) {
            throw new LoanReleaseException();
        }
        if (result != 1) {
            throw new LoanReleaseException();
        }
    }

    private PsdLoanReleaseRespBean callLoanRelease(NlsApplyInfoVO nlsApplyInfoVO, CtrLoanContVO ctrLoanContVO, PrdInfoVO proInfo, LmtPrdContVO lmtPrdContVO, CusIndivVO cusIndivVO, NlsCreditInfoVO nlsCreditInfoVO) throws OcmSystemException, LoanReleaseException {
        PsdLoanReleaseReqBean reqLoanReleaseBean = new PsdLoanReleaseReqBean();
        try {
            String cusId = cusIndivVO.getSelfCusId();
            String loanCcy = SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"CurType", (String)nlsApplyInfoVO.getLoanCcy());
            String repayMethod = SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"RepayMode", (String)nlsApplyInfoVO.getRepayMethod());
            BigDecimal rateY = nlsApplyInfoVO.getLoanRate().setScale(4, 4);
            BigDecimal applyAmt = nlsApplyInfoVO.getApplyAmt().setScale(2, 4);
            String loanTerm = nlsApplyInfoVO.getLoanTerm();
            Objects.requireNonNull(loanTerm, "\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u8868 \u671f\u9650 \u4e3a\u7a7a!!!");
            String loanTermType = nlsApplyInfoVO.getLoanTermType();
            Objects.requireNonNull(loanTermType, "\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u7528\u4fe1\u7533\u8bf7\u4fe1\u606f\u8868 \u671f\u9650\u7c7b\u578b \u4e3a\u7a7a!!!");
            String contNo = ctrLoanContVO.getContNo();
            Objects.requireNonNull(contNo, "\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u8d37\u6b3e\u5408\u540c\u8868 \u53d6\u6388\u4fe1\u5408\u540c \u4e3a\u7a7a!!!");
            String repaymentPeriod = nlsApplyInfoVO.getRepaymentPeriod();
            Objects.requireNonNull(repaymentPeriod, "\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u989d\u5ea6\u4fe1\u606f\u8868 \u8fd8\u6b3e\u5468\u671f \u4e3a\u7a7a!!!");
            String repaymentDayType = nlsApplyInfoVO.getRepaymentPeriodType();
            Objects.requireNonNull(repaymentDayType, "\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25-\u83b7\u53d6\u653e\u6b3e\u4fe1\u606f\u5931\u8d25\u3011\u6765\u6e90\u989d\u5ea6\u4fe1\u606f\u8868 \u8fd8\u6b3e\u5468\u671f\u5355\u4f4d\u7c7b\u578b \u4e3a\u7a7a!!!");
            BigDecimal rateRadio = BigDecimal.ZERO;
            reqLoanReleaseBean.setClntNo(cusId);
            String ifpProduct = PsdConstantSet.HJ_PSD_PRD_TYPE;
            reqLoanReleaseBean.setProdType(ifpProduct);
            reqLoanReleaseBean.setPrjNo(lmtPrdContVO.getLmtApplySeq());
            reqLoanReleaseBean.setCurrCd(loanCcy);
            reqLoanReleaseBean.setContrAmt(Double.valueOf(applyAmt.doubleValue()));
            reqLoanReleaseBean.setRpyMd(repayMethod);
            reqLoanReleaseBean.setIntSetlFrqcy(repaymentDayType.concat(repaymentPeriod));
            reqLoanReleaseBean.setLoanTrm(loanTerm);
            reqLoanReleaseBean.setTrmType(loanTermType);
            reqLoanReleaseBean.setIntSetlDt(Objects.isNull(proInfo.getInteDay()) ? "21" : proInfo.getInteDay());
            reqLoanReleaseBean.setComIntRate(Double.valueOf(Optional.ofNullable(rateY).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100")).doubleValue()));
            reqLoanReleaseBean.setComIntRateFltIntPrt(Double.valueOf(Optional.ofNullable(rateRadio).orElse(BigDecimal.ZERO).multiply(new BigDecimal("100").setScale(2, 4)).doubleValue()));
            reqLoanReleaseBean.setCrdtContrNo(contNo);
            reqLoanReleaseBean.setMblNo(nlsApplyInfoVO.getMobile());
            reqLoanReleaseBean.setNxtIntSetlDt("");
            reqLoanReleaseBean.setTxnBrId(nlsCreditInfoVO.getNlsOperOrgid());
            PsdLoanReleaseReqBean.IntSetInfArry intSetInf1 = new PsdLoanReleaseReqBean.IntSetInfArry();
            intSetInf1.setAcctCtgry("01");
            intSetInf1.setAmtType("PF");
            intSetInf1.setBlgAcctCl("PAY");
            intSetInf1.setBlgAcctCurrCd(loanCcy);
            intSetInf1.setBlgAcctNo(nlsApplyInfoVO.getDnAccount());
            intSetInf1.setBlgAcctProdType(ifpProduct);
            intSetInf1.setBlgMth("R");
            intSetInf1.setBlgAcctBnkNo(nlsApplyInfoVO.getBankId());
            intSetInf1.setOwnOthrBankflg(Optional.ofNullable(nlsApplyInfoVO.getBankName()).orElse("").contains("\u5e7f\u5dde\u94f6\u884c") ? "1" : "2");
            PsdLoanReleaseReqBean.IntSetInfArry intSetInf2 = new PsdLoanReleaseReqBean.IntSetInfArry();
            intSetInf2.setAcctCtgry("01");
            intSetInf2.setAmtType("PF");
            intSetInf2.setBlgAcctCl("AUT");
            intSetInf2.setBlgAcctCurrCd(loanCcy);
            intSetInf2.setBlgAcctNo(nlsApplyInfoVO.getRecvAcctNo());
            intSetInf2.setBlgAcctProdType(ifpProduct);
            intSetInf2.setBlgMth("R");
            reqLoanReleaseBean.getIntSetInfArry().add(intSetInf1);
            reqLoanReleaseBean.getIntSetInfArry().add(intSetInf2);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OcmSystemException("\u3010\u666e\u7a0e\u8d37\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011\u8c03\u7528\u5f00\u7acb\u53d1\u653e\u7cfb\u7edf\u8f6c\u5316\u503c\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        return this.psdHjLoanReleaseService.applyPsdLoanRelease(reqLoanReleaseBean, nlsApplyInfoVO);
    }

    @Deprecated
    private void insertOrUpdateAccLoan(NlsApplyInfoVO nlsApplyInfoVO, String distrNo, String loanNo) throws OcmSystemException {
        int result = 0;
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setBillNo(nlsApplyInfoVO.getApplySeq());
        accLoanVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
        accLoanVO.setDistrNo(distrNo);
        accLoanVO.setLoanSeq(loanNo);
        try {
            result = this.accLoanService.insertOrUpdateByPk(accLoanVO);
            if (result != 1) {
                throw new OcmSystemException("\u3010\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u751f\u6210\u501f\u636e\u5931\u8d25!!!");
            }
        }
        catch (Exception e) {
            throw new OcmSystemException("\u3010\u653e\u6b3e\u63d2\u69fd\u6267\u884c\u5931\u8d25\u3011 \u751f\u6210\u501f\u636e\u5931\u8d25!!!");
        }
    }

    public void updateLmtTerm(NlsApplyInfoVO nlsApplyInfoVO) {
    }
}

