/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.apply;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.constant.TimeType;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.MessageRuleCheckUtil;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.UUIDUtil;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.service.facade.SOrgService;
import com.irdstudio.efp.console.service.vo.SOrgVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizDetailVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.ImageBizDetailService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdCertUploadService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContResult;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.psd.PsdSqsSignatureService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.SoltServiceImpl;
import com.irdstudio.efp.nls.service.impl.ctrloancont.ctr.PsdApplyCtrLoanCtr;
import com.irdstudio.efp.nls.service.impl.psd.apply.bean.SignContractBean;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.signature.SignatureRecordVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdSignContractService")
public class PsdSignContractServiceImpl
extends SoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(PsdSignContractServiceImpl.class);
    private boolean Flag = false;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="psdCertUploadService")
    private PsdCertUploadService certUploadService;
    @Autowired
    @Qualifier(value="sOrgService")
    private SOrgService sOrgService;
    @Autowired
    private PsdApplyCtrLoanCtr psdApplyCtrLoanCtr;
    @Autowired
    private PsdContService psdContService;
    @Autowired
    private ImageBizDetailService imageBizDetailService;
    @Autowired
    private PsdSqsSignatureService sqsSignatureService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsApplyInfoVO nlsApplyInfoVO) throws Exception {
        String applySeq = nlsApplyInfoVO.getApplySeq();
        try {
            logger.info("======>\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
            NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
            nlsCreditInfoVO.setLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
            nlsCreditInfoVO = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
            Optional.ofNullable(nlsCreditInfoVO).orElseThrow(() -> new OcmSystemException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u4e0d\u5b58\u5728\u6388\u4fe1"));
            JSONObject signContractJson = (JSONObject)nlsApplyInfoVO.getSignContractBean();
            SignContractBean signContractBean = new SignContractBean();
            CusIndivVO cusIndivVO = null;
            CfcaSignInfoVO cfcaSignInfoVO = null;
            if (Objects.isNull(signContractJson)) {
                cusIndivVO = new CusIndivVO();
                cusIndivVO.setCusId(nlsCreditInfoVO.getCusId());
                cusIndivVO = signContractBean.getCusIndivVO(this.cusIndivService, cusIndivVO);
                cfcaSignInfoVO = new CfcaSignInfoVO();
                cfcaSignInfoVO.setApplySeq(applySeq);
                cfcaSignInfoVO = signContractBean.getCfcaSignInfoVO(this.cfcaSignInfoService, cfcaSignInfoVO);
            } else {
                cusIndivVO = (CusIndivVO)signContractJson.getObject("cusIndivVO", CusIndivVO.class);
                cfcaSignInfoVO = (CfcaSignInfoVO)signContractJson.getObject("cfcaSignInfoVO", CfcaSignInfoVO.class);
                signContractBean.setCusIndivVO(cusIndivVO);
                signContractBean.setCfcaSignInfoVO(cfcaSignInfoVO);
                nlsApplyInfoVO.setSignContractBean((Object)signContractBean);
            }
            if ((cusIndivVO == null || StringUtils.isEmpty((CharSequence)cusIndivVO.getAxqUsrId())) && logger.isErrorEnabled()) {
                logger.error("\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u901a\u8fc7\u3010" + nlsApplyInfoVO.getCusId() + "\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a \u6216 \u5b89\u5fc3\u7b7e\u7528\u6237\u53f7\u4e3a\u7a7a \u8bf7\u6838\u67e5!!!");
                throw new OcmSystemException("\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsApplyInfoVO.getApplySeq() + "\u3011\u901a\u8fc7\u3010" + nlsApplyInfoVO.getCusId() + "\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a \u6216 \u5b89\u5fc3\u7b7e\u7528\u6237\u53f7\u4e3a\u7a7a  \u8bf7\u6838\u67e5!!!");
            }
            if (Objects.isNull(cfcaSignInfoVO)) {
                Map<String, String> ctrLoanContMetaData = this.psdApplyCtrLoanCtr.getCtrLoanContMetaData(nlsCreditInfoVO, this.getSOrg(nlsCreditInfoVO.getNlsOperOrgid()), nlsApplyInfoVO);
                this.insertTmSignRecord(nlsApplyInfoVO, ctrLoanContMetaData);
                PsdContResult psdContResult = this.psdContService.signature(nlsApplyInfoVO.getGlobalSerno(), nlsApplyInfoVO.getApplySeq(), cusIndivVO.getAxqUsrId(), "dkcont.pdf", "\u4e2a\u4eba\u501f\u6b3e\u5408\u540c", ctrLoanContMetaData);
                if (!psdContResult.isRetFlag()) {
                    if (logger.isErrorEnabled()) {
                        logger.error("\u3010\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u5408\u540c\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + psdContResult.getMsg());
                    }
                    throw new OcmSystemException(psdContResult.getMsg());
                }
                this.insertCfcaSignInfo(nlsCreditInfoVO, psdContResult, "02", applySeq, cfcaSignInfoVO, signContractBean, nlsApplyInfoVO);
                this.updateCtrContInfo(applySeq, "02");
            } else {
                int result;
                CfcaSignInfoVO selectCfcaSignInfo = this.cfcaSignInfoService.queryByPk(cfcaSignInfoVO);
                if (selectCfcaSignInfo == null && (result = this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO)) < 0) {
                    if (logger.isErrorEnabled()) {
                        logger.error("\u3010\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165CFCA\u4fe1\u606f\u8868\u51fa\u9519\uff01 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + nlsApplyInfoVO.getApplySeq());
                    }
                    throw new OcmSystemException("\u3010\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165CFCA\u4fe1\u606f\u8868\u51fa\u9519\uff01");
                }
            }
            cfcaSignInfoVO = signContractBean.getCfcaSignInfoVO();
            if (StringUtil.isEmpty((String)signContractBean.getFilePath()) && StringUtils.isNotEmpty((CharSequence)cfcaSignInfoVO.getCfcaContNo()) && ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname().equals(cfcaSignInfoVO.getCfcaSignState())) {
                PsdContResult psdContResult = this.psdContService.downSignFile(nlsApplyInfoVO.getApplySeq(), cfcaSignInfoVO.getCfcaContNo(), nlsApplyInfoVO.getApplySeq() + "_dkcont.pdf");
                if (!psdContResult.isRetFlag() && logger.isErrorEnabled()) {
                    logger.error("\u3010\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + psdContResult.getMsg());
                    throw new OcmSystemException("\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + applySeq + " \u6267\u884c\u5408\u540c\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a" + psdContResult.getMsg());
                }
                signContractBean.setFilePath(psdContResult.getFileFullPath());
                this.insertCert(nlsApplyInfoVO, signContractBean);
                this.insertImageBizDetail(nlsApplyInfoVO, PsdConstantSet.PSD_YX_CONT_TYPE, FilenameUtils.getBaseName((String)psdContResult.getFileFullPath()), psdContResult.getFileFullPath());
            } else if (StringUtils.isNotEmpty((CharSequence)signContractBean.getFilePath())) {
                this.insertCert(nlsApplyInfoVO, signContractBean);
            }
            nlsApplyInfoVO.setFlowStatus("\u8d37\u6b3e\u5f00\u7acb\u53d1\u653e\u524d");
        }
        catch (Exception e) {
            logger.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg((Exception)new OcmSystemException((Throwable)e));
        }
        finally {
            logger.info("======>\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
        }
    }

    private void insertCert(NlsApplyInfoVO nlsApplyInfoVO, SignContractBean signContractBean) throws OcmSystemException {
        int result = this.certUploadService.insert(signContractBean.getFilePath());
        if (result != 1) {
            if (logger.isErrorEnabled()) {
                logger.error("\u3010\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165\u4e0a\u4f20\u4fe1\u606f\u8868\u51fa\u9519\uff01 \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:" + nlsApplyInfoVO.getApplySeq());
            }
            throw new OcmSystemException("\u3010\u666e\u7a0e\u8d37\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u91cd\u8dd1\u65f6 \u63d2\u5165\u4e0a\u4f20\u4fe1\u606f\u8868\u51fa\u9519\uff01");
        }
    }

    private CusIndivVO getCustInfo(String cusId) throws OcmSystemException {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setCusId(cusId);
        cusIndivVO = this.cusIndivService.queryByPk(cusIndivVO);
        if (Objects.isNull(cusIndivVO)) {
            throw new OcmSystemException("\u6839\u636e\u5ba2\u6237\u53f7\uff1a" + cusId + "\uff0c\u67e5\u8be2\u5230\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return cusIndivVO;
    }

    private String getContNo(String applySeq, String contType) throws OcmSystemException {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(applySeq);
        ctrLoanContVO.setContType(contType);
        ctrLoanContVO = this.ctrLoanContService.qryBySernoAndContTyp(ctrLoanContVO);
        if (Objects.isNull(ctrLoanContVO)) {
            logger.error("\u666e\u7a0e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            throw new OcmSystemException("\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String ctrContNo = ctrLoanContVO.getContNo();
        if (StringUtil.isNullorBank((String)ctrContNo)) {
            logger.error("\u666e\u7a0e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5408\u540c\u4fe1\u606f\uff0c\u5f97\u5230\u7684\u5408\u540c\u53f7\u4e3a\u7a7a\uff01");
            throw new OcmSystemException("\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5408\u540c\u4fe1\u606f\uff0c\u5f97\u5230\u7684\u5408\u540c\u53f7\u4e3a\u7a7a\uff01");
        }
        return ctrContNo;
    }

    private void insertCfcaSignInfo(NlsCreditInfoVO nlsCreditInfoVO, PsdContResult psdContResult, String contType, String applySeq, CfcaSignInfoVO cfcaSignInfoVO, SignContractBean signContractBean, NlsApplyInfoVO nlsApplyInfoVO) throws OcmSystemException {
        String contNo = this.getContNo(applySeq, contType);
        if (logger.isInfoEnabled()) {
            logger.info("======>\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u4fdd\u5b58\u5408\u540c\u7b7e\u7ae0\u8bb0\u5f55\u4fe1\u606f\u5f00\u59cb<===== \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + applySeq + " \u5408\u540c\u53f7\u4e3a\uff1a" + contNo);
        }
        cfcaSignInfoVO = Optional.ofNullable(cfcaSignInfoVO).orElse(new CfcaSignInfoVO());
        cfcaSignInfoVO.setApplySeq(applySeq);
        cfcaSignInfoVO.setPrdId(nlsCreditInfoVO.getPrdId());
        cfcaSignInfoVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        cfcaSignInfoVO.setPrdName(nlsCreditInfoVO.getPrdName());
        cfcaSignInfoVO.setContNo(contNo);
        cfcaSignInfoVO.setCfcaContNo(psdContResult.getAxqContNo());
        cfcaSignInfoVO.setCusId(nlsCreditInfoVO.getCusId());
        cfcaSignInfoVO.setCusName(nlsCreditInfoVO.getCusName());
        cfcaSignInfoVO.setPrdType(nlsCreditInfoVO.getChannelNo());
        cfcaSignInfoVO.setNlsOperOrgid(nlsCreditInfoVO.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperUserid(nlsCreditInfoVO.getNlsOperUserid());
        cfcaSignInfoVO.setFinaBrId(nlsCreditInfoVO.getNlsOperOrgid());
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        signContractBean.setCfcaSignInfoVO(cfcaSignInfoVO);
        nlsApplyInfoVO.setSignContractBean((Object)signContractBean);
        cfcaSignInfoVO.setCfcaSignTime(psdContResult.getAxqSignTime());
        int num = this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
        if (num < 0) {
            if (logger.isErrorEnabled()) {
                logger.error("\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a: " + applySeq + "\u5408\u540c\u53f7\u4e3a\uff1a" + contNo + " \u5f80cfca\u52a0\u7b7e\u4fe1\u606f\u8868\u65b0\u589e\u6570\u636e\u51fa\u9519!");
            }
            throw new OcmSystemException("\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a: " + applySeq + "\u5408\u540c\u53f7\u4e3a\uff1a" + contNo + " \u5f80cfca\u52a0\u7b7e\u4fe1\u606f\u8868\u65b0\u589e\u6570\u636e\u51fa\u9519!");
        }
        if (logger.isInfoEnabled()) {
            logger.info("======>\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u4fdd\u5b58\u5408\u540c\u7b7e\u7ae0\u8bb0\u5f55\u4fe1\u606f\u7ed3\u675f<===== \u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a" + applySeq + " \u5408\u540c\u53f7\u4e3a\uff1a" + contNo);
        }
    }

    private void updateCtrContInfo(String applySeq, String contType) throws OcmSystemException {
        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
        ctrLoanContVO.setSerno(applySeq);
        ctrLoanContVO.setContType(contType);
        ctrLoanContVO = this.ctrLoanContService.qryBySernoAndContTyp(ctrLoanContVO);
        if (Objects.isNull(ctrLoanContVO)) {
            logger.error("\u666e\u7a0e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
            throw new OcmSystemException("\u666e\u7a0e\u8d37\u7528\u4fe1\u7533\u8bf7\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u83b7\u53d6\u5230\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ctrLoanContVO.setContState("200");
        int result = this.ctrLoanContService.updateByPk(ctrLoanContVO);
        if (result != 1) {
            logger.error("\u666e\u7a0e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u66f4\u65b0\u5408\u540c\u4fe1\u606f\u4e3a\u5df2\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38\uff01");
            throw new OcmSystemException("\u666e\u7a0e\u8d37\u3010\u5408\u540c\u7b7e\u8ba2\u670d\u52a1\u3011\u901a\u8fc7\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3001\u5408\u540c\u7c7b\u578b\u66f4\u65b0\u5408\u540c\u4fe1\u606f\u4e3a\u5df2\u7b7e\u8ba2\u51fa\u73b0\u5f02\u5e38");
        }
    }

    private void updCfcaSignInfo(String contNo) throws OcmSystemException {
        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
        cfcaSignInfoVO.setContNo(contNo);
        cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(cfcaSignInfoVO);
        if (Objects.isNull(cfcaSignInfoVO)) {
            if (logger.isErrorEnabled()) {
                logger.error("\u8c03\u7528cfca\u5173\u952e\u5b57\u7b7e\u7f72\u63a5\u53e3\u30103207\u3011\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u67e5\u8be2\u5230\u7684cfca\u52a0\u7b7e\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            throw new OcmSystemException("\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u67e5\u8be2\u5230\u7684cfca\u52a0\u7b7e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        int result = this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
        if (result != 1) {
            if (logger.isErrorEnabled()) {
                logger.error("\u8c03\u7528cfca\u5173\u952e\u5b57\u7b7e\u7f72\u63a5\u53e3\u30103207\u3011\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u66f4\u65b0cfca\u52a0\u7b7e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            throw new OcmSystemException("\u8c03\u7528cfca\u5173\u952e\u5b57\u7b7e\u7f72\u63a5\u53e3\u30103207\u3011\u6839\u636e\u5408\u540c\u53f7\u3010" + contNo + "\u3011\uff0c\u66f4\u65b0cfca\u52a0\u7b7e\u4fe1\u606f\u5931\u8d25");
        }
    }

    private SOrgVO getSOrg(String orgCode) throws OcmSystemException {
        SOrgVO sOrgVO = new SOrgVO();
        sOrgVO.setOrgCode(orgCode);
        sOrgVO = this.sOrgService.queryByPk(sOrgVO);
        if (Objects.isNull(sOrgVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u673a\u6784\u53f7\u3010" + orgCode + "\u3011\uff0c\u83b7\u53d6\u5230\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return sOrgVO;
    }

    private LmtPrdContVO getLmtPrdCont(String lmtApplySeq) throws OcmSystemException {
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
        if (Objects.isNull(lmtPrdContVO)) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (null == lmtPrdContVO.getLmtAmt()) {
            throw new OcmSystemException("\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a\uff01");
        }
        return lmtPrdContVO;
    }

    private String getDateString(String date, String dateType) throws OcmSystemException {
        if (!this.Flag) {
            try {
                MessageRuleCheckUtil.checkDate((String)"\u6388\u4fe1\u6709\u6548\u65e5\u671f", (String)date, (String)"yyyy-MM-dd");
                this.Flag = true;
            }
            catch (BizException e) {
                throw new OcmSystemException("\u7ec4\u88c5\u5408\u540c\u53c2\u6570\u65f6\uff0c\u6821\u9a8c\u5230\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u8868\u7684\u6709\u6548\u65e5\u671f\u4e0d\u7b26\u5408\u683c\u5f0f\u201cyyyy-MM-dd\u201d");
            }
        }
        String result = "";
        String[] dates = date.split("-");
        if (TimeType.YEAR.getKey().equals(dateType)) {
            result = dates[0];
        } else if (TimeType.MONTH.getKey().equals(dateType)) {
            result = dates[1];
        } else if (TimeType.DAY.getKey().equals(dateType)) {
            result = dates[2];
        }
        return result;
    }

    private void insertImageBizDetail(NlsApplyInfoVO nlsApplyInfoVO, String imgType, String fileName, String filePath) {
        ImageBizDetailVO imageBizDetail = new ImageBizDetailVO();
        imageBizDetail.setApplySeq(nlsApplyInfoVO.getApplySeq());
        imageBizDetail.setBizStage("\u7528\u4fe1\u5408\u540c");
        imageBizDetail.setFileDesc("\u666e\u7a0e\u8d37\u7528\u4fe1\u5408\u540c");
        imageBizDetail.setFileName(fileName);
        imageBizDetail.setFilePath(filePath);
        imageBizDetail.setImageId(imgType);
        imageBizDetail.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizDetail.setImageType(imgType);
        this.imageBizDetailService.insertImageBizDetail(imageBizDetail);
    }

    private void insertTmSignRecord(NlsApplyInfoVO nlsApplyInfoVO, Map<String, String> ctrLoanContMetaData) {
        SignatureRecordVO tmSignatureRecordVO = new SignatureRecordVO();
        tmSignatureRecordVO.setId(UUIDUtil.getUUID());
        tmSignatureRecordVO.setPrdId("XD050300601");
        tmSignatureRecordVO.setApplySeq(nlsApplyInfoVO.getApplySeq());
        tmSignatureRecordVO.setLinkType(Integer.valueOf(4));
        tmSignatureRecordVO.setPolFileType(PsdConstantSet.PSD_YX_CONT_TM_TYPE);
        tmSignatureRecordVO.setRetryNum(Integer.valueOf(0));
        tmSignatureRecordVO.setCreateTime(new Date());
        tmSignatureRecordVO.setLastUpdateTime(new Date());
        tmSignatureRecordVO.setSiuSta(Integer.valueOf(0));
        tmSignatureRecordVO.setSiuFillInfo(JSONObject.toJSONString(ctrLoanContMetaData));
        this.sqsSignatureService.insertRecord(tmSignatureRecordVO);
    }
}

