/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.credit;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.RandomCodeUtils;
import com.irdstudio.efp.console.service.facade.PtProductUserService;
import com.irdstudio.efp.console.service.vo.PtProductUserVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.service.bo.req.frontsystem.MobileBankInfoReqBean;
import com.irdstudio.efp.esb.service.bo.req.ydxxzf.GeneratorOrderReqBean;
import com.irdstudio.efp.esb.service.bo.resp.frontsystem.MobileBankInfoRespBean;
import com.irdstudio.efp.esb.service.bo.resp.ydxxzf.GeneratorOrderRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.frontsystem.MobileBankInfoService;
import com.irdstudio.efp.esb.service.facade.ydxxzf.GeneratorOrderService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.psd.PreNlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.psd.PsdSqsSignatureService;
import com.irdstudio.efp.nls.service.facade.psd.PsdTaskReqInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.psd.PreNlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.psd.PsdTaskReqInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdAllotTaskHandleService")
public class PsdAllotTaskHandleServiceImpl
extends CreditSoltServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(PsdAllotTaskHandleServiceImpl.class);
    @Autowired
    @Qualifier(value="preNlsCreditInfoService")
    private PreNlsCreditInfoService preNlsCreditInfoService;
    @Autowired
    @Qualifier(value="psdTaskReqInfoService")
    private PsdTaskReqInfoService psdTaskReqInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="generatorOrderService")
    private GeneratorOrderService generatorOrderService;
    @Autowired
    @Qualifier(value="ptProductUserService")
    private PtProductUserService ptProductUserService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    @Qualifier(value="psdSqsSignatureService")
    private PsdSqsSignatureService psdSqsSignatureService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    private MobileBankInfoService mobileBankInfoService;
    @Autowired
    private NlsQueueSoltComnService nlsQueueSoltComnService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        try {
            this.logger.info("======>\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
            PreNlsCreditInfoVO preNlsCreditInfo = new PreNlsCreditInfoVO();
            preNlsCreditInfo.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            PreNlsCreditInfoVO preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfo);
            Optional.ofNullable(preNlsCreditInfoVO).orElseThrow(() -> new BizException("\u4efb\u52a1\u5904\u7406\u9636\u6bb5 \u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f"));
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
            Optional.ofNullable(lmtPrdContVO).orElseThrow(() -> new BizException("\u4efb\u52a1\u5904\u7406\u9636\u6bb5 \u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u989d\u5ea6\u4fe1\u606f"));
            if (preNlsCreditInfoVO != null) {
                GeneratorOrderRespBean generatorOrderRespBean = null;
                String serno = "WX" + DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()) + RandomCodeUtils.generateNumber((int)4);
                this.logger.info("\u51c6\u5907\u521b\u5efa\u5de5\u5355\u7684\u5de5\u5355\u53f7\u4e3a\uff1a{}", (Object)serno);
                try {
                    generatorOrderRespBean = this.invokerGeneratorTask(nlsCreditInfoVO, preNlsCreditInfoVO, serno, lmtPrdContVO);
                    if (!EsbBizEnums.RetCodeEnum.SUCCESS.VALUE.equals(generatorOrderRespBean.getRetCd())) {
                        throw new Exception("\u8c03\u7528\u521b\u5efa\u5de5\u5355\u63a5\u53e3\u5931\u8d25");
                    }
                    this.logger.info("\u521b\u5efa\u5de5\u5355\u54cd\u5e94\u7ed3\u679c\u4e3a:{}", (Object)generatorOrderRespBean.toString());
                    this.logger.info("\u6839\u636e\u5e7f\u4fe1app\u5206\u914d\u7684\u5ba2\u6237\u7ecf\u7406\u5de5\u53f7\u67e5\u8be2\u5ba2\u6237\u7ecf\u7406\u8868");
                    PtProductUserVO ptProduceUser = this.ptProductUserService.getPtProduceByLoginName(generatorOrderRespBean.getActlHndlrId());
                    Optional.ofNullable(ptProduceUser).orElseThrow(() -> new BizException("\u4efb\u52a1\u5904\u7406\u9636\u6bb5 \u67e5\u8be2\u4e0d\u5230\u5ba2\u6237\u7ecf\u7406\u4fe1\u606f"));
                    String userId = generatorOrderRespBean.getActlHndlrId();
                    String orgId = ptProduceUser.getDeptId();
                    if ("02".equals(lmtPrdContVO.getLmtStatus())) {
                        nlsCreditInfoVO.setNlsOperOrgid(orgId);
                        nlsCreditInfoVO.setNlsOperUserid(userId);
                        nlsCreditInfoVO.setOperateAgencyUser(userId);
                        nlsCreditInfoVO.setOperateAgency(orgId);
                        LmtPrdContVO lmtPrdCont = new LmtPrdContVO();
                        lmtPrdCont.setLmtContNo(lmtPrdContVO.getLmtContNo());
                        lmtPrdCont.setMainBrId(orgId);
                        lmtPrdCont.setChargeoffBrId(orgId);
                        lmtPrdCont.setCusManager(userId);
                        int m = this.lmtPrdContService.updateByPk(lmtPrdCont);
                        if (m != 1) {
                            this.logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u6388\u4fe1\u534f\u8bae\u7f16\u53f7" + lmtPrdCont + "\u66f4\u65b0\u8bb0\u5f55" + m + "\u6761");
                            throw new Exception("\u66f4\u65b0\u5f02\u5e38");
                        }
                        CusIndivVO indivVO = new CusIndivVO();
                        indivVO.setCusId(nlsCreditInfoVO.getCusId());
                        indivVO.setCusManager(userId);
                        indivVO.setMainBrId(orgId);
                        indivVO.setPerformanceOwner(userId);
                        indivVO.setPerformanceOrg(orgId);
                        int i = this.cusIndivService.updateByPk(indivVO);
                        if (i != 1) {
                            this.logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u5ba2\u6237\u53f7" + nlsCreditInfoVO.getCusId() + "\u66f4\u65b0\u8bb0\u5f55" + i + "\u6761");
                            throw new Exception("\u66f4\u65b0\u5f02\u5e38");
                        }
                        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
                        cfcaSignInfoVO.setApplySeq(applySeq);
                        cfcaSignInfoVO.setNlsOperOrgid(orgId);
                        cfcaSignInfoVO.setNlsOperUserid(userId);
                        cfcaSignInfoVO.setFinaBrId(orgId);
                        this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
                        this.psdSqsSignatureService.updateOperInfo(applySeq, userId, orgId);
                        CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
                        ctrLoanContVO.setContNo(applySeq);
                        ctrLoanContVO.setPerformanceOwner(userId);
                        ctrLoanContVO.setPerformanceOrg(orgId);
                        ctrLoanContVO.setCusManager(userId);
                        ctrLoanContVO.setInputBrId(orgId);
                        ctrLoanContVO.setMainBrId(orgId);
                        ctrLoanContVO.setFinaBrId(orgId);
                        ctrLoanContVO.setLegalOrgCode(orgId);
                        int n = this.ctrLoanContService.updateByPk(ctrLoanContVO);
                        if (n != 1) {
                            this.logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u5408\u540c\u7f16\u53f7" + ctrLoanContVO.getContNo() + "\u66f4\u65b0\u8bb0\u5f55" + n + "\u6761");
                            throw new Exception("\u66f4\u65b0\u5f02\u5e38");
                        }
                        this.logger.info("\u5206\u914d\u5ba2\u6237\u7ecf\u7406\u5b8c\u6210\uff0c\u5f00\u59cb\u4e0b\u53d1\u77ed\u4fe1\uff0c\u4e0b\u53d1\u573a\u666f\uff1a{}", (Object)"2");
                        this.sendMsg("2", ptProduceUser, lmtPrdContVO, nlsCreditInfoVO);
                    } else {
                        nlsCreditInfoVO.setOperateAgencyUser(userId);
                        nlsCreditInfoVO.setOperateAgency(orgId);
                        this.logger.info("\u5206\u914d\u5ba2\u6237\u7ecf\u7406\u5b8c\u6210\uff0c\u5f00\u59cb\u4e0b\u53d1\u77ed\u4fe1\uff0c\u4e0b\u53d1\u573a\u666f\uff1a{}", (Object)"1");
                        this.sendMsg("1", ptProduceUser, lmtPrdContVO, nlsCreditInfoVO);
                    }
                    int k = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
                    if (k != 1) {
                        this.logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u6388\u4fe1\u6d41\u6c34\u53f7" + nlsCreditInfoVO.getLmtApplySeq() + "\u66f4\u65b0\u8bb0\u5f55" + k + "\u6761");
                        throw new Exception("\u66f4\u65b0\u5f02\u5e38");
                    }
                    this.insertTaskReqInfo(nlsCreditInfoVO, preNlsCreditInfoVO, lmtPrdContVO, generatorOrderRespBean, serno);
                }
                catch (Exception e) {
                    this.insertTaskReqInfo1(nlsCreditInfoVO, preNlsCreditInfoVO, lmtPrdContVO, serno, generatorOrderRespBean);
                    this.logger.error("\u666e\u7a0e\u8d37\u8c03\u7528\u4efb\u52a1\u5904\u7406\u63a5\u53e3\u5931\u8d25!!!");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5de5\u5355\u521b\u5efa\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.logger.info("======>\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
        }
    }

    private void insertTaskReqInfo(NlsCreditInfoVO nlsCreditInfoVO, PreNlsCreditInfoVO preNlsCreditInfoVO, LmtPrdContVO lmtPrdContVO, GeneratorOrderRespBean generatorOrderRespBean, String serno) throws BizException {
        PsdTaskReqInfoVO psdTaskReqInfoVO = new PsdTaskReqInfoVO();
        psdTaskReqInfoVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        psdTaskReqInfoVO.setOrderId(serno);
        if ("02".equals(lmtPrdContVO.getLmtStatus())) {
            if (StringUtils.isNotEmpty((CharSequence)nlsCreditInfoVO.getNlsOperUserid())) {
                psdTaskReqInfoVO.setManagerId(nlsCreditInfoVO.getNlsOperUserid());
            } else {
                psdTaskReqInfoVO.setManagerId(preNlsCreditInfoVO.getRecommenderId());
            }
            psdTaskReqInfoVO.setDeptId(nlsCreditInfoVO.getNlsOperOrgid());
            psdTaskReqInfoVO.setTaskTyp("2");
        } else {
            if (StringUtils.isNotEmpty((CharSequence)nlsCreditInfoVO.getOperateAgencyUser())) {
                psdTaskReqInfoVO.setManagerId(nlsCreditInfoVO.getOperateAgencyUser());
            } else {
                psdTaskReqInfoVO.setManagerId(preNlsCreditInfoVO.getRecommenderId());
            }
            psdTaskReqInfoVO.setDeptId(nlsCreditInfoVO.getOperateAgency());
            psdTaskReqInfoVO.setTaskTyp("1");
        }
        psdTaskReqInfoVO.setProductId("3");
        psdTaskReqInfoVO.setHandleStatus("2");
        psdTaskReqInfoVO.setUserType("5");
        psdTaskReqInfoVO.setCusName(nlsCreditInfoVO.getCusName());
        psdTaskReqInfoVO.setGender(nlsCreditInfoVO.getGender());
        psdTaskReqInfoVO.setCelPhone(nlsCreditInfoVO.getIndivMobile());
        psdTaskReqInfoVO.setIdNum(nlsCreditInfoVO.getCertCode());
        psdTaskReqInfoVO.setIdType(nlsCreditInfoVO.getCertType());
        psdTaskReqInfoVO.setCorpName(preNlsCreditInfoVO.getEnterpriseName());
        psdTaskReqInfoVO.setSocialCode(preNlsCreditInfoVO.getSocialCreditCode());
        psdTaskReqInfoVO.setAddress(preNlsCreditInfoVO.getRegistration());
        psdTaskReqInfoVO.setQuota(nlsCreditInfoVO.getApplyAmt());
        psdTaskReqInfoVO.setDueTime(lmtPrdContVO.getExpireDate());
        psdTaskReqInfoVO.setCreateStatus(Integer.valueOf(EsbBizEnums.RetCodeEnum.SUCCESS.VALUE.equals(generatorOrderRespBean.getRetCd()) ? 200 : 201));
        psdTaskReqInfoVO.setHandleResult(generatorOrderRespBean.getRetMsg());
        psdTaskReqInfoVO.setCreateMsg(generatorOrderRespBean.getRetMsg());
        psdTaskReqInfoVO.setRemark("\u666e\u7a0e\u8d37\u5de5\u5355\u521b\u5efa");
        psdTaskReqInfoVO.setGlobaNo(nlsCreditInfoVO.getGlobalSerno());
        psdTaskReqInfoVO.setCreateDate(DateUtility.getCurrDate());
        psdTaskReqInfoVO.setCreateTime(DateUtility.getCurrTime());
        psdTaskReqInfoVO.setCreateUser("admin");
        psdTaskReqInfoVO.setLastUpdateTime(new Date());
        psdTaskReqInfoVO.setLastUpdateUser("admin");
        psdTaskReqInfoVO.setWarnFlag("N");
        int result = this.psdTaskReqInfoService.insert(psdTaskReqInfoVO);
        if (result != 1) {
            this.logger.error("\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u9636\u6bb5\u63d2\u5165\u4efb\u52a1\u8868\u5931\u8d25");
            throw new BizException("\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u9636\u6bb5\u63d2\u5165\u4efb\u52a1\u8868\u5931\u8d25");
        }
    }

    private GeneratorOrderRespBean invokerGeneratorTask(NlsCreditInfoVO nlsCreditInfoVO, PreNlsCreditInfoVO preNlsCreditInfoVO, String serno, LmtPrdContVO lmtPrdContVO) throws ESBException, InterruptedException {
        GeneratorOrderReqBean generatorOrderReqBean = new GeneratorOrderReqBean();
        generatorOrderReqBean.setWrkOrdrId(serno);
        generatorOrderReqBean.setStCd("1");
        generatorOrderReqBean.setPdNo("3");
        if ("02".equals(lmtPrdContVO.getLmtStatus())) {
            generatorOrderReqBean.setBrchId(nlsCreditInfoVO.getNlsOperOrgid());
        } else {
            generatorOrderReqBean.setBrchId(nlsCreditInfoVO.getOperateAgency());
        }
        generatorOrderReqBean.setCustMgrNo(preNlsCreditInfoVO.getRecommenderId());
        generatorOrderReqBean.setCustNm(nlsCreditInfoVO.getCusName());
        generatorOrderReqBean.setGnd(nlsCreditInfoVO.getGender());
        generatorOrderReqBean.setMblNo(nlsCreditInfoVO.getIndivMobile());
        generatorOrderReqBean.setIdentNo(nlsCreditInfoVO.getCertCode());
        generatorOrderReqBean.setIdentTp(nlsCreditInfoVO.getCertType());
        generatorOrderReqBean.setEntpNm(preNlsCreditInfoVO.getEnterpriseName());
        generatorOrderReqBean.setUnfdSoclCrdtCd(preNlsCreditInfoVO.getSocialCreditCode());
        generatorOrderReqBean.setEntpRgstAddr(preNlsCreditInfoVO.getRegistration());
        generatorOrderReqBean.setUsrFlg("5");
        generatorOrderReqBean.setLoanLmt(Double.valueOf(Objects.nonNull(nlsCreditInfoVO.getApproveAmt()) ? nlsCreditInfoVO.getApproveAmt().doubleValue() : BigDecimal.ZERO.doubleValue()));
        generatorOrderReqBean.setLoanTrm(nlsCreditInfoVO.getApplyTerm());
        generatorOrderReqBean.setRemark("\u666e\u7a0e\u8d37\u5de5\u5355\u521b\u5efa");
        generatorOrderReqBean.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        return this.generatorOrderService.applyGeneratorOrder(generatorOrderReqBean, nlsCreditInfoVO);
    }

    private void insertTaskReqInfo1(NlsCreditInfoVO nlsCreditInfoVO, PreNlsCreditInfoVO preNlsCreditInfoVO, LmtPrdContVO lmtPrdContVO, String serno, GeneratorOrderRespBean generatorOrderRespBean) {
        if (Objects.nonNull(this.psdTaskReqInfoService.selectByPrimaryKey(serno))) {
            return;
        }
        PsdTaskReqInfoVO psdTaskReqInfoVO = new PsdTaskReqInfoVO();
        psdTaskReqInfoVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        psdTaskReqInfoVO.setOrderId(serno);
        if ("02".equals(lmtPrdContVO.getLmtStatus())) {
            if (StringUtils.isNotEmpty((CharSequence)nlsCreditInfoVO.getNlsOperUserid())) {
                psdTaskReqInfoVO.setManagerId(nlsCreditInfoVO.getNlsOperUserid());
            } else {
                psdTaskReqInfoVO.setManagerId(preNlsCreditInfoVO.getRecommenderId());
            }
            psdTaskReqInfoVO.setDeptId(nlsCreditInfoVO.getNlsOperOrgid());
            psdTaskReqInfoVO.setTaskTyp("2");
        } else {
            if (StringUtils.isNotEmpty((CharSequence)nlsCreditInfoVO.getOperateAgencyUser())) {
                psdTaskReqInfoVO.setManagerId(nlsCreditInfoVO.getOperateAgencyUser());
            } else {
                psdTaskReqInfoVO.setManagerId(preNlsCreditInfoVO.getRecommenderId());
            }
            psdTaskReqInfoVO.setDeptId(nlsCreditInfoVO.getOperateAgency());
            psdTaskReqInfoVO.setTaskTyp("1");
        }
        psdTaskReqInfoVO.setProductId("3");
        psdTaskReqInfoVO.setHandleStatus("2");
        psdTaskReqInfoVO.setUserType("5");
        psdTaskReqInfoVO.setCusName(nlsCreditInfoVO.getCusName());
        psdTaskReqInfoVO.setGender(nlsCreditInfoVO.getGender());
        psdTaskReqInfoVO.setCelPhone(nlsCreditInfoVO.getIndivMobile());
        psdTaskReqInfoVO.setIdNum(nlsCreditInfoVO.getCertCode());
        psdTaskReqInfoVO.setIdType(nlsCreditInfoVO.getCertType());
        psdTaskReqInfoVO.setCorpName(preNlsCreditInfoVO.getEnterpriseName());
        psdTaskReqInfoVO.setSocialCode(preNlsCreditInfoVO.getSocialCreditCode());
        psdTaskReqInfoVO.setAddress(preNlsCreditInfoVO.getRegistration());
        psdTaskReqInfoVO.setQuota(nlsCreditInfoVO.getApplyAmt());
        psdTaskReqInfoVO.setDueTime(lmtPrdContVO.getExpireDate());
        psdTaskReqInfoVO.setCreateStatus(Integer.valueOf(201));
        psdTaskReqInfoVO.setHandleResult("");
        psdTaskReqInfoVO.setCreateMsg("");
        if (!Objects.isNull(generatorOrderRespBean)) {
            if (EsbBizEnums.RetCodeEnum.SUCCESS.VALUE.equals(generatorOrderRespBean.getRetCd())) {
                psdTaskReqInfoVO.setCreateStatus(Integer.valueOf(999));
            }
            psdTaskReqInfoVO.setManagerId(generatorOrderRespBean.getActlHndlrId());
            psdTaskReqInfoVO.setHandleResult(generatorOrderRespBean.getRetMsg());
            psdTaskReqInfoVO.setCreateMsg(generatorOrderRespBean.getRetMsg());
        }
        psdTaskReqInfoVO.setRemark("\u666e\u7a0e\u8d37\u5de5\u5355\u521b\u5efa");
        psdTaskReqInfoVO.setGlobaNo(nlsCreditInfoVO.getGlobalSerno());
        psdTaskReqInfoVO.setCreateDate(DateUtility.getCurrDate());
        psdTaskReqInfoVO.setCreateTime(DateUtility.getCurrTime());
        psdTaskReqInfoVO.setCreateUser("admin");
        psdTaskReqInfoVO.setLastUpdateTime(new Date());
        psdTaskReqInfoVO.setLastUpdateUser("admin");
        psdTaskReqInfoVO.setWarnFlag("N");
        this.psdTaskReqInfoService.insert(psdTaskReqInfoVO);
    }

    private void sendMsg(String stage, PtProductUserVO ptProduceUser, LmtPrdContVO lmtPrdContVO, NlsCreditInfoVO nlsCreditInfoVO) {
        String phone;
        this.logger.info("\u589e\u52a0\u5de5\u5355\u540e\u4e0b\u53d1\u77ed\u4fe1\u5904\u7406\u5f00\u59cb---");
        CusIndivVO cusPkParam = new CusIndivVO();
        cusPkParam.setCusId(nlsCreditInfoVO.getCusId());
        CusIndivVO cusIndivVO = this.cusIndivService.queryByPk(cusPkParam);
        if (Objects.isNull(cusIndivVO)) {
            this.logger.error("\u6839\u636e\u5ba2\u6237\u53f7{}\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25", (Object)cusPkParam.getCusId());
        }
        if (StringUtils.isBlank((CharSequence)(phone = cusIndivVO.getPhone()))) {
            this.logger.info("\u83b7\u53d6\u5ba2\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u77ed\u4fe1\u4e0b\u53d1");
            return;
        }
        if ("1".equals(stage)) {
            this.nlsPublicService.sendMessageWithCusManagerInfo("1", lmtPrdContVO, ptProduceUser, phone);
            return;
        }
        if ("2".equals(stage)) {
            try {
                boolean b = this.invokeMobileBankQuery(nlsCreditInfoVO);
                if (b) {
                    this.nlsPublicService.sendMessageWithCusManagerInfo("3", lmtPrdContVO, ptProduceUser, phone);
                } else {
                    this.nlsPublicService.sendMessageWithCusManagerInfo("2", lmtPrdContVO, ptProduceUser, phone);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u7b7e\u7ea6\u624b\u673a\u94f6\u884c\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private boolean invokeMobileBankQuery(NlsCreditInfoVO selectCreditInfo) throws Exception {
        MobileBankInfoRespBean resp = null;
        MobileBankInfoReqBean res = new MobileBankInfoReqBean();
        res.setGlobaNo(selectCreditInfo.getGlobalSerno());
        res.setIdentTp(selectCreditInfo.getCertType());
        res.setOprtTp("1");
        res.setOprtChanFlg("07");
        res.setIdentTp(selectCreditInfo.getCertType());
        res.setIdentNo(selectCreditInfo.getCertCode());
        resp = (MobileBankInfoRespBean)new EsbInvokeWrapper((Object)this.mobileBankInfoService, (Object)res, this.nlsQueueSoltComnService).invoke3Threes();
        if (Objects.isNull(resp)) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)resp.getMblBnkCustNo());
    }
}

