/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.credit;

import com.gdrcu.efp.cus.common.CusBankRelEnum;
import com.gdrcu.efp.cus.common.CusStatusEnum;
import com.gdrcu.efp.cus.common.CusTypeEnum;
import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.ValidationUtils;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.basic.framework.core.util.sdic.SDicToLocal;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.basic.sequence.service.facade.SequenceService;
import com.irdstudio.efp.console.service.vo.PrdInfoVO;
import com.irdstudio.efp.cus.service.facade.CusIndivExtService;
import com.irdstudio.efp.cus.service.facade.CusIndivRelService;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivExtVO;
import com.irdstudio.efp.cus.service.vo.CusIndivRelVO;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.esb.common.client.resp.EsbRespRetInfBean;
import com.irdstudio.efp.esb.common.client.resp.EsbRespSysHeadBean;
import com.irdstudio.efp.esb.common.constant.ESBClientConstance;
import com.irdstudio.efp.esb.service.bo.req.ecif.CusDetialInfoQueryReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.MaintainEcifThirdCusReq;
import com.irdstudio.efp.esb.service.bo.req.ecif.TrdPtyCustInfArryBean;
import com.irdstudio.efp.esb.service.bo.req.hj.ReqCusInfoCreBean;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailIdInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetailTelInfArray;
import com.irdstudio.efp.esb.service.bo.resp.ecif.CusDetialInfoQueryResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.MaintainEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PriMtEcifThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.ecif.PrivateCreateThirdCusResp;
import com.irdstudio.efp.esb.service.bo.resp.hj.RespCusInfoCreBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.ecif.CusDetailInfoQueryService;
import com.irdstudio.efp.esb.service.facade.esb.EsbService;
import com.irdstudio.efp.esb.service.facade.hj.CustomerInfoCreateService;
import com.irdstudio.efp.nls.common.util.NlsStringUtil;
import com.irdstudio.efp.nls.service.facade.CusCreateCommonService;
import com.irdstudio.efp.nls.service.facade.NlsApplyRelationService;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.psd.PreNlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoExdService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.ZydEcifThirdCusService;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyRelationVO;
import com.irdstudio.efp.nls.service.vo.psd.PreNlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoExdVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import com.irdstudio.efp.rule.common.enumeration.RefuseType;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdCusCreateService")
public class PsdCusCreateServiceImpl
extends CreditSoltServiceImpl
implements FrameworkService {
    private static final DateTimeFormatter timeStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String HEAD = "head";
    private static final String BODY = "body";
    private final Logger logger = LoggerFactory.getLogger(PsdCusCreateServiceImpl.class);
    private final String msgTemplate = "message{}";
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsApplyRelationService")
    private NlsApplyRelationService nlsApplyRelationService;
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cusIndivRelService")
    private CusIndivRelService cusIndivRelService;
    @Autowired
    @Qualifier(value="customerInfoCreateService")
    private CustomerInfoCreateService customerInfoCreateService;
    @Autowired
    @Qualifier(value="preNlsCreditInfoService")
    private PreNlsCreditInfoService preNlsCreditInfoService;
    @Autowired
    private ZydEcifThirdCusService zydEcifThirdCusService;
    @Autowired
    @Qualifier(value="cusDetailInfoQueryService")
    private CusDetailInfoQueryService cusDetailInfoQueryService;
    @Autowired
    private PatternedLimitableSeqService sequenceService;
    private static final PatternDescriptor CUS_PATTERN = DefaultPatternDescriptor.of((String)"$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="cusIndivExtService")
    private CusIndivExtService cusIndivExtService;
    @Autowired
    @Qualifier(value="nlsCreditInfoExdService")
    private NlsCreditInfoExdService nlsCreditInfoExdService;
    @Autowired
    @Qualifier(value="maintainEcifThirdCusService")
    private EsbService<MaintainEcifThirdCusReq, MaintainEcifThirdCusResp> maintainEcifThirdCusService;
    @Autowired
    @Qualifier(value="cusCreateCommonService")
    private CusCreateCommonService cusCreateCommonService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsCreditInfoVO.getLmtApplySeq();
        String dateTimeString = LocalDateTime.now().format(timeStrFormatter);
        String createUser = "admin";
        this.logger.info("======>\u666e\u7a0e\u8d37\u5ba2\u6237\u5efa\u6863\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        PrivateCreateThirdCusResp privateCreateThirdCusResp = new PrivateCreateThirdCusResp();
        PriMtEcifThirdCusResp priMtEcifThirdCusResp = new PriMtEcifThirdCusResp();
        PrdInfoVO prdInfoVo = this.nlsPublicService.getProInfo(nlsCreditInfoVO.getPrdId());
        CusIndivVO cusIndivVO = new CusIndivVO();
        try {
            CusDetialInfoQueryResp cusDetialInfoQueryResp;
            PreNlsCreditInfoVO inPreNlsCreditInfoVo = new PreNlsCreditInfoVO();
            inPreNlsCreditInfoVo.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            PreNlsCreditInfoVO preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(inPreNlsCreditInfoVo);
            NlsCreditInfoExdVO pojo = new NlsCreditInfoExdVO();
            pojo.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            NlsCreditInfoExdVO nlsCreditInfoExdVO = this.nlsCreditInfoExdService.queryByPk(pojo);
            nlsCreditInfoVO.setRetCode(nlsCreditInfoExdVO.getRetCode());
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("estblshDt", nlsCreditInfoVO.getCreateTime());
            paramsMap.put("sstblshBrch", nlsCreditInfoVO.getNlsOperOrgid());
            paramsMap.put("certCode", nlsCreditInfoVO.getCertCode());
            paramsMap.put("certType", nlsCreditInfoVO.getCertType());
            Map resultMap = this.cusCreateCommonService.getPrivateEstblshDtAndSstblshBrch(paramsMap);
            this.logger.info(nlsCreditInfoVO.getLmtApplySeq() + "\u67e5\u8be2\u5230\u7684\u5f00\u6237\u4fe1\u606f:{}", (Object)resultMap);
            String estblshDt = (String)resultMap.get("estblshDt");
            String sstblshBrch = (String)resultMap.get("sstblshBrch");
            String usrID = "";
            boolean exist = true;
            if (Objects.isNull(preNlsCreditInfoVO) || !StringUtil.isNullorBank((String)preNlsCreditInfoVO.getIndustry())) {
                // empty if block
            }
            if (Objects.isNull(cusDetialInfoQueryResp = this.queryECIFInfo(nlsCreditInfoVO.getCusName(), nlsCreditInfoVO.getCertCode())) || StringUtil.isNullorBank((String)cusDetialInfoQueryResp.getCustNo())) {
                Map<String, Object> map = this.zydEcifThirdCusService.privateCreateFn(nlsCreditInfoVO, nlsCreditInfoExdVO, sstblshBrch);
                privateCreateThirdCusResp = (PrivateCreateThirdCusResp)map.get(BODY);
                usrID = this.checkCreateThirdCusResp(map, nlsCreditInfoVO);
            } else {
                usrID = cusDetialInfoQueryResp.getCustNo();
                String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
                String telCode = "";
                List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
                if (Objects.nonNull(telInfArry)) {
                    for (CusDetailTelInfArray item : telInfArry) {
                        if (!item.getAtchSys1().equals("2003000")) continue;
                        telCode = item.getTelId();
                    }
                } else {
                    telCode = "";
                }
                this.zydEcifThirdCusService.PriMtEcifThirdCusFn(nlsCreditInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
            }
            cusIndivVO.setCertType(nlsCreditInfoVO.getCertType());
            cusIndivVO.setCertCode(nlsCreditInfoVO.getCertCode());
            cusIndivVO = this.cusIndivService.getCusInvoByCertCode(cusIndivVO);
            if (Objects.isNull(cusIndivVO)) {
                exist = false;
            }
            if (!exist) {
                cusIndivVO = this.insertCustomerInfo(nlsCreditInfoVO, exist, usrID, prdInfoVo, preNlsCreditInfoVO, nlsCreditInfoExdVO);
            } else {
                if (StringUtils.isNotBlank((CharSequence)cusIndivVO.getInnerCusId())) {
                    this.sendCusIndivToEcif(nlsCreditInfoVO, cusIndivVO, estblshDt, sstblshBrch);
                }
                cusIndivVO = this.updateCustomerInfo(nlsCreditInfoVO, preNlsCreditInfoVO, exist, usrID, prdInfoVo, nlsCreditInfoExdVO);
            }
            nlsCreditInfoVO.setCusId(cusIndivVO.getCusId());
            nlsProcessBizVo.setCusId(cusIndivVO.getCusId());
            BigDecimal amount = nlsCreditInfoVO.getApproveAmt().setScale(4, 4);
            DecimalFormat df = new DecimalFormat("###,###.00");
            String str = df.format(amount);
            this.nlsPublicService.sendSuccessMessage(nlsCreditInfoVO.getIndivMobile(), str);
        }
        catch (Exception e) {
            this.logger.error("======>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011\u6267\u884c\u5931\u8d25\u539f\u56e0\u4e3a<======", (Object)e.getMessage());
            nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
            nlsProcessBizVo.setRefuseMsg(RefuseType.OTHER.getMsg());
            nlsProcessBizVo.setExceptionMsg(e);
            this.nlsPublicService.sendFailMesage(nlsCreditInfoVO.getIndivMobile());
        }
        finally {
            this.logger.info("======>\u666e\u7a0e\u8d37\u5ba2\u6237\u5efa\u6863\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7<======" + applySeq);
        }
    }

    private CusIndivVO getCusIndivVO(NlsCreditInfoVO nlsCreditInfoVO, Boolean exist, String usrID, PrdInfoVO prdInfoVo) {
        CusIndivVO cusIndivVO = new CusIndivVO();
        cusIndivVO.setSelfCusId(usrID);
        if (!exist.booleanValue()) {
            String cusId = this.sequenceService.getPatternedSequence("CUS_ID", CUS_PATTERN);
            cusIndivVO.setCusId(cusId);
        } else {
            cusIndivVO.setCusId(this.getCusId(nlsCreditInfoVO));
        }
        cusIndivVO.setCusName(nlsCreditInfoVO.getCusName());
        cusIndivVO.setIndivSex(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname());
        cusIndivVO.setCertType(nlsCreditInfoVO.getCertType());
        cusIndivVO.setCertCode(nlsCreditInfoVO.getCertCode());
        cusIndivVO.setIndivIdExpDt(nlsCreditInfoVO.getCertEndDt());
        cusIndivVO.setIndivRsdAddr(nlsCreditInfoVO.getIndivRsdAddr());
        cusIndivVO.setPhone(nlsCreditInfoVO.getIndivMobile());
        cusIndivVO.setCusType(CusTypeEnum.NATURAL_MAN.getCode());
        cusIndivVO.setCusBankRel(CusBankRelEnum.NORMAL.getCode());
        cusIndivVO.setCusStatus(CusStatusEnum.OFFICIAL.getCode());
        cusIndivVO.setFstAppChannel(nlsCreditInfoVO.getChannelNo());
        cusIndivVO.setIndivNtn(nlsCreditInfoVO.getEthnic());
        cusIndivVO.setIndivComName(nlsCreditInfoVO.getWrkCorpNm());
        cusIndivVO.setIndivCrtfctn(nlsCreditInfoVO.getTtl());
        cusIndivVO.setIndivOcc(nlsCreditInfoVO.getProfession());
        cusIndivVO.setIndivComJobTtl(nlsCreditInfoVO.getIndivComJobTtl());
        cusIndivVO.setPostAddr(nlsCreditInfoVO.getIndivRsdAddr());
        cusIndivVO.setPostCode(nlsCreditInfoVO.getPostCode());
        cusIndivVO.setIndivSpsName(nlsCreditInfoVO.getSpsNm());
        cusIndivVO.setLastUpdateUser("admin");
        cusIndivVO.setIndivDtOfBirth(ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()));
        return cusIndivVO;
    }

    private String getCusId(NlsCreditInfoVO nlsCreditInfoVO) {
        Objects.requireNonNull(nlsCreditInfoVO);
        return this.cusIndivService.getCusIdByCertCode(nlsCreditInfoVO.getCertType(), nlsCreditInfoVO.getCertCode());
    }

    private boolean isCustomerExist(NlsCreditInfoVO nlsCreditInfoVO) {
        String cusId = this.getCusId(nlsCreditInfoVO);
        if (StringUtils.isNotEmpty((CharSequence)cusId)) {
            this.logger.info("\u7f51\u8d37\u5df2\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u5ba2\u6237\u53f7:" + cusId);
            return true;
        }
        this.logger.info("\u7f51\u8d37\u4e0d\u5b58\u5728\u8be5\u5ba2\u6237\uff0c\u5ba2\u6237\u53f7");
        return false;
    }

    private CusIndivVO insertCustomerInfo(NlsCreditInfoVO nlsCreditInfoVO, Boolean exist, String usrID, PrdInfoVO prdInfoVo, PreNlsCreditInfoVO preNlsCreditInfoVO, NlsCreditInfoExdVO nlsCreditInfoExdVO) throws BizException {
        CusIndivVO cusIndivVO = this.getCusIndivVO(nlsCreditInfoVO, exist, usrID, prdInfoVo);
        cusIndivVO.setMainBrId(StringUtil.isNullorBank((String)preNlsCreditInfoVO.getNlsOperOrgid()) ? prdInfoVo.getDefaultManageOrg() : preNlsCreditInfoVO.getNlsOperOrgid());
        cusIndivVO.setComInitLoanDate(DateUtility.getCurrAppDateStr());
        cusIndivVO.setInputDate(DateUtility.getCurrAppDateStr());
        cusIndivVO.setEntpType(preNlsCreditInfoVO.getBkColumn1());
        try {
            cusIndivVO.setIndivComTyp(StringUtils.isBlank((CharSequence)preNlsCreditInfoVO.getBkColumn1()) ? "" : SDicToLocal.getLocalSysDicVal((String)"EmpTyp", (String)preNlsCreditInfoVO.getBkColumn1()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5355\u4f4d\u6027\u8d28\u98ce\u63a7\u7801\u503c\u8f6c\u7f51\u8d37\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicToLocal.properties)\uff01");
        }
        try {
            cusIndivVO.setIndivComFld(StringUtils.isBlank((CharSequence)preNlsCreditInfoVO.getIndustry()) ? "" : SDicToLocal.getLocalSysDicVal((String)"EmpIr", (String)preNlsCreditInfoVO.getIndustry()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7a0e\u5c40\u7801\u503c\u8f6c\u6570\u6807\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicToLocal.properties)\uff01");
        }
        this.setServerInsertDefaultProperty((BaseInfo)cusIndivVO);
        int result = this.cusIndivService.insertCusIndiv(cusIndivVO);
        CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
        cusIndivExtVO.setCusId(cusIndivVO.getCusId());
        cusIndivExtVO.setCusType("02");
        cusIndivExtVO.setOnlineVerfStatus(nlsCreditInfoExdVO.getOnlineVerfStatus());
        cusIndivExtVO.setRetCode(nlsCreditInfoExdVO.getRetCode());
        cusIndivExtVO.setCreateUser("admin");
        cusIndivExtVO.setCreateTime(DateTool.getCurrentDateTime());
        cusIndivExtVO.setLastUpdateUser("admin");
        cusIndivExtVO.setLastUpdateTime(DateTool.getCurrentDateTime());
        int num4 = this.cusIndivExtService.insert(cusIndivExtVO);
        if (result != 1) {
            this.logger.error("=========>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u63d2\u5165\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!<========", (Object)"message{}");
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u63d2\u5165\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!", "message{}");
        }
        return cusIndivVO;
    }

    private RespCusInfoCreBean pushCusToOnlineFinance(NlsCreditInfoVO nlsCreditInfoVO, String industry) throws BizException {
        ReqCusInfoCreBean reqCusInfoCreBean = new ReqCusInfoCreBean();
        reqCusInfoCreBean.setMblNo(nlsCreditInfoVO.getIndivMobile());
        reqCusInfoCreBean.setCustNm(nlsCreditInfoVO.getCusName());
        reqCusInfoCreBean.setUserGnd(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname());
        reqCusInfoCreBean.setNation(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getNational()));
        reqCusInfoCreBean.setCrrCd(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getProfession()));
        reqCusInfoCreBean.setCtcAddr(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getCertAddr()));
        reqCusInfoCreBean.setWrkCorpAddr(nlsCreditInfoVO.getWrkCorpAddr());
        reqCusInfoCreBean.setCertTp(nlsCreditInfoVO.getCertType());
        reqCusInfoCreBean.setCertNo(nlsCreditInfoVO.getCertCode());
        reqCusInfoCreBean.setIdenEfftDt(nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt().split("-")[1]);
        reqCusInfoCreBean.setIssueOrgNm("\u4e2d\u56fd");
        reqCusInfoCreBean.setMrgSitu(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getMrgSitu()));
        reqCusInfoCreBean.setSpsNm(StringUtil.replaceNullByObj((Object)nlsCreditInfoVO.getSpsNm()));
        reqCusInfoCreBean.setInstId(ESBClientConstance.psdCreditInstId);
        reqCusInfoCreBean.setGlobaNo(nlsCreditInfoVO.getGlobalSerno());
        reqCusInfoCreBean.setChannlNo(nlsCreditInfoVO.getChannelNo());
        reqCusInfoCreBean.setIndusCd(industry);
        try {
            reqCusInfoCreBean.setProdType(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"PrdType", (String)nlsCreditInfoVO.getPrdId()));
            return this.customerInfoCreateService.customerInfoCreate(reqCusInfoCreBean);
        }
        catch (Exception e) {
            this.logger.error("=========>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011\u8c03\u7528\u4e92\u91d1\u6838\u5fc3\u5ba2\u6237\u5efa\u6863\u5f02\u5e38<======" + e, (Object)"message{}");
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011\u8c03\u7528\u4e92\u91d1\u6838\u5fc3\u5ba2\u6237\u5efa\u6863\u5f02\u5e38!!! " + e);
        }
    }

    private void insertCustomerRelation(NlsCreditInfoVO nlsCreditInfoVO, NlsProcessBizVO nlsProcessBizVo, RespCusInfoCreBean respCusInfoCreBean) throws BizException {
        NlsApplyRelationVO nlsApplyRelationVo = new NlsApplyRelationVO();
        nlsApplyRelationVo.setApplySeq(nlsProcessBizVo.getApplySeq());
        List nlsApplyRelationVOs = Optional.ofNullable(this.nlsApplyRelationService.queryByApplySeq(nlsApplyRelationVo)).orElseGet(ArrayList::new);
        for (NlsApplyRelationVO vo : nlsApplyRelationVOs) {
            CusIndivRelVO cusIndivRelVO = new CusIndivRelVO();
            String relSerno = "";
            try {
                relSerno = this.getCusId();
            }
            catch (Exception e) {
                throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u5173\u8054\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25!!!");
            }
            cusIndivRelVO.setRelSerno(relSerno);
            cusIndivRelVO.setCusId(respCusInfoCreBean.getClntNo());
            cusIndivRelVO.setCertCode(vo.getCertCode());
            cusIndivRelVO.setCertType(vo.getCertType());
            cusIndivRelVO.setRelName(vo.getRelName());
            cusIndivRelVO.setRelation(vo.getRelRelation());
            cusIndivRelVO.setMobile(nlsCreditInfoVO.getIndivMobile());
            int result = this.cusIndivRelService.insertCusIndivRel(cusIndivRelVO);
            if (result == 1) continue;
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u5173\u8054\u4eba\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25!!!");
        }
    }

    private CusIndivVO updateCustomerInfo(NlsCreditInfoVO nlsCreditInfoVO, PreNlsCreditInfoVO preNlsCreditInfoVO, Boolean exist, String usrID, PrdInfoVO prdInfoVo, NlsCreditInfoExdVO nlsCreditInfoExdVO) throws BizException {
        CusIndivVO cusIndivVO = this.getCusIndivVO(nlsCreditInfoVO, exist, usrID, prdInfoVo);
        try {
            cusIndivVO.setIndivComTyp(StringUtils.isBlank((CharSequence)preNlsCreditInfoVO.getBkColumn1()) ? "" : SDicToLocal.getLocalSysDicVal((String)"EmpTyp", (String)preNlsCreditInfoVO.getBkColumn1()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5355\u4f4d\u6027\u8d28\u98ce\u63a7\u7801\u503c\u8f6c\u7f51\u8d37\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicToLocal.properties)\uff01");
        }
        try {
            cusIndivVO.setIndivComFld(StringUtils.isBlank((CharSequence)preNlsCreditInfoVO.getIndustry()) ? "" : SDicToLocal.getLocalSysDicVal((String)"EmpIr", (String)preNlsCreditInfoVO.getIndustry()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7a0e\u5c40\u7801\u503c\u8f6c\u6570\u6807\u6240\u9700\u5b57\u5178\u9879\u51fa\u9519\uff0c\u8bf7\u6838\u67e5\u914d\u7f6e\u6587\u4ef6(dicToLocal.properties)\uff01");
        }
        cusIndivVO.setEntpType(preNlsCreditInfoVO.getBkColumn1());
        this.setServerUpdateDefaultProperty((BaseInfo)cusIndivVO);
        int result = this.cusIndivService.updateByPk(cusIndivVO);
        CusIndivExtVO cusIndivExtVO = new CusIndivExtVO();
        cusIndivExtVO.setCusId(cusIndivVO.getCusId());
        CusIndivExtVO cusIndivExtVO1 = this.cusIndivExtService.queryByPk(cusIndivExtVO);
        if ("01".equals(cusIndivExtVO1.getCusType())) {
            cusIndivExtVO1.setCusType("0102");
        }
        cusIndivExtVO.setOnlineVerfStatus(nlsCreditInfoExdVO.getOnlineVerfStatus());
        cusIndivExtVO.setRetCode(nlsCreditInfoExdVO.getRetCode());
        cusIndivExtVO.setLastUpdateUser("admin");
        cusIndivExtVO.setLastUpdateTime(LocalDateTime.now().format(timeStrFormatter));
        int num2 = this.cusIndivExtService.updateByPk(cusIndivExtVO1);
        if (num2 == -1) {
            throw new BizException("\u5ba2\u6237\u62d3\u5c55\u8868\u66f4\u65b0\u5f02\u5e38!!!!");
        }
        if (result == -1) {
            this.logger.error("=========>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!<======", (Object)"message{}");
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!");
        }
        return cusIndivVO;
    }

    private void updateCreditApplyInfo(NlsCreditInfoVO nlsCreditInfoVO, RespCusInfoCreBean respCusInfoCreBean) throws BizException {
        nlsCreditInfoVO.setCusId(respCusInfoCreBean.getClntNo());
        this.setServerUpdateDefaultProperty((BaseInfo)nlsCreditInfoVO);
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result == -1) {
            this.logger.error("=========>\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u63d2\u5165\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!<======", (Object)"message{}");
            throw new BizException("\u3010\u5ba2\u6237\u5efa\u6863\u63d2\u69fd\u3011,\u63d2\u5165\u5ba2\u6237\u4fe1\u606f\u5931\u8d25!!!");
        }
    }

    public String getCusId() throws Exception {
        SequenceService sequenceService = (SequenceService)SpringContextUtils.getBean((String)"dbSeqService");
        return sequenceService.getSequence("RELATION_ID", null, null);
    }

    public CusDetialInfoQueryResp queryECIFInfo(String cusName, String idNo) throws Exception {
        CusDetialInfoQueryReq cusDetialInfoQueryReq = new CusDetialInfoQueryReq();
        cusDetialInfoQueryReq.setIdntfMd("1");
        cusDetialInfoQueryReq.setCustNm(cusName);
        cusDetialInfoQueryReq.setIdentNo(idNo);
        CusDetialInfoQueryResp resp = null;
        try {
            EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.cusDetailInfoQueryService, (Object)cusDetialInfoQueryReq, this.nlsQueueSoltComnService);
            resp = (CusDetialInfoQueryResp)esbInvokeWrapper.invoke3Threes();
        }
        catch (ESBException e) {
            this.logger.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            throw new Exception("\u8c03\u7528ecif\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        return resp;
    }

    public String checkCreateThirdCusResp(Map<String, Object> map, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        EsbRespSysHeadBean respSysHeadBean = (EsbRespSysHeadBean)map.get(HEAD);
        PrivateCreateThirdCusResp privateCreateThirdCusResp = (PrivateCreateThirdCusResp)map.get(BODY);
        String usrID = privateCreateThirdCusResp.getCustNo();
        if (StringUtils.equals((CharSequence)((EsbRespRetInfBean)respSysHeadBean.getRetInfArry().get(0)).getRetCd(), (CharSequence)"3036000|210006")) {
            this.logger.info("\u77ed\u65f6\u95f4\u5e76\u53d1\u5bfc\u81f4ecif\u5df2\u5b58\u5728\u8be5\u81ea\u8425\u5ba2\u6237,\u524d\u5f80ecif\u66f4\u65b0\uff01");
            CusDetialInfoQueryResp cusDetialInfoQueryResp = this.queryECIFInfo(nlsCreditInfoVO.getCusName(), nlsCreditInfoVO.getCertCode());
            String idSeqCode = ((CusDetailIdInfArray)cusDetialInfoQueryResp.getIdInfArry().get(0)).getIdentSeqNo();
            String telCode = "";
            List telInfArry = cusDetialInfoQueryResp.getTelInfArry();
            if (Objects.nonNull(telInfArry)) {
                for (CusDetailTelInfArray item : telInfArry) {
                    if (!item.getAtchSys1().equals("2003000")) continue;
                    telCode = item.getTelId();
                }
            } else {
                telCode = "";
            }
            this.zydEcifThirdCusService.PriMtEcifThirdCusFn(nlsCreditInfoVO, cusDetialInfoQueryResp.getCustNo(), idSeqCode, telCode);
        }
        return usrID;
    }

    private void sendCusIndivToEcif(NlsCreditInfoVO nlsCreditInfoVO, CusIndivVO cusIndivVO, String estblshDt, String sstblshBrch) throws Exception {
        String identEfftvDt;
        MaintainEcifThirdCusReq maintainEcifThirdCusReq = MaintainEcifThirdCusReq.builder().build();
        String string = identEfftvDt = nlsCreditInfoVO.getCertEndDt().contains("\u957f\u671f") ? "20991231" : nlsCreditInfoVO.getCertEndDt();
        if (identEfftvDt.length() > 8) {
            identEfftvDt = identEfftvDt.length() == 10 ? DateUtility.format10To8((String)identEfftvDt) : identEfftvDt.split("-")[1];
        }
        String crrCd = nlsCreditInfoVO.getProfession().length() == 1 ? SDicToExternal.getExternalSysDicVal((String)"ECIF", (String)"Crr", (String)nlsCreditInfoVO.getProfession()) : nlsCreditInfoVO.getProfession();
        String crrCd1 = null;
        String crrCd2 = null;
        String crrCd3 = null;
        if (!crrCd.endsWith("00")) {
            crrCd3 = crrCd;
        } else if (crrCd.endsWith("00") && !crrCd.endsWith("0000")) {
            crrCd2 = crrCd;
        } else if (crrCd.endsWith("0000")) {
            crrCd1 = crrCd;
        }
        TrdPtyCustInfArryBean build = TrdPtyCustInfArryBean.builder().CustNm(nlsCreditInfoVO.getCusName()).IdentTp(nlsCreditInfoVO.getCertType()).IdentNo(nlsCreditInfoVO.getCertCode()).IdentEfftvDt(identEfftvDt).Gnd(ValidationUtils.getSexFromIdNumber((String)nlsCreditInfoVO.getCertCode()).getEnname()).Nation(StringUtils.isBlank((CharSequence)nlsCreditInfoVO.getNational()) ? "156" : nlsCreditInfoVO.getNational()).BrthDt(DateUtility.format10To8((String)ValidationUtils.getBirthdayFromIdNumber((String)nlsCreditInfoVO.getCertCode()))).HghstEdu(nlsCreditInfoVO.getEdu()).CrrCd1(crrCd1).CrrCd2(crrCd2).CrrCd3(crrCd3).ProfTtl(nlsCreditInfoVO.getTtl()).CtcAddr(NlsStringUtil.toShorterString((String)nlsCreditInfoVO.getIndivRsdAddr(), (int)300)).CtcTel(nlsCreditInfoVO.getIndivMobile()).WrkCorp(nlsCreditInfoVO.getWrkCorpNm()).ChanNo("010").EstblshDt(estblshDt).EstblshBrch(sstblshBrch).build();
        maintainEcifThirdCusReq.setTrdPtyCustInfArry(Collections.singletonList(build));
        ((TrdPtyCustInfArryBean)maintainEcifThirdCusReq.getTrdPtyCustInfArry().get(0)).setTrdPtyCustNo(cusIndivVO.getInnerCusId());
        this.maintainEcifThirdCusService.service((Object)maintainEcifThirdCusReq);
    }
}

