/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.credit;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.vo.BaseInfo;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.impl.psd.credit.PsdAllotTaskHandleServiceImpl;
import com.irdstudio.efp.nls.service.impl.sx.CreditSoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdGenerateLmtService")
public class PsdGenerateLmtServiceImpl
extends CreditSoltServiceImpl
implements FrameworkService {
    private final Logger logger = LoggerFactory.getLogger(PsdGenerateLmtServiceImpl.class);
    private final String msgTemplate = "message{}";
    private static final PatternDescriptor PATTERN = DefaultPatternDescriptor.of((String)"lmt$YEAR$$MONTH$$DAY$$SEQ$", (Integer)8);
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="psdAllotTaskHandleService")
    private PsdAllotTaskHandleServiceImpl psdAllotTaskHandleService;
    @Autowired
    @Qualifier(value="pubSysInfoService")
    private PubSysInfoService pubSysInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(NlsProcessBizVO nlsProcessBizVo, NlsCreditInfoVO nlsCreditInfoVO) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        this.logger.info("======>\u666e\u7a0e\u8d37\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7" + applySeq + "<======");
        try {
            boolean isLimitExits = this.getLimitByLmtApplySeq(nlsCreditInfoVO);
            if (isLimitExits) {
                this.insertProLmtCont(nlsCreditInfoVO);
            }
        }
        catch (Exception e) {
            nlsProcessBizVo.setExceptionFlag(Boolean.TRUE.booleanValue());
            nlsProcessBizVo.setRefuseMsg(e.getMessage());
            nlsProcessBizVo.setExceptionMsg(e);
        }
        finally {
            this.logger.info("======>\u666e\u7a0e\u8d37\u751f\u6210\u989d\u5ea6\u4fe1\u606f\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7" + applySeq + "<======");
        }
    }

    private void updateCreditApplyInfo(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        nlsCreditInfoVO.setApprvSts("02");
        this.setServerUpdateDefaultProperty((BaseInfo)nlsCreditInfoVO);
        int result = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
        if (result == -1) {
            throw new BizException("\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void insertProLmtCont(NlsCreditInfoVO nlsCreditInfoVO) throws BizException {
        Objects.requireNonNull(nlsCreditInfoVO, "\u3010\u989d\u5ea6\u751f\u6210\u63d2\u69fd\u3011\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a!!!");
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtContNo(this.generateLmtContNo());
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO.setCusId(nlsCreditInfoVO.getCusId());
        lmtPrdContVO.setCusName(nlsCreditInfoVO.getCusName());
        lmtPrdContVO.setCertType(nlsCreditInfoVO.getCertType());
        lmtPrdContVO.setCertCode(nlsCreditInfoVO.getCertCode());
        lmtPrdContVO.setChannelNo(nlsCreditInfoVO.getChannelNo());
        lmtPrdContVO.setPrdId(nlsCreditInfoVO.getPrdId());
        lmtPrdContVO.setPrdCode(nlsCreditInfoVO.getPrdCode());
        lmtPrdContVO.setPrdName(nlsCreditInfoVO.getPrdName());
        lmtPrdContVO.setLmtAmt(nlsCreditInfoVO.getApproveAmt());
        lmtPrdContVO.setAvailAmt(nlsCreditInfoVO.getApproveAmt());
        lmtPrdContVO.setCyclicFlg(nlsCreditInfoVO.getCyclicFlg());
        lmtPrdContVO.setCurrencyType(nlsCreditInfoVO.getCurrencyType());
        lmtPrdContVO.setTerm(new BigDecimal(nlsCreditInfoVO.getApplyTerm()));
        lmtPrdContVO.setTermType(nlsCreditInfoVO.getTermType());
        lmtPrdContVO.setAssureMeansMain(nlsCreditInfoVO.getAssureMeansMain());
        lmtPrdContVO.setLoanUse(nlsCreditInfoVO.getLoanUseType());
        lmtPrdContVO.setLmtStatus("01");
        lmtPrdContVO.setRateY(nlsCreditInfoVO.getApproveRateY());
        String openday = this.pubSysInfoService.getOpenday("1001");
        lmtPrdContVO.setStartDate(openday);
        try {
            lmtPrdContVO.setExpireDate(TimeUtil.addMonth((String)openday, (int)12));
        }
        catch (Exception e) {
            throw new BizException("\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u6388\u4fe1\u534f\u8bae\u8868\u5230\u671f\u65e5\u671f\u8bbe\u7f6e\u5931\u8d25!!!");
        }
        this.setServerInsertDefaultProperty((BaseInfo)lmtPrdContVO);
        lmtPrdContVO.setLegalOrgCode("00010");
        lmtPrdContVO.setLegalOrgName("\u5e7f\u5dde\u94f6\u884c\u667a\u6167\u4e2d\u5fc3");
        lmtPrdContVO.setAccountDate(openday);
        int result = this.lmtPrdContService.insertLmtPrdCont(lmtPrdContVO);
        if (result == -1) {
            throw new BizException("=======>\u3010\u989d\u5ea6\u751f\u6210\u670d\u52a1\u3011\u751f\u6210\u989d\u5ea6\u63d2\u69fd,\u63d2\u5165\u672a\u751f\u6548\u7684\u989d\u5ea6\u4fe1\u606f\u5931\u8d25<=======", "message{}");
        }
    }

    private boolean getLimitByLmtApplySeq(NlsCreditInfoVO nlsCreditInfoVO) {
        LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
        lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
        return lmtPrdContVO == null;
    }

    public String generateLmtContNo() {
        PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
        return sequenceService.getPatternedSequence("LMT", PATTERN);
    }
}

