/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.credit;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizDetailVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizInfoVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.ImageBizDetailService;
import com.irdstudio.efp.edoc.service.facade.ImageBizInfoService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdCertUploadService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContResult;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.nls.service.dao.signature.SignatureRecordDAO;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.signature.SignatureRecord;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditInfo;
import com.irdstudio.efp.nls.service.facade.psd.PsdSqsSignatureService;
import com.irdstudio.efp.nls.service.vo.signature.SignatureRecordVO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdSqsSignatureService")
public class PsdSqsSignatureServiceImpl
implements PsdSqsSignatureService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(PsdSqsSignatureServiceImpl.class);
    @Autowired
    private SignatureRecordDAO signatureRecordDAO;
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    private SCfgParamService sCfgParamService;
    @Autowired
    private PsdContService psdContService;
    @Autowired
    private PsdCertUploadService psdCertUploadService;
    @Autowired
    private CusIndivService cusIndivService;
    @Autowired
    private ImageBizDetailService imageBizDetailService;
    @Autowired
    private ImageBizInfoService imageBizInfoService;

    public Boolean signature() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5728\u7ebf\u7b7e\u7ae0");
        int[] handleNumArr = this.getHandleNumArr();
        List<SignatureRecord> SignatureRecords = this.signatureRecordDAO.getSignatureNlsList("XD050300601", handleNumArr[1], PsdConstantSet.PSD_FILE_TYPE_03, handleNumArr[0]);
        if (SignatureRecords == null || SignatureRecords.isEmpty()) {
            logger.info("\u5728\u7ebf\u7b7e\u7ae0\uff1a\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a");
            return Boolean.TRUE;
        }
        for (SignatureRecord signatureRecord : SignatureRecords) {
            try {
                signatureRecord.setRetryNum(signatureRecord.getRetryNum() + 1);
                if (signatureRecord.getSiuSta() == 1) continue;
                String applySeq = signatureRecord.getApplySeq();
                NlsCreditInfo pkParam = new NlsCreditInfo();
                pkParam.setLmtApplySeq(applySeq);
                NlsCreditInfo nlsCreditInfo = this.nlsCreditInfoDao.queryByPk(pkParam);
                if (Objects.isNull((Object)nlsCreditInfo)) {
                    if (signatureRecord.getSiuSta() == 0) {
                        signatureRecord.setSiuSta(2);
                    }
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setErrMsg("\u67e5\u8be2\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                    this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                    continue;
                }
                if (signatureRecord.getSiuSta() == 3) {
                    PsdContResult psdContResult = this.psdContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), signatureRecord.getSiuContNo(), nlsCreditInfo.getLmtApplySeq() + "_sqs.pdf");
                    if (psdContResult.isRetFlag()) {
                        signatureRecord.setSiuSta(1);
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                        this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                        this.psdCertUploadService.insert(psdContResult.getFileFullPath());
                        this.insertCfcaSignInfo(psdContResult, nlsCreditInfo, signatureRecord.getSiuContNo());
                        this.insertImageBizDetail(nlsCreditInfo, PsdConstantSet.PSD_FILE_TYPE_03, FilenameUtils.getBaseName((String)psdContResult.getFileFullPath()), psdContResult.getFileFullPath());
                        this.insertImageBizInfo(nlsCreditInfo);
                        continue;
                    }
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(psdContResult.getMsg());
                    this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                    continue;
                }
                if (signatureRecord.getSiuSta() != 0 && signatureRecord.getSiuSta() != 2) continue;
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("cusName", nlsCreditInfo.getCusName());
                paramMap.put("certNo", nlsCreditInfo.getCertCode());
                paramMap.put("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
                PsdContResult signatureResult = this.psdContService.signature(nlsCreditInfo.getGlobalSerno(), nlsCreditInfo.getLmtApplySeq(), this.getAxqUserId(nlsCreditInfo), "sqs.pdf", "\u4e2a\u4eba\u6388\u6743\u4e66", paramMap);
                if (signatureResult.isRetFlag()) {
                    signatureRecord.setSiuContNo(signatureResult.getAxqContNo());
                    signatureRecord.setSiuRetMsg("\u7b7e\u7f72\u6388\u6743\u4e66\u6210\u529f");
                    PsdContResult psdContResult = this.psdContService.downSignFile(nlsCreditInfo.getLmtApplySeq(), signatureRecord.getSiuContNo(), nlsCreditInfo.getLmtApplySeq() + "_sqs.pdf");
                    if (psdContResult.isRetFlag()) {
                        signatureRecord.setSiuSta(1);
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                        this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                        this.insertCfcaSignInfo(psdContResult, nlsCreditInfo, signatureRecord.getSiuContNo());
                        this.psdCertUploadService.insert(psdContResult.getFileFullPath());
                        this.insertImageBizDetail(nlsCreditInfo, PsdConstantSet.PSD_FILE_TYPE_03, FilenameUtils.getBaseName((String)psdContResult.getFileFullPath()), psdContResult.getFileFullPath());
                        this.insertImageBizInfo(nlsCreditInfo);
                        continue;
                    }
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(psdContResult.getMsg());
                    this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                    continue;
                }
                signatureRecord.setSiuSta(2);
                signatureRecord.setSiuRetMsg(signatureResult.getMsg());
                signatureRecord.setLastUpdateTime(new Date());
                this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7b7e\u7ae0\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                signatureRecord.setErrMsg(e.getMessage());
                this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
            }
        }
        return Boolean.TRUE;
    }

    private String getAxqUserId(NlsCreditInfo nlsCreditInfo) throws Exception {
        PsdContResult openAccountResult = this.psdContService.openAccount(nlsCreditInfo.getCusName(), nlsCreditInfo.getCertType(), nlsCreditInfo.getCertCode(), nlsCreditInfo.getEmail(), nlsCreditInfo.getIndivMobile(), nlsCreditInfo.getIndivRsdAddr(), nlsCreditInfo.getLmtApplySeq());
        if (openAccountResult.isRetFlag()) {
            return openAccountResult.getAxqUserId();
        }
        throw new Exception(openAccountResult.getMsg());
    }

    public Integer insertRecord(SignatureRecordVO signatureRecordVO) {
        SignatureRecord signatureRecord = this.signatureRecordDAO.selectByPst(signatureRecordVO.getPrdId(), signatureRecordVO.getApplySeq(), signatureRecordVO.getLinkType());
        if (!Objects.isNull(signatureRecord)) {
            return 0;
        }
        return this.signatureRecordDAO.insert((SignatureRecord)this.beanCopy(signatureRecordVO, new SignatureRecord()));
    }

    public Integer updateOperInfo(String lmtAppSeq, String userId, String orgId) {
        int updateSqsCount = 0;
        int updateSqsTmCount = 0;
        int updateSxcontTmCount = 0;
        CfcaSignInfoVO pkParam = new CfcaSignInfoVO();
        pkParam.setApplySeq(lmtAppSeq + "_sqs");
        CfcaSignInfoVO cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(pkParam);
        if (!Objects.isNull(cfcaSignInfoVO)) {
            cfcaSignInfoVO.setNlsOperOrgid(orgId);
            cfcaSignInfoVO.setNlsOperUserid(userId);
            cfcaSignInfoVO.setFinaBrId(orgId);
            updateSqsCount = this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
        }
        pkParam.setApplySeq(lmtAppSeq + "_tm_sqs");
        cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(pkParam);
        if (!Objects.isNull(cfcaSignInfoVO)) {
            cfcaSignInfoVO.setNlsOperOrgid(orgId);
            cfcaSignInfoVO.setNlsOperUserid(userId);
            cfcaSignInfoVO.setFinaBrId(orgId);
            updateSqsTmCount = this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
        }
        pkParam.setApplySeq(lmtAppSeq + "_tm_sxcont");
        cfcaSignInfoVO = this.cfcaSignInfoService.queryByPk(pkParam);
        if (!Objects.isNull(cfcaSignInfoVO)) {
            cfcaSignInfoVO.setNlsOperOrgid(orgId);
            cfcaSignInfoVO.setNlsOperUserid(userId);
            cfcaSignInfoVO.setFinaBrId(orgId);
            updateSxcontTmCount = this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
        }
        return updateSqsCount + updateSqsTmCount + updateSxcontTmCount;
    }

    private void insertCfcaSignInfo(PsdContResult psdContResult, NlsCreditInfo nlsCreditInfo, String cfcaContNo) {
        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
        cfcaSignInfoVO.setApplySeq(nlsCreditInfo.getLmtApplySeq() + "_sqs");
        cfcaSignInfoVO.setPrdId(nlsCreditInfo.getPrdId());
        cfcaSignInfoVO.setPrdCode(nlsCreditInfo.getPrdCode());
        cfcaSignInfoVO.setPrdName(nlsCreditInfo.getPrdName());
        cfcaSignInfoVO.setCfcaContNo(cfcaContNo);
        cfcaSignInfoVO.setCusId(nlsCreditInfo.getCusId());
        cfcaSignInfoVO.setCusName(nlsCreditInfo.getCusName());
        cfcaSignInfoVO.setFinaBrId(nlsCreditInfo.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperOrgid(nlsCreditInfo.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperUserid(nlsCreditInfo.getNlsOperUserid());
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        cfcaSignInfoVO.setCfcaSignTime(psdContResult.getAxqSignTime());
        this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
    }

    private int[] getHandleNumArr() {
        int[] result = new int[2];
        try {
            SCfgParamVO param = new SCfgParamVO();
            param.setParamKey("PSD_FILE_HANDLE_NUM");
            SCfgParamVO maxNumCfg = this.sCfgParamService.queryByPk(param);
            result[0] = Objects.isNull(maxNumCfg) ? 50 : Integer.parseInt(maxNumCfg.getParamValue());
            param.setParamKey("PSD_UP_RETRY_NUM");
            SCfgParamVO retryNumCfg = this.sCfgParamService.queryByPk(param);
            result[1] = Objects.isNull(retryNumCfg) ? 3 : Integer.parseInt(retryNumCfg.getParamValue());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void insertImageBizDetail(NlsCreditInfo nlsCreditInfoVO, String imgType, String fileName, String filePath) {
        ImageBizDetailVO imageBizDetail = new ImageBizDetailVO();
        imageBizDetail.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizDetail.setBizStage("\u6388\u4fe1\u9636\u6bb5");
        imageBizDetail.setFileDesc("\u666e\u7a0e\u8d37\u4e2a\u4eba\u6388\u6743\u4e66");
        imageBizDetail.setFileName(fileName);
        imageBizDetail.setFilePath(filePath);
        imageBizDetail.setImageId(imgType);
        imageBizDetail.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizDetail.setImageType(imgType);
        this.imageBizDetailService.insertImageBizDetail(imageBizDetail);
    }

    private void insertImageBizInfo(NlsCreditInfo nlsCreditInfoVO) {
        ImageBizInfoVO param = new ImageBizInfoVO();
        param.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        if (!Objects.isNull(this.imageBizInfoService.queryByPk(param))) {
            return;
        }
        ImageBizInfoVO imageBizInfo = new ImageBizInfoVO();
        imageBizInfo.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizInfo.setCreateDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        imageBizInfo.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizInfo.setCusId(nlsCreditInfoVO.getCusId());
        imageBizInfo.setCusName(nlsCreditInfoVO.getCusName());
        imageBizInfo.setPrdId(nlsCreditInfoVO.getPrdId());
        imageBizInfo.setPrdCode(nlsCreditInfoVO.getPrdCode());
        imageBizInfo.setPrdName(nlsCreditInfoVO.getPrdName());
        imageBizInfo.setSoltImageAccept("");
        imageBizInfo.setSoltImageCfca("");
        imageBizInfo.setSoltImageThird1("");
        imageBizInfo.setSoltImageThird2("");
        this.imageBizInfoService.insertOrUpdateImageBizInfoVO(imageBizInfo);
    }
}

