/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.credit;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.efp.console.service.facade.PubSysInfoService;
import com.irdstudio.efp.console.service.facade.SOrgService;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdCertUploadService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditInfo;
import com.irdstudio.efp.nls.service.facade.psd.NlsCreditApprovalInfoService;
import com.irdstudio.efp.nls.service.facade.psd.PsdSxCtrCheckService;
import com.irdstudio.efp.nls.service.vo.psd.NlsCreditApprovalInfoVO;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service(value="psdSxCtrCheckService")
public class PsdSxCtrCheckServiceImpl
implements PsdSxCtrCheckService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(PsdSxCtrCheckServiceImpl.class);
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;
    @Autowired
    @Qualifier(value="sOrgService")
    private SOrgService sOrgService;
    @Autowired
    private PsdContService psdContService;
    @Autowired
    private PsdCertUploadService psdCertUploadService;
    @Autowired
    private NlsCreditApprovalInfoService nlsCreditApprovalInfoService;
    @Autowired
    private PubSysInfoService pubSysInfoService;
    private final double limit = 1000.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean check() {
        StopWatch stopwatch = new StopWatch("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668");
        stopwatch.start();
        try {
            NlsCreditInfo param = new NlsCreditInfo();
            param.setPrdId("XD050300601");
            param.setApprvSts(NlsApplyInfoEnums.NlsApplyState.PASS.getKey());
            int totalSize = this.nlsCreditInfoDao.countByPrdIdAndApprvSts(param);
            logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\uff0c\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u7533\u8bf7\u603b\u6761\u6570\u4e3a\uff1a[{}]", (Object)totalSize);
            if (totalSize <= 0) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            int totalPage = (int)Math.ceil((double)totalSize / 1000.0);
            for (int i = 0; i < totalPage; ++i) {
                List<NlsCreditInfo> nlsCreditInfos = this.nlsCreditInfoDao.queryByPrdIdAndApprvSts(param, new RowBounds((int)((double)i * 1000.0), 1000));
                for (NlsCreditInfo creditInfo : nlsCreditInfos) {
                    LocalDate apprvLocalDate;
                    boolean b;
                    NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(creditInfo.getLmtApplySeq());
                    if (Objects.isNull(nlsCreditApprovalInfoVO)) {
                        logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\uff0c\u6839\u636e\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u83b7\u53d6\u6388\u4fe1\u5ba1\u6279\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6682\u65f6\u8df3\u8fc7\u672c\u6761\u5904\u7406\u3002\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a[{}]", (Object)creditInfo.getLmtApplySeq());
                        continue;
                    }
                    Date approveTime = nlsCreditApprovalInfoVO.getApproveTime();
                    if (Objects.isNull(approveTime)) {
                        logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\uff0c\u6839\u636e\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u83b7\u53d6\u5230\u98ce\u63a7\u5ba1\u6279\u65f6\u95f4\u4e3a\u7a7a\uff0c\u6682\u65f6\u8df3\u8fc7\u672c\u6761\u5904\u7406\u3002\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a[{}]", (Object)creditInfo.getLmtApplySeq());
                        continue;
                    }
                    LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(creditInfo.getLmtApplySeq());
                    if (Objects.isNull(lmtPrdContVO)) {
                        logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\uff0c\u6839\u636e\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u83b7\u53d6\u5230\u7684\u989d\u5ea6\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6682\u65f6\u8df3\u8fc7\u672c\u6761\u5904\u7406\u3002\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a[{}]", (Object)creditInfo.getLmtApplySeq());
                        continue;
                    }
                    if (!lmtPrdContVO.getLmtStatus().equals("01")) {
                        logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\uff0c\u6839\u636e\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f\u83b7\u53d6\u5230\u7684\u989d\u5ea6\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u6682\u65f6\u8df3\u8fc7\u672c\u6761\u5904\u7406\u3002\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a[{}]", (Object)creditInfo.getLmtApplySeq());
                        continue;
                    }
                    CtrLoanContVO ctrLoanContVO = this.ctrLoanContService.queryContNoByLmtContNoAndContype(lmtPrdContVO.getLmtContNo(), "01");
                    if (!Objects.isNull(ctrLoanContVO) && ctrLoanContVO.getContState().equals("200") || !(b = (apprvLocalDate = approveTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).plusMonths(3L).toEpochDay() < LocalDate.now().toEpochDay())) continue;
                    logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\uff0c\u9700\u8981\u66f4\u6539\u989d\u5ea6\u548c\u6388\u4fe1\u72b6\u6001\u4e3a\u5931\u6548\uff0c\u98ce\u63a7\u5ba1\u6279\u65f6\u95f4\u4e3a\uff1a[{}],\u5408\u540c\u4fe1\u606f\u662f\u5426\u5b58\u5728\uff1a[{}],\u5408\u540c\u72b6\u6001\u4e3a\uff1a[{}]\u3002\u6388\u4fe1\u6d41\u6c34\u53f7\uff1a[{}]", new Object[]{apprvLocalDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), Objects.isNull(ctrLoanContVO) ? "\u5426" : "\u662f", Objects.isNull(ctrLoanContVO) ? "" : ctrLoanContVO.getContState(), creditInfo.getLmtApplySeq()});
                    this.nlsCreditInfoDao.updateApprvSts("06", creditInfo.getLmtApplySeq());
                    this.lmtPrdContService.updateLmtStatus("03", lmtPrdContVO.getLmtContNo());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\u6267\u884c\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a[{}]", (Object)e.getMessage());
        }
        finally {
            stopwatch.stop();
            String s = stopwatch.prettyPrint();
            logger.info("\u6388\u4fe1\u5408\u540c\u7b7e\u7f72\u6821\u9a8c\u5b9a\u65f6\u5668\u6267\u884c\u7ed3\u675f\uff0c\u6267\u884c\u6548\u7387\u4e3a\uff1a[{}]", (Object)s);
        }
        return Boolean.TRUE;
    }
}

