/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.credit;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.common.psd.PsdTmUtils;
import com.irdstudio.efp.console.service.facade.SCfgParamService;
import com.irdstudio.efp.console.service.vo.SCfgParamVO;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizDetailVO;
import com.irdstudio.efp.edoc.service.bo.ImageBizInfoVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.edoc.service.facade.ImageBizDetailService;
import com.irdstudio.efp.edoc.service.facade.ImageBizInfoService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdCertUploadService;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContResult;
import com.irdstudio.efp.edoc.service.facade.signature.PsdContService;
import com.irdstudio.efp.esb.common.constant.ElectronicSignatureEnums;
import com.irdstudio.efp.nls.service.dao.NlsApplyInfoDao;
import com.irdstudio.efp.nls.service.dao.signature.SignatureRecordDAO;
import com.irdstudio.efp.nls.service.dao.sx.NlsCreditInfoDao;
import com.irdstudio.efp.nls.service.domain.NlsApplyInfo;
import com.irdstudio.efp.nls.service.domain.signature.SignatureRecord;
import com.irdstudio.efp.nls.service.domain.sx.NlsCreditInfo;
import com.irdstudio.efp.nls.service.facade.psd.PsdTmSignatureService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="psdTmSignatureService")
public class PsdTmSignatureServiceImpl
implements PsdTmSignatureService {
    private static Logger logger = LoggerFactory.getLogger(PsdTmSignatureServiceImpl.class);
    @Autowired
    private SignatureRecordDAO signatureRecordDAO;
    @Autowired
    private NlsCreditInfoDao nlsCreditInfoDao;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    private SCfgParamService sCfgParamService;
    @Autowired
    private PsdContService psdContService;
    @Autowired
    private PsdCertUploadService psdCertUploadService;
    @Autowired
    private NlsApplyInfoDao nlsApplyInfoDao;
    @Autowired
    private ImageBizDetailService imageBizDetailService;
    @Autowired
    private ImageBizInfoService imageBizInfoService;

    public Boolean signature() {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5728\u7ebf\u7b7e\u7ae0");
        int[] handleNumArr = this.getHandleNumArr();
        List<SignatureRecord> signatureRecords = this.signatureRecordDAO.getSignatureNlsListInTypes("XD050300601", handleNumArr[1], StringUtils.join((Object[])new String[]{PsdConstantSet.PSD_FILE_TM_TYPE_03, ",", PsdConstantSet.PSD_SX_CONT_TM_TYPE, ",", PsdConstantSet.PSD_YX_CONT_TM_TYPE}), handleNumArr[0]);
        if (signatureRecords == null || signatureRecords.isEmpty()) {
            logger.info("\u5728\u7ebf\u7b7e\u7ae0\uff1a\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a");
            return Boolean.TRUE;
        }
        logger.info("\u83b7\u53d6\u9700\u8981\u5904\u7406\u7684\u8131\u654f\u7684\u6570\u636e\u8bb0\u5f55\u6570\u4e3a{}", (Object)signatureRecords.size());
        for (SignatureRecord signatureRecord : signatureRecords) {
            try {
                signatureRecord.setRetryNum(signatureRecord.getRetryNum() + 1);
                if (signatureRecord.getSiuSta() == 1) continue;
                NlsApplyInfo nlsApplyInfo = null;
                if (PsdConstantSet.PSD_YX_CONT_TM_TYPE.equals(signatureRecord.getPolFileType())) {
                    NlsApplyInfo nlsApplyInfoPk = new NlsApplyInfo();
                    nlsApplyInfoPk.setApplySeq(signatureRecord.getApplySeq());
                    nlsApplyInfo = this.nlsApplyInfoDao.queryByPk(nlsApplyInfoPk);
                    if (Objects.isNull((Object)nlsApplyInfo)) {
                        if (signatureRecord.getSiuSta() == 0) {
                            signatureRecord.setSiuSta(2);
                        }
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setErrMsg("\u67e5\u8be2\u7528\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                        this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                        continue;
                    }
                }
                NlsCreditInfo pkParam = new NlsCreditInfo();
                pkParam.setLmtApplySeq(Objects.isNull(nlsApplyInfo) ? signatureRecord.getApplySeq() : nlsApplyInfo.getLmtApplySeq());
                NlsCreditInfo nlsCreditInfo = this.nlsCreditInfoDao.queryByPk(pkParam);
                if (Objects.isNull((Object)nlsCreditInfo)) {
                    if (signatureRecord.getSiuSta() == 0) {
                        signatureRecord.setSiuSta(2);
                    }
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setErrMsg("\u67e5\u8be2\u6388\u4fe1\u4fe1\u606f\u4e3a\u7a7a");
                    this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                    continue;
                }
                String[] tempFileInfo = this.getTempFileInfo(signatureRecord);
                if (signatureRecord.getSiuSta() == 3) {
                    PsdContResult psdContResult = this.psdContService.downSignFile(signatureRecord.getApplySeq(), signatureRecord.getSiuContNo(), tempFileInfo[3]);
                    if (psdContResult.isRetFlag()) {
                        signatureRecord.setSiuSta(1);
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                        this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                        this.psdCertUploadService.insert(psdContResult.getFileFullPath());
                        this.insertCfcaSignInfo(psdContResult, nlsCreditInfo, signatureRecord);
                        this.insertImageBizDetail(signatureRecord.getApplySeq(), signatureRecord.getPolFileType(), FilenameUtils.getBaseName((String)psdContResult.getFileFullPath()), psdContResult.getFileFullPath());
                        this.insertImageBizInfo(signatureRecord, nlsCreditInfo);
                        continue;
                    }
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(psdContResult.getMsg());
                    this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                    continue;
                }
                if (signatureRecord.getSiuSta() != 0 && signatureRecord.getSiuSta() != 2) continue;
                Map<String, String> paramMap = this.getParamMap(signatureRecord, nlsCreditInfo);
                PsdContResult signatureResult = this.psdContService.signature(nlsCreditInfo.getGlobalSerno(), signatureRecord.getApplySeq(), this.getAxqUserId(nlsCreditInfo), tempFileInfo[0], tempFileInfo[1], paramMap);
                if (signatureResult.isRetFlag()) {
                    signatureRecord.setSiuContNo(signatureResult.getAxqContNo());
                    signatureRecord.setSiuRetMsg("cfca\u7b7e\u7ae0\u6210\u529f");
                    PsdContResult psdContResult = this.psdContService.downSignFile(signatureRecord.getApplySeq(), signatureRecord.getSiuContNo(), tempFileInfo[3]);
                    if (psdContResult.isRetFlag()) {
                        signatureRecord.setSiuSta(1);
                        signatureRecord.setLastUpdateTime(new Date());
                        signatureRecord.setDwnRetMsg("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
                        this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                        this.insertCfcaSignInfo(psdContResult, nlsCreditInfo, signatureRecord);
                        this.psdCertUploadService.insert(psdContResult.getFileFullPath());
                        this.insertImageBizDetail(signatureRecord.getApplySeq(), signatureRecord.getPolFileType(), FilenameUtils.getBaseName((String)psdContResult.getFileFullPath()), psdContResult.getFileFullPath());
                        this.insertImageBizInfo(signatureRecord, nlsCreditInfo);
                        continue;
                    }
                    signatureRecord.setSiuSta(3);
                    signatureRecord.setLastUpdateTime(new Date());
                    signatureRecord.setDwnRetMsg(psdContResult.getMsg());
                    this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
                    continue;
                }
                signatureRecord.setSiuSta(2);
                signatureRecord.setSiuRetMsg(signatureResult.getMsg());
                signatureRecord.setLastUpdateTime(new Date());
                this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7b7e\u7ae0\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                signatureRecord.setErrMsg(e.getMessage());
                this.signatureRecordDAO.updateByPrimaryKey(signatureRecord);
            }
        }
        return Boolean.TRUE;
    }

    private Map<String, String> getParamMap(SignatureRecord signatureRecord, NlsCreditInfo nlsCreditInfo) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (PsdConstantSet.PSD_FILE_TM_TYPE_03.equals(signatureRecord.getPolFileType())) {
            paramMap.put("cusName", PsdTmUtils.cusNameTm((String)nlsCreditInfo.getCusName()));
            paramMap.put("certNo", PsdTmUtils.certCodeTm((String)nlsCreditInfo.getCertCode()));
            paramMap.put("signDate", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            return paramMap;
        }
        if (PsdConstantSet.PSD_SX_CONT_TM_TYPE.equals(signatureRecord.getPolFileType())) {
            String siuFillInfo = signatureRecord.getSiuFillInfo();
            Map map = (Map)JSONObject.parseObject((String)siuFillInfo, Map.class);
            map.put("certNoB", PsdTmUtils.certCodeTm((String)((String)map.get("certNoB"))));
            map.put("telB", PsdTmUtils.mobileTm((String)((String)map.get("telB"))));
            map.put("addrB", PsdTmUtils.addrTm((String)((String)map.get("addrB"))));
            map.put("cusNameB", PsdTmUtils.cusNameTm((String)((String)map.get("cusNameB"))));
            map.put("identNoB", PsdTmUtils.certCodeTm((String)((String)map.get("identNoB"))));
            return map;
        }
        if (PsdConstantSet.PSD_YX_CONT_TM_TYPE.equals(signatureRecord.getPolFileType())) {
            String siuFillInfo = signatureRecord.getSiuFillInfo();
            Map map = (Map)JSONObject.parseObject((String)siuFillInfo, Map.class);
            map.put("cusName", PsdTmUtils.cusNameTm((String)((String)map.get("cusName"))));
            map.put("certCode", PsdTmUtils.certCodeTm((String)((String)map.get("certCode"))));
            map.put("cusAddr", PsdTmUtils.addrTm((String)((String)map.get("cusAddr"))));
            map.put("cusPhone", PsdTmUtils.mobileTm((String)((String)map.get("cusPhone"))));
            map.put("recvNo", PsdTmUtils.accountTm((String)((String)map.get("recvNo"))));
            return map;
        }
        return paramMap;
    }

    private String[] getTempFileInfo(SignatureRecord signatureRecord) {
        if (PsdConstantSet.PSD_FILE_TM_TYPE_03.equals(signatureRecord.getPolFileType())) {
            return new String[]{"sqs.pdf", "\u4e2a\u4eba\u6388\u6743\u4e66\uff08\u4e2a\u4eba\u5f81\u4fe1\u548c\u4e2a\u4eba\u4fe1\u606f\uff09", signatureRecord.getApplySeq() + "_tmsqs", signatureRecord.getApplySeq() + "_tmsqs.pdf"};
        }
        if (PsdConstantSet.PSD_SX_CONT_TM_TYPE.equals(signatureRecord.getPolFileType())) {
            return new String[]{"sxcont.pdf", "\u4e2a\u4eba\u7efc\u5408\u6388\u4fe1\u5408\u540c", signatureRecord.getApplySeq() + "_tmsxcont", signatureRecord.getApplySeq() + "_tmsxcont.pdf"};
        }
        if (PsdConstantSet.PSD_YX_CONT_TM_TYPE.equals(signatureRecord.getPolFileType())) {
            return new String[]{"dkcont.pdf", "\u4e2a\u4eba\u501f\u6b3e\u5408\u540c", signatureRecord.getApplySeq() + "_tmdkcont", signatureRecord.getApplySeq() + "_tmdkcont.pdf"};
        }
        return new String[]{"", "", "", ""};
    }

    private String getAxqUserId(NlsCreditInfo nlsCreditInfo) throws Exception {
        PsdContResult openAccountResult = this.psdContService.openAccount(nlsCreditInfo.getCusName(), nlsCreditInfo.getCertType(), nlsCreditInfo.getCertCode(), nlsCreditInfo.getEmail(), nlsCreditInfo.getIndivMobile(), nlsCreditInfo.getIndivRsdAddr(), nlsCreditInfo.getLmtApplySeq());
        if (openAccountResult.isRetFlag()) {
            return openAccountResult.getAxqUserId();
        }
        throw new Exception(openAccountResult.getMsg());
    }

    private void insertCfcaSignInfo(PsdContResult psdContResult, NlsCreditInfo nlsCreditInfo, SignatureRecord signatureRecord) {
        CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
        cfcaSignInfoVO.setApplySeq(this.getTempFileInfo(signatureRecord)[2]);
        cfcaSignInfoVO.setPrdId(nlsCreditInfo.getPrdId());
        cfcaSignInfoVO.setPrdCode(nlsCreditInfo.getPrdCode());
        cfcaSignInfoVO.setPrdName(nlsCreditInfo.getPrdName());
        cfcaSignInfoVO.setCfcaContNo(signatureRecord.getSiuContNo());
        cfcaSignInfoVO.setCusId(nlsCreditInfo.getCusId());
        cfcaSignInfoVO.setCusName(nlsCreditInfo.getCusName());
        cfcaSignInfoVO.setFinaBrId(nlsCreditInfo.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperOrgid(nlsCreditInfo.getNlsOperOrgid());
        cfcaSignInfoVO.setNlsOperUserid(nlsCreditInfo.getNlsOperUserid());
        cfcaSignInfoVO.setCfcaSignState(ElectronicSignatureEnums.CfcaSignmentStateEnum.SIGN.getEnname());
        cfcaSignInfoVO.setCfcaSignTime(psdContResult.getAxqSignTime());
        this.cfcaSignInfoService.insertCfcaSignInfo(cfcaSignInfoVO);
    }

    private int[] getHandleNumArr() {
        int[] result = new int[2];
        try {
            SCfgParamVO param = new SCfgParamVO();
            param.setParamKey("PSD_FILE_HANDLE_NUM");
            SCfgParamVO maxNumCfg = this.sCfgParamService.queryByPk(param);
            result[0] = Objects.isNull(maxNumCfg) ? 50 : Integer.parseInt(maxNumCfg.getParamValue());
            param.setParamKey("PSD_UP_RETRY_NUM");
            SCfgParamVO retryNumCfg = this.sCfgParamService.queryByPk(param);
            result[1] = Objects.isNull(retryNumCfg) ? 3 : Integer.parseInt(retryNumCfg.getParamValue());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void insertImageBizDetail(String applySeq, String imgType, String fileName, String filePath) {
        ImageBizDetailVO imageBizDetail = new ImageBizDetailVO();
        imageBizDetail.setApplySeq(applySeq);
        imageBizDetail.setBizStage("\u6388\u4fe1\u9636\u6bb5");
        imageBizDetail.setFileDesc("\u666e\u7a0e\u8d37\u4e2a\u4eba\u6388\u6743\u4e66");
        imageBizDetail.setFileName(fileName);
        imageBizDetail.setFilePath(filePath);
        imageBizDetail.setImageId(imgType);
        imageBizDetail.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizDetail.setImageType(imgType);
        this.imageBizDetailService.insertImageBizDetail(imageBizDetail);
    }

    private void insertImageBizInfo(SignatureRecord signatureRecord, NlsCreditInfo nlsCreditInfoVO) {
        ImageBizInfoVO param = new ImageBizInfoVO();
        param.setApplySeq(signatureRecord.getApplySeq());
        if (!Objects.isNull(this.imageBizInfoService.queryByPk(param))) {
            return;
        }
        ImageBizInfoVO imageBizInfo = new ImageBizInfoVO();
        imageBizInfo.setApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        imageBizInfo.setCreateDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        imageBizInfo.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        imageBizInfo.setCusId(nlsCreditInfoVO.getCusId());
        imageBizInfo.setCusName(nlsCreditInfoVO.getCusName());
        imageBizInfo.setPrdId(nlsCreditInfoVO.getPrdId());
        imageBizInfo.setPrdCode(nlsCreditInfoVO.getPrdCode());
        imageBizInfo.setPrdName(nlsCreditInfoVO.getPrdName());
        imageBizInfo.setSoltImageAccept("");
        imageBizInfo.setSoltImageCfca("");
        imageBizInfo.setSoltImageThird1("");
        imageBizInfo.setSoltImageThird2("");
        this.imageBizInfoService.insertOrUpdateImageBizInfoVO(imageBizInfo);
    }
}

