/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.tax;

import com.irdstudio.basic.framework.core.util.UUIDUtil;
import com.irdstudio.basic.framework.redis.lock.RedisLock;
import com.irdstudio.efp.console.common.psd.PsdConstantSet;
import com.irdstudio.efp.console.common.psd.PsdEnumSet;
import com.irdstudio.efp.esb.service.bo.req.psd.SendBack2SzReqBean;
import com.irdstudio.efp.esb.service.bo.resp.psd.SendBaxkSx2SzRespBean;
import com.irdstudio.efp.esb.service.facade.psd.SendBack2SzService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.PsdSendTaxMessageRecordService;
import com.irdstudio.efp.nls.service.facade.PsdSendTaxRecordService;
import com.irdstudio.efp.nls.service.facade.psd.PreNlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.psd.PsdBackSzTaxService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.PsdSendTaxMessageRecordVO;
import com.irdstudio.efp.nls.service.vo.PsdSendTaxRecordVO;
import com.irdstudio.efp.nls.service.vo.psd.PreNlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service(value="psdBackSzTaxService")
public class PsdBackSzTaxServiceImpl
implements PsdBackSzTaxService {
    private static final Logger logger = LoggerFactory.getLogger(PsdBackSzTaxServiceImpl.class);
    public static final String FKXX = "FKXX";
    @Value(value="${back.szsj.gcb.channel.code}")
    private String gcbChannelCode;
    @Value(value="${back.szsj.gcb.pd.code:XD050300601}")
    private String pdCode;
    @Value(value="${tax.max.hand.num:5}")
    private int maxHandNum;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    private PreNlsCreditInfoService preNlsCreditInfoService;
    @Autowired
    private SendBack2SzService sendBack2SzService;
    @Autowired
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    private AccLoanService accLoanService;
    @Autowired
    private PsdSendTaxRecordService psdSendTaxRecordService;
    @Autowired
    private PsdSendTaxMessageRecordService psdSendTaxMessageRecordService;
    @Autowired
    private LmtPrdContService lmtPrdContService;

    @RedisLock(key="psdBackSzTaxService", expire=60)
    @Deprecated
    public String genLoanYwlsh() {
        LocalDateTime now = LocalDateTime.now();
        logger.info("\u5f00\u59cb\u751f\u6210\u9700\u8981\u56de\u5199\u7a0e\u5c40\u7684\u653e\u6b3e\u6d41\u6c34\u53f7\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c\u94f6\u884c\u6e20\u9053\u53f7{}", (Object)now.toString(), (Object)this.gcbChannelCode);
        StringBuilder ywlshBuilder = new StringBuilder();
        ywlshBuilder.append(this.gcbChannelCode);
        ywlshBuilder.append(FKXX);
        String dateStr = now.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String timeStr = now.format(DateTimeFormatter.ofPattern("HHmmss"));
        ywlshBuilder.append(dateStr);
        ywlshBuilder.append(timeStr);
        if (!this.jedisCluster.exists(PsdConstantSet.BACK_SZSJ_LOAN_YELSH_KEY).booleanValue() || !this.jedisCluster.hexists(PsdConstantSet.BACK_SZSJ_LOAN_YELSH_KEY, dateStr).booleanValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(dateStr, "0001");
            this.jedisCluster.hmset(PsdConstantSet.BACK_SZSJ_LOAN_YELSH_KEY, map);
            ywlshBuilder.append("0001");
            return ywlshBuilder.toString();
        }
        String indexStr = this.jedisCluster.hget(PsdConstantSet.BACK_SZSJ_LOAN_YELSH_KEY, dateStr);
        int newIndexValue = Integer.parseInt(indexStr) + 1;
        String newIndexStr = String.format("%04d", newIndexValue);
        logger.info("\u5f53\u524dkey{}\uff0c\u5f53\u524d\u6240\u6709\u503c{}", (Object)dateStr, (Object)newIndexStr);
        this.jedisCluster.hset(PsdConstantSet.BACK_SZSJ_LOAN_YELSH_KEY, dateStr, newIndexStr);
        ywlshBuilder.append(newIndexStr);
        return ywlshBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] backSzsjAfterLoan(String applySeq, boolean insertFlag, int recordId) {
        logger.info("\u653e\u6b3e\u540e\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5904\u7406\u5f00\u59cb\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a{}", (Object)applySeq);
        NlsApplyInfoVO nlsApplyInfoPk = new NlsApplyInfoVO();
        nlsApplyInfoPk.setApplySeq(applySeq);
        NlsApplyInfoVO nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoPk);
        AccLoanVO accLoanPk = new AccLoanVO();
        accLoanPk.setApplySeq(applySeq);
        AccLoanVO accLoanVO = this.accLoanService.queryByApplySeq(accLoanPk);
        NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(nlsApplyInfoVO.getLmtApplySeq());
        PreNlsCreditInfoVO preNlsCreditInfoPk = new PreNlsCreditInfoVO();
        preNlsCreditInfoPk.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
        PreNlsCreditInfoVO preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoPk);
        if (StringUtils.isEmpty((CharSequence)preNlsCreditInfoVO.getBkColumn3())) {
            logger.info("\u4e1a\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u505a\u56de\u5199\u5904\u7406");
            return new Object[]{false, ""};
        }
        LmtPrdContVO lmtPrdContPk = new LmtPrdContVO();
        lmtPrdContPk.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContPk);
        String reqInfo = "";
        String respInfo = "";
        try {
            SendBack2SzReqBean.LoanReleaseInfo loanReleaseInfo = new SendBack2SzReqBean.LoanReleaseInfo();
            loanReleaseInfo.setDistrSrlNo(preNlsCreditInfoVO.getBkColumn3());
            loanReleaseInfo.setPdNo(this.pdCode);
            loanReleaseInfo.setSoctCrdtCd(preNlsCreditInfoVO.getSocialCreditCode());
            loanReleaseInfo.setDistrAmt(accLoanVO.getLoanAmount());
            loanReleaseInfo.setDistrTrmBegDt(accLoanVO.getLoanStartDate());
            loanReleaseInfo.setDistrTrmStopDt(lmtPrdContVO.getExpireDate());
            loanReleaseInfo.setRmrk("\u7eb3\u7a0e\u4eba\u6210\u529f\u63d0\u6b3e\u540e\u56de\u5199\u6570\u636e\u7ed9\u6df1\u5733\u7a0e\u5c40");
            loanReleaseInfo.setGlobalSerno(nlsApplyInfoVO.getGlobalSerno());
            logger.info("\u653e\u6b3e\u540e\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u8bf7\u6c42\u62a5\u6587\u4e3a\uff1a{}", (Object)loanReleaseInfo.toString());
            reqInfo = loanReleaseInfo.toString();
            SendBaxkSx2SzRespBean sendBaxkSx2SzRespBean = this.sendBack2SzService.sendBackLoanReleaseInfo(loanReleaseInfo);
            logger.info("\u653e\u6b3e\u540e\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a{}", (Object)sendBaxkSx2SzRespBean.toString());
            if (insertFlag) {
                recordId = this.insertTaxRecord(applySeq, PsdEnumSet.PsdTaxSendType.LOANREL, PsdEnumSet.HandleFlg.YES, preNlsCreditInfoVO, nlsCreditInfoVO, nlsApplyInfoVO, sendBaxkSx2SzRespBean.getDistrSrlNo());
                this.insertTaxRecord(nlsCreditInfoVO.getLmtApplySeq(), PsdEnumSet.PsdTaxSendType.LIMITUPDATE, PsdEnumSet.HandleFlg.NO, preNlsCreditInfoVO, nlsCreditInfoVO, nlsApplyInfoVO, sendBaxkSx2SzRespBean.getDistrSrlNo());
            }
            respInfo = sendBaxkSx2SzRespBean.toString();
            Object[] objectArray = new Object[]{true, sendBaxkSx2SzRespBean.getDistrSrlNo()};
            return objectArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u653e\u6b3e\u540e\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5904\u7406\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            logger.info("\u653e\u6b3e\u540e\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)applySeq, (Object)e.getMessage());
            if (insertFlag) {
                recordId = this.insertTaxRecord(applySeq, PsdEnumSet.PsdTaxSendType.LOANREL, PsdEnumSet.HandleFlg.NO, preNlsCreditInfoVO, nlsCreditInfoVO, nlsApplyInfoVO, "");
                this.insertTaxRecord(nlsCreditInfoVO.getLmtApplySeq(), PsdEnumSet.PsdTaxSendType.LIMITUPDATE, PsdEnumSet.HandleFlg.NO, preNlsCreditInfoVO, nlsCreditInfoVO, nlsApplyInfoVO, "");
            }
            respInfo = e.getMessage();
            Object[] objectArray = new Object[]{false, ""};
            return objectArray;
        }
        finally {
            this.insertMessageLog(recordId, reqInfo, respInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backSzsjByLimitApprove(@NotNull String applySeq, boolean insertFlag, int recordId) {
        logger.info("\u5f00\u59cb\u56de\u5199\u6df1\u5733\u7a0e\u5c40\uff08\u989d\u5ea6\u66f4\u65b0\uff09\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)applySeq);
        NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(applySeq);
        PreNlsCreditInfoVO preNlsCreditInfoPk = new PreNlsCreditInfoVO();
        preNlsCreditInfoPk.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
        PreNlsCreditInfoVO preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoPk);
        if (StringUtils.isEmpty((CharSequence)preNlsCreditInfoVO.getBkColumn3())) {
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u7ed3\u675f\uff0c\u4e1a\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a\u3002\u4e0d\u505a\u56de\u5199\u5904\u7406\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)applySeq);
            return false;
        }
        String reqInfo = "";
        String respInfo = "";
        try {
            BigDecimal approveAmt = nlsCreditInfoVO.getApproveAmt();
            SendBack2SzReqBean.SxLimit reqBean = new SendBack2SzReqBean.SxLimit();
            reqBean.setGlobalSerno(nlsCreditInfoVO.getGlobalSerno());
            reqBean.setBsnSrlNo(preNlsCreditInfoVO.getBkColumn3());
            reqBean.setCrLmt(approveAmt);
            reqBean.setRmrk("\u7eb3\u7a0e\u4eba\u83b7\u53d6\u6b63\u5f0f\u6388\u4fe1\u5ba1\u6279\u989d\u5ea6\u6570\u636e\u56de\u5199");
            reqBean.setPdNo(this.pdCode);
            reqBean.setSoctCrdtCd(preNlsCreditInfoVO.getSocialCreditCode());
            logger.info("\u5f00\u59cb\u8c03\u7528\u6df1\u5733\u7a0e\u5c40\u989d\u5ea6\u56de\u5199,\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a{},\u53c2\u6570\u4e3a\uff1a{}", (Object)applySeq, (Object)reqBean.toString());
            reqInfo = reqBean.toString();
            SendBaxkSx2SzRespBean sendBaxkSx2SzRespBean = this.sendBack2SzService.sendBackSxLimit(reqBean);
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u6210\u529f\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a{}\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a{}", (Object)applySeq, (Object)sendBaxkSx2SzRespBean.toString());
            if (insertFlag) {
                recordId = this.insertTaxRecord(applySeq, PsdEnumSet.PsdTaxSendType.LMTAPPROVE, PsdEnumSet.HandleFlg.YES, preNlsCreditInfoVO, nlsCreditInfoVO, null, null);
            }
            respInfo = sendBaxkSx2SzRespBean.toString();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u53d1\u9001\u5f02\u5e38\uff0c\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            if (insertFlag) {
                recordId = this.insertTaxRecord(applySeq, PsdEnumSet.PsdTaxSendType.LMTAPPROVE, PsdEnumSet.HandleFlg.NO, preNlsCreditInfoVO, nlsCreditInfoVO, null, null);
            }
            respInfo = e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u7ed3\u675f\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:{}", (Object)applySeq);
            this.insertMessageLog(recordId, reqInfo, respInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backSzsjByLimitUpdate(@NotNull String applySeq, int recordId) {
        logger.info("\u5f00\u59cb\u56de\u5199\u6df1\u5733\u7a0e\u5c40\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)applySeq);
        NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(applySeq);
        PreNlsCreditInfoVO preNlsCreditInfoPk = new PreNlsCreditInfoVO();
        preNlsCreditInfoPk.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
        PreNlsCreditInfoVO preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoPk);
        if (StringUtils.isEmpty((CharSequence)preNlsCreditInfoVO.getBkColumn3())) {
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u7ed3\u675f\uff0c\u4e1a\u52a1\u6d41\u6c34\u53f7\u4e3a\u7a7a\u3002\u4e0d\u505a\u56de\u5199\u5904\u7406\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{}", (Object)applySeq);
            return false;
        }
        LmtPrdContVO lmtPrdContPk = new LmtPrdContVO();
        lmtPrdContPk.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContPk);
        String reqInfo = "";
        String respInfo = "";
        try {
            BigDecimal availAmt = lmtPrdContVO.getAvailAmt();
            SendBack2SzReqBean.SxLimit reqBean = new SendBack2SzReqBean.SxLimit();
            reqBean.setGlobalSerno(nlsCreditInfoVO.getGlobalSerno());
            reqBean.setBsnSrlNo(preNlsCreditInfoVO.getBkColumn3());
            reqBean.setCrLmt(availAmt);
            reqBean.setRmrk("\u7eb3\u7a0e\u4eba\u53ef\u7528\u989d\u5ea6\u66f4\u65b0\u6570\u636e\u56de\u5199");
            reqBean.setPdNo(this.pdCode);
            reqBean.setSoctCrdtCd(preNlsCreditInfoVO.getSocialCreditCode());
            logger.info("\u5f00\u59cb\u8c03\u7528\u6df1\u5733\u7a0e\u5c40\u989d\u5ea6\u56de\u5199,\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a{},\u53c2\u6570\u4e3a\uff1a{}", (Object)applySeq, (Object)reqBean.toString());
            reqInfo = reqBean.toString();
            SendBaxkSx2SzRespBean sendBaxkSx2SzRespBean = this.sendBack2SzService.sendBackSxLimit(reqBean);
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u6210\u529f\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a{}\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a{}", (Object)applySeq, (Object)sendBaxkSx2SzRespBean.toString());
            respInfo = sendBaxkSx2SzRespBean.toString();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u53d1\u9001\u5f02\u5e38\uff0c\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            respInfo = e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u7ed3\u675f\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a:{}", (Object)applySeq);
            this.insertMessageLog(recordId, reqInfo, respInfo);
        }
    }

    public int insertTaxRecord(String applySeq, PsdEnumSet.PsdTaxSendType sendType, PsdEnumSet.HandleFlg handleFlg, PreNlsCreditInfoVO preNlsCreditInfoVO, NlsCreditInfoVO nlsCreditInfoVO, NlsApplyInfoVO nlsApplyInfoVO, String fklsh) {
        logger.info("\u5f00\u59cb\u63d2\u5165\u6570\u636e\u5230\u56de\u5199\u8868\uff0c\u6d41\u6c34\u53f7{}\uff0c\u56de\u5199\u7c7b\u578b{}\uff0c\u653e\u6b3e\u6d41\u6c34\u53f7{}", new Object[]{applySeq, sendType.getSendType(), fklsh});
        PsdSendTaxRecordVO psdSendTaxRecordVO = new PsdSendTaxRecordVO();
        psdSendTaxRecordVO.setApplySeq(applySeq);
        psdSendTaxRecordVO.setSendType(sendType.getSendType());
        psdSendTaxRecordVO.setHandStatus(handleFlg.getValue());
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(0));
        psdSendTaxRecordVO.setCreateTime(new Date());
        psdSendTaxRecordVO.setSzsjFlag(PsdEnumSet.HandleFlg.YES.getValue());
        psdSendTaxRecordVO.setApplyStatus(PsdEnumSet.HandleFlg.YES.getValue());
        psdSendTaxRecordVO.setApplyStatus("Y");
        switch (sendType) {
            case LMTAPPROVE: {
                psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
                psdSendTaxRecordVO.setSzsjYwlsh(preNlsCreditInfoVO.getBkColumn3());
                psdSendTaxRecordVO.setBizDate(nlsCreditInfoVO.getApprvDate());
                psdSendTaxRecordVO.setApplyMsg("\u7eb3\u7a0e\u4eba\u83b7\u53d6\u6388\u4fe1\u5ba1\u6279\u989d\u5ea6\u6210\u529f");
                return this.psdSendTaxRecordService.insert(psdSendTaxRecordVO);
            }
            case LOANREL: {
                psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
                psdSendTaxRecordVO.setSzsjYwlsh(preNlsCreditInfoVO.getBkColumn3());
                psdSendTaxRecordVO.setBizDate(nlsApplyInfoVO.getApplyDate());
                psdSendTaxRecordVO.setApplyMsg("\u7eb3\u7a0e\u4eba\u653e\u6b3e\u6210\u529f\u540e\u56de\u5199\u653e\u6b3e\u4fe1\u606f");
                psdSendTaxRecordVO.setSzsjFklsh(fklsh);
                return this.psdSendTaxRecordService.insert(psdSendTaxRecordVO);
            }
            case LIMITUPDATE: {
                if (Objects.isNull(nlsCreditInfoVO)) {
                    NlsCreditInfoVO nlsCreditInfoPk = new NlsCreditInfoVO();
                    nlsCreditInfoPk.setLmtApplySeq(applySeq);
                    nlsCreditInfoVO = this.nlsCreditInfoService.queryByPk(nlsCreditInfoPk);
                }
                if (Objects.isNull(preNlsCreditInfoVO)) {
                    PreNlsCreditInfoVO preNlsCreditInfoPk = new PreNlsCreditInfoVO();
                    preNlsCreditInfoPk.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
                    preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoPk);
                }
                psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
                psdSendTaxRecordVO.setSzsjYwlsh(preNlsCreditInfoVO.getBkColumn3());
                psdSendTaxRecordVO.setBizDate(nlsCreditInfoVO.getApprvDate());
                psdSendTaxRecordVO.setApplyMsg("\u7eb3\u7a0e\u4eba\u6388\u4fe1\u5ba1\u6279\u53ef\u7528\u989d\u5ea6\u6210\u529f");
                return this.psdSendTaxRecordService.insert(psdSendTaxRecordVO);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean taskBack2Szsj() {
        try {
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff0c\u5f53\u524d\u6700\u5927\u5904\u7406\u6b21\u6570\u4e3a{}", (Object)this.maxHandNum);
            PsdSendTaxRecordVO queryParam = new PsdSendTaxRecordVO();
            queryParam.setHandStatus(PsdEnumSet.HandleFlg.NO.getValue());
            queryParam.setHandNum(Integer.valueOf(this.maxHandNum));
            List recordS = this.psdSendTaxRecordService.querySzRecordByStatusAndNum(queryParam);
            if (recordS.isEmpty()) {
                logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f53\u524d\u83b7\u53d6\u5230\u8981\u5904\u7406\u7684\u6570\u636e\u6761\u6570\u4e3a{},\u6d41\u7a0b\u7ed3\u675f", (Object)0);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f53\u524d\u83b7\u53d6\u5230\u8981\u5904\u7406\u7684\u6570\u636e\u6761\u6570\u4e3a{}", (Object)recordS.size());
            recordS.forEach(this::sendBackSzsj);
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u5f53\u524d\u6700\u5927\u5904\u7406\u6b21\u6570\u4e3a{}", (Object)this.maxHandNum);
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendBackSzsj(PsdSendTaxRecordVO recore) {
        try {
            recore.setHandNum(Integer.valueOf(recore.getHandNum() + 1));
            PsdEnumSet.PsdTaxSendType sendType = PsdEnumSet.PsdTaxSendType.getEnum((String)recore.getSendType());
            assert (sendType != null);
            logger.info("\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u5b9a\u65f6\u4efb\u52a1\uff0c\u5faa\u73af\u5904\u7406\u6570\u636e\uff0c\u5f53\u524d\u5904\u7406\u6570\u636e\u6d41\u6c34\u4e3a{}\uff0c\u5f53\u524d\u5904\u7406\u7c7b\u578b\u4e3a{},\u6d41\u7a0b\u7ed3\u675f", (Object)recore.getApplySeq(), (Object)sendType.getDesc());
            switch (Objects.requireNonNull(sendType)) {
                case LMTAPPROVE: {
                    logger.info("\u8865\u507f\u56de\u5199\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f\u5230\u6df1\u5733\u7a0e\u5c40");
                    if (!this.backSzsjByLimitApprove(recore.getApplySeq(), false, recore.getId())) return;
                    logger.info("\u56de\u5199\u6210\u529f");
                    recore.setHandStatus(PsdEnumSet.HandleFlg.YES.getValue());
                    return;
                }
                case LOANREL: {
                    logger.info("\u8865\u507f\u56de\u5199\u653e\u6b3e\u4fe1\u606f\u5230\u6df1\u5733\u7a0e\u5c40");
                    Object[] resultArr = this.backSzsjAfterLoan(recore.getApplySeq(), false, recore.getId());
                    if ((Boolean)resultArr[0] == false) return;
                    recore.setHandStatus(PsdEnumSet.HandleFlg.YES.getValue());
                    recore.setSzsjFklsh((String)resultArr[1]);
                    logger.info("\u56de\u5199\u6210\u529f");
                    return;
                }
                case LIMITUPDATE: {
                    logger.info("\u56de\u5199\u989d\u5ea6\u4fe1\u606f\u5230\u6df1\u5733\u7a0e\u5c40");
                    if (!this.backSzsjByLimitUpdate(recore.getApplySeq(), recore.getId())) return;
                    recore.setHandStatus(PsdEnumSet.HandleFlg.YES.getValue());
                    logger.info("\u56de\u5199\u6210\u529f");
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            logger.error("\u5904\u7406\u56de\u5199\u6df1\u5733\u7a0e\u5c40\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)exception);
            return;
        }
        finally {
            this.psdSendTaxRecordService.updateByPk(recore);
        }
    }

    private void insertMessageLog(int recordId, String reqInfo, String respInfo) {
        if (recordId >= 0) {
            PsdSendTaxMessageRecordVO psdSendTaxMessageRecordVO = new PsdSendTaxMessageRecordVO();
            try {
                psdSendTaxMessageRecordVO.setId(UUIDUtil.getUUID());
                psdSendTaxMessageRecordVO.setSendTaxRecordId(Integer.valueOf(recordId));
                psdSendTaxMessageRecordVO.setSendTime(new Date());
                psdSendTaxMessageRecordVO.setSendMessage((Object)reqInfo);
                psdSendTaxMessageRecordVO.setRetMessage((Object)respInfo);
                psdSendTaxMessageRecordVO.setCreateTime(new Date());
                this.psdSendTaxMessageRecordService.insert(psdSendTaxMessageRecordVO);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u63d2\u5165\u6570\u636epsdSendTaxMessageRecordVO\uff1a{}\u5f02\u5e38\uff1a{}", (Object)psdSendTaxMessageRecordVO.toString(), (Object)e.getMessage());
            }
        }
    }
}

