/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.timedTask;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.SpringContextUtils;
import com.irdstudio.basic.framework.redis.lock.RedisLock;
import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.esb.service.bo.req.psd.PsdSendMsgToTaxReqBean;
import com.irdstudio.efp.esb.service.bo.resp.psd.PsdSendMsgToTaxRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.psd.PsdSendMsgToTaxService;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.PsdSendTaxMessageRecordService;
import com.irdstudio.efp.nls.service.facade.PsdSendTaxRecordService;
import com.irdstudio.efp.nls.service.facade.psd.NlsCreditApprovalInfoService;
import com.irdstudio.efp.nls.service.facade.psd.PreNlsCreditInfoService;
import com.irdstudio.efp.nls.service.facade.psd.PsdBackSzTaxService;
import com.irdstudio.efp.nls.service.facade.psd.SendMsgToTaxService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.PsdSendTaxMessageRecordVO;
import com.irdstudio.efp.nls.service.vo.PsdSendTaxRecordVO;
import com.irdstudio.efp.nls.service.vo.psd.NlsCreditApprovalInfoVO;
import com.irdstudio.efp.nls.service.vo.psd.PreNlsCreditInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="psdSendMsgToTaxService")
public class SendMsgToTaxServiceImpl
implements SendMsgToTaxService {
    private static Logger logger = LoggerFactory.getLogger(SendMsgToTaxServiceImpl.class);
    @Value(value="${hk.tax.jrcpbh:00000079}")
    private String jrcpbh;
    @Value(value="${tax.max.hand.num:5}")
    private int maxHandNum;
    @Value(value="${tax.max.send.day:3}")
    private int maxSendDay;
    @Autowired
    @Qualifier(value="nlsCreditApprovalInfoService")
    private NlsCreditApprovalInfoService nlsCreditApprovalInfoService;
    @Autowired
    @Qualifier(value="preNlsCreditInfoService")
    private PreNlsCreditInfoService preNlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;
    @Autowired
    @Qualifier(value="psdWdSendMsgToTaxService")
    private PsdSendMsgToTaxService psdWdSendMsgToTaxService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    private PsdSendTaxRecordService psdSendTaxRecordService;
    @Autowired
    private PsdSendTaxMessageRecordService psdSendTaxMessageRecordService;
    @Autowired
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    private PsdBackSzTaxService psdBackSzTaxService;
    private ArrayList<String> taxNumber = new ArrayList();
    private static final PatternDescriptor pattern = DefaultPatternDescriptor.of((String)"2003000$YE$$MONTH$$DAY$$HOUR$$MIN$$SECOND$$SEQ$", (Integer)6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sendMsgToTax() {
        try {
            block14: {
                List records = this.nlsCreditApprovalInfoService.getNotSendMsgToTaxRecord();
                if (!Objects.nonNull(records)) break block14;
                if (records.size() <= 0) break;
                logger.info("\u666e\u7a0e\u8d37\u53d1\u9001\u7a0e\u5c40\u6570\u636e\u5171\u6709" + records.size());
                for (NlsCreditApprovalInfoVO record : records) {
                    if (record.getExcuteTime() >= 10) continue;
                    NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(record.getLmtApplySeq());
                    if (Objects.isNull(nlsCreditInfoVO)) {
                        logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + record.getLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                        continue;
                    }
                    PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
                    preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
                    preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
                    if (Objects.isNull(preNlsCreditInfoVO)) {
                        logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                        continue;
                    }
                    CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
                    ctrLoanContVO.setContNo(nlsCreditInfoVO.getLmtApplySeq());
                    ctrLoanContVO = Optional.ofNullable(this.ctrLoanContService.queryByPk(ctrLoanContVO)).orElseGet(CtrLoanContVO::new);
                    try {
                        double zero = BigDecimal.ZERO.setScale(2, 4).doubleValue();
                        double amount = Optional.ofNullable(nlsCreditInfoVO.getApproveAmt()).orElse(BigDecimal.ZERO).setScale(2, 4).doubleValue();
                        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
                        psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
                        psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
                        psdSendMsgToTaxReqBean.setCrFailRsnDesc(record.getRefuseMsg());
                        psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf(amount));
                        psdSendMsgToTaxReqBean.setCrIndr("Y".equals(record.getApprResult()) ? "Y" : "N");
                        psdSendMsgToTaxReqBean.setApplySeq(nlsCreditInfoVO.getGlobalSerno());
                        psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
                        psdSendMsgToTaxReqBean.setBadCustIndr(this.accLoanService.isCusLossCredit(nlsCreditInfoVO.getCusId()) ? "Y" : "N");
                        psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf(zero));
                        psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf(zero));
                        try {
                            Instant instant = record.getApproveTime().toInstant();
                            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                            String approveDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            String date = DateUtility.ADD_MONTH((String)approveDate, (int)Integer.parseInt(Optional.ofNullable(nlsCreditInfoVO.getApplyTerm()).orElse("12").trim())).replace("-", "");
                            psdSendMsgToTaxReqBean.setRpymtDt(date);
                            psdSendMsgToTaxReqBean.setCrMtrDt(DateUtility.format8To10((String)date));
                            psdSendMsgToTaxReqBean.setCrStrtDay(approveDate);
                        }
                        catch (Exception e) {
                            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + record.getLmtApplySeq() + "\u3011\u8fd8\u6b3e\u65e5\u671f\u8f6c\u6362\u5931\u8d25 " + e.getMessage());
                            continue;
                        }
                        EsbInvokeWrapper esbInvokeWrapper = new EsbInvokeWrapper((Object)this.psdWdSendMsgToTaxService, (Object)psdSendMsgToTaxReqBean, this.nlsQueueSoltComnService);
                        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = (PsdSendMsgToTaxRespBean)esbInvokeWrapper.invoke3Threes();
                        logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + record.getLmtApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
                        record.setIsSendToTax("Y");
                        record.setTmstmp(psdSendMsgToTaxRespBean.getTmstmp());
                        record.setTxnSrlNo(psdSendMsgToTaxReqBean.getTxnSrlNo());
                        this.nlsCreditApprovalInfoService.updateByPrimaryKeySelective(record);
                    }
                    catch (ESBException e) {
                        logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + record.getLmtApplySeq() + "\u3011\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25 " + e.getMessage());
                        record.setExcuteTime(record.getExcuteTime() + 1);
                        this.nlsCreditApprovalInfoService.updateByPrimaryKeySelective(record);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + record.getLmtApplySeq() + "\u3011\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c \u67e5\u8be2\u672a\u53d1\u9001\u5230\u7a0e\u5c40\u7684\u6570\u636e\u51fa\u9519" + e.getMessage());
            Boolean bl = false;
            return bl;
        }
        finally {
            return true;
        }
    }

    @RedisLock(key="psd_send_tax_taskHandle", expire=3600)
    public Boolean taskHandle() {
        logger.info("\u7a0e\u5c40\u56de\u5199\u5904\u7406\u5668\u5f00\u59cb\u6267\u884c");
        this.taxNumber.clear();
        logger.info("\u7a0e\u5c40\u56de\u5199\u5904\u7406\u5668\u5f00\u59cb\u6267\u884c\u7701\u7a0e\u5c40\u90e8\u5206");
        this.taskHandleSsj();
        logger.info("\u7a0e\u5c40\u56de\u5199\u5904\u7406\u5668\u7ed3\u675f\u6267\u884c\u7701\u7a0e\u5c40\u90e8\u5206");
        logger.info("\u7a0e\u5c40\u56de\u5199\u5904\u7406\u5668\u5f00\u59cb\u6267\u884c\u6df1\u5733\u7a0e\u5c40\u90e8\u5206");
        this.psdBackSzTaxService.taskBack2Szsj();
        logger.info("\u7a0e\u5c40\u56de\u5199\u5904\u7406\u5668\u7ed3\u675f\u6267\u884c\u6df1\u5733\u7a0e\u5c40\u90e8\u5206");
        logger.info("\u7a0e\u5c40\u56de\u5199\u5904\u7406\u5668\u7ed3\u675f\u6267\u884c");
        return Boolean.TRUE;
    }

    private void taskHandleSsj() {
        try {
            PsdSendTaxRecordVO queryParam = new PsdSendTaxRecordVO();
            queryParam.setHandStatus("N");
            queryParam.setHandNum(Integer.valueOf(this.maxHandNum));
            List psdSendTaxRecordVOS = this.psdSendTaxRecordService.queryRecordByStatusAndNum(queryParam);
            if (psdSendTaxRecordVOS.isEmpty()) {
                logger.info("\u83b7\u53d6\u5230\u56de\u5199\u7a0e\u5c40\uff08\u7701\u7a0e\u5c40\uff09\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u56de\u5199\u7701\u7a0e\u5c40\u5904\u7406\u7ed3\u675f");
                return;
            }
            for (PsdSendTaxRecordVO psdSendTaxRecordVO : psdSendTaxRecordVOS) {
                this.hand(psdSendTaxRecordVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u56de\u5199\u7701\u7a0e\u5c40\u5904\u7406\u51fa\u9519\uff0c\u4fe1\u606f\u4e3a\uff1a", (Throwable)e);
        }
    }

    private void hand(PsdSendTaxRecordVO psdSendTaxRecordVO) {
        String sendType;
        switch (sendType = psdSendTaxRecordVO.getSendType()) {
            case "0": {
                this.hand0(psdSendTaxRecordVO);
                break;
            }
            case "1": {
                this.hand1(psdSendTaxRecordVO);
                break;
            }
            case "2": {
                this.hand2(psdSendTaxRecordVO);
                break;
            }
            case "3": {
                this.hand3(psdSendTaxRecordVO, "02");
                break;
            }
            case "4": {
                this.hand3(psdSendTaxRecordVO, "03");
                break;
            }
            case "5": {
                this.hand5(psdSendTaxRecordVO);
                break;
            }
            case "6": {
                this.hand6(psdSendTaxRecordVO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hand6(PsdSendTaxRecordVO psdSendTaxRecordVO) {
        boolean updateFlag = true;
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(psdSendTaxRecordVO.getHandNum() + 1));
        NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = null;
        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = new PsdSendMsgToTaxRespBean();
        try {
            NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(psdSendTaxRecordVO.getApplySeq());
            if (Objects.isNull(nlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + psdSendTaxRecordVO.getApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
            preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
            if (Objects.isNull(preNlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            if (this.taxNumber.contains(preNlsCreditInfoVO.getTaxIdentificationNumber())) {
                updateFlag = false;
                return;
            }
            psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(psdSendTaxRecordVO.getApplySeq());
            if (Objects.isNull(nlsCreditApprovalInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
            }
            String[] fstCrdtDt = this.getFstCrdtDt(nlsCreditInfoVO, preNlsCreditInfoVO);
            psdSendMsgToTaxReqBean.setApplySeq(this.getSeq(nlsCreditInfoVO.getGlobalSerno()));
            double zero = BigDecimal.ZERO.setScale(2, 4).doubleValue();
            double amount = Optional.ofNullable(nlsCreditInfoVO.getApproveAmt()).orElse(BigDecimal.ZERO).setScale(2, 4).doubleValue();
            psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
            psdSendMsgToTaxReqBean.setCrFailRsnDesc(psdSendTaxRecordVO.getApplyMsg());
            psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf(amount));
            psdSendMsgToTaxReqBean.setCrIndr("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
            psdSendMsgToTaxReqBean.setBadCustIndr(this.accLoanService.isCusLossCredit(nlsCreditInfoVO.getCusId()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf(new BigDecimal(fstCrdtDt[2]).doubleValue()));
            psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf(new BigDecimal(fstCrdtDt[3]).doubleValue()));
            Instant instant = nlsCreditApprovalInfoVO.getApproveTime().toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            String approveDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            psdSendMsgToTaxReqBean.setRpymtDt(psdSendTaxRecordVO.getBizDate());
            psdSendMsgToTaxReqBean.setCrMtrDt(psdSendTaxRecordVO.getBizDate());
            psdSendMsgToTaxReqBean.setCrStrtDay(approveDate);
            psdSendMsgToTaxReqBean.setNetCrdtLoanFlg("Y");
            psdSendMsgToTaxReqBean.setFstCrdtDt(fstCrdtDt[0]);
            psdSendMsgToTaxReqBean.setLoanCrTrm("12");
            psdSendMsgToTaxReqBean.setAcmlnUseCnt(fstCrdtDt[1]);
            psdSendMsgToTaxReqBean.setExpnsUseAmt(new BigDecimal(fstCrdtDt[2]));
            psdSendMsgToTaxReqBean.setLoanTp("1");
            psdSendMsgToTaxRespBean = this.psdWdSendMsgToTaxService.applyPsdSendMsgToTax(psdSendMsgToTaxReqBean);
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, null);
            psdSendTaxRecordVO.setHandStatus("Y");
            logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
        }
        catch (Exception e) {
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, e);
            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (updateFlag) {
                this.psdSendTaxRecordService.updateByPk(psdSendTaxRecordVO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hand5(PsdSendTaxRecordVO psdSendTaxRecordVO) {
        boolean updateFlag = true;
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(psdSendTaxRecordVO.getHandNum() + 1));
        NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = null;
        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = new PsdSendMsgToTaxRespBean();
        try {
            String applySeq = psdSendTaxRecordVO.getApplySeq();
            AccLoanVO billNoParam = new AccLoanVO();
            billNoParam.setBillNo(applySeq);
            AccLoanVO accLoanVO = this.accLoanService.queryByPk(billNoParam);
            if (Objects.isNull(accLoanVO)) {
                logger.info("\u4e3b\u52a8\u8fd8\u6b3e\u56de\u8c03\u67e5\u8be2\u501f\u636e\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u501f\u636e\u4fe1\u606f\uff0c\u501f\u636e\u53f7");
            }
            NlsApplyInfoVO pkParam = new NlsApplyInfoVO();
            pkParam.setApplySeq(accLoanVO.getApplySeq());
            NlsApplyInfoVO nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(pkParam);
            if (Objects.isNull(nlsApplyInfoVO)) {
                logger.info("\u652f\u7528\u56de\u8c03\u7a0e\u5c40\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{},\u83b7\u53d6\u5230\u7684\u7528\u4fe1\u7533\u8bf7\u8bb0\u5f55\u4e3a\u7a7a", (Object)accLoanVO.getApplySeq());
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7");
            }
            String lmtApplySeq = nlsApplyInfoVO.getLmtApplySeq();
            NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(lmtApplySeq);
            if (Objects.isNull(nlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
            preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
            if (Objects.isNull(preNlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            if (this.taxNumber.contains(preNlsCreditInfoVO.getTaxIdentificationNumber())) {
                updateFlag = false;
                return;
            }
            psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(lmtApplySeq);
            if (Objects.isNull(nlsCreditApprovalInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
            }
            String[] fstCrdtDt = this.getFstCrdtDt(nlsCreditInfoVO, preNlsCreditInfoVO);
            psdSendMsgToTaxReqBean.setApplySeq(this.getSeq(nlsApplyInfoVO.getGlobalSerno()));
            double zero = BigDecimal.ZERO.setScale(2, 4).doubleValue();
            double amount = Optional.ofNullable(nlsCreditInfoVO.getApproveAmt()).orElse(BigDecimal.ZERO).setScale(2, 4).doubleValue();
            psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
            psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf(amount));
            psdSendMsgToTaxReqBean.setCrIndr("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
            psdSendMsgToTaxReqBean.setBadCustIndr(this.accLoanService.isCusLossCredit(nlsCreditInfoVO.getCusId()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf(new BigDecimal(fstCrdtDt[2]).doubleValue()));
            psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf(new BigDecimal(fstCrdtDt[3]).doubleValue()));
            Instant instant = nlsCreditApprovalInfoVO.getApproveTime().toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            String approveDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String date = DateUtility.ADD_MONTH((String)approveDate, (int)Integer.parseInt(Optional.ofNullable(nlsCreditInfoVO.getApplyTerm()).orElse("12").trim())).replace("-", "");
            psdSendMsgToTaxReqBean.setRpymtDt(DateUtility.format10To8((String)psdSendTaxRecordVO.getBizDate()));
            psdSendMsgToTaxReqBean.setCrMtrDt(DateUtility.format8To10((String)date));
            psdSendMsgToTaxReqBean.setCrStrtDay(approveDate);
            psdSendMsgToTaxReqBean.setNetCrdtLoanFlg("Y");
            psdSendMsgToTaxReqBean.setFstCrdtDt(fstCrdtDt[0]);
            psdSendMsgToTaxReqBean.setLoanCrTrm("12");
            psdSendMsgToTaxReqBean.setAcmlnUseCnt(fstCrdtDt[1]);
            psdSendMsgToTaxReqBean.setExpnsUseAmt(new BigDecimal(fstCrdtDt[2]));
            psdSendMsgToTaxReqBean.setLoanTp("1");
            psdSendMsgToTaxRespBean = this.psdWdSendMsgToTaxService.applyPsdSendMsgToTax(psdSendMsgToTaxReqBean);
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, null);
            psdSendTaxRecordVO.setHandStatus("Y");
            logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u501f\u636e\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
        }
        catch (Exception e) {
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, e);
            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (updateFlag) {
                this.psdSendTaxRecordService.updateByPk(psdSendTaxRecordVO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hand3(PsdSendTaxRecordVO psdSendTaxRecordVO, String setlType) {
        boolean updateFlag = true;
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(psdSendTaxRecordVO.getHandNum() + 1));
        NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = null;
        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = new PsdSendMsgToTaxRespBean();
        try {
            String applySeq = psdSendTaxRecordVO.getApplySeq();
            List loanRepayDetailVOS = this.loanRepayDetailService.queryBySetlSeq(applySeq);
            if (loanRepayDetailVOS.isEmpty()) {
                logger.info("\u4e3b\u52a8\u8fd8\u6b3e\u56de\u8c03\u67e5\u8be2\u4e0d\u5230\u8fd8\u6b3e\u6d41\u6c34\u8bb0\u5f55");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u8fd8\u6b3e\u6d41\u6c34\u8bb0\u5f55");
            }
            AccLoanVO billNoParam = new AccLoanVO();
            billNoParam.setBillNo(((LoanRepayDetailVO)loanRepayDetailVOS.get(0)).getLoanNo());
            AccLoanVO accLoanVO = this.accLoanService.queryByPk(billNoParam);
            if (Objects.isNull(accLoanVO)) {
                logger.info("\u4e3b\u52a8\u8fd8\u6b3e\u56de\u8c03\u67e5\u8be2\u501f\u636e\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u501f\u636e\u4fe1\u606f\uff0c\u501f\u636e\u53f7");
            }
            NlsApplyInfoVO pkParam = new NlsApplyInfoVO();
            pkParam.setApplySeq(accLoanVO.getApplySeq());
            NlsApplyInfoVO nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(pkParam);
            if (Objects.isNull(nlsApplyInfoVO)) {
                logger.info("\u652f\u7528\u56de\u8c03\u7a0e\u5c40\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{},\u83b7\u53d6\u5230\u7684\u7528\u4fe1\u7533\u8bf7\u8bb0\u5f55\u4e3a\u7a7a", (Object)accLoanVO.getApplySeq());
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7");
            }
            String lmtApplySeq = nlsApplyInfoVO.getLmtApplySeq();
            NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(lmtApplySeq);
            if (Objects.isNull(nlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
            preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
            if (Objects.isNull(preNlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            if (this.taxNumber.contains(preNlsCreditInfoVO.getTaxIdentificationNumber())) {
                updateFlag = false;
                return;
            }
            psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(lmtApplySeq);
            if (Objects.isNull(nlsCreditApprovalInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
            }
            String[] fstCrdtDt = this.getFstCrdtDt(nlsCreditInfoVO, preNlsCreditInfoVO);
            psdSendMsgToTaxReqBean.setApplySeq(this.getSeq(((LoanRepayDetailVO)loanRepayDetailVOS.get(0)).getGlobalSerno()));
            double zero = BigDecimal.ZERO.setScale(2, 4).doubleValue();
            double amount = Optional.ofNullable(nlsCreditInfoVO.getApproveAmt()).orElse(BigDecimal.ZERO).setScale(2, 4).doubleValue();
            psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
            psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf(amount));
            psdSendMsgToTaxReqBean.setCrIndr("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
            psdSendMsgToTaxReqBean.setBadCustIndr(this.accLoanService.isCusLossCredit(nlsCreditInfoVO.getCusId()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf(new BigDecimal(fstCrdtDt[2]).doubleValue()));
            psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf(new BigDecimal(fstCrdtDt[3]).doubleValue()));
            Instant instant = nlsCreditApprovalInfoVO.getApproveTime().toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            String approveDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String date = DateUtility.ADD_MONTH((String)approveDate, (int)Integer.parseInt(Optional.ofNullable(nlsCreditInfoVO.getApplyTerm()).orElse("12").trim())).replace("-", "");
            if (setlType.equals("03")) {
                psdSendMsgToTaxReqBean.setRpymtDt(date);
            } else {
                psdSendMsgToTaxReqBean.setRpymtDt(DateUtility.format10To8((String)((LoanRepayDetailVO)loanRepayDetailVOS.get(0)).getSetlValDt()));
            }
            psdSendMsgToTaxReqBean.setCrMtrDt(DateUtility.format8To10((String)date));
            psdSendMsgToTaxReqBean.setCrStrtDay(approveDate);
            psdSendMsgToTaxReqBean.setNetCrdtLoanFlg("Y");
            psdSendMsgToTaxReqBean.setFstCrdtDt(fstCrdtDt[0]);
            psdSendMsgToTaxReqBean.setLoanCrTrm("12");
            psdSendMsgToTaxReqBean.setAcmlnUseCnt(fstCrdtDt[1]);
            psdSendMsgToTaxReqBean.setExpnsUseAmt(new BigDecimal(fstCrdtDt[2]));
            psdSendMsgToTaxReqBean.setLoanTp("1");
            psdSendMsgToTaxRespBean = this.psdWdSendMsgToTaxService.applyPsdSendMsgToTax(psdSendMsgToTaxReqBean);
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, null);
            psdSendTaxRecordVO.setHandStatus("Y");
            logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
        }
        catch (Exception e) {
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, e);
            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (updateFlag) {
                this.psdSendTaxRecordService.updateByPk(psdSendTaxRecordVO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hand2(PsdSendTaxRecordVO psdSendTaxRecordVO) {
        boolean updateFlag = true;
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(psdSendTaxRecordVO.getHandNum() + 1));
        NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = null;
        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = new PsdSendMsgToTaxRespBean();
        try {
            String applySeq = psdSendTaxRecordVO.getApplySeq();
            NlsApplyInfoVO pkParam = new NlsApplyInfoVO();
            pkParam.setApplySeq(applySeq);
            NlsApplyInfoVO nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(pkParam);
            if (Objects.isNull(nlsApplyInfoVO)) {
                logger.info("\u652f\u7528\u56de\u8c03\u7a0e\u5c40\uff0c\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\uff1a{},\u83b7\u53d6\u5230\u7684\u7528\u4fe1\u7533\u8bf7\u8bb0\u5f55\u4e3a\u7a7a", (Object)applySeq);
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u7528\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7");
            }
            String lmtApplySeq = nlsApplyInfoVO.getLmtApplySeq();
            NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(lmtApplySeq);
            if (Objects.isNull(nlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
            preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
            if (Objects.isNull(preNlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            if (this.taxNumber.contains(preNlsCreditInfoVO.getTaxIdentificationNumber())) {
                updateFlag = false;
                return;
            }
            psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(lmtApplySeq);
            if (Objects.isNull(nlsCreditApprovalInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
            }
            String[] fstCrdtDt = this.getFstCrdtDt(nlsCreditInfoVO, preNlsCreditInfoVO);
            psdSendMsgToTaxReqBean.setApplySeq(this.getSeq(nlsApplyInfoVO.getGlobalSerno()));
            double zero = BigDecimal.ZERO.setScale(2, 4).doubleValue();
            double amount = Optional.ofNullable(nlsCreditInfoVO.getApproveAmt()).orElse(BigDecimal.ZERO).setScale(2, 4).doubleValue();
            psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
            psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf(amount));
            psdSendMsgToTaxReqBean.setCrIndr("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
            psdSendMsgToTaxReqBean.setBadCustIndr(this.accLoanService.isCusLossCredit(nlsCreditInfoVO.getCusId()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf(new BigDecimal(fstCrdtDt[2]).doubleValue()));
            psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf(new BigDecimal(fstCrdtDt[3]).doubleValue()));
            Instant instant = nlsCreditApprovalInfoVO.getApproveTime().toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            String approveDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String date = DateUtility.ADD_MONTH((String)approveDate, (int)Integer.parseInt(Optional.ofNullable(nlsCreditInfoVO.getApplyTerm()).orElse("12").trim())).replace("-", "");
            psdSendMsgToTaxReqBean.setRpymtDt(date);
            psdSendMsgToTaxReqBean.setCrMtrDt(DateUtility.format8To10((String)date));
            psdSendMsgToTaxReqBean.setCrStrtDay(approveDate);
            psdSendMsgToTaxReqBean.setNetCrdtLoanFlg("Y");
            psdSendMsgToTaxReqBean.setFstCrdtDt(fstCrdtDt[0]);
            psdSendMsgToTaxReqBean.setLoanCrTrm("12");
            psdSendMsgToTaxReqBean.setAcmlnUseCnt(fstCrdtDt[1]);
            psdSendMsgToTaxReqBean.setExpnsUseAmt(new BigDecimal(fstCrdtDt[2]));
            psdSendMsgToTaxReqBean.setLoanTp("1");
            psdSendMsgToTaxRespBean = this.psdWdSendMsgToTaxService.applyPsdSendMsgToTax(psdSendMsgToTaxReqBean);
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, null);
            psdSendTaxRecordVO.setHandStatus("Y");
            logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
        }
        catch (Exception e) {
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, e);
            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (updateFlag) {
                this.psdSendTaxRecordService.updateByPk(psdSendTaxRecordVO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hand1(PsdSendTaxRecordVO psdSendTaxRecordVO) {
        boolean updateFlag = true;
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(psdSendTaxRecordVO.getHandNum() + 1));
        NlsCreditApprovalInfoVO nlsCreditApprovalInfoVO = null;
        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = new PsdSendMsgToTaxRespBean();
        try {
            NlsCreditInfoVO nlsCreditInfoVO = this.nlsCreditInfoService.queryByLmtApplySeq(psdSendTaxRecordVO.getApplySeq());
            if (Objects.isNull(nlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + psdSendTaxRecordVO.getApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
            preNlsCreditInfoVO.setApplySeq(nlsCreditInfoVO.getPreLmtApplySeq());
            preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
            if (Objects.isNull(preNlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            if (this.taxNumber.contains(preNlsCreditInfoVO.getTaxIdentificationNumber())) {
                updateFlag = false;
                return;
            }
            psdSendTaxRecordVO.setTaxNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            nlsCreditApprovalInfoVO = this.nlsCreditApprovalInfoService.selectByPrimaryKey(psdSendTaxRecordVO.getApplySeq());
            if (Objects.isNull(nlsCreditApprovalInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getPreLmtApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u6388\u4fe1\u5ba1\u6279\u4fe1\u606f");
            }
            String[] fstCrdtDt = this.getFstCrdtDt(nlsCreditInfoVO, preNlsCreditInfoVO);
            psdSendMsgToTaxReqBean.setApplySeq(this.getSeq(nlsCreditInfoVO.getGlobalSerno()));
            double zero = BigDecimal.ZERO.setScale(2, 4).doubleValue();
            double amount = Optional.ofNullable(nlsCreditInfoVO.getApproveAmt()).orElse(BigDecimal.ZERO).setScale(2, 4).doubleValue();
            psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
            psdSendMsgToTaxReqBean.setCrFailRsnDesc(psdSendTaxRecordVO.getApplyMsg());
            psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? amount : 0.0));
            psdSendMsgToTaxReqBean.setCrIndr("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
            psdSendMsgToTaxReqBean.setBadCustIndr(this.accLoanService.isCusLossCredit(nlsCreditInfoVO.getCusId()) ? "Y" : "N");
            psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? new BigDecimal(fstCrdtDt[2]).doubleValue() : zero));
            psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf("Y".equals(psdSendTaxRecordVO.getApplyStatus()) ? new BigDecimal(fstCrdtDt[3]).doubleValue() : zero));
            Instant instant = nlsCreditApprovalInfoVO.getApproveTime().toInstant();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            String approveDate = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String date = DateUtility.ADD_MONTH((String)approveDate, (int)Integer.parseInt(Optional.ofNullable(nlsCreditInfoVO.getApplyTerm()).orElse("12").trim())).replace("-", "");
            psdSendMsgToTaxReqBean.setRpymtDt(date);
            psdSendMsgToTaxReqBean.setCrMtrDt(DateUtility.format8To10((String)date));
            psdSendMsgToTaxReqBean.setCrStrtDay(approveDate);
            psdSendMsgToTaxReqBean.setNetCrdtLoanFlg("Y");
            psdSendMsgToTaxReqBean.setFstCrdtDt(fstCrdtDt[0]);
            psdSendMsgToTaxReqBean.setLoanCrTrm("12");
            psdSendMsgToTaxReqBean.setAcmlnUseCnt(fstCrdtDt[1]);
            psdSendMsgToTaxReqBean.setExpnsUseAmt(new BigDecimal(fstCrdtDt[2]));
            psdSendMsgToTaxReqBean.setLoanTp("1");
            psdSendMsgToTaxRespBean = this.psdWdSendMsgToTaxService.applyPsdSendMsgToTax(psdSendMsgToTaxReqBean);
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, null);
            psdSendTaxRecordVO.setHandStatus("Y");
            logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + nlsCreditInfoVO.getLmtApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
        }
        catch (Exception e) {
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, e);
            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (updateFlag) {
                this.psdSendTaxRecordService.updateByPk(psdSendTaxRecordVO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hand0(PsdSendTaxRecordVO psdSendTaxRecordVO) {
        boolean updateFlag = false;
        psdSendTaxRecordVO.setHandNum(Integer.valueOf(psdSendTaxRecordVO.getHandNum() + 1));
        PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean = new PsdSendMsgToTaxReqBean();
        PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean = new PsdSendMsgToTaxRespBean();
        try {
            PreNlsCreditInfoVO preNlsCreditInfoVO = new PreNlsCreditInfoVO();
            preNlsCreditInfoVO.setApplySeq(psdSendTaxRecordVO.getApplySeq());
            preNlsCreditInfoVO = this.preNlsCreditInfoService.queryByPk(preNlsCreditInfoVO);
            if (Objects.isNull(preNlsCreditInfoVO)) {
                logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + psdSendTaxRecordVO.getApplySeq() + "\u3011\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
                throw new Exception("\u67e5\u8be2\u4e0d\u5230\u9884\u6388\u4fe1\u7533\u8bf7\u4fe1\u606f");
            }
            Date createTime = psdSendTaxRecordVO.getCreateTime();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(createTime.toInstant(), ZoneId.systemDefault());
            LocalDateTime plusLocalDateTime = localDateTime.plusDays(this.maxSendDay);
            LocalDateTime now = LocalDateTime.ofInstant(new Date().toInstant(), ZoneId.systemDefault());
            if (now.isBefore(plusLocalDateTime)) {
                logger.info("\u65f6\u95f4\u6ca1\u5230t+3\uff0c\u6682\u4e0d\u5904\u7406\u8be5\u56de\u5199\uff0c\u56de\u5199\u8bb0\u5f55\u6d41\u6c34\u53f7\uff1a{}", (Object)psdSendTaxRecordVO.getApplyMsg());
                return;
            }
            List psdSendTaxRecordVOS = this.psdSendTaxRecordService.queryRecordByTaxnoAndSendType(psdSendTaxRecordVO.getTaxNo(), "1");
            for (PsdSendTaxRecordVO sendTaxRecordVO : psdSendTaxRecordVOS) {
                if (sendTaxRecordVO.getApplySeq().equals(psdSendTaxRecordVO.getApplySeq())) continue;
                if (!LocalDateTime.ofInstant(sendTaxRecordVO.getCreateTime().toInstant(), ZoneId.systemDefault()).isAfter(localDateTime)) continue;
                updateFlag = true;
                psdSendTaxRecordVO.setHandNum(Integer.valueOf(999));
                return;
            }
            updateFlag = true;
            psdSendMsgToTaxReqBean.setApplySeq(this.getSeq(preNlsCreditInfoVO.getGlobalSerno()));
            psdSendMsgToTaxReqBean.setTaxpyrIdntfNo(preNlsCreditInfoVO.getTaxIdentificationNumber());
            psdSendMsgToTaxReqBean.setRgstSrlNo(preNlsCreditInfoVO.getSocialCreditCode());
            psdSendMsgToTaxReqBean.setCrFailRsnDesc(psdSendTaxRecordVO.getApplyMsg());
            psdSendMsgToTaxReqBean.setCrtLmt(Double.valueOf(0.0));
            psdSendMsgToTaxReqBean.setCrIndr("N");
            psdSendMsgToTaxReqBean.setFinPdNo(this.jrcpbh);
            psdSendMsgToTaxReqBean.setBadCustIndr("N");
            psdSendMsgToTaxReqBean.setLoanAmt(Double.valueOf(0.0));
            psdSendMsgToTaxReqBean.setLoanBal(Double.valueOf(0.0));
            psdSendMsgToTaxReqBean.setRpymtDt(preNlsCreditInfoVO.getCreateDate());
            psdSendMsgToTaxReqBean.setCrMtrDt(preNlsCreditInfoVO.getCreateDate());
            psdSendMsgToTaxReqBean.setCrStrtDay(preNlsCreditInfoVO.getCreateDate());
            psdSendMsgToTaxReqBean.setNetCrdtLoanFlg("Y");
            psdSendMsgToTaxReqBean.setFstCrdtDt(preNlsCreditInfoVO.getCreateDate());
            psdSendMsgToTaxReqBean.setLoanCrTrm("12");
            psdSendMsgToTaxReqBean.setAcmlnUseCnt("0");
            psdSendMsgToTaxReqBean.setExpnsUseAmt(new BigDecimal("0.00"));
            psdSendMsgToTaxReqBean.setLoanTp("1");
            psdSendMsgToTaxRespBean = this.psdWdSendMsgToTaxService.applyPsdSendMsgToTax(psdSendMsgToTaxReqBean);
            psdSendTaxRecordVO.setHandStatus("Y");
            this.updatePrenlsSts(preNlsCreditInfoVO);
            psdSendTaxRecordVO.setHandStatus("Y");
            psdSendTaxRecordVO.setHandNum(Integer.valueOf(999));
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, null);
            logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40 \u9884\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + preNlsCreditInfoVO.getApplySeq() + "\u3011\u53d1\u9001\u4fe1\u606f\u7a0e\u5c40\u6210\u529f");
        }
        catch (Exception e) {
            this.insertMsgRecord(psdSendTaxRecordVO, psdSendMsgToTaxReqBean, psdSendMsgToTaxRespBean, e);
            logger.error("\u53d1\u9001\u4fe1\u606f\u7ed9\u7a0e\u5c40\u7a0e\u52a1\u5c40\u4fe1\u8d37\u5ba1\u6279\u7ed3\u679c\u901a\u77e5\u5931\u8d25" + e.getMessage());
        }
        finally {
            if (updateFlag) {
                this.psdSendTaxRecordService.updateByPk(psdSendTaxRecordVO);
            }
        }
    }

    private void updatePrenlsSts(PreNlsCreditInfoVO preNlsCreditInfoVO) {
        preNlsCreditInfoVO.setStatus("06");
        this.preNlsCreditInfoService.updateByPk(preNlsCreditInfoVO);
    }

    private String[] getFstCrdtDt(NlsCreditInfoVO nlsCreditInfoVO, PreNlsCreditInfoVO preNlsCreditInfoVO) throws Exception {
        String taxIdentificationNumber = preNlsCreditInfoVO.getTaxIdentificationNumber();
        List preNlsCreditInfoVOS = this.preNlsCreditInfoService.queryByTaxNumber(taxIdentificationNumber);
        if (preNlsCreditInfoVOS == null || preNlsCreditInfoVOS.isEmpty()) {
            return new String[]{nlsCreditInfoVO.getApplyDate(), "0", "0.00", "0.00"};
        }
        List nlsCreditInfoVOS = this.nlsCreditInfoService.queryInPreLmtApplySeq(preNlsCreditInfoVOS.stream().map(PreNlsCreditInfoVO::getApplySeq).distinct().collect(Collectors.toList()));
        if (nlsCreditInfoVOS == null || nlsCreditInfoVOS.isEmpty()) {
            return new String[]{nlsCreditInfoVO.getApplyDate(), "0", "0.00", "0.00"};
        }
        List nlsApplyInfoVOS = this.nlsApplyInfoService.queryByLmtSeqs(nlsCreditInfoVOS.stream().map(NlsCreditInfoVO::getLmtApplySeq).distinct().collect(Collectors.toList()));
        if (nlsApplyInfoVOS == null || nlsApplyInfoVOS.isEmpty()) {
            return new String[]{nlsCreditInfoVO.getApplyDate(), "0", "0.00", "0.00"};
        }
        List accLoanVOS = this.accLoanService.queryByApplySqes(nlsApplyInfoVOS.stream().map(NlsApplyInfoVO::getApplySeq).distinct().collect(Collectors.toList()));
        if (accLoanVOS == null || accLoanVOS.isEmpty()) {
            return new String[]{nlsCreditInfoVO.getApplyDate(), "0", "0.00", "0.00"};
        }
        Collections.sort(accLoanVOS, (o1, o2) -> {
            try {
                return DateUtility.compareToDate((String)o1.getFirstDisbDate(), (String)o2.getFirstDisbDate());
            }
            catch (BizException e) {
                e.printStackTrace();
                return 0;
            }
        });
        BigDecimal totaAmout = accLoanVOS.stream().map(AccLoanVO::getLoanAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totaBalance = accLoanVOS.stream().map(AccLoanVO::getLoanBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        return new String[]{((AccLoanVO)accLoanVOS.get(0)).getFirstDisbDate(), String.valueOf(accLoanVOS.size()), String.valueOf(totaAmout), String.valueOf(totaBalance)};
    }

    private final void insertMsgRecord(PsdSendTaxRecordVO psdSendTaxRecordVO, PsdSendMsgToTaxReqBean psdSendMsgToTaxReqBean, PsdSendMsgToTaxRespBean psdSendMsgToTaxRespBean, Exception e) {
        try {
            if (!Objects.isNull(e)) {
                this.taxNumber.add(psdSendTaxRecordVO.getTaxNo());
            }
            PsdSendTaxMessageRecordVO psdSendTaxMessageRecordVO = new PsdSendTaxMessageRecordVO();
            psdSendTaxMessageRecordVO.setId(UUID.randomUUID().toString());
            psdSendTaxMessageRecordVO.setSendTaxRecordId(psdSendTaxRecordVO.getId());
            psdSendTaxMessageRecordVO.setSendTime(new Date());
            psdSendTaxMessageRecordVO.setSendMessage((Object)(Objects.isNull(psdSendMsgToTaxReqBean) ? "" : JSON.toJSONString((Object)psdSendMsgToTaxReqBean)));
            psdSendTaxMessageRecordVO.setRetMessage((Object)(!Objects.isNull(e) ? e.getMessage() : JSON.toJSONString((Object)psdSendMsgToTaxRespBean)));
            psdSendTaxMessageRecordVO.setCreateTime(new Date());
            this.psdSendTaxMessageRecordService.insert(psdSendTaxMessageRecordVO);
        }
        catch (Exception ex) {
            logger.error("\u63d2\u5165\u56de\u5199\u7a0e\u5c40\u63a5\u53e3\u8c03\u7528\u4fe1\u606f\u8bb0\u5f55\u8868\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    private String getSeq(String bakSeq) {
        try {
            PatternedLimitableSeqService sequenceService = (PatternedLimitableSeqService)SpringContextUtils.getBean(PatternedLimitableSeqService.class);
            return sequenceService.getPatternedSequence("ESB", pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u83b7\u53d6\u5168\u5c40\u6d41\u6c34\u53f7\u5931\u8d25");
            return bakSeq;
        }
    }
}

