/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.psd.timedTask;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ESBException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.efp.console.service.facade.PtProductUserService;
import com.irdstudio.efp.console.service.vo.PtProductUserVO;
import com.irdstudio.efp.ctr.service.facade.CtrLoanContService;
import com.irdstudio.efp.ctr.service.vo.CtrLoanContVO;
import com.irdstudio.efp.cus.service.facade.CusIndivService;
import com.irdstudio.efp.cus.service.vo.CusIndivVO;
import com.irdstudio.efp.edoc.service.bo.CfcaSignInfoVO;
import com.irdstudio.efp.edoc.service.facade.CfcaSignInfoService;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.service.bo.req.frontsystem.MobileBankInfoReqBean;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.req.ydxxzf.GainOrderReqBean;
import com.irdstudio.efp.esb.service.bo.req.ydxxzf.GeneratorOrderReqBean;
import com.irdstudio.efp.esb.service.bo.resp.frontsystem.MobileBankInfoRespBean;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.ydxxzf.GainOrderRespBean;
import com.irdstudio.efp.esb.service.bo.resp.ydxxzf.GeneratorOrderRespBean;
import com.irdstudio.efp.esb.service.facade.EsbInvokeWrapper;
import com.irdstudio.efp.esb.service.facade.frontsystem.MobileBankInfoService;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.esb.service.facade.ydxxzf.GainOrderService;
import com.irdstudio.efp.esb.service.facade.ydxxzf.GeneratorOrderService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.nls.service.facade.NlsPublicService;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.psd.PsdSqsSignatureService;
import com.irdstudio.efp.nls.service.facade.psd.PsdTaskReqInfoService;
import com.irdstudio.efp.nls.service.facade.psd.TaskHandleService;
import com.irdstudio.efp.nls.service.facade.sx.NlsCreditInfoService;
import com.irdstudio.efp.nls.service.vo.psd.PsdTaskReqInfoVO;
import com.irdstudio.efp.nls.service.vo.sx.NlsCreditInfoVO;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="taskHandleService")
public class TaskHandleServiceImpl
implements TaskHandleService {
    private static Logger logger = LoggerFactory.getLogger(TaskHandleServiceImpl.class);
    @Autowired
    @Qualifier(value="psdTaskReqInfoService")
    private PsdTaskReqInfoService psdTaskReqInfoService;
    @Autowired
    @Qualifier(value="gainOrderService")
    private GainOrderService gainOrderService;
    @Autowired
    @Qualifier(value="generatorOrderService")
    private GeneratorOrderService generatorOrderService;
    @Autowired
    @Qualifier(value="ptProductUserService")
    private PtProductUserService ptProductUserService;
    @Autowired
    @Qualifier(value="cusIndivService")
    private CusIndivService cusIndivService;
    @Autowired
    @Qualifier(value="cfcaSignInfoService")
    private CfcaSignInfoService cfcaSignInfoService;
    @Autowired
    @Qualifier(value="psdSqsSignatureService")
    private PsdSqsSignatureService psdSqsSignatureService;
    @Autowired
    @Qualifier(value="ctrLoanContService")
    private CtrLoanContService ctrLoanContService;
    @Autowired
    @Qualifier(value="nlsCreditInfoService")
    private NlsCreditInfoService nlsCreditInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;
    @Autowired
    @Qualifier(value="alarmJudgementService")
    private AlarmJudgementService alarmJudgementService;
    @Autowired
    @Qualifier(value="nlsPublicService")
    private NlsPublicService nlsPublicService;
    @Autowired
    private MobileBankInfoService mobileBankInfoService;
    @Autowired
    private NlsQueueSoltComnService nlsQueueSoltComnService;

    public void updateTaskInfo() {
        logger.info("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u5de5\u5355\u66f4\u65b0");
        PsdTaskReqInfoVO psdTaskReqInfo = null;
        try {
            List psdTaskReqInfoVOS = this.psdTaskReqInfoService.selectRecordByHandleStatus(Integer.valueOf(200));
            if (!psdTaskReqInfoVOS.isEmpty()) {
                Iterator iterator = psdTaskReqInfoVOS.iterator();
                while (iterator.hasNext()) {
                    PsdTaskReqInfoVO psdTaskReqInfoVO;
                    psdTaskReqInfo = psdTaskReqInfoVO = (PsdTaskReqInfoVO)iterator.next();
                    GainOrderReqBean gainOrderReqBean = new GainOrderReqBean();
                    gainOrderReqBean.setWrkOrdrId(psdTaskReqInfoVO.getOrderId());
                    gainOrderReqBean.setGlobaNo(psdTaskReqInfoVO.getGlobaNo());
                    try {
                        GainOrderRespBean.WrkOrdrDealInfArry wrkOrdrDealInf;
                        GainOrderRespBean gainOrderRespBean = this.gainOrderService.applygainOrder(gainOrderReqBean);
                        List wrkOrdrDealInfArry = gainOrderRespBean.getWrkOrdrDealInfArry();
                        if (!Objects.nonNull(wrkOrdrDealInfArry) || wrkOrdrDealInfArry.isEmpty() || !Objects.nonNull(wrkOrdrDealInf = (GainOrderRespBean.WrkOrdrDealInfArry)wrkOrdrDealInfArry.get(0))) continue;
                        psdTaskReqInfoVO.setHandleStatus(wrkOrdrDealInf.getStCd());
                        psdTaskReqInfoVO.setHandleResult(wrkOrdrDealInf.getDealRslt());
                        psdTaskReqInfoVO.setDeptName(wrkOrdrDealInf.getDeptNm());
                        psdTaskReqInfoVO.setProductName(wrkOrdrDealInf.getPdNm());
                        psdTaskReqInfoVO.setProductSystem(wrkOrdrDealInf.getPdBlngSysIndr());
                        psdTaskReqInfoVO.setDealUserId(wrkOrdrDealInf.getActlHndlrId());
                        psdTaskReqInfoVO.setDealName(wrkOrdrDealInf.getActlHndlrNm());
                        psdTaskReqInfoVO.setLoginName(wrkOrdrDealInf.getLgnNm());
                        psdTaskReqInfoVO.setCreateStatus(Integer.valueOf(300));
                        psdTaskReqInfoVO.setLastUpdateTime(new Date());
                        this.psdTaskReqInfoService.updateByPrimaryKey(psdTaskReqInfoVO);
                    }
                    catch (ESBException e) {
                        logger.error("\u5de5\u5355ID\uff1a\u3010" + psdTaskReqInfoVO.getOrderId() + "\u3011\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u9636\u6bb5\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5931\u8d25!!!" + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5de5\u5355ID\uff1a\u3010" + psdTaskReqInfo.getOrderId() + "\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u9636\u6bb5\u67e5\u8be2\u672a\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f\u5931\u8d25!!!" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void createTaskInfo() {
        logger.info("\u666e\u7a0e\u8d37\u5de5\u5355\u521b\u5efa\u63a5\u53e3\u5206\u914d\u5ba2\u6237\u7ecf\u7406\u5b9a\u65f6\u8865\u507f\u4efb\u52a1");
        List psdTaskReqInfoVOS = null;
        try {
            psdTaskReqInfoVOS = this.psdTaskReqInfoService.selectFaileRecords();
            if (psdTaskReqInfoVOS == null || psdTaskReqInfoVOS.isEmpty()) {
                logger.info("\u67e5\u8be2\u521b\u5efa\u5de5\u5355\u5f85\u5904\u7406\u7684\u8bb0\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u672c\u6b21\u5b9a\u65f6\u5668\u7ed3\u675f");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u521b\u5efa\u5de5\u5355\u5f85\u5904\u7406\u7684\u8bb0\u5f55\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return;
        }
        for (PsdTaskReqInfoVO psdTaskReqInfoVO : psdTaskReqInfoVOS) {
            try {
                logger.info("\u5f53\u524d\u5de5\u5355\u8865\u507f\u4efb\u52a1\u5904\u7406\u5bf9\u8c61\u4e3a\uff1a{}", (Object)psdTaskReqInfoVO.toString());
                NlsCreditInfoVO vo = new NlsCreditInfoVO();
                vo.setLmtApplySeq(psdTaskReqInfoVO.getLmtApplySeq());
                NlsCreditInfoVO query = this.nlsCreditInfoService.queryByPk(vo);
                GeneratorOrderRespBean generatorOrderRespBean = null;
                GeneratorOrderReqBean generatorOrderReqBean = new GeneratorOrderReqBean();
                if (psdTaskReqInfoVO.getCreateStatus() == 999) {
                    logger.info("\u5b9e\u65f6\u6d41\u7a0b\u521b\u5efa\u5de5\u5355\u6210\u529f\uff0c\u672c\u6b21\u4efb\u52a1\u4e0d\u518d\u8c03\u7528\u521b\u5efa\u5de5\u5355\u63a5\u53e3");
                    generatorOrderRespBean = new GeneratorOrderRespBean();
                    generatorOrderRespBean.setRetMsg(psdTaskReqInfoVO.getCreateMsg());
                    generatorOrderRespBean.setActlHndlrId(psdTaskReqInfoVO.getManagerId());
                    generatorOrderRespBean.setRetCd(EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE());
                } else {
                    generatorOrderReqBean.setWrkOrdrId(psdTaskReqInfoVO.getOrderId());
                    generatorOrderReqBean.setStCd(psdTaskReqInfoVO.getHandleStatus());
                    generatorOrderReqBean.setCustMgrNo(psdTaskReqInfoVO.getManagerId());
                    generatorOrderReqBean.setPdNo(psdTaskReqInfoVO.getProductId());
                    if ("1".equals(psdTaskReqInfoVO.getTaskTyp())) {
                        generatorOrderReqBean.setBrchId(query.getOperateAgency());
                    } else {
                        generatorOrderReqBean.setBrchId(query.getNlsOperOrgid());
                    }
                    generatorOrderReqBean.setCustNm(psdTaskReqInfoVO.getCusName());
                    generatorOrderReqBean.setGnd(psdTaskReqInfoVO.getGender());
                    generatorOrderReqBean.setTelNo(psdTaskReqInfoVO.getTelPhone());
                    generatorOrderReqBean.setIdentNo(psdTaskReqInfoVO.getIdNum());
                    generatorOrderReqBean.setIdentTp(psdTaskReqInfoVO.getIdType());
                    generatorOrderReqBean.setEntpNm(psdTaskReqInfoVO.getCorpName());
                    generatorOrderReqBean.setUnfdSoclCrdtCd(psdTaskReqInfoVO.getSocialCode());
                    generatorOrderReqBean.setEntpRgstAddr(psdTaskReqInfoVO.getAddress());
                    generatorOrderReqBean.setUsrFlg(psdTaskReqInfoVO.getUserType());
                    generatorOrderReqBean.setLoanLmt(Double.valueOf(Optional.ofNullable(psdTaskReqInfoVO.getQuota()).orElse(new BigDecimal("0")).doubleValue()));
                    generatorOrderReqBean.setLoanTrm(query.getApplyTerm());
                    generatorOrderReqBean.setCltlInf(psdTaskReqInfoVO.getMortgage());
                    generatorOrderReqBean.setRemark(psdTaskReqInfoVO.getRemark());
                    generatorOrderReqBean.setLmtApplySeq(psdTaskReqInfoVO.getGlobaNo());
                    query.setCnlTp("843");
                    generatorOrderRespBean = this.generatorOrderService.applyGeneratorOrder(generatorOrderReqBean, query);
                }
                if (!EsbBizEnums.RetCodeEnum.SUCCESS.VALUE.equals(generatorOrderRespBean.getRetCd())) {
                    if (!"Y".equals(psdTaskReqInfoVO.getWarnFlag())) {
                        String alrmInf = "\u7f51\u8d37\u666e\u7a0e\u8d37\u4ea7\u54c1\u5de5\u5355\u521b\u5efa\uff0c\u6839\u636e\u673a\u6784\u53f7\uff1a" + generatorOrderReqBean.getBrchId() + generatorOrderRespBean.getRetMsg();
                        ReqAlarmJudgementBean imageFileReqBean = new ReqAlarmJudgementBean();
                        imageFileReqBean.setMonObjNm("\u7f51\u8d37\u666e\u7a0e\u8d37\u4ea7\u54c1\u5de5\u5355\u521b\u5efa");
                        imageFileReqBean.setMonObjSpfTpVal("\u7f51\u8d37\u6279\u91cf");
                        try {
                            imageFileReqBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
                        }
                        catch (Exception e) {
                            imageFileReqBean.setMonObjLctr("efp_nls");
                        }
                        imageFileReqBean.setAlrmInf(alrmInf);
                        imageFileReqBean.setAlrmTmstmp(DateUtility.getCurrAppDateTimeString());
                        imageFileReqBean.setMonAlrmLvl("2");
                        RespAlarmJudgementBean imageFileRespBean = this.alarmJudgementService.alarmJudgement(imageFileReqBean);
                        logger.info("\u8c03\u7528\u544a\u8b66\u8fd4\u56de\u7801\uff1a\u3010" + imageFileRespBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + imageFileRespBean.getRetMsg() + "\u3011");
                        if ("0000".equals(imageFileRespBean.getRetCd())) {
                            psdTaskReqInfoVO.setWarnFlag("Y");
                        }
                    }
                } else {
                    this.updateOrgandUsr(psdTaskReqInfoVO, generatorOrderRespBean);
                }
                psdTaskReqInfoVO.setCreateStatus(Integer.valueOf(EsbBizEnums.RetCodeEnum.SUCCESS.VALUE.equals(generatorOrderRespBean.getRetCd()) ? 200 : 201));
                psdTaskReqInfoVO.setHandleResult(generatorOrderRespBean.getRetMsg());
                psdTaskReqInfoVO.setCreateMsg(generatorOrderRespBean.getRetMsg());
                psdTaskReqInfoVO.setLastUpdateTime(new Date());
                this.psdTaskReqInfoService.updateByPrimaryKey(psdTaskReqInfoVO);
            }
            catch (Exception e) {
                logger.error("\u5de5\u5355ID\uff1a\u3010" + psdTaskReqInfoVO.getOrderId() + "\u666e\u7a0e\u8d37\u4efb\u52a1\u5904\u7406\u9636\u6bb5\u5de5\u5355\u8865\u507f\u4efb\u52a1\u6267\u884c\u5931\u8d25!!!" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void updateOrgandUsr(PsdTaskReqInfoVO inVo, GeneratorOrderRespBean generatorOrderRespBean) throws BizException {
        NlsCreditInfoVO nlsCreditInfoVO = new NlsCreditInfoVO();
        String applySeq = inVo.getLmtApplySeq();
        nlsCreditInfoVO.setLmtApplySeq(applySeq);
        NlsCreditInfoVO nlsCreditInfoVO1 = this.nlsCreditInfoService.queryByPk(nlsCreditInfoVO);
        String userId = generatorOrderRespBean.getActlHndlrId();
        logger.info("\u6839\u636e\u5de5\u5355\u5904\u7406\u4eba\u5de5\u53f7\u67e5\u8be2\u5ba2\u6237\u7ecf\u7406\u540d\u5355\u8868\uff0c\u5de5\u5355\u5904\u7406\u4eba\uff1a{}", (Object)userId);
        PtProductUserVO ptProduceUser = this.ptProductUserService.getPtProduceByLoginName(userId);
        Optional.ofNullable(ptProduceUser).orElseThrow(() -> new BizException("\u4efb\u52a1\u5904\u7406\u9636\u6bb5 \u67e5\u8be2\u4e0d\u5230\u5ba2\u6237\u7ecf\u7406\u4fe1\u606f"));
        String orgId = ptProduceUser.getDeptId();
        inVo.setDeptId(orgId);
        inVo.setManagerId(userId);
        if ("1".equals(inVo.getTaskTyp())) {
            nlsCreditInfoVO.setOperateAgencyUser(userId);
            nlsCreditInfoVO.setOperateAgency(orgId);
            int k = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            if (k != 1) {
                logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u6388\u4fe1\u6d41\u6c34\u53f7" + nlsCreditInfoVO.getLmtApplySeq() + "\u66f4\u65b0\u8bb0\u5f55" + k + "\u6761");
                throw new BizException("\u66f4\u65b0\u5f02\u5e38");
            }
            this.sendMsg("1", ptProduceUser, nlsCreditInfoVO1);
        } else {
            nlsCreditInfoVO.setNlsOperOrgid(orgId);
            nlsCreditInfoVO.setNlsOperUserid(userId);
            nlsCreditInfoVO.setOperateAgencyUser(userId);
            nlsCreditInfoVO.setOperateAgency(orgId);
            int k = this.nlsCreditInfoService.updateByPk(nlsCreditInfoVO);
            if (k != 1) {
                logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u6388\u4fe1\u6d41\u6c34\u53f7" + nlsCreditInfoVO.getLmtApplySeq() + "\u66f4\u65b0\u8bb0\u5f55" + k + "\u6761");
                throw new BizException("\u66f4\u65b0\u5f02\u5e38");
            }
            LmtPrdContVO lmtPrdContVO = new LmtPrdContVO();
            lmtPrdContVO.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
            lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPrdContVO);
            LmtPrdContVO lmtPrdCont = new LmtPrdContVO();
            lmtPrdCont.setLmtContNo(lmtPrdContVO.getLmtContNo());
            lmtPrdCont.setMainBrId(orgId);
            lmtPrdCont.setChargeoffBrId(orgId);
            lmtPrdCont.setCusManager(userId);
            int m = this.lmtPrdContService.updateByPk(lmtPrdCont);
            if (m != 1) {
                logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u6388\u4fe1\u534f\u8bae\u7f16\u53f7" + lmtPrdCont + "\u66f4\u65b0\u8bb0\u5f55" + m + "\u6761");
                throw new BizException("\u66f4\u65b0\u5f02\u5e38");
            }
            CusIndivVO indivVO = new CusIndivVO();
            indivVO.setCusId(nlsCreditInfoVO1.getCusId());
            indivVO.setCusManager(userId);
            indivVO.setPerformanceOwner(userId);
            indivVO.setPerformanceOrg(orgId);
            int i = this.cusIndivService.updateByPk(indivVO);
            if (i != 1) {
                logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u5ba2\u6237\u53f7" + nlsCreditInfoVO1.getCusId() + "\u66f4\u65b0\u8bb0\u5f55" + i + "\u6761");
                throw new BizException("\u66f4\u65b0\u5f02\u5e38");
            }
            CfcaSignInfoVO cfcaSignInfoVO = new CfcaSignInfoVO();
            cfcaSignInfoVO.setApplySeq(applySeq);
            cfcaSignInfoVO.setNlsOperOrgid(orgId);
            cfcaSignInfoVO.setNlsOperUserid(userId);
            cfcaSignInfoVO.setFinaBrId(orgId);
            this.cfcaSignInfoService.updateByPk(cfcaSignInfoVO);
            this.psdSqsSignatureService.updateOperInfo(applySeq, userId, orgId);
            CtrLoanContVO ctrLoanContVO = new CtrLoanContVO();
            ctrLoanContVO.setContNo(applySeq);
            ctrLoanContVO.setPerformanceOwner(userId);
            ctrLoanContVO.setPerformanceOrg(orgId);
            ctrLoanContVO.setCusManager(userId);
            ctrLoanContVO.setInputBrId(orgId);
            ctrLoanContVO.setMainBrId(orgId);
            ctrLoanContVO.setFinaBrId(orgId);
            ctrLoanContVO.setLegalOrgCode(orgId);
            int n = this.ctrLoanContService.updateByPk(ctrLoanContVO);
            if (n != 1) {
                logger.info("\u66f4\u65b0\u5f02\u5e38\uff0c\u6839\u636e\u5408\u540c\u7f16\u53f7" + ctrLoanContVO.getContNo() + "\u66f4\u65b0\u8bb0\u5f55" + n + "\u6761");
                throw new BizException("\u66f4\u65b0\u5f02\u5e38");
            }
            this.sendMsg("2", ptProduceUser, nlsCreditInfoVO1);
        }
    }

    private void sendMsg(String stage, PtProductUserVO ptProduceUser, NlsCreditInfoVO nlsCreditInfoVO) {
        String phone;
        CusIndivVO cusPkParam = new CusIndivVO();
        cusPkParam.setCusId(nlsCreditInfoVO.getCusId());
        CusIndivVO cusIndivVO = this.cusIndivService.queryByPk(cusPkParam);
        if (Objects.isNull(cusIndivVO)) {
            logger.error("\u6839\u636e\u5ba2\u6237\u53f7{}\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25", (Object)cusPkParam.getCusId());
        }
        LmtPrdContVO lmtPkParam = new LmtPrdContVO();
        lmtPkParam.setLmtApplySeq(nlsCreditInfoVO.getLmtApplySeq());
        LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.queryByPk(lmtPkParam);
        if (Objects.isNull(lmtPrdContVO)) {
            logger.error("\u6839\u636e\u6388\u4fe1\u6d41\u6c34\u53f7{}\u83b7\u53d6\u989d\u5ea6\u4fe1\u606f\u5931\u8d25", (Object)lmtPkParam.getLmtApplySeq());
        }
        if (StringUtils.isBlank((CharSequence)(phone = cusIndivVO.getPhone()))) {
            logger.info("\u83b7\u53d6\u5ba2\u6237\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u77ed\u4fe1\u4e0b\u53d1");
            return;
        }
        if ("1".equals(stage)) {
            this.nlsPublicService.sendMessageWithCusManagerInfo("1", lmtPrdContVO, ptProduceUser, phone);
            return;
        }
        if ("2".equals(stage)) {
            try {
                boolean b = this.invokeMobileBankQuery(nlsCreditInfoVO);
                if (b) {
                    this.nlsPublicService.sendMessageWithCusManagerInfo("3", lmtPrdContVO, ptProduceUser, phone);
                } else {
                    this.nlsPublicService.sendMessageWithCusManagerInfo("2", lmtPrdContVO, ptProduceUser, phone);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u7b7e\u7ea6\u624b\u673a\u94f6\u884c\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private boolean invokeMobileBankQuery(NlsCreditInfoVO selectCreditInfo) throws Exception {
        MobileBankInfoRespBean resp = null;
        MobileBankInfoReqBean res = new MobileBankInfoReqBean();
        res.setGlobaNo(selectCreditInfo.getGlobalSerno());
        res.setIdentTp(selectCreditInfo.getCertType());
        res.setOprtTp("1");
        res.setOprtChanFlg("07");
        res.setIdentTp(selectCreditInfo.getCertType());
        res.setIdentNo(selectCreditInfo.getCertCode());
        resp = (MobileBankInfoRespBean)new EsbInvokeWrapper((Object)this.mobileBankInfoService, (Object)res, this.nlsQueueSoltComnService).invoke3Threes();
        if (Objects.isNull(resp)) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)resp.getMblBnkCustNo());
    }
}

