/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.rocketmq.handle;

import com.irdstudio.basic.framework.core.base.FrameworkService;
import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.nls.service.facade.RocketmqRetryMessageService;
import com.irdstudio.efp.nls.service.facade.rocketmq.MQSendMessageBatchService;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.vo.RocketmqRetryMessageVO;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="mqSendMessageBatchService")
public class MQSendMessageBatchServiceImpl
implements MQSendMessageBatchService,
FrameworkService {
    private static final Logger logger = LoggerFactory.getLogger(MQSendMessageBatchServiceImpl.class);
    @Autowired
    @Qualifier(value="rocketmqRetryMessageService")
    private RocketmqRetryMessageService rocketmqRetryMessageService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService mqProducerMessageSendService;
    @Autowired
    @Qualifier(value="alarmJudgementService")
    private AlarmJudgementService alarmJudgementService;

    public boolean batchSendMQ() throws Exception {
        RocketmqRetryMessageVO rocketmqRetryMessageVO = new RocketmqRetryMessageVO();
        rocketmqRetryMessageVO.setRetryStatus("0");
        List lists = this.rocketmqRetryMessageService.queryByStatus(rocketmqRetryMessageVO);
        if (Objects.isNull(lists) || lists.isEmpty()) {
            return true;
        }
        int failNum = this.rocketmqRetryMessageService.countFailMessage();
        if (failNum >= 50) {
            ReqAlarmJudgementBean reqAlarmJudgementBean = new ReqAlarmJudgementBean();
            reqAlarmJudgementBean.setAlrmInf("MQ\u91cd\u8bd5\u6761\u6570\u8fc7\u5927\uff01");
            try {
                this.getrespAlarmJudgementBean(reqAlarmJudgementBean);
            }
            catch (Exception alarme) {
                logger.error("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)alarme);
            }
        }
        for (RocketmqRetryMessageVO vo : lists) {
            Message message = new Message(vo.getTopic(), vo.getTag(), vo.getMessageKey(), vo.getMessage().getBytes("UTF-8"));
            SendResult sendResult = this.mqProducerMessageSendService.sendMsg(message, vo.getId());
            RocketmqRetryMessageVO rockmqVo = new RocketmqRetryMessageVO();
            if (Objects.nonNull(sendResult) && sendResult.getSendStatus() == SendStatus.SEND_OK) {
                rockmqVo.setRetryStatus("1");
            }
            rockmqVo.setId(vo.getId());
            int executeTime = vo.getExecuteTime();
            rockmqVo.setExecuteTime(Integer.valueOf(++executeTime));
            rockmqVo.setUpdateUser("admin");
            rockmqVo.setUpdateTime(DateTool.getCurrentDateTime());
            this.rocketmqRetryMessageService.updateByPk(rockmqVo);
        }
        return true;
    }

    public RespAlarmJudgementBean getrespAlarmJudgementBean(ReqAlarmJudgementBean reqAlarmJudgementBean) throws Exception {
        RespAlarmJudgementBean respAlarmJudgementBean = null;
        try {
            reqAlarmJudgementBean.setMonObjNm("\u7f51\u8d37MQ\u91cd\u8bd5\u6570\u91cf\u8fc7\u5927");
            reqAlarmJudgementBean.setMonObjSpfTpVal("\u7f51\u8d37\u5185\u90e8");
            reqAlarmJudgementBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmTmstmp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            reqAlarmJudgementBean.setMonAlrmLvl("3");
            respAlarmJudgementBean = this.alarmJudgementService.alarmJudgement(reqAlarmJudgementBean);
            logger.debug("\u8c03\u7528\u544a\u8b66\u5224\u65ad\u8fd4\u56de\u7801\uff1a\u3010" + respAlarmJudgementBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + respAlarmJudgementBean.getRetMsg() + "\u3011");
        }
        catch (Exception e) {
            logger.info("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
        return respAlarmJudgementBean;
    }
}

