/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.rocketmq.until;

import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.efp.basic.framework.mq.client.producer.MQProducerMessageClient;
import com.irdstudio.efp.esb.service.bo.req.hlw.ReqAlarmJudgementBean;
import com.irdstudio.efp.esb.service.bo.resp.hlw.RespAlarmJudgementBean;
import com.irdstudio.efp.esb.service.facade.hlw.AlarmJudgementService;
import com.irdstudio.efp.nls.service.facade.RocketmqRetryMessageService;
import com.irdstudio.efp.nls.service.vo.RocketmqRetryMessageVO;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="mqProducerMessageSendService")
public class MQProducerMessageSendService {
    private static Logger logger = LoggerFactory.getLogger(MQProducerMessageSendService.class);
    @Autowired
    @Qualifier(value="producerService")
    private MQProducerMessageClient producerService;
    @Autowired
    @Qualifier(value="rocketmqRetryMessageService")
    private RocketmqRetryMessageService rocketmqRetryMessageService;
    @Autowired
    @Qualifier(value="alarmJudgementService")
    private AlarmJudgementService alarmJudgementService;

    public SendResult sendMsg(Message msg, String messageKey) {
        RocketmqRetryMessageVO rocketmqRetryMessageVO = new RocketmqRetryMessageVO();
        SendResult result = null;
        try {
            result = this.producerService.sendMsgException(msg);
        }
        catch (InterruptedException e) {
            rocketmqRetryMessageVO.setExceptionType("InterruptedException");
            logger.error("InterruptedException" + e.getMessage());
        }
        catch (RemotingException e) {
            rocketmqRetryMessageVO.setExceptionType("RemotingException");
            logger.error("RemotingException" + e.getMessage());
        }
        catch (MQClientException e) {
            rocketmqRetryMessageVO.setExceptionType("MQClientException");
            logger.error("MQClientException" + e.getMessage());
        }
        catch (MQBrokerException e) {
            rocketmqRetryMessageVO.setExceptionType("MQBrokerException");
            logger.error("MQBrokerException" + e.getMessage());
        }
        catch (Exception e) {
            rocketmqRetryMessageVO.setExceptionType("Exception");
            logger.error("Exception", (Throwable)e);
        }
        if (result == null || result.getSendStatus() != SendStatus.SEND_OK) {
            this.saveMessage(msg, messageKey, rocketmqRetryMessageVO);
        }
        return result;
    }

    public void saveMessage(Message msg, String messageKey, RocketmqRetryMessageVO rocketmqRetryMessageVO) {
        try {
            int count = this.rocketmqRetryMessageService.coutMessage(messageKey);
            if (count == 0) {
                rocketmqRetryMessageVO.setId(messageKey);
                rocketmqRetryMessageVO.setTopic(msg.getTopic());
                rocketmqRetryMessageVO.setTag(msg.getTags());
                rocketmqRetryMessageVO.setMessageKey(msg.getKeys());
                rocketmqRetryMessageVO.setMessage(new String(msg.getBody(), "UTF-8"));
                rocketmqRetryMessageVO.setCreateUser("admin");
                rocketmqRetryMessageVO.setCreateTime(TimeUtil.getCurrentDateTime());
                int i = this.rocketmqRetryMessageService.insert(rocketmqRetryMessageVO);
                if (i == -1) {
                    throw new BizException("MQ\u91cd\u8bd5\u63d2\u6570\u636e\u5e93\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            ReqAlarmJudgementBean reqAlarmJudgementBean = new ReqAlarmJudgementBean();
            reqAlarmJudgementBean.setAlrmInf("MQ\u91cd\u8bd5\u63d2\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01");
            try {
                this.getrespAlarmJudgementBean(reqAlarmJudgementBean);
            }
            catch (Exception alarme) {
                e.printStackTrace();
                logger.debug("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + alarme.getMessage());
            }
        }
    }

    public RespAlarmJudgementBean getrespAlarmJudgementBean(ReqAlarmJudgementBean reqAlarmJudgementBean) throws Exception {
        RespAlarmJudgementBean respAlarmJudgementBean = null;
        try {
            reqAlarmJudgementBean.setMonObjNm("\u7f51\u8d37MQ\u91cd\u8bd5\u5165\u5e93");
            reqAlarmJudgementBean.setMonObjSpfTpVal("\u7f51\u8d37\u5185\u90e8");
            reqAlarmJudgementBean.setMonObjLctr(InetAddress.getLocalHost().getHostAddress());
            reqAlarmJudgementBean.setAlrmTmstmp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            reqAlarmJudgementBean.setMonAlrmLvl("3");
            respAlarmJudgementBean = this.alarmJudgementService.alarmJudgement(reqAlarmJudgementBean);
            logger.debug("\u8c03\u7528\u544a\u8b66\u5224\u65ad\u8fd4\u56de\u7801\uff1a\u3010" + respAlarmJudgementBean.getRetCd() + "\u3011\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a\u3010" + respAlarmJudgementBean.getRetMsg() + "\u3011");
        }
        catch (Exception e) {
            logger.info("\u8c03\u7528\u544a\u8b66\u63a5\u53e3\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
        return respAlarmJudgementBean;
    }
}

