/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sed.repay;

import com.alibaba.fastjson.JSON;
import com.irdstudio.basic.framework.core.constant.EsbEnums;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ExternalSysException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.framework.core.util.sdic.SDicToExternal;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanAccountBean;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayBean;
import com.irdstudio.efp.esb.service.bo.req.sed.repay.ReqLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayBean;
import com.irdstudio.efp.esb.service.bo.resp.sed.repay.RespLoanRepayResultQryBean;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayResultQryService;
import com.irdstudio.efp.esb.service.facade.sed.repay.LoanRepayService;
import com.irdstudio.efp.limit.service.facade.LmtPrdContService;
import com.irdstudio.efp.limit.service.vo.LmtPrdContVO;
import com.irdstudio.efp.loan.service.facade.AccLoanService;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.AccLoanVO;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.sed.DealState;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.service.facade.NlsApplyInfoService;
import com.irdstudio.efp.nls.service.impl.sed.repay.RepaySoltServiceImpl;
import com.irdstudio.efp.nls.service.vo.NlsApplyInfoVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="repayApplJudgeService")
public class RepayApplJudgeServiceImpl
extends RepaySoltServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(RepayApplJudgeServiceImpl.class);
    @Autowired
    @Qualifier(value="loanRepayResultQryService")
    private LoanRepayResultQryService loanRepayResultQryService;
    @Autowired
    @Qualifier(value="accLoanService")
    private AccLoanService accLoanService;
    @Autowired
    @Qualifier(value="loanRepayService")
    private LoanRepayService loanRepayService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    @Qualifier(value="nlsApplyInfoService")
    private NlsApplyInfoService nlsApplyInfoService;
    @Autowired
    @Qualifier(value="lmtPrdContService")
    private LmtPrdContService lmtPrdContService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(NlsProcessBizVO nlsProcessBizVo, LoanRepayDetailVO loanRepayDetailVO) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        String billNo = loanRepayDetailVO.getLoanNo();
        logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u5f00\u59cb,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        try {
            if (SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue().equals(loanRepayDetailVO.getExceptionLocation())) {
                AccLoanVO accLoanVO = new AccLoanVO();
                accLoanVO.setBillNo(billNo);
                accLoanVO = this.accLoanService.queryByPk(accLoanVO);
                if (Objects.isNull(accLoanVO)) {
                    throw new OcmSystemException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                this.updStateAndLmt(loanRepayDetailVO, accLoanVO);
            } else {
                this.excuteRepayMain(loanRepayDetailVO);
            }
        }
        catch (Exception e) {
            logger.error(Arrays.toString(e.getStackTrace()));
            nlsProcessBizVo.setExceptionFlag(true);
            nlsProcessBizVo.setExceptionMsg(e);
        }
        finally {
            logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u7ed3\u675f,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void excuteRepayMain(LoanRepayDetailVO loanRepayDetailVO) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        String globalSerno = loanRepayDetailVO.getGlobalSerno();
        String billNo = loanRepayDetailVO.getLoanNo();
        logger.info("\u6839\u636e\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u5f00\u59cb-----------------------------------");
        ReqLoanRepayResultQryBean reqLoanRepResQryBean = new ReqLoanRepayResultQryBean();
        reqLoanRepResQryBean.setTxnGlblSrlNo(globalSerno);
        reqLoanRepResQryBean.setCnlTp(loanRepayDetailVO.getCnlTp());
        RespLoanRepayResultQryBean respLoanRepResQryBean = new RespLoanRepayResultQryBean();
        try {
            respLoanRepResQryBean = this.loanRepayResultQryService.loanRepayResultQry(reqLoanRepResQryBean);
        }
        catch (Exception e) {
            throw new ExternalSysException(e.getMessage());
        }
        logger.info("\u6839\u636e\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u7ed3\u675f-------\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)respLoanRepResQryBean));
        AccLoanVO accLoanVO = this.getAccLoan(billNo);
        String isRepay = respLoanRepResQryBean.getQrySt();
        if (SedNlsEnum.QuerySts.WITHOUT.getValue().equals(isRepay)) {
            this.excuteRepay(loanRepayDetailVO, accLoanVO);
            return;
        } else {
            if (!SedNlsEnum.QuerySts.HAVE.getValue().equals(isRepay)) throw new ExternalSysException("\u8c03\u7528\u4e92\u91d1\u8d37\u6b3e\u8fd8\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u301030230007_01\u3011\uff0c\u8fd4\u56de\u7684\u67e5\u8be2\u72b6\u6001\u4e0d\u5408\u89c4\uff0c\u503c\u4e3a\uff1a" + isRepay);
            String dealState = respLoanRepResQryBean.getTxnStCd();
            if (DealState.DEALING.getValue().equals(dealState)) {
                throw new ExternalSysException("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + setlSeq + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u5b58\u5728\u5904\u7406\u4e2d\u7684\u8fd8\u6b3e\u7533\u8bf7\uff01");
            }
            if (DealState.UNKNOW.getValue().equals(dealState)) {
                throw new ExternalSysException("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + setlSeq + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u5b58\u5728\u672a\u77e5\u72b6\u6001\u7684\u8fd8\u6b3e\u7533\u8bf7\uff01");
            }
            if (DealState.SUSPEND.getValue().equals(dealState)) {
                throw new ExternalSysException("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + setlSeq + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010" + globalSerno + "\u3011\uff0c\u5b58\u5728\u5f85\u5904\u7406\u3010\u4e92\u91d1\u5df2\u63a5\u6536\u5230\u8fd8\u6b3e\u4fe1\u606f\uff0c\u5f85\u5904\u7406\u3011\u72b6\u6001\u7684\u8fd8\u6b3e\u7533\u8bf7\uff01");
            }
            if (DealState.FAIL.getValue().equals(dealState)) {
                throw new Exception("\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + setlSeq + "\u3011\uff0c\u5168\u5c40\u6d41\u6c34\u53f7\u3010 " + globalSerno + "\u3011\uff0c\u8fd8\u6b3e\u5931\u8d25\uff01\u5f02\u5e38\u4fe1\u606f:" + loanRepayDetailVO.getExceptionMsg());
            }
            if (!DealState.SUCCESS.getValue().equals(dealState)) throw new ExternalSysException("\u8c03\u7528\u4e92\u91d1\u8d37\u6b3e\u8fd8\u6b3e\u7ed3\u679c\u67e5\u8be2\u63a5\u53e3\u301030230007_01\u3011\uff0c\u8fd4\u56de\u7684\u4ea4\u6613\u72b6\u6001\u4e0d\u5408\u89c4\uff0c\u503c\u4e3a\uff1a" + dealState);
            this.updStateAndLmt(loanRepayDetailVO, accLoanVO);
        }
    }

    private AccLoanVO getAccLoan(String billNo) throws BizException {
        AccLoanVO accLoanVO = new AccLoanVO();
        accLoanVO.setBillNo(billNo);
        accLoanVO = this.accLoanService.queryByPk(accLoanVO);
        if (Objects.isNull(accLoanVO)) {
            throw new BizException("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u524d\uff0c\u6839\u636e\u501f\u636e\u53f7\u3010" + billNo + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u501f\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return accLoanVO;
    }

    private ReqLoanRepayBean buildReqLoanRepayBean(LoanRepayDetailVO loanRepayDetailVO, AccLoanVO accLoanVO) throws Exception {
        ReqLoanRepayBean reqLoanRepayBean = new ReqLoanRepayBean();
        reqLoanRepayBean.setLoanNo(accLoanVO.getLoanSeq());
        reqLoanRepayBean.setDistrNo(accLoanVO.getDistrNo());
        reqLoanRepayBean.setRpyDt(StringUtil.isNotEmpty((String)loanRepayDetailVO.getSetlApplyDt()) ? DateUtility.format10To8((String)loanRepayDetailVO.getSetlApplyDt()) : null);
        try {
            reqLoanRepayBean.setRpyType(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"SetlType", (String)loanRepayDetailVO.getSetlTyp()));
        }
        catch (Exception e) {
            logger.error("\u8fd8\u6b3e\u7c7b\u578b\u5b57\u5178\u9879\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
            throw new Exception("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u65f6\uff0c\u51fa\u73b0\u8fd8\u6b3e\u7c7b\u578b\u5b57\u5178\u9879\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        reqLoanRepayBean.setRpyAmt(loanRepayDetailVO.getTotalAmt() == null ? BigDecimal.ZERO.toString() : loanRepayDetailVO.getTotalAmt().toString());
        reqLoanRepayBean.setRpyPrin(loanRepayDetailVO.getSetlOdPrcpAmt() == null ? BigDecimal.ZERO.toString() : loanRepayDetailVO.getSetlOdPrcpAmt().toString());
        reqLoanRepayBean.setRpyTime(loanRepayDetailVO.getRepayTerm());
        reqLoanRepayBean.setRpyRsn(loanRepayDetailVO.getRepayReason());
        ArrayList<ReqLoanAccountBean> reqLoanAccountList = new ArrayList<ReqLoanAccountBean>();
        if (StringUtil.isStrNotEmpty((String)loanRepayDetailVO.getAmtType())) {
            String[] amtType = loanRepayDetailVO.getAmtType().split(",");
            for (int i = 0; i < amtType.length; ++i) {
                ReqLoanAccountBean reqLAccBean = new ReqLoanAccountBean();
                reqLAccBean.setAmtType(amtType[i]);
                BigDecimal setlAmt = BigDecimal.ZERO;
                if (EsbEnums.AmtType.ALL.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getTotalAmt();
                } else if (EsbEnums.AmtType.PRINCIPAL.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getSetlOdPrcpAmt();
                } else if (EsbEnums.AmtType.INTEREST.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getAllOdNormIntAmt();
                } else if (EsbEnums.AmtType.COMP_INTEREST.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getAllOdCommIntAmt();
                } else if (EsbEnums.AmtType.DEF_INTEREST.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getAllOdIntAmt();
                } else if (EsbEnums.AmtType.FEE.getValue().equals(amtType[i])) {
                    setlAmt = loanRepayDetailVO.getTotalFee();
                }
                reqLAccBean.setBlgAmt(setlAmt == null ? BigDecimal.ZERO.toString() : setlAmt.toString());
                reqLAccBean.setBlgAcctCl(loanRepayDetailVO.getSetlAcctClassify());
                reqLAccBean.setBlgMth(loanRepayDetailVO.getSetlMode());
                reqLAccBean.setAcctCtgry(loanRepayDetailVO.getAcctTyp());
                reqLAccBean.setBlgCstNo(loanRepayDetailVO.getCusNo());
                reqLAccBean.setBlgAcctNo(loanRepayDetailVO.getDisbAcNo());
                reqLAccBean.setBlgAcctProdType(loanRepayDetailVO.getSetlAcctPrdType());
                try {
                    reqLAccBean.setBlgAcctCurrCd(SDicToExternal.getExternalSysDicVal((String)"IFP", (String)"CurType", (String)loanRepayDetailVO.getSetlCurr()));
                }
                catch (Exception e) {
                    logger.error("\u5e01\u79cd\u5b57\u5178\u9879\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
                    throw new Exception("\u8c03\u7528\u8d37\u6b3e\u56de\u6536\u63a5\u53e3\u7ec4\u88c5\u8bf7\u6c42\u62a5\u6587\u65f6\uff0c\u51fa\u73b0\u5e01\u79cd\u5b57\u5178\u9879\u8f6c\u6362\u5f02\u5e38\uff01");
                }
                reqLAccBean.setBlgAcctSrlNo(loanRepayDetailVO.getSetlAcctSeq());
                reqLAccBean.setAtmLockMark(loanRepayDetailVO.getAtmLockMark());
                reqLAccBean.setLoanPrtyLvl(loanRepayDetailVO.getLoanPrtyLvl());
                reqLAccBean.setBlgRto(loanRepayDetailVO.getSetlWeight());
                reqLAccBean.setBankInsdOutSdFlg(loanRepayDetailVO.getBankInOut());
                reqLAccBean.setMdfMd(loanRepayDetailVO.getModifyMode());
                reqLoanAccountList.add(reqLAccBean);
            }
        }
        reqLoanRepayBean.setIntSetInfArry(reqLoanAccountList.toArray(new ReqLoanAccountBean[reqLoanAccountList.size()]));
        return reqLoanRepayBean;
    }

    private void excuteRepay(LoanRepayDetailVO loanRepayDetailVO, AccLoanVO accLoanVO) throws Exception {
        String setlSeq = loanRepayDetailVO.getSetlSeq();
        logger.info("\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u63a5\u53e3\u5f00\u59cb----------------------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
        ReqLoanRepayBean reqLoanRepayBean = this.buildReqLoanRepayBean(loanRepayDetailVO, accLoanVO);
        RespLoanRepayBean respLoanRepayBean = new RespLoanRepayBean();
        try {
            respLoanRepayBean = this.loanRepayService.loanRepay(reqLoanRepayBean, loanRepayDetailVO);
        }
        catch (Exception e) {
            throw new ExternalSysException(e.getMessage());
        }
        logger.info("\u8c03\u7528\u8d37\u6b3e\u8fd8\u6b3e\u63a5\u53e3\u7ed3\u675f----------------------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
        String sysHeadRetCode = respLoanRepayBean.getSysHeadRetCode();
        if (EsbBizEnums.RetCodeEnum.SUCCESS.getVALUE().equals(sysHeadRetCode)) {
            this.updStateAndLmt(loanRepayDetailVO, accLoanVO);
        } else {
            if (EsbBizEnums.RetCodeEnum.FAILURE.getVALUE().equals(sysHeadRetCode)) {
                throw new Exception("\u8fd8\u6b3e\u7533\u8bf7\u5931\u8d25\uff01--------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
            }
            if (EsbBizEnums.RetCodeEnum.REPEAT.getVALUE().equals(sysHeadRetCode)) {
                throw new Exception("\u8fd8\u6b3e\u7533\u8bf7\u8bf7\u6c42\u91cd\u590d\uff01--------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
            }
            if (EsbBizEnums.RetCodeEnum.HAND.getVALUE().equals(sysHeadRetCode)) {
                throw new ExternalSysException("\u8fd8\u6b3e\u7533\u8bf7\u5904\u7406\u4e2d\uff01--------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
            }
        }
    }

    private void updStateAndLmt(LoanRepayDetailVO loanRepayDetailVO, AccLoanVO accLoanVO) throws OcmSystemException {
        block8: {
            String setlSeq = loanRepayDetailVO.getSetlSeq();
            logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u6267\u884c\u5230\u8fd8\u6b3e\u6210\u529f\u540e,\u540e\u5904\u7406\u5f00\u59cb,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
            try {
                loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.PASS.getKey());
                int num = this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
                if (num < 0) {
                    logger.error("\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u72b6\u6001\u4e3a\u201c\u901a\u8fc7\u201d\uff0c\u6267\u884c\u5931\u8d25\uff01");
                    throw new OcmSystemException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u72b6\u6001\u4e3a\u201c\u901a\u8fc7\u201d\uff0c\u6267\u884c\u5931\u8d25\uff01--------\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
                }
                String lmtApplySeq = this.getLmtApplySeq(accLoanVO.getApplySeq());
                LmtPrdContVO lmtPrdContVO = this.lmtPrdContService.qryLmtPrdContByLmtApplySeq(lmtApplySeq);
                if (Objects.nonNull(lmtPrdContVO)) {
                    BigDecimal lmtAmt = lmtPrdContVO.getLmtAmt();
                    BigDecimal occAmt = lmtPrdContVO.getOccAmt().toString() == null ? BigDecimal.ZERO : lmtPrdContVO.getOccAmt();
                    BigDecimal preOccAmt = lmtPrdContVO.getPreOccAmt() == null ? BigDecimal.ZERO : lmtPrdContVO.getPreOccAmt();
                    BigDecimal rpyPrin = loanRepayDetailVO.getSetlOdPrcpAmt();
                    lmtPrdContVO.setOccAmt(occAmt.subtract(rpyPrin));
                    lmtPrdContVO.setAvailAmt(lmtAmt.subtract(occAmt).subtract(preOccAmt).add(rpyPrin));
                    lmtPrdContVO.setLastUpdateTime(TimeUtil.getCurrentDateTime());
                    int numLmt = this.lmtPrdContService.updateByPk(lmtPrdContVO);
                    if (numLmt < 0) {
                        throw new OcmSystemException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u5931\u8d25\uff01\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + setlSeq + "\u3011\uff0c\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + lmtApplySeq);
                    }
                    break block8;
                }
                logger.error("\u8fd8\u6b3e\u6210\u529f\u540e\uff0c\u8fdb\u884c\u989d\u5ea6\u6062\u590d\uff0c\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + lmtApplySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01");
                throw new OcmSystemException(SedNlsEnum.ExceptionLocation.REPAY_SUCCESS_AFTER_EXCEPTION.getValue(), "\u901a\u8fc7\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u3010 " + lmtApplySeq + "\u3011\uff0c\u67e5\u8be2\u5230\u7684\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a\uff01\u8fd8\u6b3e\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a" + setlSeq);
            }
            catch (Exception e) {
                throw new OcmSystemException((Throwable)e);
            }
            finally {
                logger.info("======>\u8fd8\u6b3e\u7533\u8bf7\u51c6\u5165\u670d\u52a1\u6267\u884c\u5230\u8fd8\u6b3e\u6210\u529f\u540e,\u540e\u5904\u7406\u7ed3\u675f,\u6d41\u6c34\u53f7\u4e3a:" + setlSeq + "<======");
            }
        }
    }

    private String getLmtApplySeq(String applySeq) throws OcmSystemException {
        NlsApplyInfoVO nlsApplyInfoVO = new NlsApplyInfoVO();
        nlsApplyInfoVO.setApplySeq(applySeq);
        nlsApplyInfoVO = this.nlsApplyInfoService.queryByPk(nlsApplyInfoVO);
        if (Objects.isNull(nlsApplyInfoVO)) {
            throw new OcmSystemException("\u8fd8\u6b3e\u6210\u529f\u540e\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u65f6\uff0c\u901a\u8fc7\u652f\u7528\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u652f\u7528\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isNullorBank((String)nlsApplyInfoVO.getLmtApplySeq())) {
            throw new OcmSystemException("\u8fd8\u6b3e\u6210\u529f\u540e\u66f4\u65b0\u6388\u4fe1\u534f\u8bae\u4fe1\u606f\u65f6\uff0c\u901a\u8fc7\u652f\u7528\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011\uff0c\u83b7\u53d6\u5230\u7684\u6388\u4fe1\u7533\u8bf7\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff01");
        }
        return nlsApplyInfoVO.getLmtApplySeq();
    }
}

