/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.impl.sed.repay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.exception.ExternalSysException;
import com.irdstudio.basic.framework.core.exception.OcmSystemException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.efp.basic.framework.mq.constant.TagEnums;
import com.irdstudio.efp.basic.framework.mq.constant.TopicEnums;
import com.irdstudio.efp.esb.common.constant.EsbBizEnums;
import com.irdstudio.efp.loan.service.facade.LoanRepayDetailService;
import com.irdstudio.efp.loan.service.vo.LoanRepayDetailVO;
import com.irdstudio.efp.nls.common.constant.NlsApplyInfoEnums;
import com.irdstudio.efp.nls.common.constant.NlsProcessBizEnums;
import com.irdstudio.efp.nls.common.constant.PrdAdaptedSoltEnums;
import com.irdstudio.efp.nls.common.constant.QueueTaskEnums;
import com.irdstudio.efp.nls.common.constant.sed.SedNlsEnum;
import com.irdstudio.efp.nls.common.exception.LoanRepaySyncException;
import com.irdstudio.efp.nls.common.exception.RepayException;
import com.irdstudio.efp.nls.service.facade.NlsQueueSoltComnService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessBizService;
import com.irdstudio.efp.nls.service.facade.queue.NlsProcessRuleService;
import com.irdstudio.efp.nls.service.facade.sed.RepaySoltService;
import com.irdstudio.efp.nls.service.impl.rocketmq.until.MQProducerMessageSendService;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessBizVO;
import com.irdstudio.efp.nls.service.vo.queue.NlsProcessRuleVO;
import java.lang.reflect.Method;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class RepaySoltServiceImpl
implements RepaySoltService {
    private static Logger logger = LoggerFactory.getLogger(RepaySoltServiceImpl.class);
    @Autowired
    @Qualifier(value="nlsProcessBizService")
    private NlsProcessBizService nlsProcessBizService;
    @Autowired
    @Qualifier(value="loanRepayDetailService")
    private LoanRepayDetailService loanRepayDetailService;
    @Autowired
    @Qualifier(value="nlsProcessRuleService")
    private NlsProcessRuleService nlsProcessRuleService;
    @Autowired
    @Qualifier(value="mqProducerMessageSendService")
    private MQProducerMessageSendService producerService;
    @Autowired
    @Qualifier(value="nlsQueueSoltComnService")
    private NlsQueueSoltComnService nlsQueueSoltComnService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(NlsProcessBizVO nlsProcessBizVo, LoanRepayDetailVO loanRepayDetailVO, int soltOrder) throws Exception {
        String applySeq = nlsProcessBizVo.getApplySeq();
        String soltCode = nlsProcessBizVo.getSoltCode();
        String soltName = nlsProcessBizVo.getSoltName();
        String soltService = nlsProcessBizVo.getSoltService();
        logger.info("*********************************************");
        logger.info("*            \u5f00\u59cb\u4e00\u4e2a\u65b0\u7684\u63d2\u69fd                 * ");
        logger.info("* \u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  *");
        logger.info("* \u501f\u636e\u53f7 : \u3010" + loanRepayDetailVO.getLoanNo() + "\u3011  *");
        logger.info("* \u5ba2\u6237\u540d\u79f0 : \u3010" + loanRepayDetailVO.getCustName() + "\u3011  *");
        logger.info("* \u5168\u5c40\u6d41\u6c34\u53f7 : \u3010" + loanRepayDetailVO.getGlobalSerno() + "\u3011  *");
        logger.info("* \u63d2\u69fd\u4ee3\u7801 : \u3010" + soltCode + "\u3011  *");
        logger.info("* \u63d2\u69fd\u540d\u79f0 : \u3010" + soltName + "\u3011  *");
        logger.info("* \u63d2\u69fd\u670d\u52a1 : \u3010" + soltService + "\u3011  *");
        logger.info("* \u521b\u5efa\u65e5\u671f : \u3010" + loanRepayDetailVO.getSetlCreateDt() + "\u3011*");
        logger.info("*********************************************");
        try {
            Method methodSoltstate = nlsProcessBizVo.getClass().getMethod("setSoltState" + soltOrder, String.class);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u5f00\u59cb");
            methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.EXECUTING.getCode());
            this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6267\u884c\u4e2d\u7ed3\u675f");
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u8c03\u7528\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u5f00\u59cb");
            this.doExecute(nlsProcessBizVo, loanRepayDetailVO);
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u8c03\u7528\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u903b\u8f91\u5904\u7406\u7ed3\u675f");
            boolean exceptionFlag = nlsProcessBizVo.isExceptionFlag();
            int hangTimes = nlsProcessBizVo.getHangTimes();
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011  \u6839\u636e\u5f02\u5e38\u6807\u5fd7\u3010" + exceptionFlag + "\u3011\u5904\u7406\u540e\u7eed\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4fe1\u606f");
            if (!exceptionFlag) {
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8be5\u63d2\u69fd\u7684\u65e0\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6210\u529f\uff0c\u6b64\u5904\u961f\u5217\u4efb\u52a1\u8868\u548c\u8fd8\u6b3e\u660e\u7ec6\u8868\u7684\u6570\u636e\u9700\u8981\u7b49\u63d2\u69fd\u5168\u90e8\u6267\u884c\u5b8c\u6210\u540e\u624d\u66f4\u65b0");
                methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
                nlsProcessBizVo.setHangTimes(QueueTaskEnums.QueueHangTimesEnum.INITIALIZE.getTimes());
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8be5\u63d2\u69fd\u7684\u65e0\u5f02\u5e38\u7ed3\u675f");
                nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                return;
            }
            Exception exception = nlsProcessBizVo.getExceptionMsg();
            logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u6839\u636e\u5f02\u5e38\u3010" + exception + "\u3011\u5904\u7406\u540e\u7eed\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4fe1\u606f");
            NlsProcessRuleVO nlsProcessRuleVO = new NlsProcessRuleVO();
            nlsProcessRuleVO.setApplySeq(applySeq);
            nlsProcessRuleVO = this.nlsProcessRuleService.queryByPk(nlsProcessRuleVO);
            if (exception instanceof ExternalSysException) {
                logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5904\u7406\u8be5\u63d2\u69fd\u7684\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38\u5f00\u59cb");
                if (++hangTimes <= QueueTaskEnums.QueueHangTimesEnum.MAX.getTimes()) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5f02\u5e38\u7c7b\u578b\u4e3a\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38\u65f6\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6302\u8d77\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6302\u8d77\uff0c\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u4e3a\u6302\u8d77");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.HANG.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.HANG.getCode());
                    loanRepayDetailVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    loanRepayDetailVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    loanRepayDetailVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.HANG.getRspCode());
                    loanRepayDetailVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.HANG.getRspMsg());
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.HANG.getKey());
                    loanRepayDetailVO.setRefuseCause(exception.getMessage());
                    nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                    loanRepayDetailVO.setLastChgDt(DateUtility.getCurrAppDateTimeString());
                    this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                    this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u6302\u8d77\u5f02\u5e38\u7ed3\u675f");
                    loanRepayDetailVO.setExceptionMsg(exception.getMessage());
                    Message message = new Message(TopicEnums.REPAY_QUEUE_TASK_HANG_TOPIC.getTopicId(), TagEnums.REPAY_TAG_QUEUE_HANG_TASK.getTagId(), loanRepayDetailVO.getSetlSeq().concat(".").concat(String.valueOf(hangTimes)), JSON.toJSONString((Object)loanRepayDetailVO).getBytes("UTF-8"));
                    message.setDelayTimeLevel(3);
                    String messageKey = TopicEnums.REPAY_QUEUE_TASK_HANG_TOPIC.getTopicId() + "_" + TagEnums.REPAY_TAG_QUEUE_HANG_TASK.getTagId() + "_" + loanRepayDetailVO.getSetlSeq().concat(".").concat(String.valueOf(hangTimes));
                    this.producerService.sendMsg(message, messageKey);
                    throw exception;
                }
                String message = "\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011 \u5f02\u5e38\u7c7b\u578b\u4e3a\u5916\u90e8\u7cfb\u7edf\u7c7b\u578b\u65f6\uff0c\u8be5\u63d2\u69fd\u5f02\u5e38\u5904\u7406\u6b21\u6570\u4e3a\uff1a\u3010" + hangTimes + "\u3011\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c\u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\uff0c \u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u4e3a\u62d2\u7edd";
                methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                nlsProcessBizVo.setHangTimes(hangTimes);
                nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                loanRepayDetailVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                loanRepayDetailVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                loanRepayDetailVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.DEAL_MAX_TIMES.getRspCode());
                loanRepayDetailVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.DEAL_MAX_TIMES.getRspMsg());
                loanRepayDetailVO.setRefuseCause(exception.getMessage());
                if (SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue().equals(((ExternalSysException)((Object)exception)).getErrorCode())) {
                    logger.error(message);
                    message = exception.getMessage();
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.PASS.getKey());
                } else {
                    logger.info(message + "\u5f00\u59cb");
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.REJECT.getKey());
                    logger.info(message + "\u7ed3\u675f");
                }
                this.nlsQueueSoltComnService.alarmNotice(EsbBizEnums.AlarmObjectName.OCM_REAL_TIME.getValue(), EsbBizEnums.AlarmLvl.SERIOUS.getValue(), message);
            } else {
                if (exception instanceof OcmSystemException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a\u3010" + applySeq + "\u3011 \u5904\u7406\u8be5\u63d2\u69fd\u7684\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\u5f00\u59cb");
                    if (++hangTimes <= QueueTaskEnums.QueueHangTimesEnum.MAX.getTimes()) {
                        logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 \uff1a\u3010" + applySeq + "\u3011\u5f02\u5e38\u7c7b\u578b\u4e3a\u5185\u90e8\u7cfb\u7edf\u5f02\u5e38\u65f6\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u6302\u8d77");
                        methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.HANG.getCode());
                        nlsProcessBizVo.setHangTimes(hangTimes);
                        nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                        this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                        loanRepayDetailVO.setExceptionLocation(((OcmSystemException)exception).getErrorCode());
                        Message message = new Message(TopicEnums.REPAY_QUEUE_TASK_HANG_TOPIC.getTopicId(), TagEnums.REPAY_TAG_QUEUE_HANG_TASK.getTagId(), loanRepayDetailVO.getSetlSeq().concat(".").concat(String.valueOf(hangTimes)), JSON.toJSONString((Object)loanRepayDetailVO).getBytes("UTF-8"));
                        message.setDelayTimeLevel(3);
                        String messageKey = TopicEnums.REPAY_QUEUE_TASK_HANG_TOPIC.getTopicId() + "_" + TagEnums.REPAY_TAG_QUEUE_HANG_TASK.getTagId() + "_" + loanRepayDetailVO.getSetlSeq().concat(".").concat(String.valueOf(hangTimes));
                        this.producerService.sendMsg(message, messageKey);
                        throw exception;
                    }
                    logger.error("\u7533\u8bf7\u6d41\u6c34\u53f7\u3010" + applySeq + "\u3011 \u5f02\u5e38\u7c7b\u578b\u4e3a\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\u7c7b\u578b\u65f6\uff0c\u8be5\u63d2\u69fd\u5f02\u5e38\u5904\u7406\u6b21\u6570\u4e3a\uff1a\u3010" + hangTimes + "\u3011\uff0c\u5df2\u8d85\u8fc7\u6700\u5927\u5bb9\u5fcd\u503c\uff01");
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    if (SedNlsEnum.ExceptionLocation.SYN_INFO_AFTER_REPAY.getValue().equals(((OcmSystemException)exception).getErrorCode()) || SedNlsEnum.ExceptionLocation.INSERT_LOAN_PLAN_AFTER_REPAY.getValue().equals(((OcmSystemException)exception).getErrorCode())) {
                        logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\uff0c\u5f53\u6267\u884c\u501f\u636e\u4fe1\u606f\u3001\u8fd8\u6b3e\u8ba1\u5212\u4fe1\u606f\u66f4\u65b0\u63d2\u69fd\u65f6\uff0c\u56e0\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38\u91cd\u8bd5\u4e86\u4e09\u6b21\u540e\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25");
                        methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                        nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    }
                    nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
                    this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
                    this.nlsQueueSoltComnService.alarmNotice(EsbBizEnums.AlarmObjectName.OCM_REAL_TIME.getValue(), EsbBizEnums.AlarmLvl.SERIOUS.getValue(), exception.getMessage());
                    throw exception;
                }
                if (exception instanceof BizException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7\uff1a\u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c \u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\u548c\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u4e3a\u62d2\u7edd");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    loanRepayDetailVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    loanRepayDetailVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    loanRepayDetailVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspCode());
                    loanRepayDetailVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspMsg());
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.REJECT.getKey());
                    loanRepayDetailVO.setRefuseCause(exception.getMessage());
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u3011\u5904\u7406\u8be5\u63d2\u69fd\u7684\u4e1a\u52a1\u5f02\u5e38\u7ed3\u675f");
                } else if (exception instanceof RepayException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8fd8\u6b3e\u670d\u52a1\u6267\u884c\u5931\u8d25,\u8f6c\u4e3a\u518d\u8fd8\u6b3e\u8865\u507f\u4efb\u52a1\u4e2d\u6267\u884c");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.SUCCESS.getCode());
                    loanRepayDetailVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    loanRepayDetailVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    loanRepayDetailVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.SUCCESS.getRspCode());
                    loanRepayDetailVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.SUCCESS.getRspMsg());
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.DEALING.getKey());
                    loanRepayDetailVO.setExecuteTime(0);
                    loanRepayDetailVO.setRefuseCause(exception.getMessage());
                    loanRepayDetailVO.setFlowStatus("\u8fd8\u6b3e\u540c\u6b65\u4efb\u52a1\u4e2d");
                    String messageKey = TopicEnums.LOANRELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId() + "_" + TagEnums.LOANRELEASEORREPAY_QUEUE_TASK.getTagId() + "_" + loanRepayDetailVO.getSetlSeq().concat(".").concat("LoanRepayDetailVO-" + loanRepayDetailVO.getExecuteTime());
                    this.producerService.sendMsg(new Message(TopicEnums.LOANRELEASEORREPAY_QUEUE_TASK_TOPIC.getTopicId(), TagEnums.LOANRELEASEORREPAY_QUEUE_TASK.getTagId(), loanRepayDetailVO.getSetlSeq().concat(".").concat("LoanRepayDetailVO-" + loanRepayDetailVO.getExecuteTime()), JSON.toJSONString((Object)loanRepayDetailVO).getBytes("UTF-8")), messageKey);
                } else if (exception instanceof LoanRepaySyncException) {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u8fd8\u6b3e\u540c\u6b65\u670d\u52a1\u6267\u884c\u5931\u8d25,\u8f6c\u4e3a\u5b9a\u65f6\u4efb\u52a1\u4e2d\u6267\u884c");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.SUCCESS.getCode());
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.SUCCESS.getCode());
                    loanRepayDetailVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    loanRepayDetailVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    loanRepayDetailVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.SUCCESS.getRspCode());
                    loanRepayDetailVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.SUCCESS.getRspMsg());
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.DEALING.getKey());
                    loanRepayDetailVO.setRpSts("1");
                    loanRepayDetailVO.setFlowStatus("\u8fd8\u6b3e\u540c\u6b65\u4efb\u52a1\u4e2d");
                } else {
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5176\u5b83\u5f02\u5e38\u5f00\u59cb\uff0c\u66f4\u65b0\u8be5\u63d2\u69fd\u72b6\u6001\u4e3a\u5931\u8d25\uff0c \u66f4\u65b0\u7f51\u8d37\u4efb\u52a1\u961f\u5217\u4e2d\u961f\u5217\u4efb\u52a1\u72b6\u6001\u4e3a\u6267\u884c\u5931\u8d25\u548c\u66f4\u65b0\u8fd8\u6b3e\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u4e3a\u62d2\u7edd");
                    methodSoltstate.invoke((Object)nlsProcessBizVo, PrdAdaptedSoltEnums.SoltProcessStateEnum.FAILURE.getCode());
                    nlsProcessBizVo.setHangTimes(hangTimes);
                    nlsProcessBizVo.setQueueTaskState(QueueTaskEnums.QueueTaskStateEnum.FAILURE.getCode());
                    loanRepayDetailVO.setSoltResultDetails(JSONObject.toJSONString((Object)nlsProcessBizVo));
                    loanRepayDetailVO.setRuleResultDetails(JSONObject.toJSONString((Object)nlsProcessRuleVO));
                    loanRepayDetailVO.setRspCode(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspCode());
                    loanRepayDetailVO.setRspMsg(NlsProcessBizEnums.RspInfoEnum.FAILURE.getRspMsg());
                    loanRepayDetailVO.setWfApprSts(NlsApplyInfoEnums.NlsApplyState.REJECT.getKey());
                    loanRepayDetailVO.setRefuseCause(exception.getMessage());
                    logger.info("\u7533\u8bf7\u6d41\u6c34\u53f7 : \u3010" + applySeq + "\u5904\u7406\u8be5\u63d2\u69fd\u7684\u5176\u5b83\u5f02\u5e38\u7ed3\u675f");
                }
            }
            nlsProcessBizVo.setLastModifyTime(DateUtility.getCurrAppDateTimeString());
            loanRepayDetailVO.setLastChgDt(DateUtility.getCurrAppDateTimeString());
            this.nlsProcessBizService.updateByPk(nlsProcessBizVo);
            this.loanRepayDetailService.updateByPk(loanRepayDetailVO);
            throw exception;
        }
        catch (ExternalSysException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5904\u7406\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new ExternalSysException();
        }
        catch (BizException e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u4e1a\u52a1\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new BizException();
        }
        catch (Exception e) {
            logger.error("\u961f\u5217\u63d2\u69fd\u670d\u52a1\u4e2d\u7533\u8bf7\u6d41\u6c34\u53f7:\u3010" + applySeq + "\u3011\u7684\u5176\u4ed6\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            throw new Exception();
        }
    }

    protected abstract void doExecute(NlsProcessBizVO var1, LoanRepayDetailVO var2) throws Exception;
}

